/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JComponent;

public class LayoutHelper
implements LayoutConstants {
    JComponent parent;
    protected boolean layoutStarted = false;
    protected Object defaultConstraints;
    protected int gridxCounter = -1;
    protected int gridyCounter = -1;
    protected LayoutManager2 izPanelLayout;
    protected static int ANCHOR = -1;
    protected static int X_STRETCH_TYPE = -1;
    protected static int Y_STRETCH_TYPE = -1;
    protected static double FULL_LINE_STRETCH_DEFAULT = -1.0;
    protected static double FULL_COLUMN_STRETCH_DEFAULT = -1.0;
    protected static Double INITIAL_STRETCH_DEFAULT = 1.0;
    protected static Double DOUBLE_ZERO = 0.0;
    public static final String[] X_GAP_NAME_LOOK_UP = new String[]{"INTERNAL_USED", "labelXGap", "textXGab", "controlXGap", "paragraphXGap", "labelToTextXGap", "labelToControlXGap", "textToLabelXGap", "controlToLabelXGap", "controlToTextXGap", "textToControlXGap", "firstXGap", "INTERNAL_USED", "INTERNAL_USED", "filler1XGap", "filler2XGap", "filler3XGap", "filler4XGap", "filler5XGap"};
    public static final String[] Y_GAP_NAME_LOOK_UP = new String[]{"INTERNAL_USED", "labelYGap", "textYGab", "controlYGap", "paragraphYGap", "labelToTextYGap", "labelToControlYGap", "textToLabelYGap", "controlToLabelYGap", "controlToTextYGap", "textToControlYGap", "firstYGap", "INTERNAL_USED", "INTERNAL_USED", "filler1YGap", "filler2YGap", "filler3YGap", "filler4YGap", "filler5YGap"};
    public static final String ALL_X_GAP = "allXGap";
    public static final String ALL_Y_GAP = "allYGap";

    public LayoutHelper(JComponent jComponent) {
        this();
        this.parent = jComponent;
        this.izPanelLayout = new GridBagLayout();
        jComponent.setLayout(this.izPanelLayout);
        ++this.gridyCounter;
    }

    protected LayoutHelper() {
    }

    private boolean isGridBag() {
        return this.izPanelLayout instanceof GridBagLayout;
    }

    private boolean isIzPanel() {
        return this.izPanelLayout instanceof IzPanelLayout;
    }

    public void startLayout(LayoutManager2 layoutManager2) {
        if (this.layoutStarted) {
            return;
        }
        this.izPanelLayout = layoutManager2;
        if (this.isGridBag()) {
            this.startGridBagLayout();
            return;
        }
        if (this.isIzPanel()) {
            this.startIzPanelLayout();
        }
    }

    private void startIzPanelLayout() {
        IzPanelLayout.setAnchor(LayoutHelper.getAnchor());
        IzPanelLayout.setXStretchType(LayoutHelper.getXStretchType());
        IzPanelLayout.setYStretchType(LayoutHelper.getYStretchType());
        IzPanelLayout.setFullLineStretch(LayoutHelper.getFullLineStretch());
        IzPanelLayout.setFullColumnStretch(LayoutHelper.getFullColumnStretch());
        LayoutHelper.getXGap(-1);
        LayoutHelper.getYGap(-1);
        this.parent.setLayout(this.izPanelLayout);
    }

    public void completeLayout() {
        if (this.isGridBag()) {
            this.completeGridBagLayout();
        }
    }

    public Object getDefaultConstraints() {
        this.startLayout(this.izPanelLayout);
        return this.defaultConstraints;
    }

    public void setDefaultConstraints(Object object) {
        this.startLayout(this.izPanelLayout);
        if (this.isGridBag() && !(object instanceof GridBagConstraints) || this.isIzPanel() && !(object instanceof IzPanelConstraints)) {
            throw new IllegalArgumentException("Layout and constraints have to be from the same type.");
        }
        this.defaultConstraints = object;
    }

    public void resetGridCounter() {
        this.gridxCounter = -1;
        this.gridyCounter = -1;
    }

    public Object getNewConstraints(int n, int n2) {
        if (this.isGridBag()) {
            GridBagConstraints gridBagConstraints = (GridBagConstraints)((GridBagConstraints)this.getDefaultConstraints()).clone();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            return gridBagConstraints;
        }
        if (this.isIzPanel()) {
            IzPanelConstraints izPanelConstraints = (IzPanelConstraints)((IzPanelConstraints)this.getDefaultConstraints()).clone();
            izPanelConstraints.setXPos(n);
            izPanelConstraints.setYPos(n2);
            return izPanelConstraints;
        }
        return null;
    }

    public Object getNewConstraints(int n, int n2, int n3, int n4) {
        Cloneable cloneable;
        Object object = this.getNewConstraints(n, n2);
        if (this.isGridBag()) {
            cloneable = (GridBagConstraints)object;
            ((GridBagConstraints)cloneable).gridwidth = n3;
            ((GridBagConstraints)cloneable).gridheight = n4;
        }
        if (this.isIzPanel()) {
            cloneable = (IzPanelConstraints)object;
            ((IzPanelConstraints)cloneable).setXWeight(n3);
            ((IzPanelConstraints)cloneable).setYWeight(n4);
        }
        return object;
    }

    public Object getNextXConstraints() {
        ++this.gridxCounter;
        return this.getNewConstraints(this.gridxCounter, this.gridyCounter);
    }

    public Object getNextYConstraints() {
        ++this.gridyCounter;
        this.gridxCounter = 0;
        return this.getNewConstraints(0, this.gridyCounter);
    }

    public Object getNextYConstraints(int n, int n2) {
        ++this.gridyCounter;
        this.gridxCounter = 0;
        return this.getNewConstraints(0, this.gridyCounter, n, n2);
    }

    private void startGridBagLayout() {
        if (this.layoutStarted) {
            return;
        }
        this.layoutStarted = true;
        if (this.izPanelLayout == null || !(this.izPanelLayout instanceof GridBagLayout)) {
            this.izPanelLayout = new GridBagLayout();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, LayoutHelper.getYGap(-1), 0);
        gridBagConstraints.anchor = 17;
        this.defaultConstraints = gridBagConstraints;
        this.parent.setLayout(this.izPanelLayout);
        switch (LayoutHelper.getAnchor()) {
            case 5: 
            case 6: {
                IzPanel.Filler filler = new IzPanel.Filler();
                GridBagConstraints gridBagConstraints2 = (GridBagConstraints)this.getNextYConstraints();
                gridBagConstraints2.weighty = 1.0;
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.anchor = 17;
                this.parent.add((Component)filler, gridBagConstraints2);
                break;
            }
        }
    }

    private void completeGridBagLayout() {
        switch (LayoutHelper.getAnchor()) {
            case 1: 
            case 8: {
                IzPanel.Filler filler = new IzPanel.Filler();
                GridBagConstraints gridBagConstraints = (GridBagConstraints)this.getNextYConstraints();
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.parent.add((Component)filler, gridBagConstraints);
                break;
            }
        }
    }

    public static int getAnchor() {
        if (ANCHOR >= 0) {
            return ANCHOR;
        }
        AutomatedInstallData automatedInstallData = AutomatedInstallData.getInstance();
        String string = automatedInstallData instanceof InstallData && ((InstallData)automatedInstallData).guiPrefs.modifier.containsKey("layoutAnchor") ? ((InstallData)automatedInstallData).guiPrefs.modifier.get("layoutAnchor") : automatedInstallData.getVariable("IzPanel.LayoutType");
        if (string == null) {
            ANCHOR = 0;
        } else if ("EAST".equalsIgnoreCase(string)) {
            ANCHOR = 3;
        } else if ("WEST".equalsIgnoreCase(string)) {
            ANCHOR = 7;
        } else if ("TOP".equalsIgnoreCase(string) || "NORTH".equalsIgnoreCase(string)) {
            ANCHOR = 1;
        } else if ("BOTTOM".equalsIgnoreCase(string) || "SOUTH".equalsIgnoreCase(string)) {
            ANCHOR = 5;
        } else if ("SOUTHWEST".equalsIgnoreCase(string) || "SOUTH_WEST".equalsIgnoreCase(string)) {
            ANCHOR = 6;
        } else if ("SOUTHEAST".equalsIgnoreCase(string) || "SOUTH_EAST".equalsIgnoreCase(string)) {
            ANCHOR = 4;
        } else if ("NORTHWEST".equalsIgnoreCase(string) || "NORTH_WEST".equalsIgnoreCase(string)) {
            ANCHOR = 8;
        } else if ("NORTHEAST".equalsIgnoreCase(string) || "NORTH_EAST".equalsIgnoreCase(string)) {
            ANCHOR = 2;
        } else if ("CENTER".equalsIgnoreCase(string)) {
            ANCHOR = 0;
        }
        return ANCHOR;
    }

    public static int getXGap(int n) {
        n = IzPanelLayout.verifyGapId(n);
        if (IzPanelLayout.getDefaultXGap(0) >= 0) {
            return IzPanelLayout.getDefaultXGap(n);
        }
        AutomatedInstallData automatedInstallData = AutomatedInstallData.getInstance();
        if (!(automatedInstallData instanceof InstallData)) {
            return IzPanelLayout.getDefaultXGap(n);
        }
        String string = null;
        InstallData installData = (InstallData)automatedInstallData;
        int n2 = -1;
        if (installData.guiPrefs.modifier.containsKey(ALL_X_GAP)) {
            try {
                n2 = Integer.parseInt(installData.guiPrefs.modifier.get(ALL_X_GAP));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 0; i < X_GAP_NAME_LOOK_UP.length; ++i) {
            int n3 = 0;
            if (n2 >= 0) {
                n3 = n2;
            } else {
                string = installData.guiPrefs.modifier.get(X_GAP_NAME_LOOK_UP[i]);
                if (string != null) {
                    try {
                        n3 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            IzPanelLayout.setDefaultXGap(n3, i);
        }
        IzPanelLayout.setDefaultXGap(0, 0);
        return IzPanelLayout.getDefaultXGap(n);
    }

    public static int getYGap(int n) {
        n = IzPanelLayout.verifyGapId(n);
        if (IzPanelLayout.getDefaultYGap(0) >= 0) {
            return IzPanelLayout.getDefaultYGap(n);
        }
        AutomatedInstallData automatedInstallData = AutomatedInstallData.getInstance();
        if (!(automatedInstallData instanceof InstallData)) {
            return IzPanelLayout.getDefaultYGap(n);
        }
        String string = null;
        InstallData installData = (InstallData)automatedInstallData;
        int n2 = -1;
        if (installData.guiPrefs.modifier.containsKey(ALL_Y_GAP)) {
            try {
                n2 = Integer.parseInt(installData.guiPrefs.modifier.get(ALL_Y_GAP));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 0; i < Y_GAP_NAME_LOOK_UP.length; ++i) {
            int n3 = 0;
            if (n2 >= 0) {
                n3 = n2;
            } else {
                string = installData.guiPrefs.modifier.get(Y_GAP_NAME_LOOK_UP[i]);
                if (string != null) {
                    try {
                        n3 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            IzPanelLayout.setDefaultYGap(n3, i);
        }
        IzPanelLayout.setDefaultYGap(0, 0);
        return IzPanelLayout.getDefaultYGap(n);
    }

    public static int getXStretchType() {
        if (X_STRETCH_TYPE > -1) {
            return X_STRETCH_TYPE;
        }
        X_STRETCH_TYPE = 2;
        String string = (String)LayoutHelper.getModifierValue(null, "RELATIVE_STRETCH", null, "layoutXStretchType");
        if (string != null) {
            if ("RELATIVE_STRETCH".equalsIgnoreCase(string) || "RELATIVE".equalsIgnoreCase(string)) {
                X_STRETCH_TYPE = 1;
            } else if ("ABSOLUTE_STRETCH".equalsIgnoreCase(string) || "ABSOLUTE".equalsIgnoreCase(string)) {
                X_STRETCH_TYPE = 2;
            } else if ("NO_STRETCH".equalsIgnoreCase(string) || "NO".equalsIgnoreCase(string)) {
                X_STRETCH_TYPE = 0;
            }
        }
        return X_STRETCH_TYPE;
    }

    public static int getYStretchType() {
        if (Y_STRETCH_TYPE > -1) {
            return Y_STRETCH_TYPE;
        }
        Y_STRETCH_TYPE = 2;
        String string = (String)LayoutHelper.getModifierValue(null, "RELATIVE_STRETCH", null, "layoutYStretchType");
        if (string != null) {
            if ("RELATIVE_STRETCH".equalsIgnoreCase(string) || "RELATIVE".equalsIgnoreCase(string)) {
                Y_STRETCH_TYPE = 1;
            } else if ("ABSOLUTE_STRETCH".equalsIgnoreCase(string) || "ABSOLUTE".equalsIgnoreCase(string)) {
                Y_STRETCH_TYPE = 2;
            } else if ("NO_STRETCH".equalsIgnoreCase(string) || "NO".equalsIgnoreCase(string)) {
                Y_STRETCH_TYPE = 0;
            }
        }
        return Y_STRETCH_TYPE;
    }

    public static double getFullLineStretch() {
        FULL_LINE_STRETCH_DEFAULT = (Double)LayoutHelper.getModifierValue(FULL_LINE_STRETCH_DEFAULT, INITIAL_STRETCH_DEFAULT, DOUBLE_ZERO, "layoutFullLineStretch");
        return FULL_LINE_STRETCH_DEFAULT;
    }

    public static double getFullColumnStretch() {
        FULL_COLUMN_STRETCH_DEFAULT = (Double)LayoutHelper.getModifierValue(FULL_COLUMN_STRETCH_DEFAULT, INITIAL_STRETCH_DEFAULT, DOUBLE_ZERO, "layoutFullColumnStretch");
        return FULL_COLUMN_STRETCH_DEFAULT;
    }

    private static Object getModifierValue(Object object, Object object2, Object object3, String string) {
        if (object2 instanceof Integer && (Integer)object >= (Integer)object3) {
            return object;
        }
        if (object2 instanceof Double && (Double)object >= (Double)object3) {
            return object;
        }
        Object object4 = object2;
        AutomatedInstallData automatedInstallData = AutomatedInstallData.getInstance();
        if (!(automatedInstallData instanceof InstallData)) {
            return object4;
        }
        String string2 = null;
        if (((InstallData)automatedInstallData).guiPrefs.modifier.containsKey(string) && (string2 = ((InstallData)automatedInstallData).guiPrefs.modifier.get(string)) != null) {
            try {
                if (object2 instanceof Integer) {
                    return Integer.parseInt(string2);
                }
                if (object2 instanceof Double) {
                    return Double.parseDouble(string2);
                }
                return string2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return object4;
    }

    public LayoutManager2 getLayout() {
        return this.izPanelLayout;
    }

    public void setLayout(LayoutManager2 layoutManager2) {
        this.izPanelLayout = layoutManager2;
    }
}

