// Code generated by "bson_corpus_spec_test_generator.go"; DO NOT EDIT

package bson_test

import (
	"encoding/hex"
	"time"

	"github.com/globalsign/mgo/bson"
	. "gopkg.in/check.v1"
)

func testValid(c *C, in []byte, expected []byte, result interface{}) {
	err := bson.Unmarshal(in, result)
	c.Assert(err, IsNil)

	out, err := bson.Marshal(result)
	c.Assert(err, IsNil)

	c.Assert(string(expected), Equals, string(out), Commentf("roundtrip failed for %T, expected '%x' but got '%x'", result, expected, out))
}

func testDecodeSkip(c *C, in []byte) {
	err := bson.Unmarshal(in, &struct{}{})
	c.Assert(err, IsNil)
}

func testDecodeError(c *C, in []byte, result interface{}) {
	err := bson.Unmarshal(in, result)
	c.Assert(err, Not(IsNil))
}

func (s *S) TestArray_Empty(c *C) {
	b, err := hex.DecodeString("0D000000046100050000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element []interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestArray_Single_Element_Array(c *C) {
	b, err := hex.DecodeString("140000000461000C0000001030000A0000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element []interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestArray_Single_Element_Array_with_index_set_incorrectly_1(c *C) {
	b, err := hex.DecodeString("130000000461000B00000010000A0000000000")
	c.Assert(err, IsNil)

	cb, err := hex.DecodeString("140000000461000C0000001030000A0000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element []interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestArray_Single_Element_Array_with_index_set_incorrectly(c *C) {
	b, err := hex.DecodeString("150000000461000D000000106162000A0000000000")
	c.Assert(err, IsNil)

	cb, err := hex.DecodeString("140000000461000C0000001030000A0000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element []interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestArray_Array_length_too_long__eats_outer_terminator(c *C) {
	b, err := hex.DecodeString("140000000461000D0000001030000A0000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestArray_Array_length_too_short__leaks_terminator(c *C) {
	b, err := hex.DecodeString("140000000461000B0000001030000A0000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestArray_Invalid_Array__bad_string_length_in_field(c *C) {
	b, err := hex.DecodeString("1A00000004666F6F00100000000230000500000062617A000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBinary_type_subtype_0x00__Zero_length_(c *C) {
	b, err := hex.DecodeString("0D000000057800000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element []byte `bson:"x"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_subtype_0x00(c *C) {
	b, err := hex.DecodeString("0F0000000578000200000000FFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element []byte `bson:"x"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_subtype_0x01(c *C) {
	b, err := hex.DecodeString("0F0000000578000200000001FFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_subtype_0x03(c *C) {
	b, err := hex.DecodeString("1D000000057800100000000373FFD26444B34C6990E8E7D1DFC035D400")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_subtype_0x04(c *C) {
	b, err := hex.DecodeString("1D000000057800100000000473FFD26444B34C6990E8E7D1DFC035D400")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_subtype_0x05(c *C) {
	b, err := hex.DecodeString("1D000000057800100000000573FFD26444B34C6990E8E7D1DFC035D400")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_subtype_0x80(c *C) {
	b, err := hex.DecodeString("0F0000000578000200000080FFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestBinary_type_Length_longer_than_document(c *C) {
	b, err := hex.DecodeString("1D000000057800FF0000000573FFD26444B34C6990E8E7D1DFC035D400")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBinary_type_Negative_length(c *C) {
	b, err := hex.DecodeString("0D000000057800FFFFFFFF0000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBinary_type_subtype_0x02_length_too_long_(c *C) {
	b, err := hex.DecodeString("13000000057800060000000203000000FFFF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBinary_type_subtype_0x02_length_too_short(c *C) {
	b, err := hex.DecodeString("13000000057800060000000201000000FFFF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBinary_type_subtype_0x02_length_negative_one(c *C) {
	b, err := hex.DecodeString("130000000578000600000002FFFFFFFFFFFF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBoolean_True(c *C) {
	b, err := hex.DecodeString("090000000862000100")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bool `bson:"b"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestBoolean_False(c *C) {
	b, err := hex.DecodeString("090000000862000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bool `bson:"b"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestBoolean_Invalid_boolean_value_of_2(c *C) {
	b, err := hex.DecodeString("090000000862000200")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestBoolean_Invalid_boolean_value_of__1(c *C) {
	b, err := hex.DecodeString("09000000086200FF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_Empty_string(c *C) {
	b, err := hex.DecodeString("0D0000000D6100010000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_Single_character(c *C) {
	b, err := hex.DecodeString("0E0000000D610002000000620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_Multi_character(c *C) {
	b, err := hex.DecodeString("190000000D61000D0000006162616261626162616261620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_two_byte_UTF_8____(c *C) {
	b, err := hex.DecodeString("190000000261000D000000C3A9C3A9C3A9C3A9C3A9C3A90000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_three_byte_UTF_8____(c *C) {
	b, err := hex.DecodeString("190000000261000D000000E29886E29886E29886E298860000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_Embedded_nulls(c *C) {
	b, err := hex.DecodeString("190000000261000D0000006162006261620062616261620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_bad_code_string_length__0__but_no_0x00_either_(c *C) {
	b, err := hex.DecodeString("0C0000000261000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_bad_code_string_length___1(c *C) {
	b, err := hex.DecodeString("0C000000026100FFFFFFFF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_bad_code_string_length__eats_terminator(c *C) {
	b, err := hex.DecodeString("10000000026100050000006200620000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_bad_code_string_length__longer_than_rest_of_document(c *C) {
	b, err := hex.DecodeString("120000000200FFFFFF00666F6F6261720000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_code_string_is_not_null_terminated(c *C) {
	b, err := hex.DecodeString("1000000002610004000000616263FF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_empty_code_string__but_extra_null(c *C) {
	b, err := hex.DecodeString("0E00000002610001000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_Empty_code_string__empty_scope(c *C) {
	b, err := hex.DecodeString("160000000F61000E0000000100000000050000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_with_Scope_Non_empty_code_string__empty_scope(c *C) {
	b, err := hex.DecodeString("1A0000000F610012000000050000006162636400050000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_with_Scope_Empty_code_string__non_empty_scope(c *C) {
	b, err := hex.DecodeString("1D0000000F61001500000001000000000C000000107800010000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_with_Scope_Non_empty_code_string_and_non_empty_scope(c *C) {
	b, err := hex.DecodeString("210000000F6100190000000500000061626364000C000000107800010000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_with_Scope_Unicode_and_embedded_null_in_code_string__empty_scope(c *C) {
	b, err := hex.DecodeString("1A0000000F61001200000005000000C3A9006400050000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestJavascript_Code_with_Scope_field_length_zero(c *C) {
	b, err := hex.DecodeString("280000000F6100000000000500000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_field_length_negative(c *C) {
	b, err := hex.DecodeString("280000000F6100FFFFFFFF0500000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_field_length_too_short__less_than_minimum_size_(c *C) {
	b, err := hex.DecodeString("160000000F61000D0000000100000000050000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_field_length_too_short__truncates_scope_(c *C) {
	b, err := hex.DecodeString("280000000F61001F0000000500000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_field_length_too_long__clips_outer_doc_(c *C) {
	b, err := hex.DecodeString("280000000F6100210000000500000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_field_length_too_long__longer_than_outer_doc_(c *C) {
	b, err := hex.DecodeString("280000000F6100FF0000000500000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_bad_code_string__length_too_short(c *C) {
	b, err := hex.DecodeString("280000000F6100200000000400000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_bad_code_string__length_too_long__clips_scope_(c *C) {
	b, err := hex.DecodeString("280000000F6100200000000600000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_bad_code_string__negative_length(c *C) {
	b, err := hex.DecodeString("280000000F610020000000FFFFFFFF61626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_bad_code_string__length_longer_than_field(c *C) {
	b, err := hex.DecodeString("280000000F610020000000FF00000061626364001300000010780001000000107900010000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestJavascript_Code_with_Scope_bad_scope_doc__field_has_bad_string_length_(c *C) {
	b, err := hex.DecodeString("1C0000000F001500000001000000000C000000020000000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDateTime_epoch(c *C) {
	b, err := hex.DecodeString("10000000096100000000000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element time.Time `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDateTime_positive_ms(c *C) {
	b, err := hex.DecodeString("10000000096100C4D8D6CC3B01000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element time.Time `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDateTime_negative(c *C) {
	b, err := hex.DecodeString("10000000096100C43CE7B9BDFFFFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element time.Time `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDateTime_datetime_field_truncated(c *C) {
	b, err := hex.DecodeString("0C0000000961001234567800")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDBPointer_type__deprecated__DBpointer(c *C) {
	b, err := hex.DecodeString("1A0000000C610002000000620056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBPointer_type__deprecated__DBpointer_with_opposite_key_order(c *C) {
	b, err := hex.DecodeString("1A0000000C610002000000620056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBPointer_type__deprecated__DBpointer_with_extra_keys(c *C) {
	b, err := hex.DecodeString("1A0000000C610002000000620056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBPointer_type__deprecated__With_two_byte_UTF_8(c *C) {
	b, err := hex.DecodeString("1B0000000C610003000000C3A90056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBPointer_type__deprecated__String_with_negative_length(c *C) {
	b, err := hex.DecodeString("1A0000000C6100FFFFFFFF620056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDBPointer_type__deprecated__String_with_zero_length(c *C) {
	b, err := hex.DecodeString("1A0000000C610000000000620056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDBPointer_type__deprecated__String_not_null_terminated(c *C) {
	b, err := hex.DecodeString("1A0000000C610002000000626256E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDBPointer_type__deprecated__short_OID__less_than_minimum_length_for_field_(c *C) {
	b, err := hex.DecodeString("160000000C61000300000061620056E1FC72E0C91700")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDBPointer_type__deprecated__short_OID__greater_than_minimum__but_truncated_(c *C) {
	b, err := hex.DecodeString("1A0000000C61000300000061620056E1FC72E0C917E9C4716100")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDBRef_DBRef(c *C) {
	b, err := hex.DecodeString("37000000036462726566002b0000000224726566000b000000636f6c6c656374696f6e00072469640058921b3e6e32ab156a22b59e0000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBRef_DBRef_with_database(c *C) {
	b, err := hex.DecodeString("4300000003646272656600370000000224726566000b000000636f6c6c656374696f6e00072469640058921b3e6e32ab156a22b59e0224646200030000006462000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBRef_DBRef_with_database_and_additional_fields(c *C) {
	b, err := hex.DecodeString("48000000036462726566003c0000000224726566000b000000636f6c6c656374696f6e0010246964002a00000002246462000300000064620002666f6f0004000000626172000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBRef_DBRef_with_additional_fields(c *C) {
	b, err := hex.DecodeString("4400000003646272656600380000000224726566000b000000636f6c6c656374696f6e00072469640058921b3e6e32ab156a22b59e02666f6f0004000000626172000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDBRef_Document_with_key_names_similar_to_those_of_a_DBRef(c *C) {
	b, err := hex.DecodeString("3e0000000224726566000c0000006e6f742d612d646272656600072469640058921b3e6e32ab156a22b59e022462616e616e6100050000007065656c0000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestDocument_type__sub_documents__Empty_subdoc(c *C) {
	b, err := hex.DecodeString("0D000000037800050000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bson.D `bson:"x"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDocument_type__sub_documents__Empty_string_key_subdoc(c *C) {
	b, err := hex.DecodeString("150000000378000D00000002000200000062000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bson.D `bson:"x"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDocument_type__sub_documents__Single_character_key_subdoc(c *C) {
	b, err := hex.DecodeString("160000000378000E0000000261000200000062000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bson.D `bson:"x"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDocument_type__sub_documents__Subdocument_length_too_long__eats_outer_terminator(c *C) {
	b, err := hex.DecodeString("1800000003666F6F000F0000001062617200FFFFFF7F0000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDocument_type__sub_documents__Subdocument_length_too_short__leaks_terminator(c *C) {
	b, err := hex.DecodeString("1500000003666F6F000A0000000862617200010000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDocument_type__sub_documents__Invalid_subdocument__bad_string_length_in_field(c *C) {
	b, err := hex.DecodeString("1C00000003666F6F001200000002626172000500000062617A000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestDouble_type__1_0_1(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000F03F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__1_0(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000F0BF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__1_0001220703125_1(c *C) {
	b, err := hex.DecodeString("10000000016400000000008000F03F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__1_0001220703125(c *C) {
	b, err := hex.DecodeString("10000000016400000000008000F0BF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__2_0001220703125e10_1(c *C) {
	b, err := hex.DecodeString("1000000001640000807ca1a9a0124200")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__2_0001220703125e10(c *C) {
	b, err := hex.DecodeString("1000000001640000807ca1a9a012c200")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type_0_0(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__0_0(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000008000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type_NaN(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000F87F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type_NaN_with_payload(c *C) {
	b, err := hex.DecodeString("10000000016400120000000000F87F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type_Inf(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000F07F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type__Inf(c *C) {
	b, err := hex.DecodeString("10000000016400000000000000F0FF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element float64 `bson:"d"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestDouble_type_double_truncated(c *C) {
	b, err := hex.DecodeString("0B0000000164000000F03F00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestInt32_type_MinValue(c *C) {
	b, err := hex.DecodeString("0C0000001069000000008000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int32 `bson:"i"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt32_type_MaxValue(c *C) {
	b, err := hex.DecodeString("0C000000106900FFFFFF7F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int32 `bson:"i"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt32_type__1(c *C) {
	b, err := hex.DecodeString("0C000000106900FFFFFFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int32 `bson:"i"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt32_type_0(c *C) {
	b, err := hex.DecodeString("0C0000001069000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int32 `bson:"i"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt32_type_1(c *C) {
	b, err := hex.DecodeString("0C0000001069000100000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int32 `bson:"i"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt32_type_Bad_int32_field_length(c *C) {
	b, err := hex.DecodeString("090000001061000500")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestInt64_type_MinValue(c *C) {
	b, err := hex.DecodeString("10000000126100000000000000008000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int64 `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt64_type_MaxValue(c *C) {
	b, err := hex.DecodeString("10000000126100FFFFFFFFFFFFFF7F00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int64 `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt64_type__1(c *C) {
	b, err := hex.DecodeString("10000000126100FFFFFFFFFFFFFFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int64 `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt64_type_0(c *C) {
	b, err := hex.DecodeString("10000000126100000000000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int64 `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt64_type_1(c *C) {
	b, err := hex.DecodeString("10000000126100010000000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element int64 `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestInt64_type_int64_field_truncated(c *C) {
	b, err := hex.DecodeString("0C0000001261001234567800")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestMaxkey_type_Maxkey(c *C) {
	b, err := hex.DecodeString("080000007F610000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestMinkey_type_Minkey(c *C) {
	b, err := hex.DecodeString("08000000FF610000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestMultiple_types_within_the_same_document_All_BSON_types(c *C) {
	b, err := hex.DecodeString("3b020000075f69640057e193d7a9cc81b4027498b50e53796d626f6c000700000073796d626f6c0002537472696e670007000000737472696e670010496e743332002a00000012496e743634002a0000000000000001446f75626c6500f6285c8fc23545400542696e617279001000000003a34c38f7c3abedc8a37814a992ab8db60542696e61727955736572446566696e656400050000008001020304050d436f6465000e00000066756e6374696f6e2829207b7d000f436f64655769746853636f7065001b0000000e00000066756e6374696f6e2829207b7d00050000000003537562646f63756d656e74001200000002666f6f0004000000626172000004417272617900280000001030000100000010310002000000103200030000001033000400000010340005000000001154696d657374616d7000010000002a0000000b5265676578007061747465726e0000094461746574696d6545706f6368000000000000000000094461746574696d65506f73697469766500ffffff7f00000000094461746574696d654e656761746976650000000080ffffffff085472756500010846616c736500000c4442506f696e746572000e00000064622e636f6c6c656374696f6e0057e193d7a9cc81b4027498b1034442526566003d0000000224726566000b000000636f6c6c656374696f6e00072469640057fd71e96e32ab4225b723fb02246462000900000064617461626173650000ff4d696e6b6579007f4d61786b6579000a4e756c6c0006556e646566696e65640000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestNull_type_Null(c *C) {
	b, err := hex.DecodeString("080000000A610000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestObjectId_All_zeroes(c *C) {
	b, err := hex.DecodeString("1400000007610000000000000000000000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bson.ObjectId `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestObjectId_All_ones(c *C) {
	b, err := hex.DecodeString("14000000076100FFFFFFFFFFFFFFFFFFFFFFFF00")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bson.ObjectId `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestObjectId_Random(c *C) {
	b, err := hex.DecodeString("1400000007610056E1FC72E0C917E9C471416100")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element bson.ObjectId `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestObjectId_OID_truncated(c *C) {
	b, err := hex.DecodeString("1200000007610056E1FC72E0C917E9C471")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestRegular_Expression_type_empty_regex_with_no_options(c *C) {
	b, err := hex.DecodeString("0A0000000B6100000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestRegular_Expression_type_regex_without_options(c *C) {
	b, err := hex.DecodeString("0D0000000B6100616263000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestRegular_Expression_type_regex_with_options(c *C) {
	b, err := hex.DecodeString("0F0000000B610061626300696D0000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestRegular_Expression_type_regex_with_slash(c *C) {
	b, err := hex.DecodeString("110000000B610061622F636400696D0000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestRegular_Expression_type_flags_not_alphabetized(c *C) {
	b, err := hex.DecodeString("100000000B6100616263006D69780000")
	c.Assert(err, IsNil)

	cb, err := hex.DecodeString("100000000B610061626300696D780000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestRegular_Expression_type_embedded_null_in_pattern(c *C) {
	b, err := hex.DecodeString("0F0000000B610061006300696D0000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestRegular_Expression_type_embedded_null_in_flags(c *C) {
	b, err := hex.DecodeString("100000000B61006162630069006D0000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestString_Empty_string(c *C) {
	b, err := hex.DecodeString("0D000000026100010000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element string `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestString_Single_character(c *C) {
	b, err := hex.DecodeString("0E00000002610002000000620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element string `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestString_Multi_character(c *C) {
	b, err := hex.DecodeString("190000000261000D0000006162616261626162616261620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element string `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestString_two_byte_UTF_8____(c *C) {
	b, err := hex.DecodeString("190000000261000D000000C3A9C3A9C3A9C3A9C3A9C3A90000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element string `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestString_three_byte_UTF_8____(c *C) {
	b, err := hex.DecodeString("190000000261000D000000E29886E29886E29886E298860000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element string `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestString_Embedded_nulls(c *C) {
	b, err := hex.DecodeString("190000000261000D0000006162006261620062616261620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element string `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestString_bad_string_length__0__but_no_0x00_either_(c *C) {
	b, err := hex.DecodeString("0C0000000261000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestString_bad_string_length___1(c *C) {
	b, err := hex.DecodeString("0C000000026100FFFFFFFF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestString_bad_string_length__eats_terminator(c *C) {
	b, err := hex.DecodeString("10000000026100050000006200620000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestString_bad_string_length__longer_than_rest_of_document(c *C) {
	b, err := hex.DecodeString("120000000200FFFFFF00666F6F6261720000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestString_string_is_not_null_terminated(c *C) {
	b, err := hex.DecodeString("1000000002610004000000616263FF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestString_empty_string__but_extra_null(c *C) {
	b, err := hex.DecodeString("0E00000002610001000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestSymbol_Empty_string(c *C) {
	b, err := hex.DecodeString("0D0000000E6100010000000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestSymbol_Single_character(c *C) {
	b, err := hex.DecodeString("0E0000000E610002000000620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestSymbol_Multi_character(c *C) {
	b, err := hex.DecodeString("190000000E61000D0000006162616261626162616261620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestSymbol_two_byte_UTF_8____(c *C) {
	b, err := hex.DecodeString("190000000E61000D000000C3A9C3A9C3A9C3A9C3A9C3A90000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestSymbol_three_byte_UTF_8____(c *C) {
	b, err := hex.DecodeString("190000000E61000D000000E29886E29886E29886E298860000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestSymbol_Embedded_nulls(c *C) {
	b, err := hex.DecodeString("190000000E61000D0000006162006261620062616261620000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestSymbol_bad_symbol_length__0__but_no_0x00_either_(c *C) {
	b, err := hex.DecodeString("0C0000000261000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestSymbol_bad_symbol_length___1(c *C) {
	b, err := hex.DecodeString("0C000000026100FFFFFFFF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestSymbol_bad_symbol_length__eats_terminator(c *C) {
	b, err := hex.DecodeString("10000000026100050000006200620000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestSymbol_bad_symbol_length__longer_than_rest_of_document(c *C) {
	b, err := hex.DecodeString("120000000200FFFFFF00666F6F6261720000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestSymbol_symbol_is_not_null_terminated(c *C) {
	b, err := hex.DecodeString("1000000002610004000000616263FF00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestSymbol_empty_symbol__but_extra_null(c *C) {
	b, err := hex.DecodeString("0E00000002610001000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTimestamp_type_Timestamp___123456789__42_(c *C) {
	b, err := hex.DecodeString("100000001161002A00000015CD5B0700")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)
	var resultS struct {
		Element interface{} `bson:"a"`
	}
	testValid(c, b, cb, &resultS)

	testDecodeSkip(c, b)
}

func (s *S) TestTimestamp_type_Truncated_timestamp_field(c *C) {
	b, err := hex.DecodeString("0f0000001161002A00000015CD5B00")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Document_with_keys_that_start_with__(c *C) {
	b, err := hex.DecodeString("0f00000010246b6579002a00000000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestTop_level_document_validity_Document_that_resembles_extended_JSON__but_with_extra_keys(c *C) {
	b, err := hex.DecodeString("3f00000002247265676578000c0000006e6f742d612d72656765780002246f7074696f6e7300020000006900022462616e616e6100050000007065656c0000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestTop_level_document_validity_Document_that_resembles_extended_JSON__but_with_missing_keys(c *C) {
	b, err := hex.DecodeString("1a000000022462696e6172790008000000616263646566670000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}

func (s *S) TestTop_level_document_validity_An_object_size_that_s_too_small_to_even_include_the_object_size__but_is_a_well_formed__empty_object(c *C) {
	b, err := hex.DecodeString("0100000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_An_object_size_that_s_only_enough_for_the_object_size__but_is_a_well_formed__empty_object(c *C) {
	b, err := hex.DecodeString("0400000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_One_object__with_length_shorter_than_size__missing_EOO_(c *C) {
	b, err := hex.DecodeString("05000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_One_object__sized_correctly__with_a_spot_for_an_EOO__but_the_EOO_is_0x01(c *C) {
	b, err := hex.DecodeString("0500000001")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_One_object__sized_correctly__with_a_spot_for_an_EOO__but_the_EOO_is_0xff(c *C) {
	b, err := hex.DecodeString("05000000FF")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_One_object__sized_correctly__with_a_spot_for_an_EOO__but_the_EOO_is_0x70(c *C) {
	b, err := hex.DecodeString("0500000070")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Byte_count_is_zero__with_non_zero_input_length_(c *C) {
	b, err := hex.DecodeString("00000000000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Stated_length_exceeds_byte_count__with_truncated_document(c *C) {
	b, err := hex.DecodeString("1200000002666F6F0004000000626172")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Stated_length_less_than_byte_count__with_garbage_after_envelope(c *C) {
	b, err := hex.DecodeString("1200000002666F6F00040000006261720000DEADBEEF")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Stated_length_exceeds_byte_count__with_valid_envelope(c *C) {
	b, err := hex.DecodeString("1300000002666F6F00040000006261720000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Stated_length_less_than_byte_count__with_valid_envelope(c *C) {
	b, err := hex.DecodeString("1100000002666F6F00040000006261720000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Invalid_BSON_type_low_range(c *C) {
	b, err := hex.DecodeString("07000000000000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Invalid_BSON_type_high_range(c *C) {
	b, err := hex.DecodeString("07000000800000")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestTop_level_document_validity_Document_truncated_mid_key(c *C) {
	b, err := hex.DecodeString("1200000002666F")
	c.Assert(err, IsNil)

	var resultD bson.D
	testDecodeError(c, b, &resultD)
}

func (s *S) TestUndefined_type__deprecated__Undefined(c *C) {
	b, err := hex.DecodeString("0800000006610000")
	c.Assert(err, IsNil)

	cb := b

	var resultD bson.D
	testValid(c, b, cb, &resultD)

	testDecodeSkip(c, b)
}
