package frontdoor

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// Allow ...
	Allow ActionType = "Allow"
	// Block ...
	Block ActionType = "Block"
	// Log ...
	Log ActionType = "Log"
	// Redirect ...
	Redirect ActionType = "Redirect"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{Allow, Block, Log, Redirect}
}

// Availability enumerates the values for availability.
type Availability string

const (
	// Available ...
	Available Availability = "Available"
	// Unavailable ...
	Unavailable Availability = "Unavailable"
)

// PossibleAvailabilityValues returns an array of possible values for the Availability const type.
func PossibleAvailabilityValues() []Availability {
	return []Availability{Available, Unavailable}
}

// BackendEnabledState enumerates the values for backend enabled state.
type BackendEnabledState string

const (
	// Disabled ...
	Disabled BackendEnabledState = "Disabled"
	// Enabled ...
	Enabled BackendEnabledState = "Enabled"
)

// PossibleBackendEnabledStateValues returns an array of possible values for the BackendEnabledState const type.
func PossibleBackendEnabledStateValues() []BackendEnabledState {
	return []BackendEnabledState{Disabled, Enabled}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceFrontDoor ...
	CertificateSourceFrontDoor CertificateSource = "FrontDoor"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceFrontDoor}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// CustomHTTPSProvisioningStateDisabled ...
	CustomHTTPSProvisioningStateDisabled CustomHTTPSProvisioningState = "Disabled"
	// CustomHTTPSProvisioningStateDisabling ...
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = "Disabling"
	// CustomHTTPSProvisioningStateEnabled ...
	CustomHTTPSProvisioningStateEnabled CustomHTTPSProvisioningState = "Enabled"
	// CustomHTTPSProvisioningStateEnabling ...
	CustomHTTPSProvisioningStateEnabling CustomHTTPSProvisioningState = "Enabling"
	// CustomHTTPSProvisioningStateFailed ...
	CustomHTTPSProvisioningStateFailed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{CustomHTTPSProvisioningStateDisabled, CustomHTTPSProvisioningStateDisabling, CustomHTTPSProvisioningStateEnabled, CustomHTTPSProvisioningStateEnabling, CustomHTTPSProvisioningStateFailed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// CustomRuleEnabledState enumerates the values for custom rule enabled state.
type CustomRuleEnabledState string

const (
	// CustomRuleEnabledStateDisabled ...
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	// CustomRuleEnabledStateEnabled ...
	CustomRuleEnabledStateEnabled CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns an array of possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{CustomRuleEnabledStateDisabled, CustomRuleEnabledStateEnabled}
}

// DynamicCompressionEnabled enumerates the values for dynamic compression enabled.
type DynamicCompressionEnabled string

const (
	// DynamicCompressionEnabledDisabled ...
	DynamicCompressionEnabledDisabled DynamicCompressionEnabled = "Disabled"
	// DynamicCompressionEnabledEnabled ...
	DynamicCompressionEnabledEnabled DynamicCompressionEnabled = "Enabled"
)

// PossibleDynamicCompressionEnabledValues returns an array of possible values for the DynamicCompressionEnabled const type.
func PossibleDynamicCompressionEnabledValues() []DynamicCompressionEnabled {
	return []DynamicCompressionEnabled{DynamicCompressionEnabledDisabled, DynamicCompressionEnabledEnabled}
}

// EnabledState enumerates the values for enabled state.
type EnabledState string

const (
	// EnabledStateDisabled ...
	EnabledStateDisabled EnabledState = "Disabled"
	// EnabledStateEnabled ...
	EnabledStateEnabled EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns an array of possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{EnabledStateDisabled, EnabledStateEnabled}
}

// EnforceCertificateNameCheckEnabledState enumerates the values for enforce certificate name check enabled
// state.
type EnforceCertificateNameCheckEnabledState string

const (
	// EnforceCertificateNameCheckEnabledStateDisabled ...
	EnforceCertificateNameCheckEnabledStateDisabled EnforceCertificateNameCheckEnabledState = "Disabled"
	// EnforceCertificateNameCheckEnabledStateEnabled ...
	EnforceCertificateNameCheckEnabledStateEnabled EnforceCertificateNameCheckEnabledState = "Enabled"
)

// PossibleEnforceCertificateNameCheckEnabledStateValues returns an array of possible values for the EnforceCertificateNameCheckEnabledState const type.
func PossibleEnforceCertificateNameCheckEnabledStateValues() []EnforceCertificateNameCheckEnabledState {
	return []EnforceCertificateNameCheckEnabledState{EnforceCertificateNameCheckEnabledStateDisabled, EnforceCertificateNameCheckEnabledStateEnabled}
}

// ForwardingProtocol enumerates the values for forwarding protocol.
type ForwardingProtocol string

const (
	// HTTPOnly ...
	HTTPOnly ForwardingProtocol = "HttpOnly"
	// HTTPSOnly ...
	HTTPSOnly ForwardingProtocol = "HttpsOnly"
	// MatchRequest ...
	MatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns an array of possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{HTTPOnly, HTTPSOnly, MatchRequest}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// MatchVariable enumerates the values for match variable.
type MatchVariable string

const (
	// Cookies ...
	Cookies MatchVariable = "Cookies"
	// PostArgs ...
	PostArgs MatchVariable = "PostArgs"
	// QueryString ...
	QueryString MatchVariable = "QueryString"
	// RemoteAddr ...
	RemoteAddr MatchVariable = "RemoteAddr"
	// RequestBody ...
	RequestBody MatchVariable = "RequestBody"
	// RequestHeader ...
	RequestHeader MatchVariable = "RequestHeader"
	// RequestMethod ...
	RequestMethod MatchVariable = "RequestMethod"
	// RequestURI ...
	RequestURI MatchVariable = "RequestUri"
	// SocketAddr ...
	SocketAddr MatchVariable = "SocketAddr"
)

// PossibleMatchVariableValues returns an array of possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{Cookies, PostArgs, QueryString, RemoteAddr, RequestBody, RequestHeader, RequestMethod, RequestURI, SocketAddr}
}

// NetworkOperationStatus enumerates the values for network operation status.
type NetworkOperationStatus string

const (
	// Failed ...
	Failed NetworkOperationStatus = "Failed"
	// InProgress ...
	InProgress NetworkOperationStatus = "InProgress"
	// Succeeded ...
	Succeeded NetworkOperationStatus = "Succeeded"
)

// PossibleNetworkOperationStatusValues returns an array of possible values for the NetworkOperationStatus const type.
func PossibleNetworkOperationStatusValues() []NetworkOperationStatus {
	return []NetworkOperationStatus{Failed, InProgress, Succeeded}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorForwardingConfiguration ...
	OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorForwardingConfiguration OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration"
	// OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorRedirectConfiguration ...
	OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorRedirectConfiguration OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration"
	// OdataTypeRouteConfiguration ...
	OdataTypeRouteConfiguration OdataType = "RouteConfiguration"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorForwardingConfiguration, OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorRedirectConfiguration, OdataTypeRouteConfiguration}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Any ...
	Any Operator = "Any"
	// BeginsWith ...
	BeginsWith Operator = "BeginsWith"
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equal ...
	Equal Operator = "Equal"
	// GeoMatch ...
	GeoMatch Operator = "GeoMatch"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// IPMatch ...
	IPMatch Operator = "IPMatch"
	// LessThan ...
	LessThan Operator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual Operator = "LessThanOrEqual"
	// RegEx ...
	RegEx Operator = "RegEx"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Any, BeginsWith, Contains, EndsWith, Equal, GeoMatch, GreaterThan, GreaterThanOrEqual, IPMatch, LessThan, LessThanOrEqual, RegEx}
}

// PolicyEnabledState enumerates the values for policy enabled state.
type PolicyEnabledState string

const (
	// PolicyEnabledStateDisabled ...
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	// PolicyEnabledStateEnabled ...
	PolicyEnabledStateEnabled PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns an array of possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{PolicyEnabledStateDisabled, PolicyEnabledStateEnabled}
}

// PolicyMode enumerates the values for policy mode.
type PolicyMode string

const (
	// Detection ...
	Detection PolicyMode = "Detection"
	// Prevention ...
	Prevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns an array of possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{Detection, Prevention}
}

// PolicyResourceState enumerates the values for policy resource state.
type PolicyResourceState string

const (
	// PolicyResourceStateCreating ...
	PolicyResourceStateCreating PolicyResourceState = "Creating"
	// PolicyResourceStateDeleting ...
	PolicyResourceStateDeleting PolicyResourceState = "Deleting"
	// PolicyResourceStateDisabled ...
	PolicyResourceStateDisabled PolicyResourceState = "Disabled"
	// PolicyResourceStateDisabling ...
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	// PolicyResourceStateEnabled ...
	PolicyResourceStateEnabled PolicyResourceState = "Enabled"
	// PolicyResourceStateEnabling ...
	PolicyResourceStateEnabling PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns an array of possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{PolicyResourceStateCreating, PolicyResourceStateDeleting, PolicyResourceStateDisabled, PolicyResourceStateDisabling, PolicyResourceStateEnabled, PolicyResourceStateEnabling}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// HTTP ...
	HTTP Protocol = "Http"
	// HTTPS ...
	HTTPS Protocol = "Https"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{HTTP, HTTPS}
}

// Query enumerates the values for query.
type Query string

const (
	// StripAll ...
	StripAll Query = "StripAll"
	// StripNone ...
	StripNone Query = "StripNone"
)

// PossibleQueryValues returns an array of possible values for the Query const type.
func PossibleQueryValues() []Query {
	return []Query{StripAll, StripNone}
}

// RedirectProtocol enumerates the values for redirect protocol.
type RedirectProtocol string

const (
	// RedirectProtocolHTTPOnly ...
	RedirectProtocolHTTPOnly RedirectProtocol = "HttpOnly"
	// RedirectProtocolHTTPSOnly ...
	RedirectProtocolHTTPSOnly RedirectProtocol = "HttpsOnly"
	// RedirectProtocolMatchRequest ...
	RedirectProtocolMatchRequest RedirectProtocol = "MatchRequest"
)

// PossibleRedirectProtocolValues returns an array of possible values for the RedirectProtocol const type.
func PossibleRedirectProtocolValues() []RedirectProtocol {
	return []RedirectProtocol{RedirectProtocolHTTPOnly, RedirectProtocolHTTPSOnly, RedirectProtocolMatchRequest}
}

// RedirectType enumerates the values for redirect type.
type RedirectType string

const (
	// Found ...
	Found RedirectType = "Found"
	// Moved ...
	Moved RedirectType = "Moved"
	// PermanentRedirect ...
	PermanentRedirect RedirectType = "PermanentRedirect"
	// TemporaryRedirect ...
	TemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns an array of possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{Found, Moved, PermanentRedirect, TemporaryRedirect}
}

// ResourceState enumerates the values for resource state.
type ResourceState string

const (
	// ResourceStateCreating ...
	ResourceStateCreating ResourceState = "Creating"
	// ResourceStateDeleting ...
	ResourceStateDeleting ResourceState = "Deleting"
	// ResourceStateDisabled ...
	ResourceStateDisabled ResourceState = "Disabled"
	// ResourceStateDisabling ...
	ResourceStateDisabling ResourceState = "Disabling"
	// ResourceStateEnabled ...
	ResourceStateEnabled ResourceState = "Enabled"
	// ResourceStateEnabling ...
	ResourceStateEnabling ResourceState = "Enabling"
)

// PossibleResourceStateValues returns an array of possible values for the ResourceState const type.
func PossibleResourceStateValues() []ResourceState {
	return []ResourceState{ResourceStateCreating, ResourceStateDeleting, ResourceStateDisabled, ResourceStateDisabling, ResourceStateEnabled, ResourceStateEnabling}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftNetworkfrontDoors ...
	MicrosoftNetworkfrontDoors ResourceType = "Microsoft.Network/frontDoors"
	// MicrosoftNetworkfrontDoorsfrontendEndpoints ...
	MicrosoftNetworkfrontDoorsfrontendEndpoints ResourceType = "Microsoft.Network/frontDoors/frontendEndpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftNetworkfrontDoors, MicrosoftNetworkfrontDoorsfrontendEndpoints}
}

// RoutingRuleEnabledState enumerates the values for routing rule enabled state.
type RoutingRuleEnabledState string

const (
	// RoutingRuleEnabledStateDisabled ...
	RoutingRuleEnabledStateDisabled RoutingRuleEnabledState = "Disabled"
	// RoutingRuleEnabledStateEnabled ...
	RoutingRuleEnabledStateEnabled RoutingRuleEnabledState = "Enabled"
)

// PossibleRoutingRuleEnabledStateValues returns an array of possible values for the RoutingRuleEnabledState const type.
func PossibleRoutingRuleEnabledStateValues() []RoutingRuleEnabledState {
	return []RoutingRuleEnabledState{RoutingRuleEnabledStateDisabled, RoutingRuleEnabledStateEnabled}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// MatchRule ...
	MatchRule RuleType = "MatchRule"
	// RateLimitRule ...
	RateLimitRule RuleType = "RateLimitRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{MatchRule, RateLimitRule}
}

// SessionAffinityEnabledState enumerates the values for session affinity enabled state.
type SessionAffinityEnabledState string

const (
	// SessionAffinityEnabledStateDisabled ...
	SessionAffinityEnabledStateDisabled SessionAffinityEnabledState = "Disabled"
	// SessionAffinityEnabledStateEnabled ...
	SessionAffinityEnabledStateEnabled SessionAffinityEnabledState = "Enabled"
)

// PossibleSessionAffinityEnabledStateValues returns an array of possible values for the SessionAffinityEnabledState const type.
func PossibleSessionAffinityEnabledStateValues() []SessionAffinityEnabledState {
	return []SessionAffinityEnabledState{SessionAffinityEnabledStateDisabled, SessionAffinityEnabledStateEnabled}
}

// TLSProtocolType enumerates the values for tls protocol type.
type TLSProtocolType string

const (
	// ServerNameIndication ...
	ServerNameIndication TLSProtocolType = "ServerNameIndication"
)

// PossibleTLSProtocolTypeValues returns an array of possible values for the TLSProtocolType const type.
func PossibleTLSProtocolTypeValues() []TLSProtocolType {
	return []TLSProtocolType{ServerNameIndication}
}

// TransformType enumerates the values for transform type.
type TransformType string

const (
	// Lowercase ...
	Lowercase TransformType = "Lowercase"
	// RemoveNulls ...
	RemoveNulls TransformType = "RemoveNulls"
	// Trim ...
	Trim TransformType = "Trim"
	// Uppercase ...
	Uppercase TransformType = "Uppercase"
	// URLDecode ...
	URLDecode TransformType = "UrlDecode"
	// URLEncode ...
	URLEncode TransformType = "UrlEncode"
)

// PossibleTransformTypeValues returns an array of possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{Lowercase, RemoveNulls, Trim, Uppercase, URLDecode, URLEncode}
}
