/*
 * Portions Copyright (c) 1987, 1993, 1994
 * The Regents of the University of California.  All rights reserved.
 *
 * Portions Copyright (c) 2003-2006, PostgreSQL Global Development Group
 *
 * $PostgreSQL: pgsql/src/include/getopt_long.h,v 1.6 2005/01/01 20:44:26 tgl Exp $
 */
#ifndef GETOPT_LONG_H
#define GETOPT_LONG_H
#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
/* These are picked up from the system's getopt() facility. */
extern int	opterr;
extern int	optind;
extern int	optopt;
extern char *optarg;
#endif

#if !defined(HAVE_GETOPT) || !defined(HAVE_INT_OPTRESET)
/* Some systems have this, otherwise you need to define it somewhere. */
extern int	optreset;
#endif

#ifndef HAVE_STRUCT_OPTION

struct option
{
	const char *name;
	int			has_arg;
	int		   *flag;
	int			val;
};

#define no_argument 0
#define required_argument 1
#endif

#ifndef HAVE_GETOPT_LONG

extern int getopt_long(int argc, char *const argv[],
			const char *optstring,
			const struct option * longopts, int *longindex);
#endif

#ifdef __cplusplus
}
#endif
#endif   /* GETOPT_LONG_H */
