// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/analytics/management/v1alpha/management_api.proto

package management

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for GetAccount RPC.
type GetAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the account to lookup.
	// Format: accounts/{account_id}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccountRequest) Reset() {
	*x = GetAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountRequest) ProtoMessage() {}

func (x *GetAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountRequest.ProtoReflect.Descriptor instead.
func (*GetAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{0}
}

func (x *GetAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccounts RPC.
type ListAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccounts` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccounts` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Accounts in the
	// results. Accounts can be inspected to determine whether they are deleted or
	// not.
	ShowDeleted bool `protobuf:"varint,3,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListAccountsRequest) Reset() {
	*x = ListAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsRequest) ProtoMessage() {}

func (x *ListAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{1}
}

func (x *ListAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAccountsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Request message for ListAccounts RPC.
type ListAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountsResponse) Reset() {
	*x = ListAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsResponse) ProtoMessage() {}

func (x *ListAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{2}
}

func (x *ListAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteAccount RPC.
type DeleteAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Account to soft-delete.
	// Format: accounts/{account_id}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccountRequest) Reset() {
	*x = DeleteAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccountRequest) ProtoMessage() {}

func (x *DeleteAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccountRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAccount RPC.
type UpdateAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to update.
	// The account's `name` field is used to identify the account.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccountRequest) Reset() {
	*x = UpdateAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountRequest) ProtoMessage() {}

func (x *UpdateAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAccountRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *UpdateAccountRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account to create.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Redirect URI where the user will be sent after accepting Terms of Service.
	// Must be configured in Developers Console as a Redirect URI
	RedirectUri string `protobuf:"bytes,2,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *ProvisionAccountTicketRequest) Reset() {
	*x = ProvisionAccountTicketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketRequest) ProtoMessage() {}

func (x *ProvisionAccountTicketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketRequest.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{5}
}

func (x *ProvisionAccountTicketRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *ProvisionAccountTicketRequest) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Response message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The param to be passed in the ToS link.
	AccountTicketId string `protobuf:"bytes,1,opt,name=account_ticket_id,json=accountTicketId,proto3" json:"account_ticket_id,omitempty"`
}

func (x *ProvisionAccountTicketResponse) Reset() {
	*x = ProvisionAccountTicketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketResponse) ProtoMessage() {}

func (x *ProvisionAccountTicketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketResponse.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{6}
}

func (x *ProvisionAccountTicketResponse) GetAccountTicketId() string {
	if x != nil {
		return x.AccountTicketId
	}
	return ""
}

// Request message for GetProperty RPC.
type GetPropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the property to lookup.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPropertyRequest) Reset() {
	*x = GetPropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPropertyRequest) ProtoMessage() {}

func (x *GetPropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPropertyRequest.ProtoReflect.Descriptor instead.
func (*GetPropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{7}
}

func (x *GetPropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListProperties RPC.
type ListPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An expression for filtering the results of the request.
	// Fields eligible for filtering are:
	// `parent:`(The resource name of the parent account) or
	// `firebase_project:`(The id or number of the linked firebase project).
	// Some examples of filters:
	//
	// | Filter                      | Description                               |
	// |-----------------------------|-------------------------------------------|
	// | parent:accounts/123         | The account with account id: 123.         |
	// | firebase_project:project-id | The firebase project with id: project-id. |
	// | firebase_project:123        | The firebase project with number: 123.    |
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListProperties` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Properties in the
	// results. Properties can be inspected to determine whether they are deleted
	// or not.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListPropertiesRequest) Reset() {
	*x = ListPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesRequest) ProtoMessage() {}

func (x *ListPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesRequest.ProtoReflect.Descriptor instead.
func (*ListPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{8}
}

func (x *ListPropertiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPropertiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPropertiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPropertiesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListProperties RPC.
type ListPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPropertiesResponse) Reset() {
	*x = ListPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesResponse) ProtoMessage() {}

func (x *ListPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesResponse.ProtoReflect.Descriptor instead.
func (*ListPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{9}
}

func (x *ListPropertiesResponse) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ListPropertiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateProperty RPC.
type UpdatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to update.
	// The property's `name` field is used to identify the property to be
	// updated.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePropertyRequest) Reset() {
	*x = UpdatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePropertyRequest) ProtoMessage() {}

func (x *UpdatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePropertyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{10}
}

func (x *UpdatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *UpdatePropertyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateProperty RPC.
type CreatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to create.
	// Note: the supplied property must specify its parent.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *CreatePropertyRequest) Reset() {
	*x = CreatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePropertyRequest) ProtoMessage() {}

func (x *CreatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePropertyRequest.ProtoReflect.Descriptor instead.
func (*CreatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{11}
}

func (x *CreatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

// Request message for DeleteProperty RPC.
type DeletePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Property to soft-delete.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePropertyRequest) Reset() {
	*x = DeletePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePropertyRequest) ProtoMessage() {}

func (x *DeletePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePropertyRequest.ProtoReflect.Descriptor instead.
func (*DeletePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{12}
}

func (x *DeletePropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetUserLink RPC.
type GetUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetUserLinkRequest) Reset() {
	*x = GetUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserLinkRequest) ProtoMessage() {}

func (x *GetUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserLinkRequest.ProtoReflect.Descriptor instead.
func (*GetUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{13}
}

func (x *GetUserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchGetUserLinks RPC.
type BatchGetUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent of all provided values for the 'names' field must match
	// this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the user links to retrieve.
	// A maximum of 1000 user links can be retrieved in a batch.
	// Format: accounts/{accountId}/userLinks/{userLinkId}
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetUserLinksRequest) Reset() {
	*x = BatchGetUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetUserLinksRequest) ProtoMessage() {}

func (x *BatchGetUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchGetUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{14}
}

func (x *BatchGetUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetUserLinksRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for BatchGetUserLinks RPC.
type BatchGetUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested user links.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchGetUserLinksResponse) Reset() {
	*x = BatchGetUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetUserLinksResponse) ProtoMessage() {}

func (x *BatchGetUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchGetUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{15}
}

func (x *BatchGetUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for ListUserLinks RPC.
type ListUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of user links to return.
	// The service may return fewer than this value.
	// If unspecified, at most 200 user links will be returned.
	// The maximum value is 500; values above 500 will be coerced to 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListUserLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListUserLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUserLinksRequest) Reset() {
	*x = ListUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserLinksRequest) ProtoMessage() {}

func (x *ListUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUserLinksRequest.ProtoReflect.Descriptor instead.
func (*ListUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{16}
}

func (x *ListUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListUserLinks RPC.
type ListUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of UserLinks. These will be ordered stably, but in an arbitrary order.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListUserLinksResponse) Reset() {
	*x = ListUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserLinksResponse) ProtoMessage() {}

func (x *ListUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUserLinksResponse.ProtoReflect.Descriptor instead.
func (*ListUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{17}
}

func (x *ListUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

func (x *ListUserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AuditUserLinks RPC.
type AuditUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of user links to return.
	// The service may return fewer than this value.
	// If unspecified, at most 1000 user links will be returned.
	// The maximum value is 5000; values above 5000 will be coerced to 5000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `AuditUserLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `AuditUserLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *AuditUserLinksRequest) Reset() {
	*x = AuditUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLinksRequest) ProtoMessage() {}

func (x *AuditUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLinksRequest.ProtoReflect.Descriptor instead.
func (*AuditUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{18}
}

func (x *AuditUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AuditUserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *AuditUserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for AuditUserLinks RPC.
type AuditUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of AuditUserLinks. These will be ordered stably, but in an arbitrary
	// order.
	UserLinks []*AuditUserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *AuditUserLinksResponse) Reset() {
	*x = AuditUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLinksResponse) ProtoMessage() {}

func (x *AuditUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLinksResponse.ProtoReflect.Descriptor instead.
func (*AuditUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{19}
}

func (x *AuditUserLinksResponse) GetUserLinks() []*AuditUserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

func (x *AuditUserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateUserLink RPC.
//
// Users can have multiple email addresses associated with their Google
// account, and one of these email addresses is the "primary" email address.
// Any of the email addresses associated with a Google account may be used
// for a new UserLink, but the returned UserLink will always contain the
// "primary" email address. As a result, the input and output email address
// for this request may differ.
type CreateUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user link to create.
	UserLink *UserLink `protobuf:"bytes,2,opt,name=user_link,json=userLink,proto3" json:"user_link,omitempty"`
}

func (x *CreateUserLinkRequest) Reset() {
	*x = CreateUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUserLinkRequest) ProtoMessage() {}

func (x *CreateUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUserLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{20}
}

func (x *CreateUserLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateUserLinkRequest) GetUserLink() *UserLink {
	if x != nil {
		return x.UserLink
	}
	return nil
}

// Request message for BatchCreateUserLinks RPC.
type BatchCreateUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are for.
	// This field is required. The parent field in the CreateUserLinkRequest
	// messages must either be empty or match this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The requests specifying the user links to create.
	// A maximum of 1000 user links can be created in a batch.
	Requests []*CreateUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateUserLinksRequest) Reset() {
	*x = BatchCreateUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateUserLinksRequest) ProtoMessage() {}

func (x *BatchCreateUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{21}
}

func (x *BatchCreateUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateUserLinksRequest) GetRequests() []*CreateUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchCreateUserLinks RPC.
type BatchCreateUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user links created.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchCreateUserLinksResponse) Reset() {
	*x = BatchCreateUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateUserLinksResponse) ProtoMessage() {}

func (x *BatchCreateUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{22}
}

func (x *BatchCreateUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for UpdateUserLink RPC.
type UpdateUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user link to update.
	UserLink *UserLink `protobuf:"bytes,1,opt,name=user_link,json=userLink,proto3" json:"user_link,omitempty"`
}

func (x *UpdateUserLinkRequest) Reset() {
	*x = UpdateUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserLinkRequest) ProtoMessage() {}

func (x *UpdateUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUserLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateUserLinkRequest) GetUserLink() *UserLink {
	if x != nil {
		return x.UserLink
	}
	return nil
}

// Request message for BatchUpdateUserLinks RPC.
type BatchUpdateUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent field in the UpdateUserLinkRequest messages must either be
	// empty or match this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*UpdateUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateUserLinksRequest) Reset() {
	*x = BatchUpdateUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateUserLinksRequest) ProtoMessage() {}

func (x *BatchUpdateUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{24}
}

func (x *BatchUpdateUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateUserLinksRequest) GetRequests() []*UpdateUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchUpdateUserLinks RPC.
type BatchUpdateUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user links updated.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchUpdateUserLinksResponse) Reset() {
	*x = BatchUpdateUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateUserLinksResponse) ProtoMessage() {}

func (x *BatchUpdateUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{25}
}

func (x *BatchUpdateUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for DeleteUserLink RPC.
type DeleteUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteUserLinkRequest) Reset() {
	*x = DeleteUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUserLinkRequest) ProtoMessage() {}

func (x *DeleteUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUserLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteUserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchDeleteUserLinks RPC.
type BatchDeleteUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent of all values for user link names to delete must match this
	// field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*DeleteUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchDeleteUserLinksRequest) Reset() {
	*x = BatchDeleteUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteUserLinksRequest) ProtoMessage() {}

func (x *BatchDeleteUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{27}
}

func (x *BatchDeleteUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteUserLinksRequest) GetRequests() []*DeleteUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Request message for GetWebDataStream RPC.
type GetWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the web data stream to lookup.
	// Format: properties/{property_id}/webDataStreams/{stream_id}
	// Example: "properties/123/webDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWebDataStreamRequest) Reset() {
	*x = GetWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWebDataStreamRequest) ProtoMessage() {}

func (x *GetWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{28}
}

func (x *GetWebDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteWebDataStream RPC.
type DeleteWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the web data stream to delete.
	// Format: properties/{property_id}/webDataStreams/{stream_id}
	// Example: "properties/123/webDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWebDataStreamRequest) Reset() {
	*x = DeleteWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWebDataStreamRequest) ProtoMessage() {}

func (x *DeleteWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteWebDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateWebDataStream RPC.
type UpdateWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The web stream to update.
	// The `name` field is used to identify the web stream to be updated.
	WebDataStream *WebDataStream `protobuf:"bytes,1,opt,name=web_data_stream,json=webDataStream,proto3" json:"web_data_stream,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWebDataStreamRequest) Reset() {
	*x = UpdateWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWebDataStreamRequest) ProtoMessage() {}

func (x *UpdateWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateWebDataStreamRequest) GetWebDataStream() *WebDataStream {
	if x != nil {
		return x.WebDataStream
	}
	return nil
}

func (x *UpdateWebDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateWebDataStream RPC.
type CreateWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The web stream to create.
	WebDataStream *WebDataStream `protobuf:"bytes,1,opt,name=web_data_stream,json=webDataStream,proto3" json:"web_data_stream,omitempty"`
	// Required. The parent resource where this web data stream will be created.
	// Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateWebDataStreamRequest) Reset() {
	*x = CreateWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWebDataStreamRequest) ProtoMessage() {}

func (x *CreateWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{31}
}

func (x *CreateWebDataStreamRequest) GetWebDataStream() *WebDataStream {
	if x != nil {
		return x.WebDataStream
	}
	return nil
}

func (x *CreateWebDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for ListWebDataStreams RPC.
type ListWebDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent property.
	// For example, to list results of web streams under the property with Id
	// 123: "properties/123"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListWebDataStreams` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListWebDataStreams` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWebDataStreamsRequest) Reset() {
	*x = ListWebDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWebDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWebDataStreamsRequest) ProtoMessage() {}

func (x *ListWebDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWebDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListWebDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{32}
}

func (x *ListWebDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWebDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWebDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListWebDataStreams RPC.
type ListWebDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	WebDataStreams []*WebDataStream `protobuf:"bytes,1,rep,name=web_data_streams,json=webDataStreams,proto3" json:"web_data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWebDataStreamsResponse) Reset() {
	*x = ListWebDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWebDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWebDataStreamsResponse) ProtoMessage() {}

func (x *ListWebDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWebDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListWebDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{33}
}

func (x *ListWebDataStreamsResponse) GetWebDataStreams() []*WebDataStream {
	if x != nil {
		return x.WebDataStreams
	}
	return nil
}

func (x *ListWebDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetIosAppDataStream RPC.
type GetIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the iOS app data stream to lookup.
	// Format: properties/{property_id}/iosAppDataStreams/{stream_id}
	// Example: "properties/123/iosAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIosAppDataStreamRequest) Reset() {
	*x = GetIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIosAppDataStreamRequest) ProtoMessage() {}

func (x *GetIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{34}
}

func (x *GetIosAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteIosAppDataStream RPC.
type DeleteIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the iOS app data stream to delete.
	// Format: properties/{property_id}/iosAppDataStreams/{stream_id}
	// Example: "properties/123/iosAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIosAppDataStreamRequest) Reset() {
	*x = DeleteIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIosAppDataStreamRequest) ProtoMessage() {}

func (x *DeleteIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteIosAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateIosAppDataStream RPC.
type UpdateIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The iOS app stream to update.
	// The `name` field is used to identify the iOS app stream to be updated.
	IosAppDataStream *IosAppDataStream `protobuf:"bytes,1,opt,name=ios_app_data_stream,json=iosAppDataStream,proto3" json:"ios_app_data_stream,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIosAppDataStreamRequest) Reset() {
	*x = UpdateIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIosAppDataStreamRequest) ProtoMessage() {}

func (x *UpdateIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateIosAppDataStreamRequest) GetIosAppDataStream() *IosAppDataStream {
	if x != nil {
		return x.IosAppDataStream
	}
	return nil
}

func (x *UpdateIosAppDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateIosAppDataStream RPC.
type CreateIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The iOS app data stream to create.
	IosAppDataStream *IosAppDataStream `protobuf:"bytes,1,opt,name=ios_app_data_stream,json=iosAppDataStream,proto3" json:"ios_app_data_stream,omitempty"`
	// Required. The parent resource where this ios app data stream will be created.
	// Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateIosAppDataStreamRequest) Reset() {
	*x = CreateIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIosAppDataStreamRequest) ProtoMessage() {}

func (x *CreateIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{37}
}

func (x *CreateIosAppDataStreamRequest) GetIosAppDataStream() *IosAppDataStream {
	if x != nil {
		return x.IosAppDataStream
	}
	return nil
}

func (x *CreateIosAppDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for ListIosAppDataStreams RPC.
type ListIosAppDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent property.
	// For example, to list results of app streams under the property with Id
	// 123: "properties/123"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListIosAppDataStreams`
	// call. Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListIosAppDataStreams`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIosAppDataStreamsRequest) Reset() {
	*x = ListIosAppDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIosAppDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIosAppDataStreamsRequest) ProtoMessage() {}

func (x *ListIosAppDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIosAppDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListIosAppDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{38}
}

func (x *ListIosAppDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIosAppDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIosAppDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListIosAppDataStreams RPC.
type ListIosAppDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	IosAppDataStreams []*IosAppDataStream `protobuf:"bytes,1,rep,name=ios_app_data_streams,json=iosAppDataStreams,proto3" json:"ios_app_data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIosAppDataStreamsResponse) Reset() {
	*x = ListIosAppDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIosAppDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIosAppDataStreamsResponse) ProtoMessage() {}

func (x *ListIosAppDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIosAppDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListIosAppDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{39}
}

func (x *ListIosAppDataStreamsResponse) GetIosAppDataStreams() []*IosAppDataStream {
	if x != nil {
		return x.IosAppDataStreams
	}
	return nil
}

func (x *ListIosAppDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetAndroidAppDataStream RPC.
type GetAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the android app data stream to lookup.
	// Format: properties/{property_id}/androidAppDataStreams/{stream_id}
	// Example: "properties/123/androidAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAndroidAppDataStreamRequest) Reset() {
	*x = GetAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *GetAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{40}
}

func (x *GetAndroidAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteAndroidAppDataStream RPC.
type DeleteAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the android app data stream to delete.
	// Format: properties/{property_id}/androidAppDataStreams/{stream_id}
	// Example: "properties/123/androidAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAndroidAppDataStreamRequest) Reset() {
	*x = DeleteAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *DeleteAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{41}
}

func (x *DeleteAndroidAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAndroidAppDataStream RPC.
type UpdateAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The android app stream to update.
	// The `name` field is used to identify the android app stream to be updated.
	AndroidAppDataStream *AndroidAppDataStream `protobuf:"bytes,1,opt,name=android_app_data_stream,json=androidAppDataStream,proto3" json:"android_app_data_stream,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAndroidAppDataStreamRequest) Reset() {
	*x = UpdateAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *UpdateAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{42}
}

func (x *UpdateAndroidAppDataStreamRequest) GetAndroidAppDataStream() *AndroidAppDataStream {
	if x != nil {
		return x.AndroidAppDataStream
	}
	return nil
}

func (x *UpdateAndroidAppDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateAndroidAppDataStream RPC.
type CreateAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The android app stream to create.
	AndroidAppDataStream *AndroidAppDataStream `protobuf:"bytes,1,opt,name=android_app_data_stream,json=androidAppDataStream,proto3" json:"android_app_data_stream,omitempty"`
	// Required. The parent resource where this android app data stream will be created.
	// Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateAndroidAppDataStreamRequest) Reset() {
	*x = CreateAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *CreateAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{43}
}

func (x *CreateAndroidAppDataStreamRequest) GetAndroidAppDataStream() *AndroidAppDataStream {
	if x != nil {
		return x.AndroidAppDataStream
	}
	return nil
}

func (x *CreateAndroidAppDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for ListAndroidAppDataStreams RPC.
type ListAndroidAppDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent property.
	// For example, to limit results to app streams under the property with Id
	// 123: "properties/123"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	//
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous call. Provide this to
	// retrieve the subsequent page.
	// When paginating, all other parameters provided to
	// `ListAndroidAppDataStreams` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAndroidAppDataStreamsRequest) Reset() {
	*x = ListAndroidAppDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAndroidAppDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAndroidAppDataStreamsRequest) ProtoMessage() {}

func (x *ListAndroidAppDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAndroidAppDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListAndroidAppDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{44}
}

func (x *ListAndroidAppDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAndroidAppDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAndroidAppDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListAndroidDataStreams RPC.
type ListAndroidAppDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	AndroidAppDataStreams []*AndroidAppDataStream `protobuf:"bytes,1,rep,name=android_app_data_streams,json=androidAppDataStreams,proto3" json:"android_app_data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAndroidAppDataStreamsResponse) Reset() {
	*x = ListAndroidAppDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAndroidAppDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAndroidAppDataStreamsResponse) ProtoMessage() {}

func (x *ListAndroidAppDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAndroidAppDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListAndroidAppDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{45}
}

func (x *ListAndroidAppDataStreamsResponse) GetAndroidAppDataStreams() []*AndroidAppDataStream {
	if x != nil {
		return x.AndroidAppDataStreams
	}
	return nil
}

func (x *ListAndroidAppDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetEnhancedMeasurementSettings RPC.
type GetEnhancedMeasurementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurementSettings
	// Example: "properties/1000/webDataStreams/2000/enhancedMeasurementSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEnhancedMeasurementSettingsRequest) Reset() {
	*x = GetEnhancedMeasurementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEnhancedMeasurementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnhancedMeasurementSettingsRequest) ProtoMessage() {}

func (x *GetEnhancedMeasurementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnhancedMeasurementSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetEnhancedMeasurementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{46}
}

func (x *GetEnhancedMeasurementSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateEnhancedMeasurementSettings RPC.
type UpdateEnhancedMeasurementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	EnhancedMeasurementSettings *EnhancedMeasurementSettings `protobuf:"bytes,1,opt,name=enhanced_measurement_settings,json=enhancedMeasurementSettings,proto3" json:"enhanced_measurement_settings,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEnhancedMeasurementSettingsRequest) Reset() {
	*x = UpdateEnhancedMeasurementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEnhancedMeasurementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEnhancedMeasurementSettingsRequest) ProtoMessage() {}

func (x *UpdateEnhancedMeasurementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEnhancedMeasurementSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateEnhancedMeasurementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateEnhancedMeasurementSettingsRequest) GetEnhancedMeasurementSettings() *EnhancedMeasurementSettings {
	if x != nil {
		return x.EnhancedMeasurementSettings
	}
	return nil
}

func (x *UpdateEnhancedMeasurementSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateFirebaseLink RPC
type CreateFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Firebase link to create.
	FirebaseLink *FirebaseLink `protobuf:"bytes,2,opt,name=firebase_link,json=firebaseLink,proto3" json:"firebase_link,omitempty"`
}

func (x *CreateFirebaseLinkRequest) Reset() {
	*x = CreateFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFirebaseLinkRequest) ProtoMessage() {}

func (x *CreateFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{48}
}

func (x *CreateFirebaseLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFirebaseLinkRequest) GetFirebaseLink() *FirebaseLink {
	if x != nil {
		return x.FirebaseLink
	}
	return nil
}

// Request message for UpdateFirebaseLink RPC
type UpdateFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Firebase link to update.
	FirebaseLink *FirebaseLink `protobuf:"bytes,1,opt,name=firebase_link,json=firebaseLink,proto3" json:"firebase_link,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFirebaseLinkRequest) Reset() {
	*x = UpdateFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFirebaseLinkRequest) ProtoMessage() {}

func (x *UpdateFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{49}
}

func (x *UpdateFirebaseLinkRequest) GetFirebaseLink() *FirebaseLink {
	if x != nil {
		return x.FirebaseLink
	}
	return nil
}

func (x *UpdateFirebaseLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteFirebaseLink RPC
type DeleteFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
	// Example: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFirebaseLinkRequest) Reset() {
	*x = DeleteFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFirebaseLinkRequest) ProtoMessage() {}

func (x *DeleteFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{50}
}

func (x *DeleteFirebaseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListFirebaseLinks RPC
type ListFirebaseLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListFirebaseLinksRequest) Reset() {
	*x = ListFirebaseLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksRequest) ProtoMessage() {}

func (x *ListFirebaseLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksRequest.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{51}
}

func (x *ListFirebaseLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for ListFirebaseLinks RPC
type ListFirebaseLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of FirebaseLinks. This will have at most one value.
	FirebaseLinks []*FirebaseLink `protobuf:"bytes,1,rep,name=firebase_links,json=firebaseLinks,proto3" json:"firebase_links,omitempty"`
}

func (x *ListFirebaseLinksResponse) Reset() {
	*x = ListFirebaseLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksResponse) ProtoMessage() {}

func (x *ListFirebaseLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksResponse.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{52}
}

func (x *ListFirebaseLinksResponse) GetFirebaseLinks() []*FirebaseLink {
	if x != nil {
		return x.FirebaseLinks
	}
	return nil
}

// Request message for GetGlobalSiteTag RPC.
type GetGlobalSiteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the site tag to lookup.
	// Note that site tags are singletons and do not have unique IDs.
	// Format: properties/{property_id}/webDataStreams/{stream_id}/globalSiteTag
	// Example: "properties/123/webDataStreams/456/globalSiteTag"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGlobalSiteTagRequest) Reset() {
	*x = GetGlobalSiteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGlobalSiteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGlobalSiteTagRequest) ProtoMessage() {}

func (x *GetGlobalSiteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGlobalSiteTagRequest.ProtoReflect.Descriptor instead.
func (*GetGlobalSiteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{53}
}

func (x *GetGlobalSiteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateGoogleAdsLink RPC
type CreateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The GoogleAdsLink to create.
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,2,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
}

func (x *CreateGoogleAdsLinkRequest) Reset() {
	*x = CreateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *CreateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{54}
}

func (x *CreateGoogleAdsLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

// Request message for UpdateGoogleAdsLink RPC
type UpdateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GoogleAdsLink to update
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,1,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleAdsLinkRequest) Reset() {
	*x = UpdateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *UpdateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{55}
}

func (x *UpdateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

func (x *UpdateGoogleAdsLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteGoogleAdsLink RPC.
type DeleteGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/googleAdsLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGoogleAdsLinkRequest) Reset() {
	*x = DeleteGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGoogleAdsLinkRequest) ProtoMessage() {}

func (x *DeleteGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{56}
}

func (x *DeleteGoogleAdsLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListGoogleAdsLinks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGoogleAdsLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGoogleAdsLinksRequest) Reset() {
	*x = ListGoogleAdsLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksRequest) ProtoMessage() {}

func (x *ListGoogleAdsLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksRequest.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{57}
}

func (x *ListGoogleAdsLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGoogleAdsLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGoogleAdsLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAdsLink `protobuf:"bytes,1,rep,name=google_ads_links,json=googleAdsLinks,proto3" json:"google_ads_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGoogleAdsLinksResponse) Reset() {
	*x = ListGoogleAdsLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksResponse) ProtoMessage() {}

func (x *ListGoogleAdsLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_management_v1alpha_management_api_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksResponse.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP(), []int{58}
}

func (x *ListGoogleAdsLinksResponse) GetGoogleAdsLinks() []*GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLinks
	}
	return nil
}

func (x *ListGoogleAdsLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_analytics_management_v1alpha_management_api_proto protoreflect.FileDescriptor

var file_google_analytics_management_v1alpha_management_api_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a,
	0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5b, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68,
	0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x88, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8a, 0x01, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x55, 0x72, 0x69, 0x22, 0x4c, 0x0a, 0x1e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74,
	0x49, 0x64, 0x22, 0x5d, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x93, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x8f, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x67, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x60, 0x0a, 0x15, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5d, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x18, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12,
	0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22,
	0x69, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x9f, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa0, 0x01, 0x0a,
	0x15, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x93, 0x01, 0x0a, 0x16, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x92, 0x01,
	0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x22, 0x6c, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x22, 0x68, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x92, 0x01, 0x0a, 0x1b, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22,
	0x6c, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4c, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x60, 0x0a,
	0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x92, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x22, 0x67, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x57, 0x65, 0x62, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a,
	0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x32, 0x0a, 0x30, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x1a, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x77, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xcf, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xa9, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6d, 0x0a, 0x1a, 0x47, 0x65, 0x74,
	0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a,
	0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x1d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x13,
	0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0xdf, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x13, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70,
	0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x12, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6f,
	0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xaf, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x12,
	0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaf, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x14, 0x69, 0x6f,
	0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x11, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x75, 0x0a, 0x1e, 0x47, 0x65,
	0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x78, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x21,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x75, 0x0a, 0x17, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x14, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xf3, 0x01, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x75, 0x0a, 0x17, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xb7, 0x01, 0x0a, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbf, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x72, 0x0a, 0x18, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x15, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x45,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x5a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x0a, 0x3e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x68, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf3, 0x01,
	0x0a, 0x28, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x89, 0x01, 0x0a, 0x1d, 0x65,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1b, 0x65, 0x6e, 0x68, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0xc9, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22,
	0xb5, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a,
	0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x68, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x6b, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x75,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x67, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcf,
	0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x5f, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x5a, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6a, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa2, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5c, 0x0a, 0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xff, 0x52, 0x0a, 0x0a, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x9d, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x13, 0x12, 0x11, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1c, 0x2a, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc3, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x32, 0x22, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0xda, 0x41, 0x13, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xd6, 0x01, 0x0a, 0x16,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65,
	0x74, 0x3a, 0x01, 0x2a, 0x12, 0xa2, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa6, 0x01, 0x0a, 0x0e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0xad, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x08, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda, 0x41, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x91, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1e, 0x2a, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x32, 0x25, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda, 0x41, 0x14,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xd8, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x54, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a, 0x12, 0x28,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x80, 0x02, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x12, 0x2f, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x5a, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47,
	0x65, 0x74, 0x12, 0xeb, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x63, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x54, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x5a, 0x2a, 0x12, 0x28, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xf7, 0x01, 0x0a, 0x0e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x66, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x3a, 0x61, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0x81, 0x02, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x6a, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x5a, 0x35, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x10, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x95,
	0x02, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x8e, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7e, 0x32, 0x30, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5a, 0x3f, 0x32, 0x32, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x09, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x95, 0x02, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12,
	0xc7, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x2a, 0x26,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a, 0x2a, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xea, 0x01, 0x0a, 0x14, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x78, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xc2, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x57, 0x65,
	0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x3c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xac, 0x01, 0x0a, 0x13,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x80, 0x02, 0x0a, 0x13, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57,
	0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32,
	0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x77, 0x65, 0x62, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f,
	0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda,
	0x41, 0x1b, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xeb, 0x01,
	0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x40, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x3a, 0x0f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x65, 0x62, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0xd5, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xce, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb5, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x99, 0x02, 0x0a,
	0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x32, 0x44, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x13, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x1f, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xff, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6f,
	0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x6a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x3a, 0x13, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70,
	0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x1a,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0xe1, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xde,
	0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xc1, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x43,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xb5, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x93, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x32, 0x4c,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x17, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x23, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f,
	0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x97, 0x02, 0x0a, 0x1a,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x76, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x3a, 0x17, 0x61, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0xf1, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x88, 0x02, 0x0a, 0x1e, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf2, 0x02, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xbb, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x88, 0x01, 0x32, 0x67, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x1d,
	0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x29,
	0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xe3, 0x01, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x2c, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0xf6, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4b, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x66, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x19, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa9, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a,
	0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd1, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd0, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74,
	0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x22,
	0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xeb, 0x01, 0x0a, 0x13,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x22, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a,
	0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x80, 0x02, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32, 0x3d,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xac, 0x01, 0x0a,
	0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd5, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x1a, 0x81, 0x02, 0xca, 0x41, 0x22, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xd8, 0x01, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x65, 0x64, 0x69, 0x74, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x2e, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64,
	0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x8e, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x42, 0x12, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x70, 0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_management_v1alpha_management_api_proto_rawDescOnce sync.Once
	file_google_analytics_management_v1alpha_management_api_proto_rawDescData = file_google_analytics_management_v1alpha_management_api_proto_rawDesc
)

func file_google_analytics_management_v1alpha_management_api_proto_rawDescGZIP() []byte {
	file_google_analytics_management_v1alpha_management_api_proto_rawDescOnce.Do(func() {
		file_google_analytics_management_v1alpha_management_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_management_v1alpha_management_api_proto_rawDescData)
	})
	return file_google_analytics_management_v1alpha_management_api_proto_rawDescData
}

var file_google_analytics_management_v1alpha_management_api_proto_msgTypes = make([]protoimpl.MessageInfo, 59)
var file_google_analytics_management_v1alpha_management_api_proto_goTypes = []interface{}{
	(*GetAccountRequest)(nil),                        // 0: google.analytics.management.v1alpha.GetAccountRequest
	(*ListAccountsRequest)(nil),                      // 1: google.analytics.management.v1alpha.ListAccountsRequest
	(*ListAccountsResponse)(nil),                     // 2: google.analytics.management.v1alpha.ListAccountsResponse
	(*DeleteAccountRequest)(nil),                     // 3: google.analytics.management.v1alpha.DeleteAccountRequest
	(*UpdateAccountRequest)(nil),                     // 4: google.analytics.management.v1alpha.UpdateAccountRequest
	(*ProvisionAccountTicketRequest)(nil),            // 5: google.analytics.management.v1alpha.ProvisionAccountTicketRequest
	(*ProvisionAccountTicketResponse)(nil),           // 6: google.analytics.management.v1alpha.ProvisionAccountTicketResponse
	(*GetPropertyRequest)(nil),                       // 7: google.analytics.management.v1alpha.GetPropertyRequest
	(*ListPropertiesRequest)(nil),                    // 8: google.analytics.management.v1alpha.ListPropertiesRequest
	(*ListPropertiesResponse)(nil),                   // 9: google.analytics.management.v1alpha.ListPropertiesResponse
	(*UpdatePropertyRequest)(nil),                    // 10: google.analytics.management.v1alpha.UpdatePropertyRequest
	(*CreatePropertyRequest)(nil),                    // 11: google.analytics.management.v1alpha.CreatePropertyRequest
	(*DeletePropertyRequest)(nil),                    // 12: google.analytics.management.v1alpha.DeletePropertyRequest
	(*GetUserLinkRequest)(nil),                       // 13: google.analytics.management.v1alpha.GetUserLinkRequest
	(*BatchGetUserLinksRequest)(nil),                 // 14: google.analytics.management.v1alpha.BatchGetUserLinksRequest
	(*BatchGetUserLinksResponse)(nil),                // 15: google.analytics.management.v1alpha.BatchGetUserLinksResponse
	(*ListUserLinksRequest)(nil),                     // 16: google.analytics.management.v1alpha.ListUserLinksRequest
	(*ListUserLinksResponse)(nil),                    // 17: google.analytics.management.v1alpha.ListUserLinksResponse
	(*AuditUserLinksRequest)(nil),                    // 18: google.analytics.management.v1alpha.AuditUserLinksRequest
	(*AuditUserLinksResponse)(nil),                   // 19: google.analytics.management.v1alpha.AuditUserLinksResponse
	(*CreateUserLinkRequest)(nil),                    // 20: google.analytics.management.v1alpha.CreateUserLinkRequest
	(*BatchCreateUserLinksRequest)(nil),              // 21: google.analytics.management.v1alpha.BatchCreateUserLinksRequest
	(*BatchCreateUserLinksResponse)(nil),             // 22: google.analytics.management.v1alpha.BatchCreateUserLinksResponse
	(*UpdateUserLinkRequest)(nil),                    // 23: google.analytics.management.v1alpha.UpdateUserLinkRequest
	(*BatchUpdateUserLinksRequest)(nil),              // 24: google.analytics.management.v1alpha.BatchUpdateUserLinksRequest
	(*BatchUpdateUserLinksResponse)(nil),             // 25: google.analytics.management.v1alpha.BatchUpdateUserLinksResponse
	(*DeleteUserLinkRequest)(nil),                    // 26: google.analytics.management.v1alpha.DeleteUserLinkRequest
	(*BatchDeleteUserLinksRequest)(nil),              // 27: google.analytics.management.v1alpha.BatchDeleteUserLinksRequest
	(*GetWebDataStreamRequest)(nil),                  // 28: google.analytics.management.v1alpha.GetWebDataStreamRequest
	(*DeleteWebDataStreamRequest)(nil),               // 29: google.analytics.management.v1alpha.DeleteWebDataStreamRequest
	(*UpdateWebDataStreamRequest)(nil),               // 30: google.analytics.management.v1alpha.UpdateWebDataStreamRequest
	(*CreateWebDataStreamRequest)(nil),               // 31: google.analytics.management.v1alpha.CreateWebDataStreamRequest
	(*ListWebDataStreamsRequest)(nil),                // 32: google.analytics.management.v1alpha.ListWebDataStreamsRequest
	(*ListWebDataStreamsResponse)(nil),               // 33: google.analytics.management.v1alpha.ListWebDataStreamsResponse
	(*GetIosAppDataStreamRequest)(nil),               // 34: google.analytics.management.v1alpha.GetIosAppDataStreamRequest
	(*DeleteIosAppDataStreamRequest)(nil),            // 35: google.analytics.management.v1alpha.DeleteIosAppDataStreamRequest
	(*UpdateIosAppDataStreamRequest)(nil),            // 36: google.analytics.management.v1alpha.UpdateIosAppDataStreamRequest
	(*CreateIosAppDataStreamRequest)(nil),            // 37: google.analytics.management.v1alpha.CreateIosAppDataStreamRequest
	(*ListIosAppDataStreamsRequest)(nil),             // 38: google.analytics.management.v1alpha.ListIosAppDataStreamsRequest
	(*ListIosAppDataStreamsResponse)(nil),            // 39: google.analytics.management.v1alpha.ListIosAppDataStreamsResponse
	(*GetAndroidAppDataStreamRequest)(nil),           // 40: google.analytics.management.v1alpha.GetAndroidAppDataStreamRequest
	(*DeleteAndroidAppDataStreamRequest)(nil),        // 41: google.analytics.management.v1alpha.DeleteAndroidAppDataStreamRequest
	(*UpdateAndroidAppDataStreamRequest)(nil),        // 42: google.analytics.management.v1alpha.UpdateAndroidAppDataStreamRequest
	(*CreateAndroidAppDataStreamRequest)(nil),        // 43: google.analytics.management.v1alpha.CreateAndroidAppDataStreamRequest
	(*ListAndroidAppDataStreamsRequest)(nil),         // 44: google.analytics.management.v1alpha.ListAndroidAppDataStreamsRequest
	(*ListAndroidAppDataStreamsResponse)(nil),        // 45: google.analytics.management.v1alpha.ListAndroidAppDataStreamsResponse
	(*GetEnhancedMeasurementSettingsRequest)(nil),    // 46: google.analytics.management.v1alpha.GetEnhancedMeasurementSettingsRequest
	(*UpdateEnhancedMeasurementSettingsRequest)(nil), // 47: google.analytics.management.v1alpha.UpdateEnhancedMeasurementSettingsRequest
	(*CreateFirebaseLinkRequest)(nil),                // 48: google.analytics.management.v1alpha.CreateFirebaseLinkRequest
	(*UpdateFirebaseLinkRequest)(nil),                // 49: google.analytics.management.v1alpha.UpdateFirebaseLinkRequest
	(*DeleteFirebaseLinkRequest)(nil),                // 50: google.analytics.management.v1alpha.DeleteFirebaseLinkRequest
	(*ListFirebaseLinksRequest)(nil),                 // 51: google.analytics.management.v1alpha.ListFirebaseLinksRequest
	(*ListFirebaseLinksResponse)(nil),                // 52: google.analytics.management.v1alpha.ListFirebaseLinksResponse
	(*GetGlobalSiteTagRequest)(nil),                  // 53: google.analytics.management.v1alpha.GetGlobalSiteTagRequest
	(*CreateGoogleAdsLinkRequest)(nil),               // 54: google.analytics.management.v1alpha.CreateGoogleAdsLinkRequest
	(*UpdateGoogleAdsLinkRequest)(nil),               // 55: google.analytics.management.v1alpha.UpdateGoogleAdsLinkRequest
	(*DeleteGoogleAdsLinkRequest)(nil),               // 56: google.analytics.management.v1alpha.DeleteGoogleAdsLinkRequest
	(*ListGoogleAdsLinksRequest)(nil),                // 57: google.analytics.management.v1alpha.ListGoogleAdsLinksRequest
	(*ListGoogleAdsLinksResponse)(nil),               // 58: google.analytics.management.v1alpha.ListGoogleAdsLinksResponse
	(*Account)(nil),                                  // 59: google.analytics.management.v1alpha.Account
	(*fieldmaskpb.FieldMask)(nil),                    // 60: google.protobuf.FieldMask
	(*Property)(nil),                                 // 61: google.analytics.management.v1alpha.Property
	(*UserLink)(nil),                                 // 62: google.analytics.management.v1alpha.UserLink
	(*AuditUserLink)(nil),                            // 63: google.analytics.management.v1alpha.AuditUserLink
	(*WebDataStream)(nil),                            // 64: google.analytics.management.v1alpha.WebDataStream
	(*IosAppDataStream)(nil),                         // 65: google.analytics.management.v1alpha.IosAppDataStream
	(*AndroidAppDataStream)(nil),                     // 66: google.analytics.management.v1alpha.AndroidAppDataStream
	(*EnhancedMeasurementSettings)(nil),              // 67: google.analytics.management.v1alpha.EnhancedMeasurementSettings
	(*FirebaseLink)(nil),                             // 68: google.analytics.management.v1alpha.FirebaseLink
	(*GoogleAdsLink)(nil),                            // 69: google.analytics.management.v1alpha.GoogleAdsLink
	(*emptypb.Empty)(nil),                            // 70: google.protobuf.Empty
	(*GlobalSiteTag)(nil),                            // 71: google.analytics.management.v1alpha.GlobalSiteTag
}
var file_google_analytics_management_v1alpha_management_api_proto_depIdxs = []int32{
	59, // 0: google.analytics.management.v1alpha.ListAccountsResponse.accounts:type_name -> google.analytics.management.v1alpha.Account
	59, // 1: google.analytics.management.v1alpha.UpdateAccountRequest.account:type_name -> google.analytics.management.v1alpha.Account
	60, // 2: google.analytics.management.v1alpha.UpdateAccountRequest.update_mask:type_name -> google.protobuf.FieldMask
	59, // 3: google.analytics.management.v1alpha.ProvisionAccountTicketRequest.account:type_name -> google.analytics.management.v1alpha.Account
	61, // 4: google.analytics.management.v1alpha.ListPropertiesResponse.properties:type_name -> google.analytics.management.v1alpha.Property
	61, // 5: google.analytics.management.v1alpha.UpdatePropertyRequest.property:type_name -> google.analytics.management.v1alpha.Property
	60, // 6: google.analytics.management.v1alpha.UpdatePropertyRequest.update_mask:type_name -> google.protobuf.FieldMask
	61, // 7: google.analytics.management.v1alpha.CreatePropertyRequest.property:type_name -> google.analytics.management.v1alpha.Property
	62, // 8: google.analytics.management.v1alpha.BatchGetUserLinksResponse.user_links:type_name -> google.analytics.management.v1alpha.UserLink
	62, // 9: google.analytics.management.v1alpha.ListUserLinksResponse.user_links:type_name -> google.analytics.management.v1alpha.UserLink
	63, // 10: google.analytics.management.v1alpha.AuditUserLinksResponse.user_links:type_name -> google.analytics.management.v1alpha.AuditUserLink
	62, // 11: google.analytics.management.v1alpha.CreateUserLinkRequest.user_link:type_name -> google.analytics.management.v1alpha.UserLink
	20, // 12: google.analytics.management.v1alpha.BatchCreateUserLinksRequest.requests:type_name -> google.analytics.management.v1alpha.CreateUserLinkRequest
	62, // 13: google.analytics.management.v1alpha.BatchCreateUserLinksResponse.user_links:type_name -> google.analytics.management.v1alpha.UserLink
	62, // 14: google.analytics.management.v1alpha.UpdateUserLinkRequest.user_link:type_name -> google.analytics.management.v1alpha.UserLink
	23, // 15: google.analytics.management.v1alpha.BatchUpdateUserLinksRequest.requests:type_name -> google.analytics.management.v1alpha.UpdateUserLinkRequest
	62, // 16: google.analytics.management.v1alpha.BatchUpdateUserLinksResponse.user_links:type_name -> google.analytics.management.v1alpha.UserLink
	26, // 17: google.analytics.management.v1alpha.BatchDeleteUserLinksRequest.requests:type_name -> google.analytics.management.v1alpha.DeleteUserLinkRequest
	64, // 18: google.analytics.management.v1alpha.UpdateWebDataStreamRequest.web_data_stream:type_name -> google.analytics.management.v1alpha.WebDataStream
	60, // 19: google.analytics.management.v1alpha.UpdateWebDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	64, // 20: google.analytics.management.v1alpha.CreateWebDataStreamRequest.web_data_stream:type_name -> google.analytics.management.v1alpha.WebDataStream
	64, // 21: google.analytics.management.v1alpha.ListWebDataStreamsResponse.web_data_streams:type_name -> google.analytics.management.v1alpha.WebDataStream
	65, // 22: google.analytics.management.v1alpha.UpdateIosAppDataStreamRequest.ios_app_data_stream:type_name -> google.analytics.management.v1alpha.IosAppDataStream
	60, // 23: google.analytics.management.v1alpha.UpdateIosAppDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	65, // 24: google.analytics.management.v1alpha.CreateIosAppDataStreamRequest.ios_app_data_stream:type_name -> google.analytics.management.v1alpha.IosAppDataStream
	65, // 25: google.analytics.management.v1alpha.ListIosAppDataStreamsResponse.ios_app_data_streams:type_name -> google.analytics.management.v1alpha.IosAppDataStream
	66, // 26: google.analytics.management.v1alpha.UpdateAndroidAppDataStreamRequest.android_app_data_stream:type_name -> google.analytics.management.v1alpha.AndroidAppDataStream
	60, // 27: google.analytics.management.v1alpha.UpdateAndroidAppDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	66, // 28: google.analytics.management.v1alpha.CreateAndroidAppDataStreamRequest.android_app_data_stream:type_name -> google.analytics.management.v1alpha.AndroidAppDataStream
	66, // 29: google.analytics.management.v1alpha.ListAndroidAppDataStreamsResponse.android_app_data_streams:type_name -> google.analytics.management.v1alpha.AndroidAppDataStream
	67, // 30: google.analytics.management.v1alpha.UpdateEnhancedMeasurementSettingsRequest.enhanced_measurement_settings:type_name -> google.analytics.management.v1alpha.EnhancedMeasurementSettings
	60, // 31: google.analytics.management.v1alpha.UpdateEnhancedMeasurementSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	68, // 32: google.analytics.management.v1alpha.CreateFirebaseLinkRequest.firebase_link:type_name -> google.analytics.management.v1alpha.FirebaseLink
	68, // 33: google.analytics.management.v1alpha.UpdateFirebaseLinkRequest.firebase_link:type_name -> google.analytics.management.v1alpha.FirebaseLink
	60, // 34: google.analytics.management.v1alpha.UpdateFirebaseLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	68, // 35: google.analytics.management.v1alpha.ListFirebaseLinksResponse.firebase_links:type_name -> google.analytics.management.v1alpha.FirebaseLink
	69, // 36: google.analytics.management.v1alpha.CreateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.management.v1alpha.GoogleAdsLink
	69, // 37: google.analytics.management.v1alpha.UpdateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.management.v1alpha.GoogleAdsLink
	60, // 38: google.analytics.management.v1alpha.UpdateGoogleAdsLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	69, // 39: google.analytics.management.v1alpha.ListGoogleAdsLinksResponse.google_ads_links:type_name -> google.analytics.management.v1alpha.GoogleAdsLink
	0,  // 40: google.analytics.management.v1alpha.Management.GetAccount:input_type -> google.analytics.management.v1alpha.GetAccountRequest
	1,  // 41: google.analytics.management.v1alpha.Management.ListAccounts:input_type -> google.analytics.management.v1alpha.ListAccountsRequest
	3,  // 42: google.analytics.management.v1alpha.Management.DeleteAccount:input_type -> google.analytics.management.v1alpha.DeleteAccountRequest
	4,  // 43: google.analytics.management.v1alpha.Management.UpdateAccount:input_type -> google.analytics.management.v1alpha.UpdateAccountRequest
	5,  // 44: google.analytics.management.v1alpha.Management.ProvisionAccountTicket:input_type -> google.analytics.management.v1alpha.ProvisionAccountTicketRequest
	7,  // 45: google.analytics.management.v1alpha.Management.GetProperty:input_type -> google.analytics.management.v1alpha.GetPropertyRequest
	8,  // 46: google.analytics.management.v1alpha.Management.ListProperties:input_type -> google.analytics.management.v1alpha.ListPropertiesRequest
	11, // 47: google.analytics.management.v1alpha.Management.CreateProperty:input_type -> google.analytics.management.v1alpha.CreatePropertyRequest
	12, // 48: google.analytics.management.v1alpha.Management.DeleteProperty:input_type -> google.analytics.management.v1alpha.DeletePropertyRequest
	10, // 49: google.analytics.management.v1alpha.Management.UpdateProperty:input_type -> google.analytics.management.v1alpha.UpdatePropertyRequest
	13, // 50: google.analytics.management.v1alpha.Management.GetUserLink:input_type -> google.analytics.management.v1alpha.GetUserLinkRequest
	14, // 51: google.analytics.management.v1alpha.Management.BatchGetUserLinks:input_type -> google.analytics.management.v1alpha.BatchGetUserLinksRequest
	16, // 52: google.analytics.management.v1alpha.Management.ListUserLinks:input_type -> google.analytics.management.v1alpha.ListUserLinksRequest
	18, // 53: google.analytics.management.v1alpha.Management.AuditUserLinks:input_type -> google.analytics.management.v1alpha.AuditUserLinksRequest
	20, // 54: google.analytics.management.v1alpha.Management.CreateUserLink:input_type -> google.analytics.management.v1alpha.CreateUserLinkRequest
	21, // 55: google.analytics.management.v1alpha.Management.BatchCreateUserLinks:input_type -> google.analytics.management.v1alpha.BatchCreateUserLinksRequest
	23, // 56: google.analytics.management.v1alpha.Management.UpdateUserLink:input_type -> google.analytics.management.v1alpha.UpdateUserLinkRequest
	24, // 57: google.analytics.management.v1alpha.Management.BatchUpdateUserLinks:input_type -> google.analytics.management.v1alpha.BatchUpdateUserLinksRequest
	26, // 58: google.analytics.management.v1alpha.Management.DeleteUserLink:input_type -> google.analytics.management.v1alpha.DeleteUserLinkRequest
	27, // 59: google.analytics.management.v1alpha.Management.BatchDeleteUserLinks:input_type -> google.analytics.management.v1alpha.BatchDeleteUserLinksRequest
	28, // 60: google.analytics.management.v1alpha.Management.GetWebDataStream:input_type -> google.analytics.management.v1alpha.GetWebDataStreamRequest
	29, // 61: google.analytics.management.v1alpha.Management.DeleteWebDataStream:input_type -> google.analytics.management.v1alpha.DeleteWebDataStreamRequest
	30, // 62: google.analytics.management.v1alpha.Management.UpdateWebDataStream:input_type -> google.analytics.management.v1alpha.UpdateWebDataStreamRequest
	31, // 63: google.analytics.management.v1alpha.Management.CreateWebDataStream:input_type -> google.analytics.management.v1alpha.CreateWebDataStreamRequest
	32, // 64: google.analytics.management.v1alpha.Management.ListWebDataStreams:input_type -> google.analytics.management.v1alpha.ListWebDataStreamsRequest
	34, // 65: google.analytics.management.v1alpha.Management.GetIosAppDataStream:input_type -> google.analytics.management.v1alpha.GetIosAppDataStreamRequest
	35, // 66: google.analytics.management.v1alpha.Management.DeleteIosAppDataStream:input_type -> google.analytics.management.v1alpha.DeleteIosAppDataStreamRequest
	36, // 67: google.analytics.management.v1alpha.Management.UpdateIosAppDataStream:input_type -> google.analytics.management.v1alpha.UpdateIosAppDataStreamRequest
	37, // 68: google.analytics.management.v1alpha.Management.CreateIosAppDataStream:input_type -> google.analytics.management.v1alpha.CreateIosAppDataStreamRequest
	38, // 69: google.analytics.management.v1alpha.Management.ListIosAppDataStreams:input_type -> google.analytics.management.v1alpha.ListIosAppDataStreamsRequest
	40, // 70: google.analytics.management.v1alpha.Management.GetAndroidAppDataStream:input_type -> google.analytics.management.v1alpha.GetAndroidAppDataStreamRequest
	41, // 71: google.analytics.management.v1alpha.Management.DeleteAndroidAppDataStream:input_type -> google.analytics.management.v1alpha.DeleteAndroidAppDataStreamRequest
	42, // 72: google.analytics.management.v1alpha.Management.UpdateAndroidAppDataStream:input_type -> google.analytics.management.v1alpha.UpdateAndroidAppDataStreamRequest
	43, // 73: google.analytics.management.v1alpha.Management.CreateAndroidAppDataStream:input_type -> google.analytics.management.v1alpha.CreateAndroidAppDataStreamRequest
	44, // 74: google.analytics.management.v1alpha.Management.ListAndroidAppDataStreams:input_type -> google.analytics.management.v1alpha.ListAndroidAppDataStreamsRequest
	46, // 75: google.analytics.management.v1alpha.Management.GetEnhancedMeasurementSettings:input_type -> google.analytics.management.v1alpha.GetEnhancedMeasurementSettingsRequest
	47, // 76: google.analytics.management.v1alpha.Management.UpdateEnhancedMeasurementSettings:input_type -> google.analytics.management.v1alpha.UpdateEnhancedMeasurementSettingsRequest
	48, // 77: google.analytics.management.v1alpha.Management.CreateFirebaseLink:input_type -> google.analytics.management.v1alpha.CreateFirebaseLinkRequest
	49, // 78: google.analytics.management.v1alpha.Management.UpdateFirebaseLink:input_type -> google.analytics.management.v1alpha.UpdateFirebaseLinkRequest
	50, // 79: google.analytics.management.v1alpha.Management.DeleteFirebaseLink:input_type -> google.analytics.management.v1alpha.DeleteFirebaseLinkRequest
	51, // 80: google.analytics.management.v1alpha.Management.ListFirebaseLinks:input_type -> google.analytics.management.v1alpha.ListFirebaseLinksRequest
	53, // 81: google.analytics.management.v1alpha.Management.GetGlobalSiteTag:input_type -> google.analytics.management.v1alpha.GetGlobalSiteTagRequest
	54, // 82: google.analytics.management.v1alpha.Management.CreateGoogleAdsLink:input_type -> google.analytics.management.v1alpha.CreateGoogleAdsLinkRequest
	55, // 83: google.analytics.management.v1alpha.Management.UpdateGoogleAdsLink:input_type -> google.analytics.management.v1alpha.UpdateGoogleAdsLinkRequest
	56, // 84: google.analytics.management.v1alpha.Management.DeleteGoogleAdsLink:input_type -> google.analytics.management.v1alpha.DeleteGoogleAdsLinkRequest
	57, // 85: google.analytics.management.v1alpha.Management.ListGoogleAdsLinks:input_type -> google.analytics.management.v1alpha.ListGoogleAdsLinksRequest
	59, // 86: google.analytics.management.v1alpha.Management.GetAccount:output_type -> google.analytics.management.v1alpha.Account
	2,  // 87: google.analytics.management.v1alpha.Management.ListAccounts:output_type -> google.analytics.management.v1alpha.ListAccountsResponse
	70, // 88: google.analytics.management.v1alpha.Management.DeleteAccount:output_type -> google.protobuf.Empty
	59, // 89: google.analytics.management.v1alpha.Management.UpdateAccount:output_type -> google.analytics.management.v1alpha.Account
	6,  // 90: google.analytics.management.v1alpha.Management.ProvisionAccountTicket:output_type -> google.analytics.management.v1alpha.ProvisionAccountTicketResponse
	61, // 91: google.analytics.management.v1alpha.Management.GetProperty:output_type -> google.analytics.management.v1alpha.Property
	9,  // 92: google.analytics.management.v1alpha.Management.ListProperties:output_type -> google.analytics.management.v1alpha.ListPropertiesResponse
	61, // 93: google.analytics.management.v1alpha.Management.CreateProperty:output_type -> google.analytics.management.v1alpha.Property
	70, // 94: google.analytics.management.v1alpha.Management.DeleteProperty:output_type -> google.protobuf.Empty
	61, // 95: google.analytics.management.v1alpha.Management.UpdateProperty:output_type -> google.analytics.management.v1alpha.Property
	62, // 96: google.analytics.management.v1alpha.Management.GetUserLink:output_type -> google.analytics.management.v1alpha.UserLink
	15, // 97: google.analytics.management.v1alpha.Management.BatchGetUserLinks:output_type -> google.analytics.management.v1alpha.BatchGetUserLinksResponse
	17, // 98: google.analytics.management.v1alpha.Management.ListUserLinks:output_type -> google.analytics.management.v1alpha.ListUserLinksResponse
	19, // 99: google.analytics.management.v1alpha.Management.AuditUserLinks:output_type -> google.analytics.management.v1alpha.AuditUserLinksResponse
	62, // 100: google.analytics.management.v1alpha.Management.CreateUserLink:output_type -> google.analytics.management.v1alpha.UserLink
	22, // 101: google.analytics.management.v1alpha.Management.BatchCreateUserLinks:output_type -> google.analytics.management.v1alpha.BatchCreateUserLinksResponse
	62, // 102: google.analytics.management.v1alpha.Management.UpdateUserLink:output_type -> google.analytics.management.v1alpha.UserLink
	25, // 103: google.analytics.management.v1alpha.Management.BatchUpdateUserLinks:output_type -> google.analytics.management.v1alpha.BatchUpdateUserLinksResponse
	70, // 104: google.analytics.management.v1alpha.Management.DeleteUserLink:output_type -> google.protobuf.Empty
	70, // 105: google.analytics.management.v1alpha.Management.BatchDeleteUserLinks:output_type -> google.protobuf.Empty
	64, // 106: google.analytics.management.v1alpha.Management.GetWebDataStream:output_type -> google.analytics.management.v1alpha.WebDataStream
	70, // 107: google.analytics.management.v1alpha.Management.DeleteWebDataStream:output_type -> google.protobuf.Empty
	64, // 108: google.analytics.management.v1alpha.Management.UpdateWebDataStream:output_type -> google.analytics.management.v1alpha.WebDataStream
	64, // 109: google.analytics.management.v1alpha.Management.CreateWebDataStream:output_type -> google.analytics.management.v1alpha.WebDataStream
	33, // 110: google.analytics.management.v1alpha.Management.ListWebDataStreams:output_type -> google.analytics.management.v1alpha.ListWebDataStreamsResponse
	65, // 111: google.analytics.management.v1alpha.Management.GetIosAppDataStream:output_type -> google.analytics.management.v1alpha.IosAppDataStream
	70, // 112: google.analytics.management.v1alpha.Management.DeleteIosAppDataStream:output_type -> google.protobuf.Empty
	65, // 113: google.analytics.management.v1alpha.Management.UpdateIosAppDataStream:output_type -> google.analytics.management.v1alpha.IosAppDataStream
	65, // 114: google.analytics.management.v1alpha.Management.CreateIosAppDataStream:output_type -> google.analytics.management.v1alpha.IosAppDataStream
	39, // 115: google.analytics.management.v1alpha.Management.ListIosAppDataStreams:output_type -> google.analytics.management.v1alpha.ListIosAppDataStreamsResponse
	66, // 116: google.analytics.management.v1alpha.Management.GetAndroidAppDataStream:output_type -> google.analytics.management.v1alpha.AndroidAppDataStream
	70, // 117: google.analytics.management.v1alpha.Management.DeleteAndroidAppDataStream:output_type -> google.protobuf.Empty
	66, // 118: google.analytics.management.v1alpha.Management.UpdateAndroidAppDataStream:output_type -> google.analytics.management.v1alpha.AndroidAppDataStream
	66, // 119: google.analytics.management.v1alpha.Management.CreateAndroidAppDataStream:output_type -> google.analytics.management.v1alpha.AndroidAppDataStream
	45, // 120: google.analytics.management.v1alpha.Management.ListAndroidAppDataStreams:output_type -> google.analytics.management.v1alpha.ListAndroidAppDataStreamsResponse
	67, // 121: google.analytics.management.v1alpha.Management.GetEnhancedMeasurementSettings:output_type -> google.analytics.management.v1alpha.EnhancedMeasurementSettings
	67, // 122: google.analytics.management.v1alpha.Management.UpdateEnhancedMeasurementSettings:output_type -> google.analytics.management.v1alpha.EnhancedMeasurementSettings
	68, // 123: google.analytics.management.v1alpha.Management.CreateFirebaseLink:output_type -> google.analytics.management.v1alpha.FirebaseLink
	68, // 124: google.analytics.management.v1alpha.Management.UpdateFirebaseLink:output_type -> google.analytics.management.v1alpha.FirebaseLink
	70, // 125: google.analytics.management.v1alpha.Management.DeleteFirebaseLink:output_type -> google.protobuf.Empty
	52, // 126: google.analytics.management.v1alpha.Management.ListFirebaseLinks:output_type -> google.analytics.management.v1alpha.ListFirebaseLinksResponse
	71, // 127: google.analytics.management.v1alpha.Management.GetGlobalSiteTag:output_type -> google.analytics.management.v1alpha.GlobalSiteTag
	69, // 128: google.analytics.management.v1alpha.Management.CreateGoogleAdsLink:output_type -> google.analytics.management.v1alpha.GoogleAdsLink
	69, // 129: google.analytics.management.v1alpha.Management.UpdateGoogleAdsLink:output_type -> google.analytics.management.v1alpha.GoogleAdsLink
	70, // 130: google.analytics.management.v1alpha.Management.DeleteGoogleAdsLink:output_type -> google.protobuf.Empty
	58, // 131: google.analytics.management.v1alpha.Management.ListGoogleAdsLinks:output_type -> google.analytics.management.v1alpha.ListGoogleAdsLinksResponse
	86, // [86:132] is the sub-list for method output_type
	40, // [40:86] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_google_analytics_management_v1alpha_management_api_proto_init() }
func file_google_analytics_management_v1alpha_management_api_proto_init() {
	if File_google_analytics_management_v1alpha_management_api_proto != nil {
		return
	}
	file_google_analytics_management_v1alpha_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWebDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWebDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIosAppDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIosAppDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAndroidAppDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAndroidAppDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEnhancedMeasurementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEnhancedMeasurementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGlobalSiteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_management_v1alpha_management_api_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_management_v1alpha_management_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   59,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_management_v1alpha_management_api_proto_goTypes,
		DependencyIndexes: file_google_analytics_management_v1alpha_management_api_proto_depIdxs,
		MessageInfos:      file_google_analytics_management_v1alpha_management_api_proto_msgTypes,
	}.Build()
	File_google_analytics_management_v1alpha_management_api_proto = out.File
	file_google_analytics_management_v1alpha_management_api_proto_rawDesc = nil
	file_google_analytics_management_v1alpha_management_api_proto_goTypes = nil
	file_google_analytics_management_v1alpha_management_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ManagementClient is the client API for Management service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ManagementClient interface {
	// Lookup for a single Account.
	// Throws "Target not found" if no such account found, or if caller does not
	// have permissions to access it.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have App+Web properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error)
	// Lookup for a single "App+Web" Property.
	//
	// Throws "Target not found" if no such property found, if property is not
	// of the type "App+Web", or if caller does not have permissions to access it.
	GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "App+Web" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error)
	// Creates an "App+Web" property with the specified location and attributes.
	CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an App+Web Property.
	DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a property.
	UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Gets information about a user's link to an account or property.
	GetUserLink(ctx context.Context, in *GetUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Gets information about multiple users' links to an account or property.
	BatchGetUserLinks(ctx context.Context, in *BatchGetUserLinksRequest, opts ...grpc.CallOption) (*BatchGetUserLinksResponse, error)
	// Lists all user links on an account or property.
	ListUserLinks(ctx context.Context, in *ListUserLinksRequest, opts ...grpc.CallOption) (*ListUserLinksResponse, error)
	// Lists all user links on an account or property, including implicit ones
	// that come from effective permissions granted by groups or organization
	// admin roles.
	//
	// If a returned user link does not have direct permissions, they cannot
	// be removed from the account or property directly with the DeleteUserLink
	// command. They have to be removed from the group/etc that gives them
	// permissions, which is currently only usable/discoverable in the GA or GMP
	// UIs.
	AuditUserLinks(ctx context.Context, in *AuditUserLinksRequest, opts ...grpc.CallOption) (*AuditUserLinksResponse, error)
	// Creates a user link on an account or property.
	//
	// If the user with the specified email already has permissions on the
	// account or property, then the user's existing permissions will be unioned
	// with the permissions specified in the new UserLink.
	CreateUserLink(ctx context.Context, in *CreateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Creates information about multiple users' links to an account or property.
	//
	// This method is transactional. If any UserLink cannot be created, none of
	// the UserLinks will be created.
	BatchCreateUserLinks(ctx context.Context, in *BatchCreateUserLinksRequest, opts ...grpc.CallOption) (*BatchCreateUserLinksResponse, error)
	// Updates a user link on an account or property.
	UpdateUserLink(ctx context.Context, in *UpdateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Updates information about multiple users' links to an account or property.
	BatchUpdateUserLinks(ctx context.Context, in *BatchUpdateUserLinksRequest, opts ...grpc.CallOption) (*BatchUpdateUserLinksResponse, error)
	// Deletes a user link on an account or property.
	DeleteUserLink(ctx context.Context, in *DeleteUserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteUserLinks(ctx context.Context, in *BatchDeleteUserLinksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single WebDataStream
	//
	// Throws "Target not found" if no such web data stream found, or if the
	// caller does not have permissions to access it.
	GetWebDataStream(ctx context.Context, in *GetWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error)
	// Deletes a web stream on a property.
	DeleteWebDataStream(ctx context.Context, in *DeleteWebDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a web stream on a property.
	UpdateWebDataStream(ctx context.Context, in *UpdateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error)
	// Creates a web stream with the specified location and attributes.
	CreateWebDataStream(ctx context.Context, in *CreateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error)
	// Returns child web data streams under the specified parent property.
	//
	// Web data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant web data streams are found.
	ListWebDataStreams(ctx context.Context, in *ListWebDataStreamsRequest, opts ...grpc.CallOption) (*ListWebDataStreamsResponse, error)
	// Lookup for a single IosAppDataStream
	//
	// Throws "Target not found" if no such iOS app data stream found, or if the
	// caller does not have permissions to access it.
	GetIosAppDataStream(ctx context.Context, in *GetIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error)
	// Deletes an iOS app stream on a property.
	DeleteIosAppDataStream(ctx context.Context, in *DeleteIosAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an iOS app stream on a property.
	UpdateIosAppDataStream(ctx context.Context, in *UpdateIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error)
	// Creates an iOS app data stream with the specified location and attributes.
	CreateIosAppDataStream(ctx context.Context, in *CreateIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error)
	// Returns child iOS app data streams under the specified parent property.
	//
	// iOS app data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant iOS app data streams are found.
	ListIosAppDataStreams(ctx context.Context, in *ListIosAppDataStreamsRequest, opts ...grpc.CallOption) (*ListIosAppDataStreamsResponse, error)
	// Lookup for a single AndroidAppDataStream
	//
	// Throws "Target not found" if no such android app data stream found, or if
	// the caller does not have permissions to access it.
	GetAndroidAppDataStream(ctx context.Context, in *GetAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error)
	// Deletes an android app stream on a property.
	DeleteAndroidAppDataStream(ctx context.Context, in *DeleteAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an android app stream on a property.
	UpdateAndroidAppDataStream(ctx context.Context, in *UpdateAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error)
	// Creates an android app stream with the specified location and attributes.
	CreateAndroidAppDataStream(ctx context.Context, in *CreateAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error)
	// Returns child android app streams under the specified parent property.
	//
	// Android app streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant android app streams are found.
	ListAndroidAppDataStreams(ctx context.Context, in *ListAndroidAppDataStreamsRequest, opts ...grpc.CallOption) (*ListAndroidAppDataStreamsResponse, error)
	// Returns the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Updates the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Updates a FirebaseLink on a property
	UpdateFirebaseLink(ctx context.Context, in *UpdateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error)
}

type managementClient struct {
	cc grpc.ClientConnInterface
}

func NewManagementClient(cc grpc.ClientConnInterface) ManagementClient {
	return &managementClient{cc}
}

func (c *managementClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error) {
	out := new(ProvisionAccountTicketResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ProvisionAccountTicket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error) {
	out := new(ListPropertiesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListProperties", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetUserLink(ctx context.Context, in *GetUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) BatchGetUserLinks(ctx context.Context, in *BatchGetUserLinksRequest, opts ...grpc.CallOption) (*BatchGetUserLinksResponse, error) {
	out := new(BatchGetUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/BatchGetUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListUserLinks(ctx context.Context, in *ListUserLinksRequest, opts ...grpc.CallOption) (*ListUserLinksResponse, error) {
	out := new(ListUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) AuditUserLinks(ctx context.Context, in *AuditUserLinksRequest, opts ...grpc.CallOption) (*AuditUserLinksResponse, error) {
	out := new(AuditUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/AuditUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateUserLink(ctx context.Context, in *CreateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) BatchCreateUserLinks(ctx context.Context, in *BatchCreateUserLinksRequest, opts ...grpc.CallOption) (*BatchCreateUserLinksResponse, error) {
	out := new(BatchCreateUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/BatchCreateUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateUserLink(ctx context.Context, in *UpdateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) BatchUpdateUserLinks(ctx context.Context, in *BatchUpdateUserLinksRequest, opts ...grpc.CallOption) (*BatchUpdateUserLinksResponse, error) {
	out := new(BatchUpdateUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/BatchUpdateUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteUserLink(ctx context.Context, in *DeleteUserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) BatchDeleteUserLinks(ctx context.Context, in *BatchDeleteUserLinksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/BatchDeleteUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetWebDataStream(ctx context.Context, in *GetWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error) {
	out := new(WebDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteWebDataStream(ctx context.Context, in *DeleteWebDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateWebDataStream(ctx context.Context, in *UpdateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error) {
	out := new(WebDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateWebDataStream(ctx context.Context, in *CreateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error) {
	out := new(WebDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListWebDataStreams(ctx context.Context, in *ListWebDataStreamsRequest, opts ...grpc.CallOption) (*ListWebDataStreamsResponse, error) {
	out := new(ListWebDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListWebDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetIosAppDataStream(ctx context.Context, in *GetIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error) {
	out := new(IosAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteIosAppDataStream(ctx context.Context, in *DeleteIosAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateIosAppDataStream(ctx context.Context, in *UpdateIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error) {
	out := new(IosAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateIosAppDataStream(ctx context.Context, in *CreateIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error) {
	out := new(IosAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListIosAppDataStreams(ctx context.Context, in *ListIosAppDataStreamsRequest, opts ...grpc.CallOption) (*ListIosAppDataStreamsResponse, error) {
	out := new(ListIosAppDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListIosAppDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetAndroidAppDataStream(ctx context.Context, in *GetAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error) {
	out := new(AndroidAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteAndroidAppDataStream(ctx context.Context, in *DeleteAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateAndroidAppDataStream(ctx context.Context, in *UpdateAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error) {
	out := new(AndroidAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateAndroidAppDataStream(ctx context.Context, in *CreateAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error) {
	out := new(AndroidAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListAndroidAppDataStreams(ctx context.Context, in *ListAndroidAppDataStreamsRequest, opts ...grpc.CallOption) (*ListAndroidAppDataStreamsResponse, error) {
	out := new(ListAndroidAppDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListAndroidAppDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetEnhancedMeasurementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateEnhancedMeasurementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateFirebaseLink(ctx context.Context, in *UpdateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error) {
	out := new(ListFirebaseLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListFirebaseLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error) {
	out := new(GlobalSiteTag)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/GetGlobalSiteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/CreateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/UpdateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/DeleteGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managementClient) ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error) {
	out := new(ListGoogleAdsLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.management.v1alpha.Management/ListGoogleAdsLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagementServer is the server API for Management service.
type ManagementServer interface {
	// Lookup for a single Account.
	// Throws "Target not found" if no such account found, or if caller does not
	// have permissions to access it.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have App+Web properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error)
	// Lookup for a single "App+Web" Property.
	//
	// Throws "Target not found" if no such property found, if property is not
	// of the type "App+Web", or if caller does not have permissions to access it.
	GetProperty(context.Context, *GetPropertyRequest) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "App+Web" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error)
	// Creates an "App+Web" property with the specified location and attributes.
	CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an App+Web Property.
	DeleteProperty(context.Context, *DeletePropertyRequest) (*emptypb.Empty, error)
	// Updates a property.
	UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error)
	// Gets information about a user's link to an account or property.
	GetUserLink(context.Context, *GetUserLinkRequest) (*UserLink, error)
	// Gets information about multiple users' links to an account or property.
	BatchGetUserLinks(context.Context, *BatchGetUserLinksRequest) (*BatchGetUserLinksResponse, error)
	// Lists all user links on an account or property.
	ListUserLinks(context.Context, *ListUserLinksRequest) (*ListUserLinksResponse, error)
	// Lists all user links on an account or property, including implicit ones
	// that come from effective permissions granted by groups or organization
	// admin roles.
	//
	// If a returned user link does not have direct permissions, they cannot
	// be removed from the account or property directly with the DeleteUserLink
	// command. They have to be removed from the group/etc that gives them
	// permissions, which is currently only usable/discoverable in the GA or GMP
	// UIs.
	AuditUserLinks(context.Context, *AuditUserLinksRequest) (*AuditUserLinksResponse, error)
	// Creates a user link on an account or property.
	//
	// If the user with the specified email already has permissions on the
	// account or property, then the user's existing permissions will be unioned
	// with the permissions specified in the new UserLink.
	CreateUserLink(context.Context, *CreateUserLinkRequest) (*UserLink, error)
	// Creates information about multiple users' links to an account or property.
	//
	// This method is transactional. If any UserLink cannot be created, none of
	// the UserLinks will be created.
	BatchCreateUserLinks(context.Context, *BatchCreateUserLinksRequest) (*BatchCreateUserLinksResponse, error)
	// Updates a user link on an account or property.
	UpdateUserLink(context.Context, *UpdateUserLinkRequest) (*UserLink, error)
	// Updates information about multiple users' links to an account or property.
	BatchUpdateUserLinks(context.Context, *BatchUpdateUserLinksRequest) (*BatchUpdateUserLinksResponse, error)
	// Deletes a user link on an account or property.
	DeleteUserLink(context.Context, *DeleteUserLinkRequest) (*emptypb.Empty, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteUserLinks(context.Context, *BatchDeleteUserLinksRequest) (*emptypb.Empty, error)
	// Lookup for a single WebDataStream
	//
	// Throws "Target not found" if no such web data stream found, or if the
	// caller does not have permissions to access it.
	GetWebDataStream(context.Context, *GetWebDataStreamRequest) (*WebDataStream, error)
	// Deletes a web stream on a property.
	DeleteWebDataStream(context.Context, *DeleteWebDataStreamRequest) (*emptypb.Empty, error)
	// Updates a web stream on a property.
	UpdateWebDataStream(context.Context, *UpdateWebDataStreamRequest) (*WebDataStream, error)
	// Creates a web stream with the specified location and attributes.
	CreateWebDataStream(context.Context, *CreateWebDataStreamRequest) (*WebDataStream, error)
	// Returns child web data streams under the specified parent property.
	//
	// Web data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant web data streams are found.
	ListWebDataStreams(context.Context, *ListWebDataStreamsRequest) (*ListWebDataStreamsResponse, error)
	// Lookup for a single IosAppDataStream
	//
	// Throws "Target not found" if no such iOS app data stream found, or if the
	// caller does not have permissions to access it.
	GetIosAppDataStream(context.Context, *GetIosAppDataStreamRequest) (*IosAppDataStream, error)
	// Deletes an iOS app stream on a property.
	DeleteIosAppDataStream(context.Context, *DeleteIosAppDataStreamRequest) (*emptypb.Empty, error)
	// Updates an iOS app stream on a property.
	UpdateIosAppDataStream(context.Context, *UpdateIosAppDataStreamRequest) (*IosAppDataStream, error)
	// Creates an iOS app data stream with the specified location and attributes.
	CreateIosAppDataStream(context.Context, *CreateIosAppDataStreamRequest) (*IosAppDataStream, error)
	// Returns child iOS app data streams under the specified parent property.
	//
	// iOS app data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant iOS app data streams are found.
	ListIosAppDataStreams(context.Context, *ListIosAppDataStreamsRequest) (*ListIosAppDataStreamsResponse, error)
	// Lookup for a single AndroidAppDataStream
	//
	// Throws "Target not found" if no such android app data stream found, or if
	// the caller does not have permissions to access it.
	GetAndroidAppDataStream(context.Context, *GetAndroidAppDataStreamRequest) (*AndroidAppDataStream, error)
	// Deletes an android app stream on a property.
	DeleteAndroidAppDataStream(context.Context, *DeleteAndroidAppDataStreamRequest) (*emptypb.Empty, error)
	// Updates an android app stream on a property.
	UpdateAndroidAppDataStream(context.Context, *UpdateAndroidAppDataStreamRequest) (*AndroidAppDataStream, error)
	// Creates an android app stream with the specified location and attributes.
	CreateAndroidAppDataStream(context.Context, *CreateAndroidAppDataStreamRequest) (*AndroidAppDataStream, error)
	// Returns child android app streams under the specified parent property.
	//
	// Android app streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant android app streams are found.
	ListAndroidAppDataStreams(context.Context, *ListAndroidAppDataStreamsRequest) (*ListAndroidAppDataStreamsResponse, error)
	// Returns the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Updates the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error)
	// Updates a FirebaseLink on a property
	UpdateFirebaseLink(context.Context, *UpdateFirebaseLinkRequest) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error)
}

// UnimplementedManagementServer can be embedded to have forward compatible implementations.
type UnimplementedManagementServer struct {
}

func (*UnimplementedManagementServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (*UnimplementedManagementServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (*UnimplementedManagementServer) DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccount not implemented")
}
func (*UnimplementedManagementServer) UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccount not implemented")
}
func (*UnimplementedManagementServer) ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionAccountTicket not implemented")
}
func (*UnimplementedManagementServer) GetProperty(context.Context, *GetPropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProperty not implemented")
}
func (*UnimplementedManagementServer) ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProperties not implemented")
}
func (*UnimplementedManagementServer) CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProperty not implemented")
}
func (*UnimplementedManagementServer) DeleteProperty(context.Context, *DeletePropertyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProperty not implemented")
}
func (*UnimplementedManagementServer) UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProperty not implemented")
}
func (*UnimplementedManagementServer) GetUserLink(context.Context, *GetUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserLink not implemented")
}
func (*UnimplementedManagementServer) BatchGetUserLinks(context.Context, *BatchGetUserLinksRequest) (*BatchGetUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetUserLinks not implemented")
}
func (*UnimplementedManagementServer) ListUserLinks(context.Context, *ListUserLinksRequest) (*ListUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserLinks not implemented")
}
func (*UnimplementedManagementServer) AuditUserLinks(context.Context, *AuditUserLinksRequest) (*AuditUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuditUserLinks not implemented")
}
func (*UnimplementedManagementServer) CreateUserLink(context.Context, *CreateUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUserLink not implemented")
}
func (*UnimplementedManagementServer) BatchCreateUserLinks(context.Context, *BatchCreateUserLinksRequest) (*BatchCreateUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateUserLinks not implemented")
}
func (*UnimplementedManagementServer) UpdateUserLink(context.Context, *UpdateUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserLink not implemented")
}
func (*UnimplementedManagementServer) BatchUpdateUserLinks(context.Context, *BatchUpdateUserLinksRequest) (*BatchUpdateUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateUserLinks not implemented")
}
func (*UnimplementedManagementServer) DeleteUserLink(context.Context, *DeleteUserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUserLink not implemented")
}
func (*UnimplementedManagementServer) BatchDeleteUserLinks(context.Context, *BatchDeleteUserLinksRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteUserLinks not implemented")
}
func (*UnimplementedManagementServer) GetWebDataStream(context.Context, *GetWebDataStreamRequest) (*WebDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWebDataStream not implemented")
}
func (*UnimplementedManagementServer) DeleteWebDataStream(context.Context, *DeleteWebDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWebDataStream not implemented")
}
func (*UnimplementedManagementServer) UpdateWebDataStream(context.Context, *UpdateWebDataStreamRequest) (*WebDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWebDataStream not implemented")
}
func (*UnimplementedManagementServer) CreateWebDataStream(context.Context, *CreateWebDataStreamRequest) (*WebDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWebDataStream not implemented")
}
func (*UnimplementedManagementServer) ListWebDataStreams(context.Context, *ListWebDataStreamsRequest) (*ListWebDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWebDataStreams not implemented")
}
func (*UnimplementedManagementServer) GetIosAppDataStream(context.Context, *GetIosAppDataStreamRequest) (*IosAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIosAppDataStream not implemented")
}
func (*UnimplementedManagementServer) DeleteIosAppDataStream(context.Context, *DeleteIosAppDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIosAppDataStream not implemented")
}
func (*UnimplementedManagementServer) UpdateIosAppDataStream(context.Context, *UpdateIosAppDataStreamRequest) (*IosAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIosAppDataStream not implemented")
}
func (*UnimplementedManagementServer) CreateIosAppDataStream(context.Context, *CreateIosAppDataStreamRequest) (*IosAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIosAppDataStream not implemented")
}
func (*UnimplementedManagementServer) ListIosAppDataStreams(context.Context, *ListIosAppDataStreamsRequest) (*ListIosAppDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIosAppDataStreams not implemented")
}
func (*UnimplementedManagementServer) GetAndroidAppDataStream(context.Context, *GetAndroidAppDataStreamRequest) (*AndroidAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAndroidAppDataStream not implemented")
}
func (*UnimplementedManagementServer) DeleteAndroidAppDataStream(context.Context, *DeleteAndroidAppDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAndroidAppDataStream not implemented")
}
func (*UnimplementedManagementServer) UpdateAndroidAppDataStream(context.Context, *UpdateAndroidAppDataStreamRequest) (*AndroidAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAndroidAppDataStream not implemented")
}
func (*UnimplementedManagementServer) CreateAndroidAppDataStream(context.Context, *CreateAndroidAppDataStreamRequest) (*AndroidAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAndroidAppDataStream not implemented")
}
func (*UnimplementedManagementServer) ListAndroidAppDataStreams(context.Context, *ListAndroidAppDataStreamsRequest) (*ListAndroidAppDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAndroidAppDataStreams not implemented")
}
func (*UnimplementedManagementServer) GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnhancedMeasurementSettings not implemented")
}
func (*UnimplementedManagementServer) UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnhancedMeasurementSettings not implemented")
}
func (*UnimplementedManagementServer) CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirebaseLink not implemented")
}
func (*UnimplementedManagementServer) UpdateFirebaseLink(context.Context, *UpdateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFirebaseLink not implemented")
}
func (*UnimplementedManagementServer) DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirebaseLink not implemented")
}
func (*UnimplementedManagementServer) ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirebaseLinks not implemented")
}
func (*UnimplementedManagementServer) GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlobalSiteTag not implemented")
}
func (*UnimplementedManagementServer) CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleAdsLink not implemented")
}
func (*UnimplementedManagementServer) UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleAdsLink not implemented")
}
func (*UnimplementedManagementServer) DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleAdsLink not implemented")
}
func (*UnimplementedManagementServer) ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleAdsLinks not implemented")
}

func RegisterManagementServer(s *grpc.Server, srv ManagementServer) {
	s.RegisterService(&_Management_serviceDesc, srv)
}

func _Management_GetAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetAccount(ctx, req.(*GetAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListAccounts(ctx, req.(*ListAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteAccount(ctx, req.(*DeleteAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateAccount(ctx, req.(*UpdateAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ProvisionAccountTicket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionAccountTicketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ProvisionAccountTicket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ProvisionAccountTicket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ProvisionAccountTicket(ctx, req.(*ProvisionAccountTicketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetProperty(ctx, req.(*GetPropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListProperties(ctx, req.(*ListPropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateProperty(ctx, req.(*CreatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteProperty(ctx, req.(*DeletePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateProperty(ctx, req.(*UpdatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetUserLink(ctx, req.(*GetUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_BatchGetUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).BatchGetUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/BatchGetUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).BatchGetUserLinks(ctx, req.(*BatchGetUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListUserLinks(ctx, req.(*ListUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_AuditUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).AuditUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/AuditUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).AuditUserLinks(ctx, req.(*AuditUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateUserLink(ctx, req.(*CreateUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_BatchCreateUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).BatchCreateUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/BatchCreateUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).BatchCreateUserLinks(ctx, req.(*BatchCreateUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateUserLink(ctx, req.(*UpdateUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_BatchUpdateUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).BatchUpdateUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/BatchUpdateUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).BatchUpdateUserLinks(ctx, req.(*BatchUpdateUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteUserLink(ctx, req.(*DeleteUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_BatchDeleteUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).BatchDeleteUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/BatchDeleteUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).BatchDeleteUserLinks(ctx, req.(*BatchDeleteUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetWebDataStream(ctx, req.(*GetWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteWebDataStream(ctx, req.(*DeleteWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateWebDataStream(ctx, req.(*UpdateWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateWebDataStream(ctx, req.(*CreateWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListWebDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWebDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListWebDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListWebDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListWebDataStreams(ctx, req.(*ListWebDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetIosAppDataStream(ctx, req.(*GetIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteIosAppDataStream(ctx, req.(*DeleteIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateIosAppDataStream(ctx, req.(*UpdateIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateIosAppDataStream(ctx, req.(*CreateIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListIosAppDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIosAppDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListIosAppDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListIosAppDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListIosAppDataStreams(ctx, req.(*ListIosAppDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetAndroidAppDataStream(ctx, req.(*GetAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteAndroidAppDataStream(ctx, req.(*DeleteAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateAndroidAppDataStream(ctx, req.(*UpdateAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateAndroidAppDataStream(ctx, req.(*CreateAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListAndroidAppDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAndroidAppDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListAndroidAppDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListAndroidAppDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListAndroidAppDataStreams(ctx, req.(*ListAndroidAppDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetEnhancedMeasurementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnhancedMeasurementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetEnhancedMeasurementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetEnhancedMeasurementSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetEnhancedMeasurementSettings(ctx, req.(*GetEnhancedMeasurementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateEnhancedMeasurementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnhancedMeasurementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateEnhancedMeasurementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateEnhancedMeasurementSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateEnhancedMeasurementSettings(ctx, req.(*UpdateEnhancedMeasurementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateFirebaseLink(ctx, req.(*CreateFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateFirebaseLink(ctx, req.(*UpdateFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteFirebaseLink(ctx, req.(*DeleteFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListFirebaseLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirebaseLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListFirebaseLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListFirebaseLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListFirebaseLinks(ctx, req.(*ListFirebaseLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_GetGlobalSiteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalSiteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).GetGlobalSiteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/GetGlobalSiteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).GetGlobalSiteTag(ctx, req.(*GetGlobalSiteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_CreateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).CreateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/CreateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).CreateGoogleAdsLink(ctx, req.(*CreateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_UpdateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).UpdateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/UpdateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).UpdateGoogleAdsLink(ctx, req.(*UpdateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_DeleteGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).DeleteGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/DeleteGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).DeleteGoogleAdsLink(ctx, req.(*DeleteGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Management_ListGoogleAdsLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoogleAdsLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagementServer).ListGoogleAdsLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.management.v1alpha.Management/ListGoogleAdsLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagementServer).ListGoogleAdsLinks(ctx, req.(*ListGoogleAdsLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Management_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.management.v1alpha.Management",
	HandlerType: (*ManagementServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccount",
			Handler:    _Management_GetAccount_Handler,
		},
		{
			MethodName: "ListAccounts",
			Handler:    _Management_ListAccounts_Handler,
		},
		{
			MethodName: "DeleteAccount",
			Handler:    _Management_DeleteAccount_Handler,
		},
		{
			MethodName: "UpdateAccount",
			Handler:    _Management_UpdateAccount_Handler,
		},
		{
			MethodName: "ProvisionAccountTicket",
			Handler:    _Management_ProvisionAccountTicket_Handler,
		},
		{
			MethodName: "GetProperty",
			Handler:    _Management_GetProperty_Handler,
		},
		{
			MethodName: "ListProperties",
			Handler:    _Management_ListProperties_Handler,
		},
		{
			MethodName: "CreateProperty",
			Handler:    _Management_CreateProperty_Handler,
		},
		{
			MethodName: "DeleteProperty",
			Handler:    _Management_DeleteProperty_Handler,
		},
		{
			MethodName: "UpdateProperty",
			Handler:    _Management_UpdateProperty_Handler,
		},
		{
			MethodName: "GetUserLink",
			Handler:    _Management_GetUserLink_Handler,
		},
		{
			MethodName: "BatchGetUserLinks",
			Handler:    _Management_BatchGetUserLinks_Handler,
		},
		{
			MethodName: "ListUserLinks",
			Handler:    _Management_ListUserLinks_Handler,
		},
		{
			MethodName: "AuditUserLinks",
			Handler:    _Management_AuditUserLinks_Handler,
		},
		{
			MethodName: "CreateUserLink",
			Handler:    _Management_CreateUserLink_Handler,
		},
		{
			MethodName: "BatchCreateUserLinks",
			Handler:    _Management_BatchCreateUserLinks_Handler,
		},
		{
			MethodName: "UpdateUserLink",
			Handler:    _Management_UpdateUserLink_Handler,
		},
		{
			MethodName: "BatchUpdateUserLinks",
			Handler:    _Management_BatchUpdateUserLinks_Handler,
		},
		{
			MethodName: "DeleteUserLink",
			Handler:    _Management_DeleteUserLink_Handler,
		},
		{
			MethodName: "BatchDeleteUserLinks",
			Handler:    _Management_BatchDeleteUserLinks_Handler,
		},
		{
			MethodName: "GetWebDataStream",
			Handler:    _Management_GetWebDataStream_Handler,
		},
		{
			MethodName: "DeleteWebDataStream",
			Handler:    _Management_DeleteWebDataStream_Handler,
		},
		{
			MethodName: "UpdateWebDataStream",
			Handler:    _Management_UpdateWebDataStream_Handler,
		},
		{
			MethodName: "CreateWebDataStream",
			Handler:    _Management_CreateWebDataStream_Handler,
		},
		{
			MethodName: "ListWebDataStreams",
			Handler:    _Management_ListWebDataStreams_Handler,
		},
		{
			MethodName: "GetIosAppDataStream",
			Handler:    _Management_GetIosAppDataStream_Handler,
		},
		{
			MethodName: "DeleteIosAppDataStream",
			Handler:    _Management_DeleteIosAppDataStream_Handler,
		},
		{
			MethodName: "UpdateIosAppDataStream",
			Handler:    _Management_UpdateIosAppDataStream_Handler,
		},
		{
			MethodName: "CreateIosAppDataStream",
			Handler:    _Management_CreateIosAppDataStream_Handler,
		},
		{
			MethodName: "ListIosAppDataStreams",
			Handler:    _Management_ListIosAppDataStreams_Handler,
		},
		{
			MethodName: "GetAndroidAppDataStream",
			Handler:    _Management_GetAndroidAppDataStream_Handler,
		},
		{
			MethodName: "DeleteAndroidAppDataStream",
			Handler:    _Management_DeleteAndroidAppDataStream_Handler,
		},
		{
			MethodName: "UpdateAndroidAppDataStream",
			Handler:    _Management_UpdateAndroidAppDataStream_Handler,
		},
		{
			MethodName: "CreateAndroidAppDataStream",
			Handler:    _Management_CreateAndroidAppDataStream_Handler,
		},
		{
			MethodName: "ListAndroidAppDataStreams",
			Handler:    _Management_ListAndroidAppDataStreams_Handler,
		},
		{
			MethodName: "GetEnhancedMeasurementSettings",
			Handler:    _Management_GetEnhancedMeasurementSettings_Handler,
		},
		{
			MethodName: "UpdateEnhancedMeasurementSettings",
			Handler:    _Management_UpdateEnhancedMeasurementSettings_Handler,
		},
		{
			MethodName: "CreateFirebaseLink",
			Handler:    _Management_CreateFirebaseLink_Handler,
		},
		{
			MethodName: "UpdateFirebaseLink",
			Handler:    _Management_UpdateFirebaseLink_Handler,
		},
		{
			MethodName: "DeleteFirebaseLink",
			Handler:    _Management_DeleteFirebaseLink_Handler,
		},
		{
			MethodName: "ListFirebaseLinks",
			Handler:    _Management_ListFirebaseLinks_Handler,
		},
		{
			MethodName: "GetGlobalSiteTag",
			Handler:    _Management_GetGlobalSiteTag_Handler,
		},
		{
			MethodName: "CreateGoogleAdsLink",
			Handler:    _Management_CreateGoogleAdsLink_Handler,
		},
		{
			MethodName: "UpdateGoogleAdsLink",
			Handler:    _Management_UpdateGoogleAdsLink_Handler,
		},
		{
			MethodName: "DeleteGoogleAdsLink",
			Handler:    _Management_DeleteGoogleAdsLink_Handler,
		},
		{
			MethodName: "ListGoogleAdsLinks",
			Handler:    _Management_ListGoogleAdsLinks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/management/v1alpha/management_api.proto",
}
