<?php
/*
** Copyright (C) 2001-2024 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/


class CControllerResponseRedirect extends CControllerResponse {

	protected $formData = [];

	/**
	 * @param string|CUrl $location
	 */
	public function __construct($location) {
		if ($location instanceof CUrl) {
			$location = $location->getUrl();
		}

		$this->location = $location;
	}

	public function setFormData(array $formData): void {
		$this->formData = $formData;
	}

	public function getFormData(): array {
		return $this->formData;
	}
}
