//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2015 Thomas S. Ullrich 
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: March 28, 2014
//-----------------------------------------------------------------------------
#include <QtGui>
#include <QApplication>
#include <iostream>
#include <QString>
#include <QFileInfo>
#include "xyscanWindow.h"
#include "xyscanVersion.h"

using namespace std;

void usage(const char* prog)
{
    cout << "Usage: " << prog << " [-v] [file]" << endl;
}

int main(int argc, char *argv[])
{
    //
    //  Init application
    //
    QApplication app(argc, argv);
    Q_INIT_RESOURCE(xyscan);
    app.setApplicationVersion(VERSION);

#ifdef Q_OS_MAC
    //
    //  Set attributes related to Retina display (Mac)
    //
    if (QGuiApplication::primaryScreen()->devicePixelRatio() > 1)
        app.setAttribute(Qt::AA_UseHighDpiPixmaps);
#endif
     
    //
    //  Create and launch xyscan
    //
    xyscanWindow win;
    app.installEventFilter(&win);
    win.show();
    return app.exec();
}


