// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLAL2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SMLAL2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_smlal2_2D[] = {
  0x00003ffd00090000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x00000000007ffd00, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x000000000fffa000, 0x0000000000000001,
  0x000000003e7e8900, 0x0000000000000001,
  0x000000003efe8600, 0x0000000000000001,
  0x000000003f7e8300, 0x0000000000000001,
  0x0000003ffd000900, 0x0000000000000001,
  0x0000003ffd800600, 0x0000000000000001,
  0x0000003ffe000300, 0x0000000000000001,
  0x001998ffffe66700, 0x0000000000000001,
  0x002aa9aaaa800100, 0x0000000000000001,
  0x003ffe7ffe800900, 0x0000000000000001,
  0x003ffe7fff000600, 0x0000000000000001,
  0x003ffe7fff800300, 0x0000000000000001,
  0xffc0018000000000, 0x0000000000000001,
  0xffc00180007ffd00, 0x0000000000000001,
  0xffd5565555000200, 0x0000000000000001,
  0xffe666ffff999c00, 0x0000000000000001,
  0xffffffc001800000, 0x0000000000000001,
  0xffffffc001fffd00, 0x0000000000000001,
  0xffffffc0027ffa00, 0x0000000000000001,
  0xffffffc002fff700, 0x0000000000000001,
  0xffffffffc0018000, 0x0000000000000001,
  0xffffffffc0817d00, 0x0000000000000001,
  0xffffffffc1017a00, 0x0000000000000001,
  0xffffffffc1817700, 0x0000000000000001,
  0xfffffffff0006000, 0x0000000000000001,
  0xfffffffffe800900, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000021,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x0000000000000080,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000000000, 0x0000000033333334,
  0x0000000000000000, 0x0000000055555556,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0x0000000080000000,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffff80000002,
  0x0000000000000000, 0xffffffffaaaaaaab,
  0x0000000000000000, 0xffffffffcccccccd,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffff8004,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff84,
  0x0000000000000000, 0xffffffffffffffe1,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000005,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000020, 0x00000000000000fb,
  0x000000000000007d, 0x00000000000000fd,
  0x000000000000007e, 0x00000000000000ff,
  0x000000000000007f, 0x000000000000fffb,
  0x0000000000007ffd, 0x000000000000fffd,
  0x0000000000007ffe, 0x000000000000ffff,
  0x0000000000007fff, 0x0000000066666667,
  0x0000000033333333, 0x00000000aaaaaaab,
  0x0000000055555555, 0x00000000fffffffb,
  0x000000007ffffffd, 0x00000000fffffffd,
  0x000000007ffffffe, 0x00000000ffffffff,
  0x000000007fffffff, 0xffffffff00000001,
  0xffffffff80000000, 0xffffffff00000003,
  0xffffffff80000001, 0xffffffff55555555,
  0xffffffffaaaaaaaa, 0xffffffff99999999,
  0xffffffffcccccccc, 0xffffffffffff0001,
  0xffffffffffff8000, 0xffffffffffff0003,
  0xffffffffffff8001, 0xffffffffffff0005,
  0xffffffffffff8002, 0xffffffffffff0007,
  0xffffffffffff8003, 0xffffffffffffff01,
  0xffffffffffffff80, 0xffffffffffffff03,
  0xffffffffffffff81, 0xffffffffffffff05,
  0xffffffffffffff82, 0xffffffffffffff07,
  0xffffffffffffff83, 0xffffffffffffffc1,
  0xffffffffffffffe0, 0xfffffffffffffffb,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffe, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000021,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000004, 0x0000000000000401,
  0x0000000000000040, 0x0000000000000fa1,
  0x00000000000000fa, 0x0000000000000fc1,
  0x00000000000000fc, 0x0000000000000fe1,
  0x00000000000000fe, 0x00000000000fffa1,
  0x000000000000fffa, 0x00000000000fffc1,
  0x000000000000fffc, 0x00000000000fffe1,
  0x000000000000fffe, 0x0000000666666661,
  0x0000000066666666, 0x0000000aaaaaaaa1,
  0x00000000aaaaaaaa, 0x0000000fffffffa1,
  0x00000000fffffffa, 0x0000000fffffffc1,
  0x00000000fffffffc, 0x0000000fffffffe1,
  0x00000000fffffffe, 0xfffffff000000001,
  0xffffffff00000000, 0xfffffff000000021,
  0xffffffff00000002, 0xfffffff555555541,
  0xffffffff55555554, 0xfffffff999999981,
  0xffffffff99999998, 0xfffffffffff00001,
  0xffffffffffff0000, 0xfffffffffff00021,
  0xffffffffffff0002, 0xfffffffffff00041,
  0xffffffffffff0004, 0xfffffffffff00061,
  0xffffffffffff0006, 0xfffffffffffff001,
  0xffffffffffffff00, 0xfffffffffffff021,
  0xffffffffffffff02, 0xfffffffffffff041,
  0xffffffffffffff04, 0xfffffffffffff061,
  0xffffffffffffff06, 0xfffffffffffffc01,
  0xffffffffffffffc0, 0xffffffffffffffa1,
  0xfffffffffffffffa, 0xffffffffffffffc1,
  0xfffffffffffffffc, 0xffffffffffffffe1,
  0xffffffffffffffe0, 0x0000000000000001,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000020, 0x00000000000000fb,
  0x0000000000000040, 0x0000000000000fa1,
  0x0000000000000400, 0x0000000000003d0a,
  0x0000000000000fa0, 0x0000000000003d87,
  0x0000000000000fc0, 0x0000000000003e04,
  0x0000000000000fe0, 0x00000000003e7e8a,
  0x00000000000fffa0, 0x00000000003e7f07,
  0x00000000000fffc0, 0x00000000003e7f84,
  0x00000000000fffe0, 0x00000018ffffffe8,
  0x0000000666666660, 0x00000029aaaaaa82,
  0x0000000aaaaaaaa0, 0x0000003e7ffffe8a,
  0x0000000fffffffa0, 0x0000003e7fffff07,
  0x0000000fffffffc0, 0x0000003e7fffff84,
  0x0000000fffffffe0, 0xffffffc180000001,
  0xfffffff000000000, 0xffffffc18000007e,
  0xfffffff000000020, 0xffffffd655555503,
  0xfffffff555555540, 0xffffffe6ffffff9d,
  0xfffffff999999980, 0xffffffffffc18001,
  0xfffffffffff00000, 0xffffffffffc1807e,
  0xfffffffffff00020, 0xffffffffffc180fb,
  0xfffffffffff00040, 0xffffffffffc18178,
  0xfffffffffff00060, 0xffffffffffffc181,
  0xfffffffffffff000, 0xffffffffffffc1fe,
  0xfffffffffffff020, 0xffffffffffffc27b,
  0xfffffffffffff040, 0xffffffffffffc2f8,
  0xfffffffffffff060, 0xfffffffffffff061,
  0xfffffffffffffc00, 0xfffffffffffffe8a,
  0xffffffffffffffa0, 0xffffffffffffff07,
  0xffffffffffffffc0, 0xffffffffffffff84,
  0xffffffffffffff83, 0x0000000000000001,
  0x0000000000000000, 0x000000000000007f,
  0x000000000000007d, 0x00000000000000fd,
  0x00000000000000fa, 0x0000000000000fc1,
  0x0000000000000fa0, 0x0000000000003d87,
  0x0000000000003d09, 0x0000000000003e05,
  0x0000000000003d86, 0x0000000000003e83,
  0x0000000000003e03, 0x00000000003efe87,
  0x00000000003e7e89, 0x00000000003eff05,
  0x00000000003e7f06, 0x00000000003eff83,
  0x00000000003e7f83, 0x000000193333331b,
  0x00000018ffffffe7, 0x00000029ffffffd7,
  0x00000029aaaaaa81, 0x0000003efffffe87,
  0x0000003e7ffffe89, 0x0000003effffff05,
  0x0000003e7fffff06, 0x0000003effffff83,
  0x0000003e7fffff83, 0xffffffc100000001,
  0xffffffc180000000, 0xffffffc10000007f,
  0xffffffc18000007d, 0xffffffd5ffffffad,
  0xffffffd655555502, 0xffffffe6cccccc69,
  0xffffffe6ffffff9c, 0xffffffffffc10001,
  0xffffffffffc18000, 0xffffffffffc1007f,
  0xffffffffffc1807d, 0xffffffffffc100fd,
  0xffffffffffc180fa, 0xffffffffffc1017b,
  0xffffffffffc18177, 0xffffffffffffc101,
  0xffffffffffffc180, 0xffffffffffffc17f,
  0xffffffffffffc1fd, 0xffffffffffffc1fd,
  0xffffffffffffc27a, 0xffffffffffffc27b,
  0xffffffffffffc2f7, 0xfffffffffffff041,
  0xfffffffffffff060, 0xfffffffffffffe87,
  0xfffffffffffffe89, 0xffffffffffffff05,
  0xffffffffffffff06, 0xffffffffffffff83,
  0xffffffffffffff82, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000080,
  0x000000000000007e, 0x00000000000000ff,
  0x00000000000000fc, 0x0000000000000fe1,
  0x0000000000000fc0, 0x0000000000003e04,
  0x0000000000003d86, 0x0000000000003e83,
  0x0000000000003e04, 0x0000000000003f02,
  0x0000000000003e82, 0x00000000003f7e84,
  0x00000000003efe86, 0x00000000003f7f03,
  0x00000000003eff04, 0x00000000003f7f82,
  0x00000000003eff82, 0x000000196666664e,
  0x000000193333331a, 0x0000002a5555552c,
  0x00000029ffffffd6, 0x0000003f7ffffe84,
  0x0000003efffffe86, 0x0000003f7fffff03,
  0x0000003effffff04, 0x0000003f7fffff82,
  0x0000003effffff82, 0xffffffc080000001,
  0xffffffc100000000, 0xffffffc080000080,
  0xffffffc10000007e, 0xffffffd5aaaaaa57,
  0xffffffd5ffffffac, 0xffffffe699999935,
  0xffffffe6cccccc68, 0xffffffffffc08001,
  0xffffffffffc10000, 0xffffffffffc08080,
  0xffffffffffc1007e, 0xffffffffffc080ff,
  0xffffffffffc100fc, 0xffffffffffc0817e,
  0xffffffffffc1017a, 0xffffffffffffc081,
  0xffffffffffffc100, 0xffffffffffffc100,
  0xffffffffffffc17e, 0xffffffffffffc17f,
  0xffffffffffffc1fc, 0xffffffffffffc1fe,
  0xffffffffffffc27a, 0xfffffffffffff021,
  0xfffffffffffff040, 0xfffffffffffffe84,
  0xfffffffffffffe86, 0xffffffffffffff03,
  0xffffffffffffff04, 0xffffffffffffff82,
  0xffffffffffffff81, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007ffe,
  0x000000000000007f, 0x000000000000fffb,
  0x00000000000000fe, 0x00000000000fffa1,
  0x0000000000000fe0, 0x00000000003e7e8a,
  0x0000000000003e03, 0x00000000003efe87,
  0x0000000000003e82, 0x00000000003f7e84,
  0x0000000000003f01, 0x000000003ffd000a,
  0x00000000003f7e83, 0x000000003ffd8007,
  0x00000000003f7f02, 0x000000003ffe0004,
  0x00000000003f7f81, 0x00001998ffffe668,
  0x000000196666664d, 0x00002aa9aaaa8002,
  0x0000002a5555552b, 0x00003ffe7ffe800a,
  0x0000003f7ffffe83, 0x00003ffe7fff0007,
  0x0000003f7fffff02, 0x00003ffe7fff8004,
  0x0000003f7fffff81, 0xffffc00180000001,
  0xffffffc080000000, 0xffffc00180007ffe,
  0xffffffc08000007f, 0xffffd55655550003,
  0xffffffd5aaaaaa56, 0xffffe666ffff999d,
  0xffffffe699999934, 0xffffffffc0018001,
  0xffffffffffc08000, 0xffffffffc001fffe,
  0xffffffffffc0807f, 0xffffffffc0027ffb,
  0xffffffffffc080fe, 0xffffffffc002fff8,
  0xffffffffffc0817d, 0xffffffffffc00181,
  0xffffffffffffc080, 0xffffffffffc0817e,
  0xffffffffffffc0ff, 0xffffffffffc1017b,
  0xffffffffffffc17e, 0xffffffffffc18178,
  0xffffffffffffc1fd, 0xfffffffffff00061,
  0xfffffffffffff020, 0xfffffffffffe800a,
  0xfffffffffffffe83, 0xffffffffffff0007,
  0xffffffffffffff02, 0xffffffffffff8004,
  0xffffffffffff8003, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000007ffd, 0x000000000000fffd,
  0x000000000000fffa, 0x00000000000fffc1,
  0x00000000000fffa0, 0x00000000003e7f07,
  0x00000000003e7e89, 0x00000000003eff05,
  0x00000000003efe86, 0x00000000003f7f03,
  0x00000000003f7e83, 0x000000003ffd8007,
  0x000000003ffd0009, 0x000000003ffe0005,
  0x000000003ffd8006, 0x000000003ffe8003,
  0x000000003ffe0003, 0x000019993333199b,
  0x00001998ffffe667, 0x00002aa9ffffd557,
  0x00002aa9aaaa8001, 0x00003ffefffe8007,
  0x00003ffe7ffe8009, 0x00003ffeffff0005,
  0x00003ffe7fff0006, 0x00003ffeffff8003,
  0x00003ffe7fff8003, 0xffffc00100000001,
  0xffffc00180000000, 0xffffc00100007fff,
  0xffffc00180007ffd, 0xffffd555ffffaaad,
  0xffffd55655550002, 0xffffe666cccc6669,
  0xffffe666ffff999c, 0xffffffffc0010001,
  0xffffffffc0018000, 0xffffffffc0017fff,
  0xffffffffc001fffd, 0xffffffffc001fffd,
  0xffffffffc0027ffa, 0xffffffffc0027ffb,
  0xffffffffc002fff7, 0xffffffffffc00101,
  0xffffffffffc00180, 0xffffffffffc080ff,
  0xffffffffffc0817d, 0xffffffffffc100fd,
  0xffffffffffc1017a, 0xffffffffffc180fb,
  0xffffffffffc18177, 0xfffffffffff00041,
  0xfffffffffff00060, 0xfffffffffffe8007,
  0xfffffffffffe8009, 0xffffffffffff0005,
  0xffffffffffff0006, 0xffffffffffff8003,
  0xffffffffffff8002, 0x0000000000000001,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000007ffe, 0x000000000000ffff,
  0x000000000000fffc, 0x00000000000fffe1,
  0x00000000000fffc0, 0x00000000003e7f84,
  0x00000000003e7f06, 0x00000000003eff83,
  0x00000000003eff04, 0x00000000003f7f82,
  0x00000000003f7f02, 0x000000003ffe0004,
  0x000000003ffd8006, 0x000000003ffe8003,
  0x000000003ffe0004, 0x000000003fff0002,
  0x000000003ffe8002, 0x0000199966664cce,
  0x000019993333199a, 0x00002aaa55552aac,
  0x00002aa9ffffd556, 0x00003fff7ffe8004,
  0x00003ffefffe8006, 0x00003fff7fff0003,
  0x00003ffeffff0004, 0x00003fff7fff8002,
  0x00003ffeffff8002, 0xffffc00080000001,
  0xffffc00100000000, 0xffffc00080008000,
  0xffffc00100007ffe, 0xffffd555aaaa5557,
  0xffffd555ffffaaac, 0xffffe66699993335,
  0xffffe666cccc6668, 0xffffffffc0008001,
  0xffffffffc0010000, 0xffffffffc0010000,
  0xffffffffc0017ffe, 0xffffffffc0017fff,
  0xffffffffc001fffc, 0xffffffffc001fffe,
  0xffffffffc0027ffa, 0xffffffffffc00081,
  0xffffffffffc00100, 0xffffffffffc08080,
  0xffffffffffc080fe, 0xffffffffffc1007f,
  0xffffffffffc100fc, 0xffffffffffc1807e,
  0xffffffffffc180fa, 0xfffffffffff00021,
  0xfffffffffff00040, 0xfffffffffffe8004,
  0xfffffffffffe8006, 0xffffffffffff0003,
  0xffffffffffff0004, 0xffffffffffff8002,
  0xffffffffffff8001, 0x0000000000000001,
  0x0000000000000000, 0x0000000033333334,
  0x0000000000007fff, 0x0000000066666667,
  0x000000000000fffe, 0x0000000666666661,
  0x00000000000fffe0, 0x00000018ffffffe8,
  0x00000000003e7f83, 0x000000193333331b,
  0x00000000003eff82, 0x000000196666664e,
  0x00000000003f7f81, 0x00001998ffffe668,
  0x000000003ffe0003, 0x000019993333199b,
  0x000000003ffe8002, 0x0000199966664cce,
  0x000000003fff0001, 0x0a3d70a3c28f5c2a,
  0x0000199966664ccd, 0x11111110eeeeeef0,
  0x00002aaa55552aab, 0x19999998e6666668,
  0x00003fff7ffe8003, 0x199999991999999b,
  0x00003fff7fff0002, 0x199999994cccccce,
  0x00003fff7fff8001, 0xe666666680000001,
  0xffffc00080000000, 0xe6666666b3333334,
  0xffffc00080007fff, 0xeeeeeeeedddddddf,
  0xffffd555aaaa5556, 0xf5c28f5c0a3d70a5,
  0xffffe66699993334, 0xffffe66666668001,
  0xffffffffc0008000, 0xffffe6669999b334,
  0xffffffffc000ffff, 0xffffe666cccce667,
  0xffffffffc0017ffe, 0xffffe6670000199a,
  0xffffffffc001fffd, 0xffffffe666666681,
  0xffffffffffc00080, 0xffffffe6999999b4,
  0xffffffffffc0807f, 0xffffffe6cccccce7,
  0xffffffffffc1007e, 0xffffffe70000001a,
  0xffffffffffc1807d, 0xfffffff9999999a1,
  0xfffffffffff00020, 0xffffffff66666668,
  0xfffffffffffe8003, 0xffffffff9999999b,
  0xffffffffffff0002, 0xffffffffccccccce,
  0xffffffffcccccccd, 0x0000000000000001,
  0x0000000000000000, 0x0000000055555556,
  0x0000000033333333, 0x00000000aaaaaaab,
  0x0000000066666666, 0x0000000aaaaaaaa1,
  0x0000000666666660, 0x00000029aaaaaa82,
  0x00000018ffffffe7, 0x00000029ffffffd7,
  0x000000193333331a, 0x0000002a5555552c,
  0x000000196666664d, 0x00002aa9aaaa8002,
  0x00001998ffffe667, 0x00002aa9ffffd557,
  0x000019993333199a, 0x00002aaa55552aac,
  0x0000199966664ccd, 0x11111110eeeeeef0,
  0x0a3d70a3c28f5c29, 0x1c71c71c38e38e3a,
  0x11111110eeeeeeef, 0x2aaaaaa980000002,
  0x19999998e6666667, 0x2aaaaaa9d5555557,
  0x199999991999999a, 0x2aaaaaaa2aaaaaac,
  0x199999994ccccccd, 0xd555555580000001,
  0xe666666680000000, 0xd5555555d5555556,
  0xe6666666b3333333, 0xe38e38e371c71c73,
  0xeeeeeeeeddddddde, 0xeeeeeeeebbbbbbbd,
  0xf5c28f5c0a3d70a4, 0xffffd55555558001,
  0xffffe66666668000, 0xffffd555aaaad556,
  0xffffe6669999b333, 0xffffd55600002aab,
  0xffffe666cccce666, 0xffffd55655558000,
  0xffffe66700001999, 0xffffffd555555581,
  0xffffffe666666680, 0xffffffd5aaaaaad6,
  0xffffffe6999999b3, 0xffffffd60000002b,
  0xffffffe6cccccce6, 0xffffffd655555580,
  0xffffffe700000019, 0xfffffff555555561,
  0xfffffff9999999a0, 0xffffffff00000002,
  0xffffffff66666667, 0xffffffff55555557,
  0xffffffff9999999a, 0xffffffffaaaaaaac,
  0xffffffffaaaaaaab, 0x0000000000000001,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000055555555, 0x00000000fffffffb,
  0x00000000aaaaaaaa, 0x0000000fffffffa1,
  0x0000000aaaaaaaa0, 0x0000003e7ffffe8a,
  0x00000029aaaaaa81, 0x0000003efffffe87,
  0x00000029ffffffd6, 0x0000003f7ffffe84,
  0x0000002a5555552b, 0x00003ffe7ffe800a,
  0x00002aa9aaaa8001, 0x00003ffefffe8007,
  0x00002aa9ffffd556, 0x00003fff7ffe8004,
  0x00002aaa55552aab, 0x19999998e6666668,
  0x11111110eeeeeeef, 0x2aaaaaa980000002,
  0x1c71c71c38e38e39, 0x3ffffffd0000000a,
  0x2aaaaaa980000001, 0x3ffffffd80000007,
  0x2aaaaaa9d5555556, 0x3ffffffe00000004,
  0x2aaaaaaa2aaaaaab, 0xc000000180000001,
  0xd555555580000000, 0xc0000001fffffffe,
  0xd5555555d5555555, 0xd555555600000003,
  0xe38e38e371c71c72, 0xe66666669999999d,
  0xeeeeeeeebbbbbbbc, 0xffffc00000018001,
  0xffffd55555558000, 0xffffc00080017ffe,
  0xffffd555aaaad555, 0xffffc00100017ffb,
  0xffffd55600002aaa, 0xffffc00180017ff8,
  0xffffd55655557fff, 0xffffffc000000181,
  0xffffffd555555580, 0xffffffc08000017e,
  0xffffffd5aaaaaad5, 0xffffffc10000017b,
  0xffffffd60000002a, 0xffffffc180000178,
  0xffffffd65555557f, 0xfffffff000000061,
  0xfffffff555555560, 0xfffffffe8000000a,
  0xffffffff00000001, 0xffffffff00000007,
  0xffffffff55555556, 0xffffffff80000004,
  0xffffffff80000003, 0x0000000000000001,
  0x0000000000000000, 0x000000007fffffff,
  0x000000007ffffffd, 0x00000000fffffffd,
  0x00000000fffffffa, 0x0000000fffffffc1,
  0x0000000fffffffa0, 0x0000003e7fffff07,
  0x0000003e7ffffe89, 0x0000003effffff05,
  0x0000003efffffe86, 0x0000003f7fffff03,
  0x0000003f7ffffe83, 0x00003ffe7fff0007,
  0x00003ffe7ffe8009, 0x00003ffeffff0005,
  0x00003ffefffe8006, 0x00003fff7fff0003,
  0x00003fff7ffe8003, 0x199999991999999b,
  0x19999998e6666667, 0x2aaaaaa9d5555557,
  0x2aaaaaa980000001, 0x3ffffffd80000007,
  0x3ffffffd00000009, 0x3ffffffe00000005,
  0x3ffffffd80000006, 0x3ffffffe80000003,
  0x3ffffffe00000003, 0xc000000100000001,
  0xc000000180000000, 0xc00000017fffffff,
  0xc0000001fffffffd, 0xd5555555aaaaaaad,
  0xd555555600000002, 0xe666666666666669,
  0xe66666669999999c, 0xffffc00000010001,
  0xffffc00000018000, 0xffffc0008000ffff,
  0xffffc00080017ffd, 0xffffc0010000fffd,
  0xffffc00100017ffa, 0xffffc0018000fffb,
  0xffffc00180017ff7, 0xffffffc000000101,
  0xffffffc000000180, 0xffffffc0800000ff,
  0xffffffc08000017d, 0xffffffc1000000fd,
  0xffffffc10000017a, 0xffffffc1800000fb,
  0xffffffc180000177, 0xfffffff000000041,
  0xfffffff000000060, 0xfffffffe80000007,
  0xfffffffe80000009, 0xffffffff00000005,
  0xffffffff00000006, 0xffffffff80000003,
  0xffffffff80000002, 0x0000000000000001,
  0x0000000000000000, 0x0000000080000000,
  0x000000007ffffffe, 0x00000000ffffffff,
  0x00000000fffffffc, 0x0000000fffffffe1,
  0x0000000fffffffc0, 0x0000003e7fffff84,
  0x0000003e7fffff06, 0x0000003effffff83,
  0x0000003effffff04, 0x0000003f7fffff82,
  0x0000003f7fffff02, 0x00003ffe7fff8004,
  0x00003ffe7fff0006, 0x00003ffeffff8003,
  0x00003ffeffff0004, 0x00003fff7fff8002,
  0x00003fff7fff0002, 0x199999994cccccce,
  0x199999991999999a, 0x2aaaaaaa2aaaaaac,
  0x2aaaaaa9d5555556, 0x3ffffffe00000004,
  0x3ffffffd80000006, 0x3ffffffe80000003,
  0x3ffffffe00000004, 0x3fffffff00000002,
  0x3ffffffe80000002, 0xc000000080000001,
  0xc000000100000000, 0xc000000100000000,
  0xc00000017ffffffe, 0xd555555555555557,
  0xd5555555aaaaaaac, 0xe666666633333335,
  0xe666666666666668, 0xffffc00000008001,
  0xffffc00000010000, 0xffffc00080008000,
  0xffffc0008000fffe, 0xffffc00100007fff,
  0xffffc0010000fffc, 0xffffc00180007ffe,
  0xffffc0018000fffa, 0xffffffc000000081,
  0xffffffc000000100, 0xffffffc080000080,
  0xffffffc0800000fe, 0xffffffc10000007f,
  0xffffffc1000000fc, 0xffffffc18000007e,
  0xffffffc1800000fa, 0xfffffff000000021,
  0xfffffff000000040, 0xfffffffe80000004,
  0xfffffffe80000006, 0xffffffff00000003,
  0xffffffff00000004, 0xffffffff80000002,
  0xffffffff80000001, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000001,
  0x000000007fffffff, 0xffffffff00000001,
  0x00000000fffffffe, 0xfffffff000000001,
  0x0000000fffffffe0, 0xffffffc180000001,
  0x0000003e7fffff83, 0xffffffc100000001,
  0x0000003effffff82, 0xffffffc080000001,
  0x0000003f7fffff81, 0xffffc00180000001,
  0x00003ffe7fff8003, 0xffffc00100000001,
  0x00003ffeffff8002, 0xffffc00080000001,
  0x00003fff7fff8001, 0xe666666680000001,
  0x199999994ccccccd, 0xd555555580000001,
  0x2aaaaaaa2aaaaaab, 0xc000000180000001,
  0x3ffffffe00000003, 0xc000000100000001,
  0x3ffffffe80000002, 0xc000000080000001,
  0x3fffffff00000001, 0x4000000000000001,
  0xc000000080000000, 0x3fffffff80000001,
  0xc0000000ffffffff, 0x2aaaaaab00000001,
  0xd555555555555556, 0x1999999a00000001,
  0xe666666633333334, 0x0000400000000001,
  0xffffc00000008000, 0x00003fff80000001,
  0xffffc00080007fff, 0x00003fff00000001,
  0xffffc00100007ffe, 0x00003ffe80000001,
  0xffffc00180007ffd, 0x0000004000000001,
  0xffffffc000000080, 0x0000003f80000001,
  0xffffffc08000007f, 0x0000003f00000001,
  0xffffffc10000007e, 0x0000003e80000001,
  0xffffffc18000007d, 0x0000001000000001,
  0xfffffff000000020, 0x0000000180000001,
  0xfffffffe80000003, 0x0000000100000001,
  0xffffffff00000002, 0x0000000080000001,
  0x0000000080000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffff80000002,
  0xffffffff80000000, 0xffffffff00000003,
  0xffffffff00000000, 0xfffffff000000021,
  0xfffffff000000000, 0xffffffc18000007e,
  0xffffffc180000000, 0xffffffc10000007f,
  0xffffffc100000000, 0xffffffc080000080,
  0xffffffc080000000, 0xffffc00180007ffe,
  0xffffc00180000000, 0xffffc00100007fff,
  0xffffc00100000000, 0xffffc00080008000,
  0xffffc00080000000, 0xe6666666b3333334,
  0xe666666680000000, 0xd5555555d5555556,
  0xd555555580000000, 0xc0000001fffffffe,
  0xc000000180000000, 0xc00000017fffffff,
  0xc000000100000000, 0xc000000100000000,
  0xc000000080000000, 0x3fffffff80000001,
  0x4000000000000000, 0x3fffffff00000002,
  0x3fffffff80000000, 0x2aaaaaaaaaaaaaab,
  0x2aaaaaab00000000, 0x19999999cccccccd,
  0x1999999a00000000, 0x00003fffffff8001,
  0x0000400000000000, 0x00003fff7fff8002,
  0x00003fff80000000, 0x00003ffeffff8003,
  0x00003fff00000000, 0x00003ffe7fff8004,
  0x00003ffe80000000, 0x0000003fffffff81,
  0x0000004000000000, 0x0000003f7fffff82,
  0x0000003f80000000, 0x0000003effffff83,
  0x0000003f00000000, 0x0000003e7fffff84,
  0x0000003e80000000, 0x0000000fffffffe1,
  0x0000001000000000, 0x000000017ffffffe,
  0x0000000180000000, 0x00000000ffffffff,
  0x0000000100000000, 0x0000000080000000,
  0x000000007fffffff, 0x0000000000000001,
  0x0000000000000000, 0xffffffffaaaaaaab,
  0xffffffff80000001, 0xffffffff55555555,
  0xffffffff00000002, 0xfffffff555555541,
  0xfffffff000000020, 0xffffffd655555503,
  0xffffffc18000007d, 0xffffffd5ffffffad,
  0xffffffc10000007e, 0xffffffd5aaaaaa57,
  0xffffffc08000007f, 0xffffd55655550003,
  0xffffc00180007ffd, 0xffffd555ffffaaad,
  0xffffc00100007ffe, 0xffffd555aaaa5557,
  0xffffc00080007fff, 0xeeeeeeeedddddddf,
  0xe6666666b3333333, 0xe38e38e371c71c73,
  0xd5555555d5555555, 0xd555555600000003,
  0xc0000001fffffffd, 0xd5555555aaaaaaad,
  0xc00000017ffffffe, 0xd555555555555557,
  0xc0000000ffffffff, 0x2aaaaaab00000001,
  0x3fffffff80000000, 0x2aaaaaaaaaaaaaab,
  0x3fffffff00000001, 0x1c71c71ce38e38e5,
  0x2aaaaaaaaaaaaaaa, 0x1111111177777779,
  0x19999999cccccccc, 0x00002aaaaaab0001,
  0x00003fffffff8000, 0x00002aaa5555aaab,
  0x00003fff7fff8001, 0x00002aaa00005555,
  0x00003ffeffff8002, 0x00002aa9aaaaffff,
  0x00003ffe7fff8003, 0x0000002aaaaaab01,
  0x0000003fffffff80, 0x0000002a555555ab,
  0x0000003f7fffff81, 0x0000002a00000055,
  0x0000003effffff82, 0x00000029aaaaaaff,
  0x0000003e7fffff83, 0x0000000aaaaaaac1,
  0x0000000fffffffe0, 0x0000000100000003,
  0x000000017ffffffd, 0x00000000aaaaaaad,
  0x00000000fffffffe, 0x0000000055555557,
  0x0000000055555556, 0x0000000000000001,
  0x0000000000000000, 0xffffffffcccccccd,
  0xffffffffaaaaaaaa, 0xffffffff99999999,
  0xffffffff55555554, 0xfffffff999999981,
  0xfffffff555555540, 0xffffffe6ffffff9d,
  0xffffffd655555502, 0xffffffe6cccccc69,
  0xffffffd5ffffffac, 0xffffffe699999935,
  0xffffffd5aaaaaa56, 0xffffe666ffff999d,
  0xffffd55655550002, 0xffffe666cccc6669,
  0xffffd555ffffaaac, 0xffffe66699993335,
  0xffffd555aaaa5556, 0xf5c28f5c0a3d70a5,
  0xeeeeeeeeddddddde, 0xeeeeeeeebbbbbbbd,
  0xe38e38e371c71c72, 0xe66666669999999d,
  0xd555555600000002, 0xe666666666666669,
  0xd5555555aaaaaaac, 0xe666666633333335,
  0xd555555555555556, 0x1999999a00000001,
  0x2aaaaaab00000000, 0x19999999cccccccd,
  0x2aaaaaaaaaaaaaaa, 0x1111111177777779,
  0x1c71c71ce38e38e4, 0x0a3d70a428f5c291,
  0x1111111177777778, 0x00001999999a0001,
  0x00002aaaaaab0000, 0x000019996666cccd,
  0x00002aaa5555aaaa, 0x0000199933339999,
  0x00002aaa00005554, 0x0000199900006665,
  0x00002aa9aaaafffe, 0x0000001999999a01,
  0x0000002aaaaaab00, 0x00000019666666cd,
  0x0000002a555555aa, 0x0000001933333399,
  0x0000002a00000054, 0x0000001900000065,
  0x00000029aaaaaafe, 0x0000000666666681,
  0x0000000aaaaaaac0, 0x000000009999999d,
  0x0000000100000002, 0x0000000066666669,
  0x00000000aaaaaaac, 0x0000000033333335,
  0x0000000033333334, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8001,
  0xffffffffcccccccc, 0xffffffffffff0001,
  0xffffffff99999998, 0xfffffffffff00001,
  0xfffffff999999980, 0xffffffffffc18001,
  0xffffffe6ffffff9c, 0xffffffffffc10001,
  0xffffffe6cccccc68, 0xffffffffffc08001,
  0xffffffe699999934, 0xffffffffc0018001,
  0xffffe666ffff999c, 0xffffffffc0010001,
  0xffffe666cccc6668, 0xffffffffc0008001,
  0xffffe66699993334, 0xffffe66666668001,
  0xf5c28f5c0a3d70a4, 0xffffd55555558001,
  0xeeeeeeeebbbbbbbc, 0xffffc00000018001,
  0xe66666669999999c, 0xffffc00000010001,
  0xe666666666666668, 0xffffc00000008001,
  0xe666666633333334, 0x0000400000000001,
  0x1999999a00000000, 0x00003fffffff8001,
  0x19999999cccccccc, 0x00002aaaaaab0001,
  0x1111111177777778, 0x00001999999a0001,
  0x0a3d70a428f5c290, 0x0000000040000001,
  0x00001999999a0000, 0x000000003fff8001,
  0x000019996666cccc, 0x000000003fff0001,
  0x0000199933339998, 0x000000003ffe8001,
  0x0000199900006664, 0x0000000000400001,
  0x0000001999999a00, 0x00000000003f8001,
  0x00000019666666cc, 0x00000000003f0001,
  0x0000001933333398, 0x00000000003e8001,
  0x0000001900000064, 0x0000000000100001,
  0x0000000666666680, 0x0000000000018001,
  0x000000009999999c, 0x0000000000010001,
  0x0000000066666668, 0x0000000000008001,
  0x0000000000008000, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8002,
  0xffffffffffff8000, 0xffffffffffff0003,
  0xffffffffffff0000, 0xfffffffffff00021,
  0xfffffffffff00000, 0xffffffffffc1807e,
  0xffffffffffc18000, 0xffffffffffc1007f,
  0xffffffffffc10000, 0xffffffffffc08080,
  0xffffffffffc08000, 0xffffffffc001fffe,
  0xffffffffc0018000, 0xffffffffc0017fff,
  0xffffffffc0010000, 0xffffffffc0010000,
  0xffffffffc0008000, 0xffffe6669999b334,
  0xffffe66666668000, 0xffffd555aaaad556,
  0xffffd55555558000, 0xffffc00080017ffe,
  0xffffc00000018000, 0xffffc0008000ffff,
  0xffffc00000010000, 0xffffc00080008000,
  0xffffc00000008000, 0x00003fff80000001,
  0x0000400000000000, 0x00003fff7fff8002,
  0x00003fffffff8000, 0x00002aaa5555aaab,
  0x00002aaaaaab0000, 0x000019996666cccd,
  0x00001999999a0000, 0x000000003fff8001,
  0x0000000040000000, 0x000000003fff0002,
  0x000000003fff8000, 0x000000003ffe8003,
  0x000000003fff0000, 0x000000003ffe0004,
  0x000000003ffe8000, 0x00000000003fff81,
  0x0000000000400000, 0x00000000003f7f82,
  0x00000000003f8000, 0x00000000003eff83,
  0x00000000003f0000, 0x00000000003e7f84,
  0x00000000003e8000, 0x00000000000fffe1,
  0x0000000000100000, 0x0000000000017ffe,
  0x0000000000018000, 0x000000000000ffff,
  0x0000000000010000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8003,
  0xffffffffffff8001, 0xffffffffffff0005,
  0xffffffffffff0002, 0xfffffffffff00041,
  0xfffffffffff00020, 0xffffffffffc180fb,
  0xffffffffffc1807d, 0xffffffffffc100fd,
  0xffffffffffc1007e, 0xffffffffffc080ff,
  0xffffffffffc0807f, 0xffffffffc0027ffb,
  0xffffffffc001fffd, 0xffffffffc001fffd,
  0xffffffffc0017ffe, 0xffffffffc0017fff,
  0xffffffffc000ffff, 0xffffe666cccce667,
  0xffffe6669999b333, 0xffffd55600002aab,
  0xffffd555aaaad555, 0xffffc00100017ffb,
  0xffffc00080017ffd, 0xffffc0010000fffd,
  0xffffc0008000fffe, 0xffffc00100007fff,
  0xffffc00080007fff, 0x00003fff00000001,
  0x00003fff80000000, 0x00003ffeffff8003,
  0x00003fff7fff8001, 0x00002aaa00005555,
  0x00002aaa5555aaaa, 0x0000199933339999,
  0x000019996666cccc, 0x000000003fff0001,
  0x000000003fff8000, 0x000000003ffe8003,
  0x000000003fff0001, 0x000000003ffe0005,
  0x000000003ffe8002, 0x000000003ffd8007,
  0x000000003ffe0003, 0x00000000003fff01,
  0x00000000003fff80, 0x00000000003f7f03,
  0x00000000003f7f81, 0x00000000003eff05,
  0x00000000003eff82, 0x00000000003e7f07,
  0x00000000003e7f83, 0x00000000000fffc1,
  0x00000000000fffe0, 0x0000000000017ffb,
  0x0000000000017ffd, 0x000000000000fffd,
  0x000000000000fffe, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff8004,
  0xffffffffffff8002, 0xffffffffffff0007,
  0xffffffffffff0004, 0xfffffffffff00061,
  0xfffffffffff00040, 0xffffffffffc18178,
  0xffffffffffc180fa, 0xffffffffffc1017b,
  0xffffffffffc100fc, 0xffffffffffc0817e,
  0xffffffffffc080fe, 0xffffffffc002fff8,
  0xffffffffc0027ffa, 0xffffffffc0027ffb,
  0xffffffffc001fffc, 0xffffffffc001fffe,
  0xffffffffc0017ffe, 0xffffe6670000199a,
  0xffffe666cccce666, 0xffffd55655558000,
  0xffffd55600002aaa, 0xffffc00180017ff8,
  0xffffc00100017ffa, 0xffffc0018000fffb,
  0xffffc0010000fffc, 0xffffc00180007ffe,
  0xffffc00100007ffe, 0x00003ffe80000001,
  0x00003fff00000000, 0x00003ffe7fff8004,
  0x00003ffeffff8002, 0x00002aa9aaaaffff,
  0x00002aaa00005554, 0x0000199900006665,
  0x0000199933339998, 0x000000003ffe8001,
  0x000000003fff0000, 0x000000003ffe0004,
  0x000000003ffe8002, 0x000000003ffd8007,
  0x000000003ffe0004, 0x000000003ffd000a,
  0x000000003ffd8006, 0x00000000003ffe81,
  0x00000000003fff00, 0x00000000003f7e84,
  0x00000000003f7f02, 0x00000000003efe87,
  0x00000000003eff04, 0x00000000003e7e8a,
  0x00000000003e7f06, 0x00000000000fffa1,
  0x00000000000fffc0, 0x0000000000017ff8,
  0x0000000000017ffa, 0x000000000000fffb,
  0x000000000000fffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff81,
  0xffffffffffff8003, 0xffffffffffffff01,
  0xffffffffffff0006, 0xfffffffffffff001,
  0xfffffffffff00060, 0xffffffffffffc181,
  0xffffffffffc18177, 0xffffffffffffc101,
  0xffffffffffc1017a, 0xffffffffffffc081,
  0xffffffffffc0817d, 0xffffffffffc00181,
  0xffffffffc002fff7, 0xffffffffffc00101,
  0xffffffffc0027ffa, 0xffffffffffc00081,
  0xffffffffc001fffd, 0xffffffe666666681,
  0xffffe66700001999, 0xffffffd555555581,
  0xffffd55655557fff, 0xffffffc000000181,
  0xffffc00180017ff7, 0xffffffc000000101,
  0xffffc0018000fffa, 0xffffffc000000081,
  0xffffc00180007ffd, 0x0000004000000001,
  0x00003ffe80000000, 0x0000003fffffff81,
  0x00003ffe7fff8003, 0x0000002aaaaaab01,
  0x00002aa9aaaafffe, 0x0000001999999a01,
  0x0000199900006664, 0x0000000000400001,
  0x000000003ffe8000, 0x00000000003fff81,
  0x000000003ffe0003, 0x00000000003fff01,
  0x000000003ffd8006, 0x00000000003ffe81,
  0x000000003ffd0009, 0x0000000000004001,
  0x00000000003ffe80, 0x0000000000003f81,
  0x00000000003f7e83, 0x0000000000003f01,
  0x00000000003efe86, 0x0000000000003e81,
  0x00000000003e7e89, 0x0000000000001001,
  0x00000000000fffa0, 0x0000000000000181,
  0x0000000000017ff7, 0x0000000000000101,
  0x000000000000fffa, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff82,
  0xffffffffffffff80, 0xffffffffffffff03,
  0xffffffffffffff00, 0xfffffffffffff021,
  0xfffffffffffff000, 0xffffffffffffc1fe,
  0xffffffffffffc180, 0xffffffffffffc17f,
  0xffffffffffffc100, 0xffffffffffffc100,
  0xffffffffffffc080, 0xffffffffffc0817e,
  0xffffffffffc00180, 0xffffffffffc080ff,
  0xffffffffffc00100, 0xffffffffffc08080,
  0xffffffffffc00080, 0xffffffe6999999b4,
  0xffffffe666666680, 0xffffffd5aaaaaad6,
  0xffffffd555555580, 0xffffffc08000017e,
  0xffffffc000000180, 0xffffffc0800000ff,
  0xffffffc000000100, 0xffffffc080000080,
  0xffffffc000000080, 0x0000003f80000001,
  0x0000004000000000, 0x0000003f7fffff82,
  0x0000003fffffff80, 0x0000002a555555ab,
  0x0000002aaaaaab00, 0x00000019666666cd,
  0x0000001999999a00, 0x00000000003f8001,
  0x0000000000400000, 0x00000000003f7f82,
  0x00000000003fff80, 0x00000000003f7f03,
  0x00000000003fff00, 0x00000000003f7e84,
  0x00000000003ffe80, 0x0000000000003f81,
  0x0000000000004000, 0x0000000000003f02,
  0x0000000000003f80, 0x0000000000003e83,
  0x0000000000003f00, 0x0000000000003e04,
  0x0000000000003e80, 0x0000000000000fe1,
  0x0000000000001000, 0x000000000000017e,
  0x0000000000000180, 0x00000000000000ff,
  0x0000000000000100, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff83,
  0xffffffffffffff81, 0xffffffffffffff05,
  0xffffffffffffff02, 0xfffffffffffff041,
  0xfffffffffffff020, 0xffffffffffffc27b,
  0xffffffffffffc1fd, 0xffffffffffffc1fd,
  0xffffffffffffc17e, 0xffffffffffffc17f,
  0xffffffffffffc0ff, 0xffffffffffc1017b,
  0xffffffffffc0817d, 0xffffffffffc100fd,
  0xffffffffffc080fe, 0xffffffffffc1007f,
  0xffffffffffc0807f, 0xffffffe6cccccce7,
  0xffffffe6999999b3, 0xffffffd60000002b,
  0xffffffd5aaaaaad5, 0xffffffc10000017b,
  0xffffffc08000017d, 0xffffffc1000000fd,
  0xffffffc0800000fe, 0xffffffc10000007f,
  0xffffffc08000007f, 0x0000003f00000001,
  0x0000003f80000000, 0x0000003effffff83,
  0x0000003f7fffff81, 0x0000002a00000055,
  0x0000002a555555aa, 0x0000001933333399,
  0x00000019666666cc, 0x00000000003f0001,
  0x00000000003f8000, 0x00000000003eff83,
  0x00000000003f7f81, 0x00000000003eff05,
  0x00000000003f7f02, 0x00000000003efe87,
  0x00000000003f7e83, 0x0000000000003f01,
  0x0000000000003f80, 0x0000000000003e83,
  0x0000000000003f01, 0x0000000000003e05,
  0x0000000000003e82, 0x0000000000003d87,
  0x0000000000003e03, 0x0000000000000fc1,
  0x0000000000000fe0, 0x000000000000017b,
  0x000000000000017d, 0x00000000000000fd,
  0x00000000000000fe, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff84,
  0xffffffffffffff82, 0xffffffffffffff07,
  0xffffffffffffff04, 0xfffffffffffff061,
  0xfffffffffffff040, 0xffffffffffffc2f8,
  0xffffffffffffc27a, 0xffffffffffffc27b,
  0xffffffffffffc1fc, 0xffffffffffffc1fe,
  0xffffffffffffc17e, 0xffffffffffc18178,
  0xffffffffffc1017a, 0xffffffffffc180fb,
  0xffffffffffc100fc, 0xffffffffffc1807e,
  0xffffffffffc1007e, 0xffffffe70000001a,
  0xffffffe6cccccce6, 0xffffffd655555580,
  0xffffffd60000002a, 0xffffffc180000178,
  0xffffffc10000017a, 0xffffffc1800000fb,
  0xffffffc1000000fc, 0xffffffc18000007e,
  0xffffffc10000007e, 0x0000003e80000001,
  0x0000003f00000000, 0x0000003e7fffff84,
  0x0000003effffff82, 0x00000029aaaaaaff,
  0x0000002a00000054, 0x0000001900000065,
  0x0000001933333398, 0x00000000003e8001,
  0x00000000003f0000, 0x00000000003e7f84,
  0x00000000003eff82, 0x00000000003e7f07,
  0x00000000003eff04, 0x00000000003e7e8a,
  0x00000000003efe86, 0x0000000000003e81,
  0x0000000000003f00, 0x0000000000003e04,
  0x0000000000003e82, 0x0000000000003d87,
  0x0000000000003e04, 0x0000000000003d0a,
  0x0000000000003d86, 0x0000000000000fa1,
  0x0000000000000fc0, 0x0000000000000178,
  0x000000000000017a, 0x00000000000000fb,
  0x00000000000000fc, 0x000000000000007e,
  0x000000000000007d, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffe1,
  0xffffffffffffff83, 0xffffffffffffffc1,
  0xffffffffffffff06, 0xfffffffffffffc01,
  0xfffffffffffff060, 0xfffffffffffff061,
  0xffffffffffffc2f7, 0xfffffffffffff041,
  0xffffffffffffc27a, 0xfffffffffffff021,
  0xffffffffffffc1fd, 0xfffffffffff00061,
  0xffffffffffc18177, 0xfffffffffff00041,
  0xffffffffffc180fa, 0xfffffffffff00021,
  0xffffffffffc1807d, 0xfffffff9999999a1,
  0xffffffe700000019, 0xfffffff555555561,
  0xffffffd65555557f, 0xfffffff000000061,
  0xffffffc180000177, 0xfffffff000000041,
  0xffffffc1800000fa, 0xfffffff000000021,
  0xffffffc18000007d, 0x0000001000000001,
  0x0000003e80000000, 0x0000000fffffffe1,
  0x0000003e7fffff83, 0x0000000aaaaaaac1,
  0x00000029aaaaaafe, 0x0000000666666681,
  0x0000001900000064, 0x0000000000100001,
  0x00000000003e8000, 0x00000000000fffe1,
  0x00000000003e7f83, 0x00000000000fffc1,
  0x00000000003e7f06, 0x00000000000fffa1,
  0x00000000003e7e89, 0x0000000000001001,
  0x0000000000003e80, 0x0000000000000fe1,
  0x0000000000003e03, 0x0000000000000fc1,
  0x0000000000003d86, 0x0000000000000fa1,
  0x0000000000003d09, 0x0000000000000401,
  0x0000000000000fa0, 0x0000000000000061,
  0x0000000000000177, 0x0000000000000041,
  0x00000000000000fa, 0x0000000000000021,
  0x0000000000000020, 0x0000000000000001,
  0x0000000000000000, 0xfffffffffffffffe,
  0xffffffffffffffe0, 0xfffffffffffffffb,
  0xffffffffffffffc0, 0xffffffffffffffa1,
  0xfffffffffffffc00, 0xfffffffffffffe8a,
  0xfffffffffffff060, 0xfffffffffffffe87,
  0xfffffffffffff040, 0xfffffffffffffe84,
  0xfffffffffffff020, 0xfffffffffffe800a,
  0xfffffffffff00060, 0xfffffffffffe8007,
  0xfffffffffff00040, 0xfffffffffffe8004,
  0xfffffffffff00020, 0xffffffff66666668,
  0xfffffff9999999a0, 0xffffffff00000002,
  0xfffffff555555560, 0xfffffffe8000000a,
  0xfffffff000000060, 0xfffffffe80000007,
  0xfffffff000000040, 0xfffffffe80000004,
  0xfffffff000000020, 0x0000000180000001,
  0x0000001000000000, 0x000000017ffffffe,
  0x0000000fffffffe0, 0x0000000100000003,
  0x0000000aaaaaaac0, 0x000000009999999d,
  0x0000000666666680, 0x0000000000018001,
  0x0000000000100000, 0x0000000000017ffe,
  0x00000000000fffe0, 0x0000000000017ffb,
  0x00000000000fffc0, 0x0000000000017ff8,
  0x00000000000fffa0, 0x0000000000000181,
  0x0000000000001000, 0x000000000000017e,
  0x0000000000000fe0, 0x000000000000017b,
  0x0000000000000fc0, 0x0000000000000178,
  0x0000000000000fa0, 0x0000000000000061,
  0x0000000000000400, 0x000000000000000a,
  0x0000000000000060, 0x0000000000000007,
  0x0000000000000040, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffff,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffa, 0xffffffffffffffc1,
  0xffffffffffffffa0, 0xffffffffffffff07,
  0xfffffffffffffe89, 0xffffffffffffff05,
  0xfffffffffffffe86, 0xffffffffffffff03,
  0xfffffffffffffe83, 0xffffffffffff0007,
  0xfffffffffffe8009, 0xffffffffffff0005,
  0xfffffffffffe8006, 0xffffffffffff0003,
  0xfffffffffffe8003, 0xffffffff9999999b,
  0xffffffff66666667, 0xffffffff55555557,
  0xffffffff00000001, 0xffffffff00000007,
  0xfffffffe80000009, 0xffffffff00000005,
  0xfffffffe80000006, 0xffffffff00000003,
  0xfffffffe80000003, 0x0000000100000001,
  0x0000000180000000, 0x00000000ffffffff,
  0x000000017ffffffd, 0x00000000aaaaaaad,
  0x0000000100000002, 0x0000000066666669,
  0x000000009999999c, 0x0000000000010001,
  0x0000000000018000, 0x000000000000ffff,
  0x0000000000017ffd, 0x000000000000fffd,
  0x0000000000017ffa, 0x000000000000fffb,
  0x0000000000017ff7, 0x0000000000000101,
  0x0000000000000180, 0x00000000000000ff,
  0x000000000000017d, 0x00000000000000fd,
  0x000000000000017a, 0x00000000000000fb,
  0x0000000000000177, 0x0000000000000041,
  0x0000000000000060, 0x0000000000000007,
  0x0000000000000009, 0x0000000000000005,
  0x0000000000000006, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffffe, 0xffffffffffffffff,
  0xfffffffffffffffc, 0xffffffffffffffe1,
  0xffffffffffffffc0, 0xffffffffffffff84,
  0xffffffffffffff06, 0xffffffffffffff83,
  0xffffffffffffff04, 0xffffffffffffff82,
  0xffffffffffffff02, 0xffffffffffff8004,
  0xffffffffffff0006, 0xffffffffffff8003,
  0xffffffffffff0004, 0xffffffffffff8002,
  0xffffffffffff0002, 0xffffffffccccccce,
  0xffffffff9999999a, 0xffffffffaaaaaaac,
  0xffffffff55555556, 0xffffffff80000004,
  0xffffffff00000006, 0xffffffff80000003,
  0xffffffff00000004, 0xffffffff80000002,
  0xffffffff00000002, 0x0000000080000001,
  0x0000000100000000, 0x0000000080000000,
  0x00000000fffffffe, 0x0000000055555557,
  0x00000000aaaaaaac, 0x0000000033333335,
  0x0000000066666668, 0x0000000000008001,
  0x0000000000010000, 0x0000000000008000,
  0x000000000000fffe, 0x0000000000007fff,
  0x000000000000fffc, 0x0000000000007ffe,
  0x000000000000fffa, 0x0000000000000081,
  0x0000000000000100, 0x0000000000000080,
  0x00000000000000fe, 0x000000000000007f,
  0x00000000000000fc, 0x000000000000007e,
  0x00000000000000fa, 0x0000000000000021,
  0x0000000000000040, 0x0000000000000004,
  0x0000000000000006, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000002,
};
const unsigned kExpectedCount_NEON_smlal2_2D = 961;

#endif  // VIXL_SIM_SMLAL2_2D_TRACE_AARCH64_H_
