package sts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateSessionAccessKey invokes the sts.GenerateSessionAccessKey API synchronously
// api document: https://help.aliyun.com/api/sts/generatesessionaccesskey.html
func (client *Client) GenerateSessionAccessKey(request *GenerateSessionAccessKeyRequest) (response *GenerateSessionAccessKeyResponse, err error) {
	response = CreateGenerateSessionAccessKeyResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateSessionAccessKeyWithChan invokes the sts.GenerateSessionAccessKey API asynchronously
// api document: https://help.aliyun.com/api/sts/generatesessionaccesskey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateSessionAccessKeyWithChan(request *GenerateSessionAccessKeyRequest) (<-chan *GenerateSessionAccessKeyResponse, <-chan error) {
	responseChan := make(chan *GenerateSessionAccessKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateSessionAccessKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateSessionAccessKeyWithCallback invokes the sts.GenerateSessionAccessKey API asynchronously
// api document: https://help.aliyun.com/api/sts/generatesessionaccesskey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateSessionAccessKeyWithCallback(request *GenerateSessionAccessKeyRequest, callback func(response *GenerateSessionAccessKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateSessionAccessKeyResponse
		var err error
		defer close(result)
		response, err = client.GenerateSessionAccessKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateSessionAccessKeyRequest is the request struct for api GenerateSessionAccessKey
type GenerateSessionAccessKeyRequest struct {
	*requests.RpcRequest
	DurationSeconds requests.Integer `position:"Query" name:"DurationSeconds"`
}

// GenerateSessionAccessKeyResponse is the response struct for api GenerateSessionAccessKey
type GenerateSessionAccessKeyResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	SessionAccessKey SessionAccessKey `json:"SessionAccessKey" xml:"SessionAccessKey"`
}

// CreateGenerateSessionAccessKeyRequest creates a request to invoke GenerateSessionAccessKey API
func CreateGenerateSessionAccessKeyRequest() (request *GenerateSessionAccessKeyRequest) {
	request = &GenerateSessionAccessKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sts", "2015-04-01", "GenerateSessionAccessKey", "", "")
	return
}

// CreateGenerateSessionAccessKeyResponse creates a response to parse from GenerateSessionAccessKey response
func CreateGenerateSessionAccessKeyResponse() (response *GenerateSessionAccessKeyResponse) {
	response = &GenerateSessionAccessKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
