package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportKeyMaterial invokes the kms.ImportKeyMaterial API synchronously
// api document: https://help.aliyun.com/api/kms/importkeymaterial.html
func (client *Client) ImportKeyMaterial(request *ImportKeyMaterialRequest) (response *ImportKeyMaterialResponse, err error) {
	response = CreateImportKeyMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// ImportKeyMaterialWithChan invokes the kms.ImportKeyMaterial API asynchronously
// api document: https://help.aliyun.com/api/kms/importkeymaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImportKeyMaterialWithChan(request *ImportKeyMaterialRequest) (<-chan *ImportKeyMaterialResponse, <-chan error) {
	responseChan := make(chan *ImportKeyMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportKeyMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportKeyMaterialWithCallback invokes the kms.ImportKeyMaterial API asynchronously
// api document: https://help.aliyun.com/api/kms/importkeymaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImportKeyMaterialWithCallback(request *ImportKeyMaterialRequest, callback func(response *ImportKeyMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportKeyMaterialResponse
		var err error
		defer close(result)
		response, err = client.ImportKeyMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportKeyMaterialRequest is the request struct for api ImportKeyMaterial
type ImportKeyMaterialRequest struct {
	*requests.RpcRequest
	KeyId                 string           `position:"Query" name:"KeyId"`
	STSToken              string           `position:"Query" name:"STSToken"`
	EncryptedKeyMaterial  string           `position:"Query" name:"EncryptedKeyMaterial"`
	ImportToken           string           `position:"Query" name:"ImportToken"`
	KeyMaterialExpireUnix requests.Integer `position:"Query" name:"KeyMaterialExpireUnix"`
}

// ImportKeyMaterialResponse is the response struct for api ImportKeyMaterial
type ImportKeyMaterialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateImportKeyMaterialRequest creates a request to invoke ImportKeyMaterial API
func CreateImportKeyMaterialRequest() (request *ImportKeyMaterialRequest) {
	request = &ImportKeyMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ImportKeyMaterial", "kms", "openAPI")
	return
}

// CreateImportKeyMaterialResponse creates a response to parse from ImportKeyMaterial response
func CreateImportKeyMaterialResponse() (response *ImportKeyMaterialResponse) {
	response = &ImportKeyMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
