//start of PostLzsEncoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PostLzsEncoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;


/**
 * -lzs- kp PostLzssEncoderB
 * 
 * <pre>
 * -- revision history --
 * $Log: PostLzsEncoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/31 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     -lzs-  MaxMatch  16 łȂ 17 ̂CB
 * [maintenance]
 *     \[X
 *     ^u̔p~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PostLzsEncoder implements PostLzssEncoder {


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 2048;

    /** őv */
    private static final int MaxMatch       = 17;

    /** ŏv */
    private static final int Threshold      = 2;


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  length of LZSS code
    //------------------------------------------------------------------
    //  private static final int PositionBits
    //  private static final int LengthBits
    //------------------------------------------------------------------
    /** vʒũrbg */
    private static final int PositionBits = Bits.len( PostLzsEncoder.DictionarySize - 1 );

    /** ṽrbg */
    private static final int LengthBits = Bits.len( PostLzsEncoder.MaxMatch - PostLzsEncoder.Threshold );


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  private BitOutputStream out
    //  private int position
    //  private int matchLength
    //------------------------------------------------------------------
    /**
     * -lzs- `̃f[^o͂rbgo̓Xg[
     */
    private BitOutputStream out;

    /**
     * Xg[ݏʒu
     */
    private int position;

    /**
     * ݏLZSSkR[h
     */
    private int matchLength;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private PostLzsEncoder()
    //  public PostLzsEncoder( OutputStream out )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PostLzsEncoder(){   }

    /**
     * -lzs- kp PostLzssEncoder \zB
     * 
     * @param out -lzs- `̈kf[^o͂Xg[
     */
    public PostLzsEncoder( OutputStream out ){
        if( out != null ){
            if( out instanceof BitOutputStream ){
                this.out = (BitOutputStream)out;
            }else{
                this.out = new BitOutputStream( out );
            }
            this.position    = 0;
            this.matchLength = 0;
        }else{
            throw new NullPointerException( "out" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void writeCode( int code )
    //  public void writeOffset( int offset )
    //------------------------------------------------------------------
    /**
     * 1byte  LZSSk̃f[^́A
     * LZSS ňkꂽkR[ĥvށB<br>
     * 
     * @param code 1byte  LZSSk̃f[^́A
     *             LZSS ňkꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeCode( int code ) throws IOException {
        if( code < 0x100 ){
            this.out.writeBit( 1 );                                             //throws IOException
            this.out.writeBits( 8, code );                                      //throws IOException
            this.position++;
        }else{
            // close()  writeCode() 
            // NullPointerException 𓊂邱Ƃ҂ĂB
            this.out.writeBit( 0 );                                             //throws IOException
            this.matchLength = code - 0x100;
        }
    }

    /**
     * LZSS ňkꂽkR[ĥvʒuށB<br>
     * 
     * @param offset LZSS ňkꂽkR[ĥvʒu
     */
    public void writeOffset( int offset ) throws IOException {
        int pos = ( this.position - offset - 1
                  - PostLzsEncoder.MaxMatch )
                & ( PostLzsEncoder.DictionarySize - 1 );

        this.position += this.matchLength + PostLzsEncoder.Threshold;

        this.out.writeBits( this.PositionBits, pos );                           //throws IOException
        this.out.writeBits( this.LengthBits,   this.matchLength );              //throws IOException
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  PostLzssEncoder Ƀobt@OĂ
     * SĂ 8rbgPʂ̃f[^o͐ OutputStream ɏo͂A 
     * o͐ OutputStream  flush() B<br>
     * ̃\bh͈kωȂB 
     * 
     * @exception IOException o̓G[ꍇ
     *
     * @see PostLzssEncoder#flush()
     * @see BitOutputStream#flush()
     */
    public void flush() throws IOException {
        this.out.flush();                                                       //throws IOException
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.out.close();                                                       //throws IOException

        this.out = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS patameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lzs-` LZSS̃TCY𓾂B
     * 
     * @return -lzs-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PostLzsEncoder.DictionarySize;
    }

    /**
     * -lzs-` LZSS̍őv𓾂B
     * 
     * @return -lzs-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PostLzsEncoder.MaxMatch;
    }

    /**
     * -lzs-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lzs-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PostLzsEncoder.Threshold;
    }

}
//end of PostLzsEncoder.java
