/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.Instrumentation.CollocatedObserver;
import com.zeroc.Ice.Instrumentation.InvocationObserver;
import com.zeroc.Ice.Instrumentation.RemoteObserver;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.IceInternal.CollocatedObserverI;
import com.zeroc.IceInternal.CommunicatorObserverI;
import com.zeroc.IceInternal.RemoteObserverI;
import com.zeroc.IceMX.CollocatedMetrics;
import com.zeroc.IceMX.InvocationMetrics;
import com.zeroc.IceMX.MetricsHelper;
import com.zeroc.IceMX.Observer;
import com.zeroc.IceMX.ObserverWithDelegate;
import com.zeroc.IceMX.RemoteMetrics;

public class InvocationObserverI
extends ObserverWithDelegate<InvocationMetrics, InvocationObserver>
implements InvocationObserver {
    final Observer.MetricsUpdate<InvocationMetrics> _incrementRetry = new Observer.MetricsUpdate<InvocationMetrics>(){

        @Override
        public void update(InvocationMetrics v) {
            ++v.retry;
        }
    };
    final Observer.MetricsUpdate<InvocationMetrics> _userException = new Observer.MetricsUpdate<InvocationMetrics>(){

        @Override
        public void update(InvocationMetrics v) {
            ++v.userException;
        }
    };

    @Override
    public void userException() {
        this.forEach(this._userException);
        if (this._delegate != null) {
            ((InvocationObserver)this._delegate).userException();
        }
    }

    @Override
    public void retried() {
        this.forEach(this._incrementRetry);
        if (this._delegate != null) {
            ((InvocationObserver)this._delegate).retried();
        }
    }

    @Override
    public RemoteObserver getRemoteObserver(ConnectionInfo con, Endpoint edpt, int requestId, int sz) {
        RemoteObserver delegate = null;
        if (this._delegate != null) {
            delegate = ((InvocationObserver)this._delegate).getRemoteObserver(con, edpt, requestId, sz);
        }
        return this.getObserver("Remote", new RemoteInvocationHelper(con, edpt, requestId, sz), RemoteMetrics.class, RemoteObserverI.class, delegate);
    }

    @Override
    public CollocatedObserver getCollocatedObserver(ObjectAdapter adapter, int requestId, int sz) {
        CollocatedObserver delegate = null;
        if (this._delegate != null) {
            delegate = ((InvocationObserver)this._delegate).getCollocatedObserver(adapter, requestId, sz);
        }
        return this.getObserver("Collocated", new CollocatedInvocationHelper(adapter, requestId, sz), CollocatedMetrics.class, CollocatedObserverI.class, delegate);
    }

    public static final class CollocatedInvocationHelper
    extends MetricsHelper<CollocatedMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<CollocatedInvocationHelper> cl = CollocatedInvocationHelper.class;
                        this.add("parent", cl.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", cl.getDeclaredMethod("getId", new Class[0]));
                        this.add("requestId", cl.getDeclaredMethod("getRequestId", new Class[0]));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final int _requestId;
        private final int _size;
        private final String _id;

        CollocatedInvocationHelper(ObjectAdapter adapter, int requestId, int size) {
            super(_attributes);
            this._id = adapter.getName();
            this._requestId = requestId;
            this._size = size;
        }

        @Override
        public void initMetrics(CollocatedMetrics v) {
            v.size += (long)this._size;
        }

        public String getId() {
            return this._id;
        }

        public String getParent() {
            return "Communicator";
        }
    }

    public static final class RemoteInvocationHelper
    extends MetricsHelper<RemoteMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<RemoteInvocationHelper> cl = RemoteInvocationHelper.class;
                        this.add("parent", cl.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", cl.getDeclaredMethod("getId", new Class[0]));
                        this.add("requestId", cl.getDeclaredMethod("getRequestId", new Class[0]));
                        CommunicatorObserverI.addConnectionAttributes(this, RemoteInvocationHelper.class);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final ConnectionInfo _connectionInfo;
        private final Endpoint _endpoint;
        private final int _requestId;
        private final int _size;
        private String _id;
        private EndpointInfo _endpointInfo;

        RemoteInvocationHelper(ConnectionInfo con, Endpoint endpt, int requestId, int size) {
            super(_attributes);
            this._connectionInfo = con;
            this._endpoint = endpt;
            this._requestId = requestId;
            this._size = size;
        }

        @Override
        public void initMetrics(RemoteMetrics v) {
            v.size += (long)this._size;
        }

        public String getId() {
            if (this._id == null) {
                this._id = this._endpoint.toString();
                if (this._connectionInfo.connectionId != null && !this._connectionInfo.connectionId.isEmpty()) {
                    this._id = this._id + " [" + this._connectionInfo.connectionId + "]";
                }
            }
            return this._id;
        }

        public String getParent() {
            if (this._connectionInfo.adapterName != null && !this._connectionInfo.adapterName.isEmpty()) {
                return this._connectionInfo.adapterName;
            }
            return "Communicator";
        }

        public ConnectionInfo getConnectionInfo() {
            return this._connectionInfo;
        }

        public Endpoint getEndpoint() {
            return this._endpoint;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._endpointInfo == null) {
                this._endpointInfo = this._endpoint.getInfo();
            }
            return this._endpointInfo;
        }
    }
}

