/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGridGUI.LiveDeployment.Adapter;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.TableField;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class AdapterEditor
extends Editor {
    private JTextField _currentStatus = new JTextField(20);
    private JTextField _currentEndpoints = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private JTextField _id = new JTextField(20);
    private JTextField _replicaGroupId = new JTextField(20);
    private JTextField _priority = new JTextField(20);
    private JTextField _endpoints = new JTextField(20);
    private JTextField _publishedEndpoints = new JTextField(20);
    private JCheckBox _registerProcess = new JCheckBox("Register Process");
    private JCheckBox _serverLifetime = new JCheckBox("Server Lifetime");
    private TableField _objects = new TableField("Identity", "Type");
    private TableField _allocatables = new TableField("Identity", "Type");

    AdapterEditor() {
        this._currentStatus.setEditable(false);
        this._currentEndpoints.setEditable(false);
        this._description.setEditable(false);
        this._description.setOpaque(false);
        this._id.setEditable(false);
        this._replicaGroupId.setEditable(false);
        this._priority.setEditable(false);
        this._endpoints.setEditable(false);
        this._publishedEndpoints.setEditable(false);
        this._registerProcess.setEnabled(false);
        this._serverLifetime.setEnabled(false);
    }

    void show(Adapter adapter) {
        AdapterDescriptor descriptor = adapter.getDescriptor();
        Utils.Resolver resolver = adapter.getResolver();
        this._id.setText(resolver.substitute(descriptor.id));
        String currentEndpoints = adapter.getCurrentEndpoints();
        if (currentEndpoints == null) {
            this._currentStatus.setText("Inactive");
            this._currentEndpoints.setText("");
        } else {
            this._currentStatus.setText("Active");
            this._currentEndpoints.setText(currentEndpoints);
        }
        this._description.setText(resolver.substitute(descriptor.description));
        this._replicaGroupId.setText(resolver.substitute(descriptor.replicaGroupId));
        this._priority.setText(resolver.substitute(descriptor.priority));
        Map<String, String> properties = adapter.getProperties();
        this._endpoints.setText(resolver.substitute(properties.get(adapter.getId() + ".Endpoints")));
        this._publishedEndpoints.setText(resolver.substitute(properties.get(adapter.getId() + ".PublishedEndpoints")));
        this._registerProcess.setSelected(descriptor.registerProcess);
        this._serverLifetime.setSelected(descriptor.serverLifetime);
        this._objects.setObjects(descriptor.objects, resolver);
        this._allocatables.setObjects(descriptor.allocatables, resolver);
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.appendSeparator("Runtime Status");
        builder.append("Status");
        builder.append((Component)this._currentStatus, 3);
        builder.nextLine();
        builder.append("Published Endpoints");
        builder.append((Component)this._currentEndpoints, 3);
        builder.nextLine();
        builder.appendSeparator("Configuration");
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Adapter ID");
        builder.append((Component)this._id, 3);
        builder.nextLine();
        builder.append("Replica Group");
        builder.append((Component)this._replicaGroupId, 3);
        builder.nextLine();
        builder.append("Priority");
        builder.append((Component)this._priority, 3);
        builder.nextLine();
        builder.append("Endpoints");
        builder.append((Component)this._endpoints, 3);
        builder.nextLine();
        builder.append("Published Endpoints");
        builder.append((Component)this._publishedEndpoints, 3);
        builder.nextLine();
        builder.append("", (Component)this._registerProcess);
        builder.nextLine();
        builder.append("", (Component)this._serverLifetime);
        builder.nextLine();
        builder.append("Well-known Objects");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._objects);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Allocatable Objects");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._allocatables);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Adapter Properties");
    }
}

