/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.httputils;

import java.util.ArrayList;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.httputils.HtmlContext;

@Deprecated
public class HtmlContextAnalyser {
    private char[] quotes = new char[]{'\'', '\"'};
    private String[] scriptAttributes = new String[]{"onBlur", "onChange", "onClick", "onDblClick", "onFocus", "onKeydown", "onKeyup", "onKeypress", "onLoad", "onMousedown", "onMouseup", "onMouseover", "onMousemove", "onMouseout", "onReset", "onSelect", "onSubmit", "onUnload"};
    private String[] urlAttributes = new String[]{"action", "background", "cite", "classid", "codebase", "data", "formaction", "href", "icon", "longdesc", "manifest", "poster", "profile", "src", "usemap"};
    private String[] tagsWithSrcAttributes = new String[]{"frame", "iframe", "img", "input", "script", "src"};
    private HttpMessage msg = null;
    private String htmlPage = null;
    private Source src = null;

    public HtmlContextAnalyser(HttpMessage msg) {
        this.msg = msg;
        this.htmlPage = msg.getResponseBody().toString();
        this.src = new Source((CharSequence)this.htmlPage);
        this.src.fullSequentialParse();
    }

    private boolean isQuote(char chr) {
        for (int i = 0; i < this.quotes.length; ++i) {
            if (chr != this.quotes[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isScriptAttribute(String att) {
        for (int i = 0; i < this.scriptAttributes.length; ++i) {
            if (!att.equalsIgnoreCase(this.scriptAttributes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUrlAttribute(String att) {
        for (int i = 0; i < this.urlAttributes.length; ++i) {
            if (!att.equalsIgnoreCase(this.urlAttributes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isInTagWithSrcAttribute(String tag) {
        for (int i = 0; i < this.tagsWithSrcAttributes.length; ++i) {
            if (!tag.equalsIgnoreCase(this.tagsWithSrcAttributes[i])) continue;
            return true;
        }
        return false;
    }

    public List<HtmlContext> getHtmlContexts(String target) {
        return this.getHtmlContexts(target, null, 0);
    }

    public List<HtmlContext> getHtmlContexts(String target, HtmlContext targetContext, int ignoreFlags) {
        ArrayList<HtmlContext> contexts = new ArrayList<HtmlContext>();
        int offset = 0;
        while ((offset = this.htmlPage.indexOf(target, offset)) >= 0) {
            Element element;
            String prefix;
            char chr;
            int i;
            HtmlContext context = new HtmlContext(this.msg, target, offset, offset + target.length());
            offset += target.length();
            char leftQuote = '\u0000';
            for (i = context.getStart() - 1; i > 0; --i) {
                chr = this.htmlPage.charAt(i);
                if (this.isQuote(chr)) {
                    leftQuote = chr;
                    break;
                }
                if (chr == '>') break;
            }
            if (leftQuote != '\u0000') {
                for (i = context.getEnd(); i < this.htmlPage.length(); ++i) {
                    chr = this.htmlPage.charAt(i);
                    if (leftQuote == chr) {
                        context.setSurroundingQuote("" + leftQuote);
                        break;
                    }
                    if (this.isQuote(chr) || chr == '<') break;
                }
            }
            if ((prefix = this.htmlPage.substring(0, context.getStart())).lastIndexOf("<!--") > prefix.lastIndexOf(">")) {
                context.setHtmlComment(true);
            }
            if ((element = this.src.getEnclosingElement(context.getStart())) != null) {
                boolean isInputTag = element.getName().equalsIgnoreCase("input");
                boolean isImageInputTag = false;
                for (Attribute att : element.getAttributes()) {
                    if (att.getValue() != null && att.getValue().toLowerCase().indexOf(target.toLowerCase()) >= 0) {
                        context.setTagAttribute(att.getName());
                        context.setInUrlAttribute(this.isUrlAttribute(att.getName()));
                        context.setInScriptAttribute(this.isScriptAttribute(att.getName()));
                    }
                    if (!isInputTag || !att.getName().equalsIgnoreCase("type") || !"image".equalsIgnoreCase(att.getValue())) continue;
                    isImageInputTag = true;
                }
                context.addParentTag(element.getName());
                if (!isInputTag || isImageInputTag) {
                    context.setInTagWithSrc(this.isInTagWithSrcAttribute(element.getName()));
                }
                while ((element = element.getParentElement()) != null) {
                    context.addParentTag(element.getName());
                }
            }
            if (targetContext == null) {
                contexts.add(context);
                continue;
            }
            if (!targetContext.matches(context, ignoreFlags)) continue;
            contexts.add(context);
        }
        return contexts;
    }
}

