/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.utils.XMLStringUtil;

public final class ApiResponseConversionUtils {
    private static final Logger LOGGER = LogManager.getLogger(ApiResponseConversionUtils.class);

    private ApiResponseConversionUtils() {
    }

    public static ApiResponseSet<String> httpMessageToSet(int historyId, HttpMessage msg) {
        return ApiResponseConversionUtils.httpMessageToSet(historyId, -1, msg);
    }

    public static ApiResponseSet<String> httpMessageToSet(int historyId, int historyType, HttpMessage msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", String.valueOf(historyId));
        map.put("type", String.valueOf(historyType));
        map.put("timestamp", String.valueOf(msg.getTimeSentMillis()));
        map.put("rtt", String.valueOf(msg.getTimeElapsedMillis()));
        map.put("cookieParams", msg.getCookieParamsAsString());
        map.put("note", msg.getNote());
        map.put("requestHeader", msg.getRequestHeader().toString());
        map.put("requestBody", msg.getRequestBody().toString());
        map.put("responseHeader", msg.getResponseHeader().toString());
        map.put("responseBody", msg.getResponseBody().toString());
        List<String> tags = Collections.emptyList();
        try {
            tags = HistoryReference.getTags(historyId);
        }
        catch (DatabaseException e) {
            LOGGER.warn("Failed to obtain the tags for message with ID {}", (Object)historyId, (Object)e);
        }
        return new HttpMessageResponseSet(map, tags);
    }

    private static class HttpMessageResponseSet
    extends ApiResponseSet<String> {
        private final List<String> tags;

        public HttpMessageResponseSet(Map<String, String> map, List<String> tags) {
            super("message", map);
            this.tags = tags;
        }

        @Override
        public JSON toJSON() {
            JSONObject jo = (JSONObject)super.toJSON();
            JSONArray array = new JSONArray();
            array.addAll(this.tags);
            jo.put((Object)"tags", (Object)array);
            return jo;
        }

        @Override
        public void toXML(Document doc, Element parent) {
            super.toXML(doc, parent);
            Element elTags = doc.createElement("tags");
            parent.appendChild(elTags);
            for (String tag : this.tags) {
                Element el = doc.createElement("tag");
                el.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs(tag)));
                elTags.appendChild(el);
            }
        }

        @Override
        public void toHTML(StringBuilder sb) {
            sb.append("<h2>" + StringEscapeUtils.escapeHtml4((String)this.getName()) + "</h2>\n");
            sb.append("<table border=\"1\">\n");
            for (Map.Entry entry : this.getValues().entrySet()) {
                HttpMessageResponseSet.appendRow(sb, entry.getKey(), (String)entry.getValue());
                sb.append("</td></tr>\n");
            }
            HttpMessageResponseSet.appendRow(sb, "tags", HttpMessageResponseSet.tagsToString(this.tags));
            sb.append("</table>\n");
        }

        private static void appendRow(StringBuilder sb, String cell1, String cell2) {
            sb.append("<tr><td>\n");
            sb.append(cell1);
            sb.append("</td><td>\n");
            if (cell2 != null) {
                sb.append(StringEscapeUtils.escapeHtml4((String)cell2));
            }
            sb.append("</td></tr>\n");
        }

        private static String tagsToString(List<String> tags) {
            if (tags == null || tags.isEmpty()) {
                return "";
            }
            if (tags.size() == 1) {
                return tags.get(0);
            }
            StringBuilder strBuilder = new StringBuilder();
            for (String tag : tags) {
                if (strBuilder.length() > 0) {
                    strBuilder.append(", ");
                }
                strBuilder.append(tag);
            }
            return strBuilder.toString();
        }
    }
}

