/* Generated by wayland-scanner 1.24.0 */

#ifndef INPUT_METHOD_EXPERIMENTAL_V2_ENUM_PROTOCOL_H
#define INPUT_METHOD_EXPERIMENTAL_V2_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef XX_INPUT_METHOD_V1_ERROR_ENUM
#define XX_INPUT_METHOD_V1_ERROR_ENUM
enum xx_input_method_v1_error {
	/**
	 * surface already has a role
	 */
	XX_INPUT_METHOD_V1_ERROR_SURFACE_HAS_ROLE = 0x0,
	/**
	 * operation requires the input method to be active
	 */
	XX_INPUT_METHOD_V1_ERROR_INACTIVE = 0x1,
};
#endif /* XX_INPUT_METHOD_V1_ERROR_ENUM */

#ifndef XX_INPUT_POPUP_SURFACE_V2_ERROR_ENUM
#define XX_INPUT_POPUP_SURFACE_V2_ERROR_ENUM
enum xx_input_popup_surface_v2_error {
	/**
	 * received acknowledgement for a serial which has already been acknowledged or has never been issued
	 */
	XX_INPUT_POPUP_SURFACE_V2_ERROR_INVALID_SERIAL = 0,
};
#endif /* XX_INPUT_POPUP_SURFACE_V2_ERROR_ENUM */

#ifndef XX_INPUT_POPUP_POSITIONER_V1_ERROR_ENUM
#define XX_INPUT_POPUP_POSITIONER_V1_ERROR_ENUM
enum xx_input_popup_positioner_v1_error {
	/**
	 * invalid input provided
	 */
	XX_INPUT_POPUP_POSITIONER_V1_ERROR_INVALID_INPUT = 0,
};
#endif /* XX_INPUT_POPUP_POSITIONER_V1_ERROR_ENUM */

#ifndef XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_ENUM
#define XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_ENUM
enum xx_input_popup_positioner_v1_anchor {
	/**
	 * no edge, specfies center
	 */
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_NONE = 0,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_TOP = 1,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_BOTTOM = 2,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_LEFT = 3,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_RIGHT = 4,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_TOP_LEFT = 5,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_BOTTOM_LEFT = 6,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_TOP_RIGHT = 7,
	XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_BOTTOM_RIGHT = 8,
};
#endif /* XX_INPUT_POPUP_POSITIONER_V1_ANCHOR_ENUM */

#ifndef XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_ENUM
#define XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_ENUM
enum xx_input_popup_positioner_v1_gravity {
	/**
	 * center to center
	 */
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_NONE = 0,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_TOP = 1,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_BOTTOM = 2,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_LEFT = 3,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_RIGHT = 4,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_TOP_LEFT = 5,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_BOTTOM_LEFT = 6,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_TOP_RIGHT = 7,
	XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_BOTTOM_RIGHT = 8,
};
#endif /* XX_INPUT_POPUP_POSITIONER_V1_GRAVITY_ENUM */

#ifndef XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_ENUM
#define XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_ENUM
/**
 * @ingroup iface_xx_input_popup_positioner_v1
 * constraint adjustments
 *
 * The constraint adjustment value define ways the compositor will adjust
 * the position of the surface, if the unadjusted position would result
 * in the surface being partly constrained.
 *
 * Whether a surface is considered 'constrained' is left to the compositor
 * to determine. For example, the surface may be partly outside the
 * compositor's defined 'work area', thus necessitating the child surface's
 * position be adjusted until it is entirely inside the work area.
 *
 * The adjustments can be combined, according to a defined precedence: 1)
 * Flip, 2) Slide, 3) Resize.
 */
enum xx_input_popup_positioner_v1_constraint_adjustment {
	/**
	 * don't move the surface when constrained
	 *
	 * Don't alter the surface position even if it is constrained on
	 * some axis, for example partially outside the edge of an output.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_NONE = 0,
	/**
	 * move along the x axis until unconstrained
	 *
	 * Slide the surface along the x axis until it is no longer
	 * constrained.
	 *
	 * First try to slide towards the direction of the gravity on the x
	 * axis until either the edge in the opposite direction of the
	 * gravity is unconstrained or the edge in the direction of the
	 * gravity is constrained.
	 *
	 * Then try to slide towards the opposite direction of the gravity
	 * on the x axis until either the edge in the direction of the
	 * gravity is unconstrained or the edge in the opposite direction
	 * of the gravity is constrained.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_SLIDE_X = 1,
	/**
	 * move along the y axis until unconstrained
	 *
	 * Slide the surface along the y axis until it is no longer
	 * constrained.
	 *
	 * First try to slide towards the direction of the gravity on the y
	 * axis until either the edge in the opposite direction of the
	 * gravity is unconstrained or the edge in the direction of the
	 * gravity is constrained.
	 *
	 * Then try to slide towards the opposite direction of the gravity
	 * on the y axis until either the edge in the direction of the
	 * gravity is unconstrained or the edge in the opposite direction
	 * of the gravity is constrained.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_SLIDE_Y = 2,
	/**
	 * invert the anchor and gravity on the x axis
	 *
	 * Invert the anchor and gravity on the x axis if the surface is
	 * constrained on the x axis. For example, if the left edge of the
	 * surface is constrained, the gravity is 'left' and the anchor is
	 * 'left', change the gravity to 'right' and the anchor to 'right'.
	 *
	 * If the adjusted position also ends up being constrained, the
	 * resulting position of the flip_x adjustment will be the one
	 * before the adjustment.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_FLIP_X = 4,
	/**
	 * invert the anchor and gravity on the y axis
	 *
	 * Invert the anchor and gravity on the y axis if the surface is
	 * constrained on the y axis. For example, if the bottom edge of
	 * the surface is constrained, the gravity is 'bottom' and the
	 * anchor is 'bottom', change the gravity to 'top' and the anchor
	 * to 'top'.
	 *
	 * The adjusted position is calculated given the original anchor
	 * rectangle and offset, but with the new flipped anchor and
	 * gravity values.
	 *
	 * If the adjusted position also ends up being constrained, the
	 * resulting position of the flip_y adjustment will be the one
	 * before the adjustment.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_FLIP_Y = 8,
	/**
	 * horizontally resize the surface
	 *
	 * Resize the surface horizontally so that it is completely
	 * unconstrained.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_RESIZE_X = 16,
	/**
	 * vertically resize the surface
	 *
	 * Resize the surface vertically so that it is completely
	 * unconstrained.
	 */
	XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_RESIZE_Y = 32,
};
#endif /* XX_INPUT_POPUP_POSITIONER_V1_CONSTRAINT_ADJUSTMENT_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
