/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconManager {
    private static IconManager instance;
    private final Content errorIconContent = new ResourceURLContent(IconManager.class, "resources/error.png");
    private final Content waitIconContent = new ResourceURLContent(IconManager.class, "resources/wait.png");
    private final Map<Content, Map<Integer, Icon>> icons = Collections.synchronizedMap(new WeakHashMap());
    private ExecutorService iconsLoader;

    private IconManager() {
    }

    public static IconManager getInstance() {
        if (instance == null) {
            instance = new IconManager();
        }
        return instance;
    }

    public void clear() {
        if (this.iconsLoader != null) {
            this.iconsLoader.shutdownNow();
            this.iconsLoader = null;
        }
        this.icons.clear();
    }

    public Icon getErrorIcon(int n) {
        return this.getIcon(this.errorIconContent, n, null);
    }

    public Icon getErrorIcon() {
        return this.getIcon(this.errorIconContent, -1, null);
    }

    public boolean isErrorIcon(Icon icon) {
        Map<Integer, Icon> map = this.icons.get(this.errorIconContent);
        return map != null && (map.containsValue(icon) || icon instanceof IconProxy && map.containsValue(((IconProxy)icon).getIcon()));
    }

    public Icon getWaitIcon(int n) {
        return this.getIcon(this.waitIconContent, n, null);
    }

    public Icon getWaitIcon() {
        return this.getIcon(this.waitIconContent, -1, null);
    }

    public boolean isWaitIcon(Icon icon) {
        Map<Integer, Icon> map = this.icons.get(this.waitIconContent);
        return map != null && (map.containsValue(icon) || icon instanceof IconProxy && map.containsValue(((IconProxy)icon).getIcon()));
    }

    public Icon getIcon(Content content, Component component) {
        return this.getIcon(content, -1, component);
    }

    public Icon getIcon(Content content, final int n, Component component) {
        Icon icon;
        Map<Integer, Icon> map = this.icons.get(content);
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.icons.put(content, map);
        }
        if ((icon = map.get(n)) == null) {
            icon = content == null ? new Icon(){
                final /* synthetic */ IconManager this$0;
                {
                    this.this$0 = iconManager;
                }

                @Override
                public void paintIcon(Component component, Graphics graphics, int n3, int n2) {
                }

                @Override
                public int getIconWidth() {
                    return Math.max(0, n);
                }

                @Override
                public int getIconHeight() {
                    return Math.max(0, n);
                }
            } : (content == this.errorIconContent || content == this.waitIconContent ? this.createIcon(content, n, null) : (component == null ? this.createIcon(content, n, this.getIcon(this.errorIconContent, n, null)) : new IconProxy(content, n, component, this.getIcon(this.errorIconContent, n, null), this.getIcon(this.waitIconContent, n, null))));
            map.put(n, icon);
        }
        return icon;
    }

    private Icon createIcon(Content content, int n, Icon icon) {
        try {
            InputStream inputStream = content.openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            if (bufferedImage != null) {
                if (n != -1 && n != bufferedImage.getHeight()) {
                    int n2 = bufferedImage.getWidth() * n / bufferedImage.getHeight();
                    BufferedImage bufferedImage2 = new BufferedImage(n2, n, 2);
                    Graphics graphics = bufferedImage2.getGraphics();
                    graphics.drawImage(bufferedImage.getScaledInstance(n2, n, 4), 0, 0, null);
                    graphics.dispose();
                    return new ImageIcon(bufferedImage2);
                }
                return new ImageIcon(bufferedImage);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return icon;
    }

    private class IconProxy
    implements Icon {
        private Icon icon;

        public IconProxy(final Content content, final int n, final Component component, final Icon icon, Icon icon2) {
            this.icon = icon2;
            if (IconManager.this.iconsLoader == null) {
                IconManager.this.iconsLoader = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
            }
            IconManager.this.iconsLoader.execute(new Runnable(){
                final /* synthetic */ IconProxy this$1;
                {
                    this.this$1 = iconProxy;
                }

                @Override
                public void run() {
                    this.this$1.icon = this.this$1.IconManager.this.createIcon(content, n, icon);
                    component.repaint();
                }
            });
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

