/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.wbxml;

import java.util.List;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.MutableAttributes;

public class AttributesImpl
implements MutableAttributes {
    private static final int MAX = 64;
    private int nIdx = 0;
    private int[] type = new int[64];
    private int[] idx = new int[64];
    private int[] tags = new int[64];
    private int nObject;
    private List[] listValue = new List[64];
    private int nDoubleValue;
    private int nLongValue;
    private int nStringValue;
    private long[] longValue = new long[64];
    private double[] doubleValue = new double[64];
    private String[] stringValue = new String[64];
    private int nObjectArray;
    private Object[] objectArray = new Object[64];

    public AttributesImpl() {
    }

    public AttributesImpl(Attributes atts) {
        this();
        int[] tags = atts.getTags();
        block11: for (int i = 0; i < tags.length; ++i) {
            int tag = tags[i];
            int type = atts.getType(tag);
            switch (type) {
                case 1: {
                    this.set(tag, atts.getByteValue(tag));
                    continue block11;
                }
                case 0: {
                    this.set(tag, atts.getBooleanValue(tag));
                    continue block11;
                }
                case 2: {
                    this.set(tag, atts.getCharValue(tag));
                    continue block11;
                }
                case 3: {
                    this.set(tag, atts.getDoubleValue(tag));
                    continue block11;
                }
                case 4: {
                    this.set(tag, atts.getFloatValue(tag));
                    continue block11;
                }
                case 5: {
                    this.set(tag, atts.getIntValue(tag));
                    continue block11;
                }
                case 6: {
                    this.set(tag, atts.getLongValue(tag));
                    continue block11;
                }
                case 7: {
                    this.set(tag, atts.getShortValue(tag));
                    continue block11;
                }
                case 8: {
                    this.set(tag, atts.getStringValue(tag));
                    continue block11;
                }
                default: {
                    throw new RuntimeException("Copy of Attributes for type: " + type + " of tag: " + tag + " not handled.");
                }
            }
        }
    }

    public void clear() {
        this.nIdx = 0;
        this.nObject = 0;
        this.nDoubleValue = 0;
        this.nLongValue = 0;
        this.nStringValue = 0;
        this.nObjectArray = 0;
    }

    public void set(int tag, boolean value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 0;
            this.idx[index] = this.nLongValue++;
        } else if (this.type[index] != 0) {
            throw new NumberFormatException();
        }
        this.longValue[this.idx[index]] = value ? 1L : 0L;
    }

    public void set(int tag, boolean[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 16;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 16) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, byte value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 1;
            this.idx[index] = this.nLongValue++;
        } else if (this.type[index] != 1) {
            throw new NumberFormatException();
        }
        this.longValue[this.idx[index]] = value;
    }

    public void set(int tag, byte[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 17;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 17) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, char value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 2;
            this.idx[index] = this.nLongValue++;
        } else if (this.type[index] != 2) {
            throw new NumberFormatException();
        }
        this.longValue[this.idx[index]] = value;
    }

    public void set(int tag, char[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 18;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 18) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, double value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 3;
            this.idx[index] = this.nDoubleValue++;
        } else if (this.type[index] != 3) {
            throw new NumberFormatException();
        }
        this.doubleValue[this.idx[index]] = value;
    }

    public void set(int tag, double[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 19;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 19) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, float value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 4;
            this.idx[index] = this.nDoubleValue++;
        } else if (this.type[index] != 4) {
            throw new NumberFormatException();
        }
        this.doubleValue[this.idx[index]] = value;
    }

    public void set(int tag, float[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 20;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 20) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, int value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 5;
            this.idx[index] = this.nLongValue++;
        } else if (this.type[index] != 5) {
            throw new NumberFormatException();
        }
        this.longValue[this.idx[index]] = value;
    }

    public void set(int tag, int[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 21;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 21) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, long value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 6;
            this.idx[index] = this.nLongValue++;
        } else if (this.type[index] != 6) {
            throw new NumberFormatException();
        }
        this.longValue[this.idx[index]] = value;
    }

    public void set(int tag, long[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 22;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 22) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, short value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 7;
            this.idx[index] = this.nLongValue++;
        } else if (this.type[index] != 7) {
            throw new NumberFormatException();
        }
        this.longValue[this.idx[index]] = value;
    }

    public void set(int tag, short[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 23;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 23) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, String value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 8;
            this.idx[index] = this.nStringValue++;
        } else if (this.type[index] != 8) {
            throw new NumberFormatException("Found String while expecting: " + this.getTypeName(this.type[index]));
        }
        this.stringValue[this.idx[index]] = value;
    }

    public void set(int tag, String[] array) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 24;
            this.idx[index] = this.nObjectArray++;
        } else if (this.type[index] != 24) {
            throw new NumberFormatException();
        }
        this.objectArray[this.idx[index]] = array;
    }

    public void set(int tag, List value) {
        int index = this.getIndex(tag);
        if (index < 0) {
            index = this.nIdx++;
            this.tags[index] = tag;
            this.type[index] = 9;
            this.idx[index] = this.nObject;
            ++this.nStringValue;
        } else if (this.type[index] != 9) {
            throw new NumberFormatException();
        }
        this.listValue[this.idx[index]] = value;
    }

    private int getIndex(int tag) {
        for (int i = 0; i < this.nIdx; ++i) {
            if (tag != this.tags[i]) continue;
            return i;
        }
        return -1;
    }

    public int getType(int tag) {
        int index = this.getIndex(tag);
        return index < 0 ? -1 : this.type[index];
    }

    public int[] getTags() {
        int[] result = new int[this.nIdx];
        System.arraycopy(this.tags, 0, result, 0, result.length);
        return result;
    }

    public boolean getBooleanValue(int tag, boolean def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 0 ? this.longValue[this.idx[index]] != 0L : def);
    }

    public boolean getBooleanValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 0) {
            throw new NumberFormatException();
        }
        return this.longValue[this.idx[index]] != 0L;
    }

    public boolean[] getBooleanArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 16) {
            throw new NumberFormatException();
        }
        return (boolean[])this.objectArray[this.idx[index]];
    }

    public byte getByteValue(int tag, byte def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 1 ? (byte)this.longValue[this.idx[index]] : def);
    }

    public byte getByteValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 1) {
            throw new NumberFormatException();
        }
        return (byte)this.longValue[this.idx[index]];
    }

    public byte[] getByteArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 17) {
            throw new NumberFormatException();
        }
        return (byte[])this.objectArray[this.idx[index]];
    }

    public char getCharValue(int tag, char def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 2 ? (char)this.longValue[this.idx[index]] : def);
    }

    public char getCharValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 2) {
            throw new NumberFormatException();
        }
        return (char)this.longValue[this.idx[index]];
    }

    public char[] getCharArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 18) {
            throw new NumberFormatException();
        }
        return (char[])this.objectArray[this.idx[index]];
    }

    public double getDoubleValue(int tag, double def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 3 ? this.doubleValue[this.idx[index]] : def);
    }

    public double getDoubleValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 3) {
            throw new NumberFormatException();
        }
        return this.doubleValue[this.idx[index]];
    }

    public double[] getDoubleArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 19) {
            throw new NumberFormatException();
        }
        return (double[])this.objectArray[this.idx[index]];
    }

    public float getFloatValue(int tag, float def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 4 ? (float)this.doubleValue[this.idx[index]] : def);
    }

    public float getFloatValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 4) {
            throw new NumberFormatException();
        }
        return (float)this.doubleValue[this.idx[index]];
    }

    public float[] getFloatArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 20) {
            throw new NumberFormatException();
        }
        return (float[])this.objectArray[this.idx[index]];
    }

    public int getIntValue(int tag, int def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 5 ? (int)this.longValue[this.idx[index]] : def);
    }

    public int getIntValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 5) {
            throw new NumberFormatException();
        }
        return (int)this.longValue[this.idx[index]];
    }

    public int[] getIntArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 21) {
            throw new NumberFormatException();
        }
        return (int[])this.objectArray[this.idx[index]];
    }

    public long getLongValue(int tag, long def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 6 ? this.longValue[this.idx[index]] : def);
    }

    public long getLongValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 6) {
            throw new NumberFormatException();
        }
        return this.longValue[this.idx[index]];
    }

    public long[] getLongArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 22) {
            throw new NumberFormatException();
        }
        return (long[])this.objectArray[this.idx[index]];
    }

    public short getShortValue(int tag, short def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 7 ? (short)this.longValue[this.idx[index]] : def);
    }

    public short getShortValue(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 7) {
            throw new NumberFormatException();
        }
        return (short)this.longValue[this.idx[index]];
    }

    public short[] getShortArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 23) {
            throw new NumberFormatException();
        }
        return (short[])this.objectArray[this.idx[index]];
    }

    public String getStringValue(int tag, String def) {
        int index = this.getIndex(tag);
        return index < 0 ? def : (this.type[index] == 8 ? this.stringValue[this.idx[index]] : def);
    }

    public String getStringValue(int tag) {
        int index = this.getIndex(tag);
        if (index < 0) {
            return null;
        }
        if (this.type[index] != 8) {
            throw new NumberFormatException();
        }
        return this.stringValue[this.idx[index]];
    }

    public String[] getStringArray(int tag) {
        int index = this.getIndex(tag);
        if (this.type[index] != 24) {
            throw new NumberFormatException();
        }
        return (String[])this.objectArray[this.idx[index]];
    }

    private String getTypeName(int type) {
        switch (type) {
            case 0: {
                return "boolean";
            }
            case 1: {
                return "byte";
            }
            case 2: {
                return "char";
            }
            case 10: {
                return "Color";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "long";
            }
            case 9: {
                return "Object";
            }
            case 7: {
                return "short";
            }
            case 8: {
                return "String";
            }
        }
        return "Unknown";
    }
}

