\name{NormalizedCorrelationImageFilter}
\alias{NormalizedCorrelationImageFilter}
\title{NormalizedCorrelationImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the normalized correlation of an image and a template.
NormalizedCorrelationImageFilter}
\details{
This filter calculates the normalized correlation between an image and
the template. Normalized correlation is frequently use in feature
detection because it is invariant to local changes in contrast.
The filter can be given a mask. When presented with an input image and
a mask, the normalized correlation is only calculated at those pixels
under the mask.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
NormalizedCorrelation for the procedural interface
itk::NormalizedCorrelationImageFilter for the Doxygen on the original ITK class.
NormalizedCorrelationImageFilter}
%C++ includes: sitkNormalizedCorrelationImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &maskImage, const Image &templateImage):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ NormalizedCorrelationImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NormalizedCorrelationImageFilter():}{
Destructor
}
}
}
