/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.interpreter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.PathUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.interpreter.UseDetectedInterpreterFix;
import com.jetbrains.python.inspections.interpreter.UseExistingInterpreterFix;
import com.jetbrains.python.inspections.interpreter.UseProvidedInterpreterFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.configuration.CreateSdkInfo;
import com.jetbrains.python.sdk.configuration.CreateSdkInfoWithTool;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0002\u0010\b\u001a\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a0\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a0\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"NAME", "Ljava/util/regex/Pattern;", "getSuitableSdkFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "name", "", "module", "Lcom/intellij/openapi/module/Module;", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExistingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "detectAssociatedViaRootNameEnv", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "associatedName", "existingSdks", "context", "Lcom/intellij/openapi/util/UserDataHolderBase;", "detectSystemWideSdk", "version", "findAssociatedViaRootNameEnv", "envs", "getVirtualEnvRootName", "sdk", "isFileIgnored", "", "pyFile", "Lcom/jetbrains/python/psi/PyFile;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyInterpreterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyInterpreterInspection.kt\ncom/jetbrains/python/inspections/interpreter/PyInterpreterInspectionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n3919#2:257\n4434#2,2:258\n295#3,2:260\n774#3:262\n865#3,2:263\n1761#3,3:266\n1#4:265\n*S KotlinDebug\n*F\n+ 1 PyInterpreterInspection.kt\ncom/jetbrains/python/inspections/interpreter/PyInterpreterInspectionKt\n*L\n157#1:257\n157#1:258,2\n168#1:260,2\n174#1:262\n174#1:263,2\n183#1:266,3\n*E\n"})
public final class PyInterpreterInspectionKt {
    @NotNull
    private static final Pattern NAME;

    private static final Object getSuitableSdkFix(String name2, Module module2, Continuation<? super LocalQuickFix> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LocalQuickFix>, Object>(module2, name2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int label;
            final /* synthetic */ Module $module;
            final /* synthetic */ String $name;
            {
                this.$module = $module;
                this.$name = $name;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block20: {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            existingSdks = PyInterpreterInspectionKt.access$getExistingSdks();
                            associatedSdk = PySdkExtKt.mostPreferred(PySdkExtKt.filterAssociatedSdks(this.$module, existingSdks));
                            if (associatedSdk != null) {
                                return new UseExistingInterpreterFix(associatedSdk, this.$module);
                            }
                            context = new UserDataHolderBase();
                            this.L$0 = existingSdks;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)associatedSdk);
                            this.L$2 = context;
                            this.label = 1;
                            v0 = PyProjectSdkConfigurationExtension.Companion.findAllSortedForModule(this.$module, (Continuation)this);
                            if (v0 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            context = (UserDataHolderBase)this.L$2;
                            associatedSdk = (Sdk)this.L$1;
                            existingSdks = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            if ((createSdkInfo = (CreateSdkInfoWithTool)CollectionsKt.firstOrNull((List)((List)v0))) != null) {
                                return new UseProvidedInterpreterFix(this.$module, createSdkInfo);
                            }
                            if (this.$name != null && (matcher = PyInterpreterInspectionKt.access$getNAME$p().matcher(this.$name)).matches()) {
                                venvName = matcher.group("name");
                                if (venvName != null) {
                                    detectedAssociatedViaRootNameEnv = PyInterpreterInspectionKt.access$detectAssociatedViaRootNameEnv(venvName, this.$module, existingSdks, context);
                                    if (detectedAssociatedViaRootNameEnv != null) {
                                        return new UseDetectedInterpreterFix(detectedAssociatedViaRootNameEnv, existingSdks, true, this.$module);
                                    }
                                } else {
                                    v1 = matcher.group("version");
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"group(...)");
                                    detectedSystemWideSdk = PyInterpreterInspectionKt.access$detectSystemWideSdk(v1, this.$module, existingSdks, context);
                                    if (detectedSystemWideSdk != null) {
                                        return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks, false, this.$module);
                                    }
                                }
                            }
                            if (PyCondaSdkCustomizer.Companion.getInstance().getSuggestSharedCondaEnvironments() && (sharedCondaEnv = PySdkExtKt.mostPreferred(PySdkExtKt.filterSharedCondaEnvs(this.$module, existingSdks))) != null) {
                                return new UseExistingInterpreterFix(sharedCondaEnv, this.$module);
                            }
                            systemWideSdk = PySdkExtKt.mostPreferred(PySdkExtKt.filterSystemWideSdks(existingSdks));
                            if (systemWideSdk != null) {
                                return new UseExistingInterpreterFix(systemWideSdk, this.$module);
                            }
                            v2 = PyCondaSdkCustomizer.Companion.getInstance().getFallbackConfigurator();
                            if (v2 == null) break;
                            var9_10 = v2;
                            var10_11 = this.$module;
                            configurator = var9_10;
                            $i$a$-let-PyInterpreterInspectionKt$getSuitableSdkFix$2$fallbackCreateSdkInfo$1 = 0;
                            this.L$0 = existingSdks;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)associatedSdk);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)context);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)createSdkInfo);
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)systemWideSdk);
                            this.L$5 = configurator;
                            this.I$0 = $i$a$-let-PyInterpreterInspectionKt$getSuitableSdkFix$2$fallbackCreateSdkInfo$1;
                            this.label = 2;
                            v3 = configurator.checkEnvironmentAndPrepareSdkCreator(var10_11, (Continuation)this);
                            if (v3 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl71
                        }
                        case 2: {
                            $i$a$-let-PyInterpreterInspectionKt$getSuitableSdkFix$2$fallbackCreateSdkInfo$1 = this.I$0;
                            configurator = (PyProjectSdkConfigurationExtension)this.L$5;
                            systemWideSdk = (Sdk)this.L$4;
                            createSdkInfo = (CreateSdkInfoWithTool)this.L$3;
                            context = (UserDataHolderBase)this.L$2;
                            associatedSdk = (Sdk)this.L$1;
                            existingSdks = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl71:
                            // 2 sources

                            v4 = (CreateSdkInfo)v3;
                            if (v4 != null) {
                                it = v4;
                                $i$a$-let-PyInterpreterInspectionKt$getSuitableSdkFix$2$fallbackCreateSdkInfo$1$1 = false;
                                v5 = new CreateSdkInfoWithTool(it, configurator.getToolId-dG2_5CA(), null);
                            } else {
                                v5 = null;
                            }
                            break block20;
                        }
                    }
                    v5 = fallbackCreateSdkInfo = null;
                }
                if (fallbackCreateSdkInfo != null) {
                    return new UseProvidedInterpreterFix(this.$module, fallbackCreateSdkInfo);
                }
                detectedSystemWideSdk = (PyDetectedSdk)CollectionsKt.firstOrNull((List)PySdkExtKt.detectSystemWideSdks$default(this.$module, existingSdks, null, 4, null));
                if (detectedSystemWideSdk != null) {
                    return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks, false, this.$module);
                }
                return null;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LocalQuickFix> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Sdk> getExistingSdks() {
        void $this$filterTo$iv$iv;
        ProjectSdksModel model2 = new ProjectSdksModel();
        model2.reset(null);
        Sdk[] sdkArray = model2.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getSdks(...)");
        Object[] $this$filter$iv = sdkArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            if (!(it.getSdkType() instanceof PythonSdkType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PyDetectedSdk detectAssociatedViaRootNameEnv(String associatedName, Module module2, List<? extends Sdk> existingSdks, UserDataHolderBase context) {
        return PyInterpreterInspectionKt.findAssociatedViaRootNameEnv(associatedName, PySdkExtKt.detectVirtualEnvs(module2, existingSdks, (UserDataHolder)context));
    }

    private static final PyDetectedSdk detectSystemWideSdk(String version2, Module module2, List<? extends Sdk> existingSdks, UserDataHolderBase context) {
        PyDetectedSdk pyDetectedSdk;
        LanguageLevel parsedVersion = LanguageLevel.fromPythonVersion((String)version2);
        if (Intrinsics.areEqual((Object)String.valueOf(parsedVersion), (Object)version2)) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = PySdkExtKt.detectSystemWideSdks(module2, existingSdks, (UserDataHolder)context);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv);
                    boolean bl = false;
                    if (!(PySdkExtKt.getGuessedLanguageLevel(it) == parsedVersion)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            pyDetectedSdk = v0;
        } else {
            pyDetectedSdk = null;
        }
        return pyDetectedSdk;
    }

    /*
     * WARNING - void declaration
     */
    private static final PyDetectedSdk findAssociatedViaRootNameEnv(String associatedName, List<PyDetectedSdk> envs) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = envs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv$iv);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)associatedName, (Object)PyInterpreterInspectionKt.getVirtualEnvRootName(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                PyDetectedSdk it = (PyDetectedSdk)((Object)a);
                boolean bl = false;
                Comparable comparable = (Comparable)PySdkExtKt.getGuessedLanguageLevel(it);
                it = (PyDetectedSdk)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)PySdkExtKt.getGuessedLanguageLevel(it)));
            }
        };
        return (PyDetectedSdk)((Object)CollectionsKt.maxWithOrNull((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    PyDetectedSdk it = (PyDetectedSdk)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getHomePath());
                    it = (PyDetectedSdk)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getHomePath())));
                }
                return n;
            }
        }));
    }

    private static final String getVirtualEnvRootName(PyDetectedSdk sdk2) {
        Object object;
        block3: {
            block2: {
                object = sdk2.getHomePath();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                File file = PythonSdkUtil.getVirtualEnvRoot((String)it);
                object = file;
                if (file != null) break block3;
            }
            return null;
        }
        Object file = object;
        return PathUtil.getFileName((String)((File)file).getPath());
    }

    private static final boolean isFileIgnored(PyFile pyFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = PyInspectionExtension.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyInspectionExtension it = (PyInspectionExtension)element$iv;
                    boolean bl2 = false;
                    if (!it.ignoreInterpreterWarnings(pyFile)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Object access$getSuitableSdkFix(String name2, Module module2, Continuation $completion) {
        return PyInterpreterInspectionKt.getSuitableSdkFix(name2, module2, (Continuation<? super LocalQuickFix>)$completion);
    }

    public static final /* synthetic */ boolean access$isFileIgnored(PyFile pyFile) {
        return PyInterpreterInspectionKt.isFileIgnored(pyFile);
    }

    public static final /* synthetic */ List access$getExistingSdks() {
        return PyInterpreterInspectionKt.getExistingSdks();
    }

    public static final /* synthetic */ Pattern access$getNAME$p() {
        return NAME;
    }

    public static final /* synthetic */ PyDetectedSdk access$detectAssociatedViaRootNameEnv(String associatedName, Module module2, List existingSdks, UserDataHolderBase context) {
        return PyInterpreterInspectionKt.detectAssociatedViaRootNameEnv(associatedName, module2, existingSdks, context);
    }

    public static final /* synthetic */ PyDetectedSdk access$detectSystemWideSdk(String version2, Module module2, List existingSdks, UserDataHolderBase context) {
        return PyInterpreterInspectionKt.detectSystemWideSdk(version2, module2, existingSdks, context);
    }

    static {
        Pattern pattern = Pattern.compile("Python (?<version>\\d\\.\\d+)\\s*(\\((?<name>.+?)\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        NAME = pattern;
    }
}

