/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLObjectPropertyChainEditor
extends AbstractOWLObjectEditor<List<OWLObjectPropertyExpression>>
implements VerifiedInputEditor {
    private final Logger logger = LoggerFactory.getLogger(OWLObjectPropertyChainEditor.class);
    private JLabel impliesLabel;
    private OWLEditorKit owlEditorKit;
    private JPanel panel;
    protected ExpressionEditor<List<OWLObjectPropertyExpression>> editor;

    public OWLObjectPropertyChainEditor(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        OWLExpressionChecker<List<OWLObjectPropertyExpression>> checker = owlEditorKit.getModelManager().getOWLExpressionCheckerFactory().getPropertyChainChecker();
        this.editor = new ExpressionEditor<List<OWLObjectPropertyExpression>>(owlEditorKit, checker);
        Dimension prefSize = this.editor.getPreferredSize();
        this.editor.setPreferredSize(new Dimension(350, prefSize.height * 3));
        this.impliesLabel = new JLabel();
        this.panel = new JPanel(new BorderLayout(7, 7));
        this.panel.add(new JScrollPane(this.editor));
        this.panel.add((Component)this.impliesLabel, "East");
    }

    @Override
    @Nullable
    public List<OWLObjectPropertyExpression> getEditedObject() {
        try {
            return this.editor.createObject();
        }
        catch (OWLException e) {
            this.logger.error("An error occurred whilst creating the entered property chain.", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean setEditedObject(List<OWLObjectPropertyExpression> objectPropertyList) {
        this.editor.setExpressionObject(objectPropertyList);
        return true;
    }

    public void setAxiom(OWLSubPropertyChainOfAxiom ax) {
        Object rendering = "";
        Iterator it = ax.getPropertyChain().iterator();
        while (it.hasNext()) {
            rendering = (String)rendering + this.owlEditorKit.getModelManager().getRendering((OWLObject)it.next());
            if (!it.hasNext()) continue;
            rendering = (String)rendering + " o ";
        }
        this.editor.setText((String)rendering);
        this.setSuperProperty(ax.getSuperProperty());
    }

    public void setSuperProperty(OWLObjectPropertyExpression prop) {
        String rendering = this.owlEditorKit.getModelManager().getRendering((OWLObject)prop);
        this.impliesLabel.setText(" \u279e " + rendering);
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "List of Object Properties";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkList(object, OWLObjectPropertyExpression.class);
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.panel;
    }

    @Override
    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.addStatusChangedListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.removeStatusChangedListener(listener);
    }
}

