/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import uk.ac.manchester.cs.owl.owlapi.CompressionEnabled;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImplNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends OWLDataFactoryInternalsImplNoCache {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private transient LoadingCache<IRI, OWLClass> classesByURI;
    @Nonnull
    private transient LoadingCache<IRI, OWLObjectProperty> objectPropertiesByURI;
    @Nonnull
    private transient LoadingCache<IRI, OWLDataProperty> dataPropertiesByURI;
    @Nonnull
    private transient LoadingCache<IRI, OWLDatatype> datatypesByURI;
    @Nonnull
    private transient LoadingCache<IRI, OWLNamedIndividual> individualsByURI;
    @Nonnull
    private transient LoadingCache<IRI, OWLAnnotationProperty> annotationPropertiesByURI;
    @Nonnull
    private transient LoadingCache<String, String> languageTagInterner;
    private transient LoadingCache<OWLAnnotation, OWLAnnotation> annotationsCache;

    @Inject
    public OWLDataFactoryInternalsImpl(@CompressionEnabled boolean useCompression) {
        super(useCompression);
        this.initCaches();
    }

    private void readObject(ObjectInputStream stream) {
        this.initCaches();
    }

    protected void initCaches() {
        Caffeine builder = Caffeine.newBuilder().weakKeys().maximumSize(this.size());
        this.classesByURI = builder.build(OWLClassImpl::new);
        this.objectPropertiesByURI = builder.build(OWLObjectPropertyImpl::new);
        this.dataPropertiesByURI = builder.build(OWLDataPropertyImpl::new);
        this.datatypesByURI = builder.build(OWLDatatypeImpl::new);
        this.individualsByURI = builder.build(OWLNamedIndividualImpl::new);
        this.annotationPropertiesByURI = builder.build(OWLAnnotationPropertyImpl::new);
        this.annotationsCache = builder.build(k -> k);
        this.languageTagInterner = builder.build(k -> k);
    }

    protected long size() {
        return ConfigurationOptions.CACHE_SIZE.getValue(Integer.class, Collections.emptyMap()).longValue();
    }

    @Override
    @Nonnull
    public OWLClass getOWLClass(IRI iri) {
        return (OWLClass)this.classesByURI.get((Object)iri);
    }

    @Override
    public void purge() {
        this.classesByURI.invalidateAll();
        this.objectPropertiesByURI.invalidateAll();
        this.dataPropertiesByURI.invalidateAll();
        this.datatypesByURI.invalidateAll();
        this.individualsByURI.invalidateAll();
        this.annotationPropertiesByURI.invalidateAll();
        this.annotationsCache.invalidateAll();
    }

    @Override
    @Nonnull
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return (OWLObjectProperty)this.objectPropertiesByURI.get((Object)iri);
    }

    @Override
    @Nonnull
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return (OWLDataProperty)this.dataPropertiesByURI.get((Object)iri);
    }

    @Override
    @Nonnull
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return (OWLNamedIndividual)this.individualsByURI.get((Object)iri);
    }

    @Override
    @Nonnull
    public OWLDatatype getOWLDatatype(IRI iri) {
        return (OWLDatatype)this.datatypesByURI.get((Object)iri);
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return (OWLAnnotationProperty)this.annotationPropertiesByURI.get((Object)iri);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        return super.getOWLLiteral(literal, this.intern(lang));
    }

    protected String intern(String lang) {
        if (lang == null) {
            return "";
        }
        return (String)this.languageTagInterner.get((Object)lang.trim().toLowerCase());
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAnnotationImpl key = new OWLAnnotationImpl(property, value, annotations);
        return (OWLAnnotation)this.annotationsCache.get((Object)key);
    }
}

