/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.NNF;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.CollectionContainer;
import uk.ac.manchester.cs.owl.owlapi.CollectionContainerVisitor;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithEntityAndAnonCaching;

public abstract class OWLAxiomImplWithEntityAndAnonCaching
extends OWLObjectImplWithEntityAndAnonCaching
implements OWLAxiom,
CollectionContainer<OWLAnnotation> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLAnnotation> annotations;

    @Override
    protected int index() {
        return 2000 + this.getAxiomType().getIndex();
    }

    public OWLAxiomImplWithEntityAndAnonCaching(@Nonnull Collection<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(annotations, "annotations cannot be null");
        if (!annotations.isEmpty()) {
            if (annotations.size() == 1) {
                OWLAnnotation tmp = annotations.iterator().next();
                this.annotations = Collections.singletonList(tmp);
            } else {
                this.annotations = CollectionFactory.sortOptionally(annotations);
            }
        } else {
            this.annotations = CollectionFactory.emptyList();
        }
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        if (this.annotations.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.annotations);
    }

    @Override
    public void accept(CollectionContainerVisitor<OWLAnnotation> t) {
        int size = this.annotations.size();
        for (int i = 0; i < size; ++i) {
            t.visitItem(this.annotations.get(i));
        }
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        if (this.annotations.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        HashSet<OWLAnnotation> result = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : this.annotations) {
            if (!anno.getProperty().equals(annotationProperty)) continue;
            result.add(anno);
        }
        return result;
    }

    @Override
    public boolean equalsIgnoreAnnotations(OWLAxiom axiom) {
        return this.getAxiomWithoutAnnotations().equals(axiom.getAxiomWithoutAnnotations());
    }

    @Override
    public boolean isOfType(AxiomType<?> ... axiomTypes) {
        for (AxiomType<?> type : axiomTypes) {
            if (!this.getAxiomType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOfType(Set<AxiomType<?>> types) {
        return types.contains(this.getAxiomType());
    }

    @Nonnull
    protected Set<OWLAnnotation> mergeAnnos(Set<OWLAnnotation> annos) {
        HashSet<OWLAnnotation> merged = new HashSet<OWLAnnotation>(annos);
        merged.addAll(this.annotations);
        return merged;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (!(obj instanceof OWLAxiom)) {
            return false;
        }
        OWLAxiom other = (OWLAxiom)obj;
        if (other instanceof OWLAxiomImplWithEntityAndAnonCaching) {
            return this.annotations.equals(((OWLAxiomImplWithEntityAndAnonCaching)other).annotations);
        }
        return this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public OWLAxiom getNNF() {
        NNF con = new NNF(new OWLDataFactoryImpl());
        OWLAxiom nnf = this.accept(con);
        return OWLAPIPreconditions.verifyNotNull(nnf);
    }
}

