/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.quarkus.hibernate.cache.DomainDataRegionImpl;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;

abstract class AbstractDomainDataAccess
implements CachedDomainDataAccess {
    final InternalDataAccess internal;
    final DomainDataRegionImpl region;

    AbstractDomainDataAccess(InternalDataAccess internal, DomainDataRegionImpl region) {
        this.internal = internal;
        this.region = region;
    }

    public DomainDataRegion getRegion() {
        return this.region;
    }

    public Object get(SharedSessionContractImplementor session, Object key) {
        return this.internal.get(session, key, session.getCacheTransactionSynchronization().getCachingTimestamp());
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return this.internal.putFromLoad(session, key, value, session.getCacheTransactionSynchronization().getCachingTimestamp(), version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version, boolean minimalPutOverride) {
        return this.internal.putFromLoad(session, key, value, session.getCacheTransactionSynchronization().getCachingTimestamp(), version, minimalPutOverride);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) {
    }

    public void remove(SharedSessionContractImplementor session, Object key) {
        this.internal.remove(session, key);
    }

    public void removeAll(SharedSessionContractImplementor session) {
        this.internal.removeAll();
    }

    public boolean contains(Object key) {
        return this.internal.get(null, key, Long.MAX_VALUE) != null;
    }

    public SoftLock lockRegion() {
        return null;
    }

    public void unlockRegion(SoftLock lock) {
    }

    public void evict(Object key) {
        this.internal.evict(key);
    }

    public void evictAll() {
        this.internal.evictAll();
    }
}

