/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelocatableFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "baseDir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "toPath", "", "file", "toFile", "path", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nRelocatableFileToPathConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelocatableFileToPathConverter.kt\norg/jetbrains/kotlin/incremental/storage/RelocatableFileToPathConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class RelocatableFileToPathConverter
implements FileToPathConverter {
    @NotNull
    private final File baseDir;

    public RelocatableFileToPathConverter(@NotNull File baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDir = baseDir;
    }

    @Override
    @NotNull
    public String toPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isAbsolute()) {
            boolean bl = false;
            String string = "Expected absolute path but found relative path: " + file.getPath();
            throw new IllegalStateException(string.toString());
        }
        return FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file, (File)this.baseDir));
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.normalize((File)FilesKt.resolve((File)this.baseDir, (String)path));
    }
}

