/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexMatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

public class Parameter
implements Setting {
    public static final String LANGUAGE_VARIANT = "variant";
    private final ai.grazie.nlp.langs.Language language;
    private final String id;
    private final String displayName;
    private final List<Setting.Value> possibleValues;
    private final Map<String, Setting.Value> id2Value;

    public Parameter(ai.grazie.nlp.langs.Language language, String id, String displayName, List<Setting.Value> possibleValues) {
        this.language = language;
        this.id = id;
        this.displayName = displayName;
        this.possibleValues = possibleValues;
        this.id2Value = StreamEx.of(possibleValues).mapToEntry(v -> v.id(), Function.identity()).toMap();
    }

    @NotNull
    public String getValue(Tree tree) {
        Setting.Value value = this.getValueObject(tree);
        return value != null ? value.id() : "";
    }

    @Nullable
    public Setting.Value getValueObject(Tree tree) {
        String defined = tree.parameterValues.getValueId(this);
        if (defined != null) {
            Setting.Value value = this.id2Value.get(defined);
            if (value == null) {
                throw new IllegalArgumentException("Invalid value given " + defined + " for parameter " + this.id + "; possible=" + String.valueOf(this.possibleValues));
            }
            return value;
        }
        return null;
    }

    public NodePattern withValue(@Language(value="RegExp") String valueIdRegex) {
        RegexMatcher matcher = Regex.parse(valueIdRegex).caseSensitiveMatcher();
        return NodePattern.custom((n, m) -> matcher.matches(this.getValue(m.anchor().tree())) ? m : null);
    }

    public String id() {
        return this.id;
    }

    @Override
    @NotNull
    public String displayName() {
        return this.displayName;
    }

    public List<Setting.Value> possibleValues(RuleClient client) {
        return this.possibleValues;
    }

    @Override
    @NotNull
    public Setting.Value defaultValue(TextStyle style, RuleClient client) {
        String valueId = style.paramValues().get(this.globalId());
        if (valueId != null) {
            for (Setting.Value value : this.possibleValues(client)) {
                if (!value.id().equals(valueId)) continue;
                return value;
            }
        }
        return this.possibleValues.get(0);
    }

    @NotNull
    public String globalId() {
        return StringTools.uppercaseFirstChar((String)this.language.getIso().toString()) + "." + this.id();
    }

    public String toString() {
        return "Parameter[id=" + this.id + ", displayName=" + this.displayName + ", possibleValues=" + String.valueOf(this.possibleValues) + "]";
    }
}

