/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.LTRuleInfo;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.PhraseReplacement;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

class VariantDifferences {
    static final NodePattern punctBeforeQuotesVariant = EnglishParameters.VARIANT.withValue("US|CA");
    static final NodePattern punctAfterQuotesVariant = EnglishParameters.VARIANT.withValue("GB.*|AU|NZ");
    private static final Pattern lDoublingForm = Pattern.compile("(.+[^l]l)(l?)(ed|ing|ers?|ors?|est|ous)");
    private static final Pattern lDoublingVariant = Pattern.compile("GB.*|AU|CA|NZ");
    static final String ourVariant = "GB.*|AU|CA";
    static final String iseVariant = "GB|AU";
    static final String erVariant = "US";
    private static final String atLeastSyllable = ".*[aeiouy].*";
    private static final Pattern ourForm = Pattern.compile("(.*[aeiouy].*o)(u?)(r(?:s?|ed|ings?|hoods?|ful|less|al|(al)?isms?))");

    VariantDifferences() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Style.VARIANT_LEXICAL_DIFFERENCES", "Spelling differences between English variants (US, GB, Oxford spelling, etc.)", "British, American, and other variants of English have different spellings for the same words.", "https://www.oxfordinternationalenglish.com/differences-in-british-and-american-spelling/", () -> NodePattern.or(VariantDifferences.our(), VariantDifferences.yze(), VariantDifferences.ise(), VariantDifferences.lDoubling(), VariantDifferences.ae(), VariantDifferences.erRe(), VariantDifferences.eable(), VariantDifferences.byTable()), new Example("For the US: <b>colours</b>, <b>analysing</b>, <b>travelled</b>, <b>organisation</b>", List.of("For the US: <b>colors</b>, <b>analyzing</b>, <b>traveled</b>, <b>organization</b>"), Map.of(EnglishParameters.VARIANT, erVariant)), new Example("For the UK: <b>colors</b>, <b>analyzing</b>, <b>traveled</b>, <b>organization</b>", List.of("For the UK: <b>colours</b>, <b>analysing</b>, <b>travelled</b>, <b>organisation</b>"), Map.of(EnglishParameters.VARIANT, "GB")), new Example("For the Oxford spelling: <b>colors</b>, <b>analyzing</b>, <b>traveled</b>, <b>organisation</b>", List.of("For the Oxford spelling: <b>colours</b>, <b>analysing</b>, <b>travelled</b>, <b>organization<b>"), Map.of(EnglishParameters.VARIANT, "GB-oxendict"))).enableInFlatTrees().coveringLTRules(new LTRuleInfo("OXFORD_SPELLING_Z_NOT_S", EnglishParameters.VARIANT, "GB-oxendict"), new LTRuleInfo("EN_US_SIMPLE_REPLACE", EnglishParameters.VARIANT, erVariant), new LTRuleInfo("EN_GB_SIMPLE_REPLACE", EnglishParameters.VARIANT, "GB"), new LTRuleInfo("EN_NZ_SIMPLE_REPLACE", EnglishParameters.VARIANT, "NZ"));
    }

    private static NodePattern byTable() {
        HashMap<String, Map<String, List<PhraseReplacement>>> table = new HashMap<String, Map<String, List<PhraseReplacement>>>();
        for (String code : List.of(erVariant, "GB", "NZ", "CA", "AU")) {
            table.put(code, PhraseReplacement.parseLines(WordSet.loadLines("en/words/replace_" + code + ".txt")));
        }
        Set allKeys = StreamEx.of(table.values()).flatCollection(Map::keySet).map(s -> s.toLowerCase(Locale.ROOT)).toSet();
        NodePattern onlyGerund = NodePattern.N.onlyPos("VBG");
        return NodePattern.or(NodePattern.N.pos("NNS?|JJ"), NodePattern.N.inFormSequence(0, "per", "cents?"), NodePattern.N.noPos(), onlyGerund, NodePattern.N.pos("VBD").form(allKeys)).andOr(NodePattern.N.form(allKeys), NodePattern.N.lemma(allKeys)).noFormCaseSensitive("Defence").andNot(NodePattern.N.form(".+ed").pos("JJ")).andNot(NodePattern.N.inFormSequence(0, "garbage", "collections?|collectors?")).andNot(NodePattern.N.form("trash").and(n -> ((StreamEx)n.forward().limit(5L)).anyMatch(NodePattern.N.lemma("folder")::matches))).andNot(NodePattern.N.form("tire").pos("VBP?")).andNot(NodePattern.N.lemma("practise").and(EnglishParameters.VARIANT.withValue("GB-oxendict"))).andNot(NodePattern.N.formCaseSensitive("Gray").andOr(NodePattern.N.label("PERSON|MISC"), NodePattern.N.inFlatTree())).andNot(EnglishTreePatterns.percentConfusedWithPercentage).and((node, match) -> {
            Setting.Value varObj = EnglishParameters.VARIANT.getValueObject(node.tree());
            if (varObj == null) {
                return null;
            }
            Map map = (Map)table.get(varObj.id().startsWith("GB") ? "GB" : varObj.id());
            if (map == null) {
                return null;
            }
            List<PhraseReplacement.MatchStrategy> strategies = onlyGerund.matches(node) ? List.of(PhraseReplacement.MatchStrategy.Form) : List.of(PhraseReplacement.MatchStrategy.Form, PhraseReplacement.MatchStrategy.Lemma);
            for (PhraseReplacement.MatchStrategy strategy : strategies) {
                PhraseReplacement phrase = strategy.findRule(node, map);
                if (phrase == null) continue;
                match = match.withMessage(EnglishParameters.Variant.countryAdj(varObj) + " English uses '" + phrase.replacements().get(0) + "'");
                return EnglishTreePatterns.replaceNominalPhrase(node, match, phrase, strategy);
            }
            return null;
        });
    }

    private static NodePattern our() {
        String pos = "VB.*|NNS?|JJ";
        String regex = ourForm.pattern();
        return NodePattern.N.pos(pos).withSubstringHint("ou?r").and(VariantDifferences.infixMismatch(regex, ourVariant, "u", "", pos, "American roots ending with '-or' usually have '-our' in %s English", "British roots ending with '-our' usually have '-or' in %s English")).andNot(CommonPatterns.capitalized.lemma("endeavour"));
    }

    private static NodePattern yze() {
        String regex = "(?:un)?(.*[aeiouy].*y)([zs])(e[sd]?|ing|ers?|able|abilit(y|ies))";
        String pos = "VB.*|NNS?";
        return NodePattern.N.pos(pos).withSubstringHint("y[sz](e|ab|ing)").and(VariantDifferences.infixMismatch(regex, "GB.*|AU", "s", "z", pos, "%s English uses '-ys-' in suffixes", "%s English uses '-yz-' in suffixes")).andNot(NodePattern.N.form(".*y[zs]es").pos("NNS"));
    }

    private static NodePattern ise() {
        String ending = "(e[sd]?|ing|ers?|ation(s|al(ly)?)?|able|abilit(y|ies))";
        String regex = "(?:un)?(.*[aeiouy].*i)([zs])" + ending;
        String pos = "VB.*|NNS?|JJ|RB";
        NodePattern possiblyFrench = NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.letterWord.noPos()), NodePattern.N.directlyAfter(CommonPatterns.letterWord.noPos()));
        NodePattern possiblyProper = CommonPatterns.capitalized.andOr(NodePattern.N.label(".*"), NodePattern.N.inFlatTree().form(".*i[sz](ed|er|ation)")).noForm("americanisations?");
        return NodePattern.N.pos(pos).withSubstringHint("i[sz](e|a|ing)").andOr(NodePattern.N.form(".+is" + ending).and(EnglishParameters.VARIANT.withValue("GB-oxendict")).and(VariantDifferences.infixMismatch(regex, iseVariant, "s", "z", pos, null, "Oxford spelling uses '-iz-' in suffixes")), VariantDifferences.infixMismatch(regex, iseVariant, "s", "z", pos, "%s English uses '-is-' in suffixes", "%s English uses '-iz-' in suffixes")).andNot(possiblyFrench).andNot(possiblyProper).noForm("advertis.*|maize|brais.*|merchandis.*|misadvis.*|chastis.*|(de)?serializ.*");
    }

    private static NodePattern lDoubling() {
        String regex = lDoublingForm.pattern();
        String pos = "VB[DGN]|NNS?|JJ[RS]?";
        NodePattern changeVerb = VariantDifferences.infixMismatch(regex, lDoublingVariant.pattern(), "l", "", pos, "%s English doubles '-l-' in suffixes", "%s English does not double '-l-' in suffixes").andNot(NodePattern.N.inFormSequence(1, "business", "traveller")).noForm("cancelling");
        NodePattern changeAdj = VariantDifferences.infixMismatch(regex, lDoublingVariant.pattern(), "l", "", pos, "%s English doubles '-l-' in comparative and superlative adjectives", "%s English does not double '-l-' in comparative and superlative adjectives");
        return NodePattern.N.pos(pos).withSubstringHint("l(e[dr]|ing|est|or|ous)").and((node, match) -> {
            TextRange range = VariantDifferences.infixRange(lDoublingForm, node.form());
            if (range == null) {
                return null;
            }
            String stem = node.form().substring(0, range.start());
            List<String> stemPos = node.tree().treeSupport().tagToken(stem).posReadings();
            if (stemPos.contains("VB")) {
                return changeVerb.match(node, match);
            }
            if (stemPos.contains("JJ")) {
                return changeAdj.match(node, match);
            }
            return null;
        });
    }

    private static NodePattern ae() {
        String lemmasWithAe = "(ana?emi|ana?esthe|gyna?eco|ha?em[oa]|pa?ediatr|pa?edo|septica?em|leuka?em|syna?esthe|pala?eontolog|ca?ec).+|ca?esium|fa?eces";
        String beforeAe = "an|c|f|gyn|h|p|pal|leuk|septic|syn";
        String regex = "(" + beforeAe + ")(a?e)(.+)";
        String pos = "NNS?|JJ|VB[DG]?";
        return NodePattern.N.pos(pos).lemma(lemmasWithAe).withSubstringHint("(" + beforeAe + ")a?e").and(VariantDifferences.infixMismatch(regex, erVariant, "e", "ae", pos, "American English uses '-e-' instead of '-ae-' in some words of Greek and Latin origin", "%s English uses '-ae-' instead of '-e-' in some words of Greek and Latin origin"));
    }

    private static NodePattern erRe() {
        String beforeRe = "calib|cent|fib|lit|louv|lust|meag|mit|och|philt|reconnoit|sab|scept|sepulch|somb|spect|theat|tit";
        String regex = "(" + beforeRe + ")(er|re)(.*)";
        String pos = "NNS?|JJ|VB";
        NodePattern properName = CommonPatterns.capitalized.andOr(NodePattern.N.label(".*"), NodePattern.N.form("specter"), NodePattern.N.form("centers?").andOr(NodePattern.N.directlyAfter(CommonPatterns.capitalized.pos("JJ.*|NN.*")), NodePattern.N.directlyBefore(NodePattern.N.pos("IN")).withNeighbor(2, CommonPatterns.capitalized)));
        return NodePattern.N.pos(pos).withSubstringHint("(" + beforeRe + ")(er|re)").and(VariantDifferences.infixMismatch(regex, erVariant, "er", "re", pos, "American English uses '-er' instead of '-re'", "%s English uses '-re' instead of '-er'")).noPos("VBZ").andNot(properName);
    }

    private static NodePattern eable() {
        String beforeAble = "lik|liv|rat|sal|siz|shak";
        String regex = "(?:un)?(" + beforeAble + ")(e?)(abi?l.+)";
        String pos = "JJ|NNS?";
        return NodePattern.N.pos(pos).withSubstringHint("(" + beforeAble + ")e?abi?l").and(VariantDifferences.infixMismatch(regex, "GB.*|AU|NZ", "e", "", pos, "%s English usually keeps the '-e-' before '-able'", "%s English usually drops the '-e-' before '-able'"));
    }

    private static NodePattern infixMismatch(String formRegex, String variant1Regex, String infix1, String infix2, String replacementPos, String to1Message, String to2Message) {
        Pattern pattern = Pattern.compile(formRegex, 2);
        Predicate<String> isVariant1 = Pattern.compile(variant1Regex).asMatchPredicate();
        return NodePattern.custom((node, match) -> {
            String expectedInfix;
            String form = node.form();
            TextRange range = VariantDifferences.infixRange(pattern, form);
            if (range == null) {
                return null;
            }
            Tree tree = node.tree();
            Setting.Value variantValue = EnglishParameters.VARIANT.getValueObject(tree);
            if (variantValue == null || variantValue.id().isEmpty()) {
                return null;
            }
            boolean expectsVariant1 = isVariant1.test(variantValue.id());
            String string = expectedInfix = expectsVariant1 ? infix1 : infix2;
            if (expectedInfix.equals(range.substring(form))) {
                return null;
            }
            String replacement = range.replace(form, expectedInfix);
            if (!tree.treeSupport().tagToken(replacement).hasPos(replacementPos)) {
                return null;
            }
            ActionSuggestion[] actions = (ActionSuggestion.ChangeParameter[])EnglishParameters.VARIANT.possibleValues(RuleClient.FullyCapable).stream().filter(v -> isVariant1.test(v.id()) != expectsVariant1 && !v.id().isEmpty()).map(v -> EnglishParameters.VARIANT.changeTo(v.id())).toArray(ActionSuggestion.ChangeParameter[]::new);
            if (actions.length == 0) {
                throw new AssertionError((Object)("No variant-changing suggestions for " + variant1Regex + "," + expectsVariant1));
            }
            return match.withCorrector(NodeCorrector.replace(node, replacement)).withMessage(String.format(expectsVariant1 ? to1Message : to2Message, EnglishParameters.Variant.countryAdj(variantValue))).withActions(actions);
        });
    }

    @Nullable
    private static TextRange infixRange(Pattern pattern, String form) {
        Matcher matcher = pattern.matcher(form);
        return matcher.matches() ? new TextRange(matcher.start(2), matcher.end(2)) : null;
    }

    static List<String> removeVariantIncompatibleSuggestions(List<String> result, Tree tree) {
        if (result.stream().noneMatch(lDoublingForm.asMatchPredicate())) {
            return result;
        }
        String variant = EnglishParameters.VARIANT.getValue(tree);
        if (variant.isEmpty()) {
            return result;
        }
        String expectedInfix = lDoublingVariant.matcher(variant).matches() ? "l" : "";
        HashSet<String> resultSet = new HashSet<String>(result);
        Set toRemove = ((StreamEx)StreamEx.of(result).filter(s -> {
            TextRange range = VariantDifferences.infixRange(lDoublingForm, s);
            return range != null && !expectedInfix.equals(range.substring((String)s)) && resultSet.contains(range.replace((String)s, expectedInfix));
        })).toSet();
        return result.stream().filter(s -> !toRemove.contains(s)).toList();
    }

    static NodePattern variantQuotePunctuation() {
        NodePattern closingQuotationPeriod = CommonPatterns.dot.directlyBefore(CommonPatterns.lastToken);
        NodePattern quotationInternalPunctuation = CommonPatterns.comma.and(n -> ((StreamEx)n.forward().skip(2L)).anyMatch(EnglishTreePatterns.aposOrQuote::matches));
        NodePattern codeFragmentWithStringLiteral = NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.letterWord);
        NodePattern apos = NodePattern.N.form("['\u2019`\u2018]");
        NodePattern possessiveApostrophe = NodePattern.N.directlyAfter(apos.noSpaceBefore().directlyAfter(NodePattern.N.pos("NNS").form(".+s"))).andNot(NodePattern.N.after(apos.and(Quotes.openingPosition)));
        return NodePattern.N.form("[.,]").andOr(FormattingIssues.movePunctBeforeQuote.and(punctBeforeQuotesVariant).andNot(codeFragmentWithStringLiteral).andNot(possessiveApostrophe), FormattingIssues.movePunctAfterQuote(AbbreviationPatterns.withPunctCaseSensitive((Language)Language.ENGLISH)).and(punctAfterQuotesVariant).andNot(closingQuotationPeriod).andNot(quotationInternalPunctuation)).and((node, match) -> {
            String expected = EnglishTreePatterns.aposOrQuote.matches(node.prevNode()) ? "inside" : "outside";
            Setting.Value variant = Objects.requireNonNull(EnglishParameters.VARIANT.getValueObject(node.tree()));
            String message = StringTools.uppercaseFirstChar((String)PunctuationRules.punctuationName(node.form())) + " should be placed " + expected + " quotation marks in " + EnglishParameters.Variant.countryAdj(variant) + " English";
            return match.withMessage(message);
        });
    }
}

