/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAwareReferencesSearchParameters;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0010\u0010\t\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAliasedImportedElementSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "parameters", "consumer", "Lcom/intellij/util/Processor;", "AliasProcessor", "intellij.kotlin.base.analysis"})
public final class KotlinAliasedImportedElementSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters2, @NotNull Processor<? super PsiReference> consumer) {
        block2: {
            Function0 queryFunction;
            Object kotlinOptions;
            Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Object object = parameters2 instanceof KotlinAwareReferencesSearchParameters ? (KotlinAwareReferencesSearchParameters)parameters2 : null;
            if (object == null || (object = object.getKotlinOptions()) == null) {
                object = KotlinReferencesSearchOptions.Companion.getEmpty();
            }
            if (!((KotlinReferencesSearchOptions)(kotlinOptions = object)).getAcceptImportAlias()) {
                return;
            }
            Project project = parameters2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Function0 function0 = queryFunction = (Function0)DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> KotlinAliasedImportedElementSearcher.processQuery$lambda$0(parameters2, (KotlinReferencesSearchOptions)kotlinOptions));
            if (function0 == null) break block2;
            function0.invoke();
        }
    }

    private static final Function0 processQuery$lambda$0(ReferencesSearch.SearchParameters $parameters, KotlinReferencesSearchOptions $kotlinOptions) {
        PsiElement psiElement = $parameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        PsiElement element = psiElement;
        if (!element.isValid()) {
            return null;
        }
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element);
        if (psiNamedElement == null) {
            return null;
        }
        PsiNamedElement unwrappedElement = psiNamedElement;
        PsiNamedElement elementToSearch = ExpectActualUtils.INSTANCE.getElementToSearch($kotlinOptions, unwrappedElement);
        String name2 = elementToSearch.getName();
        CharSequence charSequence = name2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        SearchScope effectiveSearchScope = SearchUtilKt.effectiveSearchScope($parameters, (PsiElement)elementToSearch);
        SearchRequestCollector searchRequestCollector = $parameters.getOptimizer();
        Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"getOptimizer(...)");
        SearchRequestCollector collector2 = searchRequestCollector;
        SearchSession searchSession = collector2.getSearchSession();
        Intrinsics.checkNotNullExpressionValue((Object)searchSession, (String)"getSearchSession(...)");
        SearchSession session2 = searchSession;
        Function0 function = () -> KotlinAliasedImportedElementSearcher.processQuery$lambda$0$0(collector2, name2, effectiveSearchScope, elementToSearch, session2);
        return function;
    }

    private static final Unit processQuery$lambda$0$0(SearchRequestCollector $collector, String $name, SearchScope $effectiveSearchScope, PsiNamedElement $elementToSearch, SearchSession $session) {
        $collector.searchWord($name, $effectiveSearchScope, (short)1, true, (PsiElement)$elementToSearch, (RequestResultProcessor)new AliasProcessor((PsiElement)$elementToSearch, $session));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAliasedImportedElementSearcher$AliasProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "myTarget", "Lcom/intellij/psi/PsiElement;", "mySession", "Lcom/intellij/psi/search/SearchSession;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/SearchSession;)V", "processTextOccurrence", "", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.kotlin.base.analysis"})
    private static final class AliasProcessor
    extends RequestResultProcessor {
        @NotNull
        private final PsiElement myTarget;
        @NotNull
        private final SearchSession mySession;

        public AliasProcessor(@NotNull PsiElement myTarget, @NotNull SearchSession mySession) {
            Intrinsics.checkNotNullParameter((Object)myTarget, (String)"myTarget");
            Intrinsics.checkNotNullParameter((Object)mySession, (String)"mySession");
            Object[] objectArray = new Object[]{myTarget};
            super(objectArray);
            this.myTarget = myTarget;
            this.mySession = mySession;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            PsiElement psiElement = element.getParent();
            KtImportDirective ktImportDirective = psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
            if (ktImportDirective == null) {
                return true;
            }
            KtImportDirective importStatement = ktImportDirective;
            KtImportAlias ktImportAlias = importStatement.getAlias();
            if (ktImportAlias == null) {
                return true;
            }
            KtImportAlias alias = ktImportAlias;
            String string = alias.getName();
            if (string == null) {
                return true;
            }
            String importAlias = string;
            KtExpression ktExpression = importStatement.getImportedReference();
            if (ktExpression == null || (ktExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression))) == null || (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)ktExpression)) == null) {
                return true;
            }
            KtExpression reference = ktExpression;
            if (!reference.isReferenceTo(this.myTarget)) {
                return true;
            }
            SearchRequestCollector collector2 = new SearchRequestCollector(this.mySession);
            SearchScope fileScope = (SearchScope)new LocalSearchScope((PsiElement)element.getContainingFile());
            collector2.searchWord(importAlias, fileScope, (short)1, true, (PsiElement)alias);
            return PsiSearchHelper.getInstance((Project)element.getProject()).processRequests(collector2, consumer);
        }
    }
}

