/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.documentation.AbstractExternalFilter;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.kotlin.idea.KotlinDocumentationProvider;
import org.jetbrains.kotlin.idea.kdoc.KotlinExternalDocsKt;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0007J\"\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0003J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0003J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KotlinDocExtractorFromJavaDoc;", "Lcom/intellij/codeInsight/documentation/AbstractExternalFilter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myCurrentProcessingElement", "Lcom/intellij/psi/PsiElement;", "myReferenceConverters", "", "Lcom/intellij/codeInsight/documentation/AbstractExternalFilter$RefConvertor;", "[Lcom/intellij/codeInsight/documentation/AbstractExternalFilter$RefConvertor;", "getRefConverters", "()[Lcom/intellij/codeInsight/documentation/AbstractExternalFilter$RefConvertor;", "getExternalDocInfoForElement", "", "elementDocUrl", "element", "javaDocPageHtml", "buildResultDocPage", "elementSignature", "elementDoc", "generateSignature", "tryGetDocFromBuiltInServer", "doBuildFromStream", "", "url", "input", "Ljava/io/Reader;", "data", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinExternalDocs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExternalDocs.kt\norg/jetbrains/kotlin/idea/kdoc/KotlinDocExtractorFromJavaDoc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n1#2:387\n1#2:398\n1617#3,9:388\n1869#3:397\n1870#3:399\n1626#3:400\n*S KotlinDebug\n*F\n+ 1 KotlinExternalDocs.kt\norg/jetbrains/kotlin/idea/kdoc/KotlinDocExtractorFromJavaDoc\n*L\n322#1:398\n322#1:388,9\n322#1:397\n322#1:399\n322#1:400\n*E\n"})
public final class KotlinDocExtractorFromJavaDoc
extends AbstractExternalFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private PsiElement myCurrentProcessingElement;
    @NotNull
    private final AbstractExternalFilter.RefConvertor[] myReferenceConverters;
    private static final Pattern HREF_REGEXP = Pattern.compile("<A.*?HREF=\"([^>\"]*)\"", 34);

    public KotlinDocExtractorFromJavaDoc(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        AbstractExternalFilter.RefConvertor[] refConvertorArray = new AbstractExternalFilter.RefConvertor[1];
        Pattern pattern2 = HREF_REGEXP;
        refConvertorArray[0] = new AbstractExternalFilter.RefConvertor(this, pattern2){
            final /* synthetic */ KotlinDocExtractorFromJavaDoc this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected String convertReference(String root, String href) {
                String string;
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)href, (String)"href");
                if (BrowserUtil.isAbsoluteURL((String)href)) {
                    return href;
                }
                PsiElement psiElement = KotlinDocExtractorFromJavaDoc.access$getMyCurrentProcessingElement$p(this.this$0);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    string = JavaDocInfoGenerator.createReferenceForRelativeLink((String)href, (PsiElement)it);
                } else {
                    string = null;
                }
                String reference = string;
                Object object = reference;
                if (object == null) {
                    if (StringsKt.startsWith$default((String)href, (String)"#", (boolean)false, (int)2, null)) {
                        object = root + href;
                    } else {
                        String nakedRoot = KotlinDocExtractorFromJavaDoc.access$getOurHtmlFileSuffix$p$s-679781371().matcher(root).replaceAll("/");
                        String string2 = KotlinDocExtractorFromJavaDoc.access$doAnnihilate$s-679781371(nakedRoot + href);
                        Intrinsics.checkNotNull((Object)string2);
                        object = string2;
                    }
                }
                return object;
            }
        };
        this.myReferenceConverters = refConvertorArray;
    }

    @NotNull
    protected AbstractExternalFilter.RefConvertor[] getRefConverters() {
        return this.myReferenceConverters;
    }

    @Nls
    @Nullable
    public String getExternalDocInfoForElement(@NotNull String elementDocUrl, @NotNull PsiElement element) throws Exception {
        String string;
        Intrinsics.checkNotNullParameter((Object)elementDocUrl, (String)"elementDocUrl");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.myCurrentProcessingElement = element;
        String string2 = this.tryGetDocFromBuiltInServer(elementDocUrl);
        if (string2 == null) {
            string2 = super.getExternalDocInfoForElement(elementDocUrl, element);
        }
        String externalDoc = string2;
        this.myCurrentProcessingElement = null;
        String string3 = externalDoc;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string = this.buildResultDocPage(elementDocUrl, this.generateSignature(element), it);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final String getExternalDocInfoForElement(@NotNull String elementDocUrl, @NotNull String javaDocPageHtml) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)elementDocUrl, (String)"elementDocUrl");
        Intrinsics.checkNotNullParameter((Object)javaDocPageHtml, (String)"javaDocPageHtml");
        String string = javaDocPageHtml;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] content = byArray;
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content);
        AbstractExternalFilter.MyReader contentReader = new AbstractExternalFilter.MyReader(contentStream, StandardCharsets.UTF_8.name());
        StringBuilder $this$getExternalDocInfoForElement_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Closeable closeable = (Closeable)contentReader;
        Throwable throwable = null;
        try {
            AbstractExternalFilter.MyReader reader = (AbstractExternalFilter.MyReader)closeable;
            boolean bl2 = false;
            this.doBuildFromStream(elementDocUrl, (Reader)reader, $this$getExternalDocInfoForElement_u24lambda_u241);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String parsedDocs = stringBuilder.toString();
        String string2 = this.correctDocText(elementDocUrl, parsedDocs);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"correctDocText(...)");
        return string2;
    }

    @Nls
    private final String buildResultDocPage(String elementDocUrl, String elementSignature, String elementDoc) {
        String string;
        Object object;
        block5: {
            block4: {
                object = VfsUtilCore.convertToURL((String)elementDocUrl);
                if (object == null) break block4;
                URL it = object;
                boolean bl = false;
                String string2 = "<base href=\"" + it + "\">";
                object = string2;
                if (string2 != null) break block5;
            }
            object = "";
        }
        if ((string = elementSignature) == null) {
            string = "";
        }
        String result2 = StringsKt.trimIndent((String)("\n                <html>\n                <head>\n                  " + (String)object + "\n                  <style type=\"text/css\">\n                    ul.inheritance {\n                      margin: 0;\n                      padding: 0;\n                    }\n                    ul.inheritance li {\n                      display: inline;\n                      list-style-type: none;\n                    }\n                    ul.inheritance li ul.inheritance {\n                      margin-left: 15px;\n                      padding-left: 15px;\n                      padding-top: 1px;\n                    }\n                    .definition { \n                      padding: 0 0 5px 0;\n                      margin: 0 0 5px 0;\n                      border-bottom: thin solid #c8cac0; \n                    }\n                  </style>\n                </head>\n    \n                <body>\n                  " + string + "\n                  " + elementDoc + "\n                </body>\n                </html>\n            "));
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String generateSignature(PsiElement element) {
        String string = (String)ActionsKt.runReadAction(() -> KotlinDocExtractorFromJavaDoc.generateSignature$lambda$0(element));
        if (string == null) return null;
        String it = string;
        boolean bl = false;
        Document document = Jsoup.parse((String)it);
        if (document == null) return null;
        Elements elements = document.getElementsByClass("definition");
        if (elements == null) return null;
        Element element2 = elements.first();
        if (element2 == null) return null;
        String string2 = element2.outerHtml();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NlsSafe
    private final String tryGetDocFromBuiltInServer(String elementDocUrl) {
        StringBuilder stringBuilder;
        Object it;
        String projectPath = "/" + this.project.getName() + "/";
        String urlToBuiltInServer = "http://localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() + projectPath;
        if (!StringsKt.startsWith$default((String)elementDocUrl, (String)urlToBuiltInServer, (boolean)false, (int)2, null)) {
            return null;
        }
        Url url = Urls.parseFromIdea((CharSequence)elementDocUrl);
        if (url == null) {
            return null;
        }
        Url url2 = url;
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(this.project);
        String string = url2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Object object = string;
        int n = projectPath.length();
        String string2 = ((String)object).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        VirtualFile virtualFile = WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string2, (boolean)false, null, (int)6, null);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        object = file.getInputStream();
        Throwable throwable = null;
        try {
            it = (InputStream)object;
            boolean bl = false;
            it = ((InputStream)it).readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object content = it;
        ByteArrayInputStream contentStream = new ByteArrayInputStream((byte[])content);
        AbstractExternalFilter.MyReader contentReader = new AbstractExternalFilter.MyReader(contentStream, StandardCharsets.UTF_8.name());
        StringBuilder $this$tryGetDocFromBuiltInServer_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Closeable closeable = (Closeable)contentReader;
        Throwable throwable3 = null;
        try {
            AbstractExternalFilter.MyReader reader = (AbstractExternalFilter.MyReader)closeable;
            boolean bl2 = false;
            this.doBuildFromStream(elementDocUrl, (Reader)reader, $this$tryGetDocFromBuiltInServer_u24lambda_u241);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable3);
        }
        String parsedDocs = stringBuilder.toString();
        return this.correctDocText(elementDocUrl, parsedDocs);
    }

    /*
     * WARNING - void declaration
     */
    protected void doBuildFromStream(@NotNull String url, @NotNull Reader input, @NotNull StringBuilder data) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(input instanceof AbstractExternalFilter.MyReader)) {
            return;
        }
        Document document = Jsoup.parse((InputStream)((AbstractExternalFilter.MyReader)input).getInputStream(), (String)((AbstractExternalFilter.MyReader)input).getEncoding(), (String)url);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document root = document;
        String anchor = StringsKt.substringAfterLast((String)url, (String)"#", (String)"");
        if (StringsKt.isBlank((CharSequence)anchor)) {
            String string = KotlinExternalDocsKt.access$findClassDescriptionFromRoot((Element)root);
            if (string == null) {
                string = "";
            }
            v2 = data.append(string);
        } else {
            String elementDescription;
            String string;
            String string2;
            List anchors = KotlinExternalDocsKt.access$findAnchors((Element)root, anchor);
            if (anchors.size() == 1) {
                Element it = (Element)CollectionsKt.single((List)anchors);
                boolean bl = false;
                string2 = KotlinExternalDocsKt.findClassMemberElementDescriptionFromAnchor$default(it, false, 1, null);
                if (string2 == null) {
                    string2 = KotlinExternalDocsKt.access$findEnumEntryDescriptionFromAnchor(it);
                }
            } else {
                String result2;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = anchors;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    Element it = (Element)element$iv$iv;
                    boolean bl2 = false;
                    if (KotlinExternalDocsKt.access$findClassMemberElementDescriptionFromAnchor(it, true) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List overloads = (List)destination$iv$iv;
                string2 = result2 = StringsKt.trimIndent((String)("\n                        <h3 style=\"margin-bottom: 0; font-weight: bold;\">Found " + overloads.size() + " overloads:</h3>\n                        <ol>\n                           " + CollectionsKt.joinToString$default((Iterable)overloads, (CharSequence)"\n\n", null, null, (int)0, null, KotlinDocExtractorFromJavaDoc::doBuildFromStream$lambda$2, (int)30, null) + "\n                        </ol>\n                    "));
            }
            if ((string = (elementDescription = string2)) == null) {
                string = "";
            }
            v2 = data.append(string);
        }
    }

    private static final String generateSignature$lambda$0(PsiElement $element) {
        return new KotlinDocumentationProvider().generateDoc($element, null);
    }

    private static final CharSequence doBuildFromStream$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "<li style='margin: 0 0 8px 0;'>" + it + "</li>";
    }

    public static final /* synthetic */ PsiElement access$getMyCurrentProcessingElement$p(KotlinDocExtractorFromJavaDoc $this) {
        return $this.myCurrentProcessingElement;
    }

    public static final /* synthetic */ Pattern access$getOurHtmlFileSuffix$p$s-679781371() {
        return AbstractExternalFilter.ourHtmlFileSuffix;
    }

    public static final /* synthetic */ String access$doAnnihilate$s-679781371(String p0) {
        return AbstractExternalFilter.doAnnihilate((String)p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KotlinDocExtractorFromJavaDoc$Companion;", "", "<init>", "()V", "HREF_REGEXP", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

