/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.CapturedAsFieldValueData;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.CapturedValuesSearcherKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ExistingVariable;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ExistingVariables;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.LabeledThisData;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ThisLabelUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "", "<init>", "()V", "addTo", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "Ordinary", "This", "Container", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$This;", "intellij.kotlin.jvm.debugger.core"})
abstract sealed class PendingValue {
    private PendingValue() {
    }

    @Nullable
    public abstract DescriptorData<? extends ValueDescriptorImpl> addTo(@NotNull ExistingVariables var1);

    public /* synthetic */ PendingValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tJ\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\u0018\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "value", "Lcom/sun/jdi/ObjectReference;", "<init>", "(Lcom/sun/jdi/ObjectReference;)V", "getValue", "()Lcom/sun/jdi/ObjectReference;", "getChildren", "", "isApplicable", "", "Lcom/sun/jdi/Field;", "addTo", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "intellij.kotlin.jvm.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCapturedValuesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedValuesSearcher.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n774#2:135\n865#2,2:136\n1617#2,9:138\n1869#2:147\n1870#2:149\n1626#2:150\n1#3:148\n*S KotlinDebug\n*F\n+ 1 CapturedValuesSearcher.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container\n*L\n50#1:135\n50#1:136,2\n51#1:138,9\n51#1:147\n51#1:149\n51#1:150\n51#1:148\n*E\n"})
    public static final class Container
    extends PendingValue {
        @NotNull
        private final ObjectReference value;

        public Container(@NotNull ObjectReference value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final ObjectReference getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PendingValue> getChildren() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            ReferenceType referenceType = this.value.referenceType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"referenceType(...)");
            Iterable $this$filter$iv = SafeUtilKt.safeFields(referenceType);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!this.isApplicable(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PendingValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Field it = (Field)element$iv$iv;
                boolean bl2 = false;
                if (CapturedValuesSearcherKt.access$createPendingValue(this, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isApplicable(Field $this$isApplicable) {
            String name2 = $this$isApplicable.name();
            Intrinsics.checkNotNull((Object)name2);
            return StringsKt.startsWith$default((String)name2, (String)"$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"this$0");
        }

        @Override
        @NotNull
        public DescriptorData<? extends ValueDescriptorImpl> addTo(@NotNull ExistingVariables existingVariables) {
            Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
            throw new IllegalStateException("Should not be called on a container");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "name", "", "field", "Lcom/sun/jdi/Field;", "container", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "<init>", "(Ljava/lang/String;Lcom/sun/jdi/Field;Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;)V", "getName", "()Ljava/lang/String;", "getField", "()Lcom/sun/jdi/Field;", "getContainer", "()Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "addTo", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/CapturedAsFieldValueData;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "intellij.kotlin.jvm.debugger.core"})
    public static final class Ordinary
    extends PendingValue {
        @NotNull
        private final String name;
        @NotNull
        private final Field field;
        @NotNull
        private final Container container;

        public Ordinary(@NotNull String name2, @NotNull Field field2, @NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            super(null);
            this.name = name2;
            this.field = field2;
            this.container = container;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @NotNull
        public final Container getContainer() {
            return this.container;
        }

        @Nullable
        public CapturedAsFieldValueData addTo(@NotNull ExistingVariables existingVariables) {
            Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
            if (!existingVariables.add(new ExistingVariable.Ordinary(this.name))) {
                return null;
            }
            return new CapturedAsFieldValueData(this.name, this.container.getValue(), this.field);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$This;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "label", "", "value", "Lcom/sun/jdi/Value;", "<init>", "(Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getLabel", "()Ljava/lang/String;", "getValue", "()Lcom/sun/jdi/Value;", "addTo", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "intellij.kotlin.jvm.debugger.core"})
    public static final class This
    extends PendingValue {
        @NotNull
        private final String label;
        @Nullable
        private final Value value;

        public This(@NotNull String label2, @Nullable Value value) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            super(null);
            this.label = label2;
            this.value = value;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public DescriptorData<? extends ValueDescriptorImpl> addTo(@NotNull ExistingVariables existingVariables) {
            String string;
            Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
            if (existingVariables.getHasThisVariables()) {
                if (!existingVariables.add(new ExistingVariable.LabeledThis(this.label))) {
                    return null;
                }
                string = ThisLabelUtilsKt.getThisName(this.label);
            } else {
                if (!existingVariables.add(new ExistingVariable.LabeledThis(this.label))) {
                    return null;
                }
                string = "this";
            }
            String thisName = string;
            return new LabeledThisData(this.label, thisName, this.value);
        }
    }
}

