/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinAllFilesScopeProvider;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinAllFilesScopeProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getAllKotlinFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Companion", "intellij.kotlin.jvm.debugger.base.util"})
public final class KotlinAllFilesScopeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public KotlinAllFilesScopeProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final GlobalSearchScope getAllKotlinFilesScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        GlobalSearchScope globalSearchScope2 = KotlinSourceFilterScope.Companion.projectAndLibrarySources(globalSearchScope, this.project);
        return (GlobalSearchScope)new DelegatingGlobalSearchScope(this, globalSearchScope2){
            private final ProjectFileIndex projectIndex;
            private final Comparator<VirtualFile> scopeComparator;
            {
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)KotlinAllFilesScopeProvider.access$getProject$p($receiver)).getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
                this.projectIndex = projectFileIndex;
                this.scopeComparator = ((Comparator)new Comparator(this){
                    final /* synthetic */ getAllKotlinFilesScope.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final int compare(T a, T b) {
                        VirtualFile it = (VirtualFile)a;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(getAllKotlinFilesScope.1.access$getProjectIndex$p(this.this$0).isInSourceContent(it));
                        it = (VirtualFile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(getAllKotlinFilesScope.1.access$getProjectIndex$p(this.this$0).isInSourceContent(it)));
                    }
                }).thenComparing(arg_0 -> getAllKotlinFilesScope.1.scopeComparator$lambda$2(arg_0 -> getAllKotlinFilesScope.1.scopeComparator$lambda$1(this, arg_0), arg_0)).thenComparing((arg_0, arg_1) -> getAllKotlinFilesScope.1.scopeComparator$lambda$4((arg_0, arg_1) -> getAllKotlinFilesScope.1.scopeComparator$lambda$3(this, arg_0, arg_1), arg_0, arg_1));
            }

            public int compare(VirtualFile file1, VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
                return this.scopeComparator.compare(file1, file2);
            }

            private static final Boolean scopeComparator$lambda$1(getAllKotlinFilesScope.1 this$0, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this$0.projectIndex.isInLibrarySource(file);
            }

            private static final Boolean scopeComparator$lambda$2(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final int scopeComparator$lambda$3(getAllKotlinFilesScope.1 this$0, VirtualFile file1, VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
                return super.compare(file1, file2);
            }

            private static final int scopeComparator$lambda$4(Function2 $tmp0, Object p0, Object p1) {
                return ((Number)$tmp0.invoke(p0, p1)).intValue();
            }

            public static final /* synthetic */ ProjectFileIndex access$getProjectIndex$p(getAllKotlinFilesScope.1 $this) {
                return $this.projectIndex;
            }
        };
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinAllFilesScopeProvider $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinAllFilesScopeProvider$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinAllFilesScopeProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jvm.debugger.base.util"})
    @SourceDebugExtension(value={"SMAP\nKotlinAllFilesScopeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAllFilesScopeProvider.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinAllFilesScopeProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,31:1\n30#2,2:32\n*S KotlinDebug\n*F\n+ 1 KotlinAllFilesScopeProvider.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinAllFilesScopeProvider$Companion\n*L\n16#1:32,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinAllFilesScopeProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinAllFilesScopeProvider> serviceClass$iv = KotlinAllFilesScopeProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinAllFilesScopeProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

