/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00050\nj\b\u0012\u0004\u0012\u00020\u0005`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "groupDisplayId", "", "title", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "messages", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addMessage", "message", "showNotification", "", "resultMessage", "getResultMessage", "()Ljava/lang/String;", "Companion", "intellij.kotlin.projectConfiguration"})
public final class NotificationMessageCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String groupDisplayId;
    @NotNull
    private final String title;
    @NotNull
    private final ArrayList<String> messages;

    public NotificationMessageCollector(@NotNull Project project, @NotNull String groupDisplayId, @NlsContexts.NotificationTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)groupDisplayId, (String)"groupDisplayId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.project = project;
        this.groupDisplayId = groupDisplayId;
        this.title = title;
        this.messages = new ArrayList();
    }

    @NotNull
    public final NotificationMessageCollector addMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messages.add(message2);
        return this;
    }

    public final void showNotification() {
        if (this.messages.isEmpty()) {
            return;
        }
        Notifications.Bus.notify((Notification)new Notification(this.groupDisplayId, this.title, this.getResultMessage(), NotificationType.INFORMATION), (Project)this.project);
    }

    private final String getResultMessage() {
        String singleMessage = (String)CollectionsKt.singleOrNull((List)this.messages);
        if (singleMessage != null) {
            return singleMessage;
        }
        return CollectionsKt.joinToString$default((Iterable)this.messages, (CharSequence)"<br/><br/>", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmStatic
    @NotNull
    public static final NotificationMessageCollector create(@NotNull Project project) {
        return Companion.create(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.projectConfiguration"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NotificationMessageCollector create(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logShowConfiguredKtNotification(project);
            String title = KotlinProjectConfigurationBundle.message("configure.kotlin", new Object[0]);
            return new NotificationMessageCollector(project, "Configure Kotlin", title);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

