/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001e2\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0007H$R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ/\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H$R\u00020\bR\u00020\rj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J+\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0002R\u00020\bR\u00020\rj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\u0007H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "isWholeReflectionApiAvailable", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "report", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "isAllowedKClassMember", "name", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/Name;)Z", "check", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "isAllowedReflectionApi", "containingClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/ClassId;)Z", "isReflectionSource", "Companion", "checkers"})
@SourceDebugExtension(value={"SMAP\nAbstractFirReflectionApiCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirReflectionApiCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1661#2,3:102\n1661#2,3:105\n1661#2,3:108\n*S KotlinDebug\n*F\n+ 1 AbstractFirReflectionApiCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker\n*L\n90#1:102,3\n93#1:105,3\n96#1:108,3\n*E\n"})
public abstract class AbstractFirReflectionApiCallChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final ClassId K_CLASS;
    @NotNull
    private static final Name K_CLASS_SIMPLE_NAME;
    @NotNull
    private static final Name K_CLASS_IS_INSTANCE;
    @NotNull
    private static final Name K_CLASS_QUALIFIED_NAME;
    @NotNull
    private static final Name K_CLASS_IS_INTERFACE_NAME;
    @NotNull
    private static final Set<ClassId> K_PROPERTY_CLASSES;
    @NotNull
    private static final Set<Name> ALLOWED_MEMBER_NAMES;
    @NotNull
    private static final Set<ClassId> ALLOWED_CLASSES;

    public AbstractFirReflectionApiCallChecker() {
        super(MppCheckerKind.Common);
    }

    protected abstract boolean isWholeReflectionApiAvailable(@NotNull CheckerContext var1);

    protected abstract void report(@NotNull CheckerContext var1, @NotNull DiagnosticReporter var2, @Nullable KtSourceElement var3);

    protected boolean isAllowedKClassMember(@NotNull CheckerContext context2, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Name name3 = name2;
        return Intrinsics.areEqual((Object)name3, (Object)K_CLASS_SIMPLE_NAME) || Intrinsics.areEqual((Object)name3, (Object)K_CLASS_IS_INSTANCE) ? true : (Intrinsics.areEqual((Object)name3, (Object)K_CLASS_QUALIFIED_NAME) ? (Boolean)context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass()) : false);
    }

    @Override
    public final void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression) {
        ClassId containingClassId;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isWholeReflectionApiAvailable(context2)) {
            return;
        }
        if (this.isReflectionSource(context2)) {
            return;
        }
        FirReference firReference = ReferenceUtilsKt.toReference(expression, context2.getSession());
        if (firReference == null || (firReference = FirReferenceUtilsKt.getResolved(firReference)) == null) {
            return;
        }
        FirReference resolvedReference = firReference;
        FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)resolvedReference).getResolvedSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol referencedSymbol = firCallableSymbol;
        Object object = expression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)expression : null;
        ClassId classId = object != null && (object = ((FirQualifiedAccessExpression)object).getDispatchReceiver()) != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? FirHelpersKt.fullyExpandedClassId((ConeKotlinType)object, context2.getSession()) : (containingClassId = null);
        if (containingClassId == null || !Intrinsics.areEqual((Object)containingClassId.getPackageFqName(), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME)) {
            return;
        }
        if (!this.isAllowedReflectionApi(context2, referencedSymbol.getName(), containingClassId)) {
            KtSourceElement ktSourceElement = ((FirResolvedNamedReference)resolvedReference).getSource();
            if (ktSourceElement == null) {
                ktSourceElement = ((FirQualifiedAccessExpression)expression).getSource();
            }
            this.report(context2, reporter, ktSourceElement);
        }
    }

    protected boolean isAllowedReflectionApi(@NotNull CheckerContext context2, @NotNull Name name2, @NotNull ClassId containingClassId) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)containingClassId, (String)"containingClassId");
        return ALLOWED_MEMBER_NAMES.contains(name2) || Intrinsics.areEqual((Object)containingClassId, (Object)K_CLASS) && this.isAllowedKClassMember(context2, name2) || (Intrinsics.areEqual((Object)name2.asString(), (Object)"get") || Intrinsics.areEqual((Object)name2.asString(), (Object)"set")) && K_PROPERTY_CLASSES.contains(containingClassId) || ALLOWED_CLASSES.contains(containingClassId);
    }

    private final boolean isReflectionSource(CheckerContext context2) {
        FirFileSymbol containingFile = context2.getContainingFileSymbol();
        return containingFile != null && UtilsKt.getPackageFqName(containingFile).startsWith(StandardNames.KOTLIN_REFLECT_FQ_NAME);
    }

    @NotNull
    protected static final Name getK_CLASS_IS_INTERFACE_NAME() {
        return Companion.getK_CLASS_IS_INTERFACE_NAME();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        String p0;
        String it;
        Collection collection;
        Object item$iv;
        Object $this$mapTo$iv;
        Companion = new Companion(null);
        K_CLASS = ClassId.Companion.topLevel(StandardNames.FqNames.kClass.toSafe());
        Name name2 = Name.identifier((String)"simpleName");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        K_CLASS_SIMPLE_NAME = name2;
        Name name3 = Name.identifier((String)"isInstance");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        K_CLASS_IS_INSTANCE = name3;
        Name name4 = Name.identifier((String)"qualifiedName");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        K_CLASS_QUALIFIED_NAME = name4;
        Name name5 = Name.identifier((String)"isInterface");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        K_CLASS_IS_INTERFACE_NAME = name5;
        Object object = new FqNameUnsafe[]{StandardNames.FqNames.kProperty0, StandardNames.FqNames.kProperty1, StandardNames.FqNames.kProperty2, StandardNames.FqNames.kMutableProperty0, StandardNames.FqNames.kMutableProperty1, StandardNames.FqNames.kMutableProperty2};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            FqNameUnsafe fqNameUnsafe = (FqNameUnsafe)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(ClassId.Companion.topLevel(it.toSafe()));
        }
        K_PROPERTY_CLASSES = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"equals", "hashCode", "toString", "invoke", "name"};
        $this$mapTo$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            it = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(Name.identifier((String)p0));
        }
        ALLOWED_MEMBER_NAMES = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"KType", "KTypeParameter", "KTypeProjection", "KTypeProjection.Companion", "KVariance"};
        $this$mapTo$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            p0 = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new ClassId(StandardNames.KOTLIN_REFLECT_FQ_NAME, new FqName(it), false));
        }
        ALLOWED_CLASSES = (Set)var1_1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker$Companion;", "", "<init>", "()V", "K_CLASS", "Lorg/jetbrains/kotlin/name/ClassId;", "K_CLASS_SIMPLE_NAME", "Lorg/jetbrains/kotlin/name/Name;", "K_CLASS_IS_INSTANCE", "K_CLASS_QUALIFIED_NAME", "K_CLASS_IS_INTERFACE_NAME", "getK_CLASS_IS_INTERFACE_NAME$annotations", "getK_CLASS_IS_INTERFACE_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "K_PROPERTY_CLASSES", "", "ALLOWED_MEMBER_NAMES", "ALLOWED_CLASSES", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Name getK_CLASS_IS_INTERFACE_NAME() {
            return K_CLASS_IS_INTERFACE_NAME;
        }

        @JvmStatic
        protected static /* synthetic */ void getK_CLASS_IS_INTERFACE_NAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

