/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.base.fe10.analysis.decompiler.konan;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibLoadingMetadataCache;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImpl;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.PackageAccessHandler;
import org.jetbrains.kotlin.metadata.ProtoBuf;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u001c\u0010\u001c\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u0010*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/base/fe10/analysis/decompiler/konan/CachingIdeKlibMetadataLoader;", "Lorg/jetbrains/kotlin/library/metadata/PackageAccessHandler;", "<init>", "()V", "loadModuleHeader", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "loadPackageFragment", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "packageFqName", "", "partName", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "asJarFileSystemFile", "jarFile", "localFile", "asLocalFile", "cache", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache;", "getCache", "()Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache;", "moduleHeaderFile", "getModuleHeaderFile", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Lorg/jetbrains/kotlin/konan/file/File;", "packageFragmentFile", "isZipped", "", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Z", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nCachingIdeKlibMetadataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingIdeKlibMetadataLoader.kt\norg/jetbrains/kotlin/base/fe10/analysis/decompiler/konan/CachingIdeKlibMetadataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class CachingIdeKlibMetadataLoader
implements PackageAccessHandler {
    @NotNull
    public static final CachingIdeKlibMetadataLoader INSTANCE = new CachingIdeKlibMetadataLoader();

    private CachingIdeKlibMetadataLoader() {
    }

    @NotNull
    public KlibMetadataProtoBuf.Header loadModuleHeader(@NotNull KotlinLibrary library) {
        VirtualFile virtualFile;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                VirtualFile virtualFile2 = this.getVirtualFile(library, this.getModuleHeaderFile(library));
                virtualFile = virtualFile2;
                if (virtualFile == null) break block2;
                VirtualFile it = virtualFile;
                boolean bl = false;
                KlibMetadataProtoBuf.Header header = INSTANCE.getCache().getCachedModuleHeader(virtualFile2);
                virtualFile = header;
                if (header != null) break block3;
            }
            KlibMetadataProtoBuf.Header header = KlibMetadataProtoBuf.Header.getDefaultInstance();
            virtualFile = header;
            Intrinsics.checkNotNullExpressionValue((Object)header, (String)"getDefaultInstance(...)");
        }
        return virtualFile;
    }

    @NotNull
    public ProtoBuf.PackageFragment loadPackageFragment(@NotNull KotlinLibrary library, @NotNull String packageFqName, @NotNull String partName) {
        VirtualFile virtualFile;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
                VirtualFile virtualFile2 = this.getVirtualFile(library, this.packageFragmentFile(library, packageFqName, partName));
                virtualFile = virtualFile2;
                if (virtualFile == null) break block2;
                VirtualFile it = virtualFile;
                boolean bl = false;
                ProtoBuf.PackageFragment packageFragment2 = INSTANCE.getCache().getCachedPackageFragment(virtualFile2);
                virtualFile = packageFragment2;
                if (packageFragment2 != null) break block3;
            }
            ProtoBuf.PackageFragment packageFragment3 = ProtoBuf.PackageFragment.getDefaultInstance();
            virtualFile = packageFragment3;
            Intrinsics.checkNotNullExpressionValue((Object)packageFragment3, (String)"getDefaultInstance(...)");
        }
        return virtualFile;
    }

    private final VirtualFile getVirtualFile(KotlinLibrary library, File file) {
        return this.isZipped(library) ? this.asJarFileSystemFile(library.getLibraryFile(), file) : this.asLocalFile(file);
    }

    private final VirtualFile asJarFileSystemFile(File jarFile, File localFile) {
        String fullPath = jarFile.getAbsolutePath() + "!" + PathUtil.toSystemIndependentName((String)localFile.getPath());
        return StandardFileSystems.jar().findFileByPath(fullPath);
    }

    private final VirtualFile asLocalFile(File localFile) {
        String fullPath = localFile.getAbsolutePath();
        return StandardFileSystems.local().findFileByPath(fullPath);
    }

    private final KlibLoadingMetadataCache getCache() {
        return KlibLoadingMetadataCache.Companion.getInstance();
    }

    private final File getModuleHeaderFile(KotlinLibrary $this$moduleHeaderFile) {
        Intrinsics.checkNotNull((Object)$this$moduleHeaderFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        return ((KotlinLibraryImpl)$this$moduleHeaderFile).getMetadata().getAccess().getLayout().getModuleHeaderFile();
    }

    private final File packageFragmentFile(KotlinLibrary $this$packageFragmentFile, String packageFqName, String partName) {
        Intrinsics.checkNotNull((Object)$this$packageFragmentFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        return ((KotlinLibraryImpl)$this$packageFragmentFile).getMetadata().getAccess().getLayout().packageFragmentFile(packageFqName, partName);
    }

    private final boolean isZipped(KotlinLibrary $this$isZipped) {
        Intrinsics.checkNotNull((Object)$this$isZipped, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        return ((KotlinLibraryImpl)$this$isZipped).getBase().getAccess().getLayout().isZipped();
    }
}

