/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.transformers.PartialBodyAnalysisSuspendedException;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPhaseEventCompleter;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Name(value="org.jetbrains.kotlin.LLPhase")
@Category(value={"Kotlin Code Analysis"})
@Label(value="Kotlin Declaration Phase Execution")
@Description(value="A Kotlin declaration is analyzed to the specified FIR resolution phase (either successfully or with an error)")
@StackTrace(value=false)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLPhaseEvent;", "Ljdk/jfr/Event;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLPhaseEventCompleter;", "path", "", "hash", "", "phase", "", "moduleKind", "<init>", "(Ljava/lang/String;IBB)V", "result", "notifyCompleted", "", "notifyCompletedWithFailure", "throwable", "", "low-level-api-fir"})
final class LLPhaseEvent
extends Event
implements LLPhaseEventCompleter {
    @Label(value="Designation Path")
    @NotNull
    private final String path;
    @Label(value="Declaration Hash")
    private final int hash;
    @Label(value="Phase")
    private final byte phase;
    @Label(value="Module Kind")
    private final byte moduleKind;
    @Label(value="Execution Result")
    @Description(value="0 - Success, 1 - Cancellation, 2 - Exception")
    private byte result;

    public LLPhaseEvent(@NotNull String path2, int hash, byte phase, byte moduleKind) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2;
        this.hash = hash;
        this.phase = phase;
        this.moduleKind = moduleKind;
        this.result = (byte)-1;
    }

    @Override
    public void notifyCompleted() {
        this.result = 0;
        this.end();
        this.commit();
    }

    @Override
    public void notifyCompletedWithFailure(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.result = throwable instanceof PartialBodyAnalysisSuspendedException ? 0 : (PlatformExceptionUtilsKt.shouldIjPlatformExceptionBeRethrown((Throwable)throwable) ? 1 : 2);
        this.end();
        this.commit();
    }
}

