/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a)\u0010\b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0082\b\u001a)\u0010\u000e\u001a\u00020\n*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0082\b\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"canParse", "", "Lkotlin/time/Duration$Companion;", "value", "", "javaDurationCanParse", "isoDurationRegex", "Lkotlin/text/Regex;", "substringWhile", "startIndex", "", "predicate", "Lkotlin/Function1;", "", "skipWhile", "durationUnitByIsoCharOrNull", "Lkotlin/time/DurationUnit;", "isoChar", "isTimeComponent", "durationUnitByShortNameOrNull", "shortName", "core"})
@SourceDebugExtension(value={"SMAP\nCanParseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanParseUtils.kt\norg/jetbrains/kotlinx/dataframe/impl/CanParseUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n105#1,9:153\n111#1,3:163\n105#1,9:166\n105#1,9:175\n111#1,3:184\n1#2:162\n*S KotlinDebug\n*F\n+ 1 CanParseUtils.kt\norg/jetbrains/kotlinx/dataframe/impl/CanParseUtilsKt\n*L\n37#1:153,9\n67#1:163,3\n70#1:166,9\n73#1:175,9\n105#1:184,3\n*E\n"})
public final class CanParseUtilsKt {
    @NotNull
    private static final Regex isoDurationRegex = new Regex("([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", RegexOption.IGNORE_CASE);

    /*
     * WARNING - void declaration
     */
    public static final boolean canParse(@NotNull Duration.Companion $this$canParse, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$canParse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int length = value.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        String infinityString = "Infinity";
        switch (value.charAt(index)) {
            case '+': 
            case '-': {
                ++index;
            }
        }
        boolean hasSign = index > 0;
        if (length <= index) {
            return false;
        }
        if (value.charAt(index) == 'P') {
            if (++index == length) {
                return false;
            }
            String nonDigitSymbols = "+-.";
            boolean isTimeComponent = false;
            DurationUnit prevUnit = null;
            while (index < length) {
                DurationUnit unit;
                String component;
                void $this$skipWhile$iv$iv2;
                int i$iv$iv;
                void $this$substringWhile$iv;
                if (value.charAt(index) == 'T') {
                    if (isTimeComponent || ++index == length) {
                        return false;
                    }
                    isTimeComponent = true;
                    continue;
                }
                String string = value;
                int startIndex$iv22 = index;
                boolean $i$f$substringWhile = false;
                void var13_26 = $this$substringWhile$iv;
                void var14_31 = $this$substringWhile$iv;
                int startIndex$iv$iv = startIndex$iv22;
                boolean $i$f$skipWhile = false;
                for (i$iv$iv = startIndex$iv$iv; i$iv$iv < $this$skipWhile$iv$iv2.length(); ++i$iv$iv) {
                    char it = $this$skipWhile$iv$iv2.charAt(i$iv$iv);
                    boolean bl = false;
                    boolean bl2 = '0' <= it ? it < ':' : false;
                    if (!(bl2 || StringsKt.contains$default((CharSequence)nonDigitSymbols, (char)it, (boolean)false, (int)2, null))) break;
                }
                int $this$skipWhile$iv$iv2 = i$iv$iv;
                Intrinsics.checkNotNullExpressionValue((Object)var13_26.substring(startIndex$iv22, $this$skipWhile$iv$iv2), (String)"substring(...)");
                if (((CharSequence)component).length() == 0) {
                    return false;
                }
                CharSequence startIndex$iv22 = value;
                if (!(0 <= (index += component.length()) ? index < startIndex$iv22.length() : false)) {
                    int it = index;
                    boolean bl = false;
                    return false;
                }
                char unitChar = startIndex$iv22.charAt(index);
                ++index;
                if (CanParseUtilsKt.durationUnitByIsoCharOrNull(unitChar, isTimeComponent) == null) {
                    return false;
                }
                if (prevUnit != null && prevUnit.compareTo((Enum)unit) <= 0) {
                    return false;
                }
                prevUnit = unit;
            }
        } else {
            boolean allowSpaces;
            int nonDigitSymbols = length - index;
            int isTimeComponent = infinityString.length();
            if (StringsKt.regionMatches((String)value, (int)index, (String)infinityString, (int)0, (int)Math.max(nonDigitSymbols, isTimeComponent), (boolean)true)) {
                return true;
            }
            DurationUnit prevUnit = null;
            boolean afterFirst = false;
            boolean bl = allowSpaces = !hasSign;
            if (hasSign && value.charAt(index) == '(' && StringsKt.last((CharSequence)value) == ')') {
                allowSpaces = true;
                if (++index == --length) {
                    return false;
                }
            }
            while (index < length) {
                DurationUnit unit;
                String unitName;
                void $this$skipWhile$iv$iv;
                int i$iv$iv;
                void $this$substringWhile$iv;
                void $this$skipWhile$iv$iv3;
                int i$iv$iv2;
                void $this$substringWhile$iv2;
                String component;
                if (afterFirst && allowSpaces) {
                    void $this$skipWhile$iv;
                    int i$iv;
                    component = value;
                    int startIndex$iv = index;
                    boolean $i$f$skipWhile = false;
                    for (i$iv = startIndex$iv; i$iv < $this$skipWhile$iv.length(); ++i$iv) {
                        char it = $this$skipWhile$iv.charAt(i$iv);
                        boolean bl3 = false;
                        if (!(it == ' ')) break;
                    }
                    index = i$iv;
                }
                afterFirst = true;
                String startIndex$iv = value;
                int startIndex$iv32 = index;
                boolean $i$f$substringWhile = false;
                void it = $this$substringWhile$iv2;
                void bl3 = $this$substringWhile$iv2;
                int startIndex$iv$iv22 = startIndex$iv32;
                boolean $i$f$skipWhile = false;
                for (i$iv$iv2 = startIndex$iv$iv22; i$iv$iv2 < $this$skipWhile$iv$iv3.length(); ++i$iv$iv2) {
                    char it2 = $this$skipWhile$iv$iv3.charAt(i$iv$iv2);
                    boolean bl4 = false;
                    boolean bl5 = '0' <= it2 ? it2 < ':' : false;
                    if (!(bl5 || it2 == '.')) break;
                }
                int n = i$iv$iv2;
                Intrinsics.checkNotNullExpressionValue((Object)it.substring(startIndex$iv32, n), (String)"substring(...)");
                if (((CharSequence)component).length() == 0) {
                    return false;
                }
                String startIndex$iv32 = value;
                int startIndex$iv2 = index += component.length();
                boolean $i$f$substringWhile2 = false;
                void var14_32 = $this$substringWhile$iv;
                void startIndex$iv$iv22 = $this$substringWhile$iv;
                int startIndex$iv$iv = startIndex$iv2;
                boolean $i$f$skipWhile2 = false;
                for (i$iv$iv = startIndex$iv$iv; i$iv$iv < $this$skipWhile$iv$iv.length(); ++i$iv$iv) {
                    char it3 = $this$skipWhile$iv$iv.charAt(i$iv$iv);
                    boolean bl6 = false;
                    boolean bl7 = 'a' <= it3 ? it3 < '{' : false;
                    if (!bl7) break;
                }
                int n2 = i$iv$iv;
                Intrinsics.checkNotNullExpressionValue((Object)var14_32.substring(startIndex$iv2, n2), (String)"substring(...)");
                index += unitName.length();
                if (CanParseUtilsKt.durationUnitByShortNameOrNull(unitName) == null) {
                    return false;
                }
                if (prevUnit != null && prevUnit.compareTo((Enum)unit) <= 0) {
                    return false;
                }
                prevUnit = unit;
                int dotIndex = StringsKt.indexOf$default((CharSequence)component, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex <= 0 || index >= length) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean javaDurationCanParse(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return isoDurationRegex.matches((CharSequence)value);
    }

    /*
     * WARNING - void declaration
     */
    private static final String substringWhile(String $this$substringWhile, int startIndex, Function1<? super Character, Boolean> predicate) {
        void $this$skipWhile$iv;
        int i$iv;
        boolean $i$f$substringWhile = false;
        String string = $this$substringWhile;
        String string2 = $this$substringWhile;
        int startIndex$iv = startIndex;
        boolean $i$f$skipWhile = false;
        for (i$iv = startIndex$iv; i$iv < $this$skipWhile$iv.length() && ((Boolean)predicate.invoke((Object)Character.valueOf($this$skipWhile$iv.charAt(i$iv)))).booleanValue(); ++i$iv) {
        }
        int n = i$iv;
        String string3 = string.substring(startIndex, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    private static final int skipWhile(String $this$skipWhile, int startIndex, Function1<? super Character, Boolean> predicate) {
        int i;
        boolean $i$f$skipWhile = false;
        for (i = startIndex; i < $this$skipWhile.length() && ((Boolean)predicate.invoke((Object)Character.valueOf($this$skipWhile.charAt(i)))).booleanValue(); ++i) {
        }
        return i;
    }

    private static final DurationUnit durationUnitByIsoCharOrNull(char isoChar, boolean isTimeComponent) {
        Object object;
        if (!isTimeComponent) {
            object = isoChar == 'D' ? DurationUnit.DAYS : null;
        } else {
            switch (isoChar) {
                case 'H': {
                    object = DurationUnit.HOURS;
                    break;
                }
                case 'M': {
                    object = DurationUnit.MINUTES;
                    break;
                }
                case 'S': {
                    object = DurationUnit.SECONDS;
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    private static final DurationUnit durationUnitByShortNameOrNull(String shortName) {
        DurationUnit durationUnit;
        switch (shortName) {
            case "ns": {
                durationUnit = DurationUnit.NANOSECONDS;
                break;
            }
            case "us": {
                durationUnit = DurationUnit.MICROSECONDS;
                break;
            }
            case "ms": {
                durationUnit = DurationUnit.MILLISECONDS;
                break;
            }
            case "s": {
                durationUnit = DurationUnit.SECONDS;
                break;
            }
            case "m": {
                durationUnit = DurationUnit.MINUTES;
                break;
            }
            case "h": {
                durationUnit = DurationUnit.HOURS;
                break;
            }
            case "d": {
                durationUnit = DurationUnit.DAYS;
                break;
            }
            default: {
                durationUnit = null;
            }
        }
        return durationUnit;
    }
}

