/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy.reflection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010+\u001a\u00028\u00002\u0016\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0-\"\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010/J#\u00100\u001a\u00028\u00002\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010.01H\u0016\u00a2\u0006\u0002\u00102J\u0013\u0010;\u001a\u00020\u00132\b\u0010<\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u0010=\u001a\u00020\u000fH\u0016J\b\u0010>\u001a\u00020\u0019H\u0016J\f\u0010?\u001a\u00020\u0013*\u00020@H\u0002J\u000e\u0010A\u001a\u0004\u0018\u00010B*\u00020@H\u0002J\u0014\u0010C\u001a\u00020\u0013*\u00020@2\u0006\u0010<\u001a\u00020@H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010 R\u0016\u00103\u001a\u0004\u0018\u0001048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0014R\u0014\u00108\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0014R\u0014\u00109\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0014R\u0014\u0010:\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0014\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KFunctionProxy;", "R", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/ReflectionProxy;", "Lkotlin/reflect/KFunction;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "arity", "", "getArity", "()I", "isInline", "", "()Z", "isExternal", "isOperator", "isInfix", "name", "", "getName", "()Ljava/lang/String;", "annotations", "", "", "getAnnotations", "()Ljava/util/List;", "parameters", "Lkotlin/reflect/KParameter;", "getParameters", "returnType", "Lkotlin/reflect/KType;", "getReturnType", "()Lkotlin/reflect/KType;", "typeParameters", "Lkotlin/reflect/KTypeParameter;", "getTypeParameters", "call", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "callBy", "", "(Ljava/util/Map;)Ljava/lang/Object;", "visibility", "Lkotlin/reflect/KVisibility;", "getVisibility", "()Lkotlin/reflect/KVisibility;", "isFinal", "isOpen", "isAbstract", "isSuspend", "equals", "other", "hashCode", "toString", "isAdapter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getAdapteeCallSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "equalsByAdapteeCall", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nKFunctionProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KFunctionProxy.kt\norg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KFunctionProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1573#2:144\n1604#2,4:145\n*S KotlinDebug\n*F\n+ 1 KFunctionProxy.kt\norg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KFunctionProxy\n*L\n56#1:144\n56#1:145,4\n*E\n"})
public abstract class KFunctionProxy<R>
implements KFunction<R>,
ReflectionProxy {
    @NotNull
    private final KFunctionState state;
    @NotNull
    private final CallInterceptor callInterceptor;
    private final int arity;

    public KFunctionProxy(@NotNull KFunctionState state, @NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        this.state = state;
        this.callInterceptor = callInterceptor;
        Integer n2 = this.state.getArity();
        this.arity = n2 != null ? n2 : 23;
    }

    @Override
    @NotNull
    public final KFunctionState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public final CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    public final int getArity() {
        return this.arity;
    }

    @Override
    public boolean isInline() {
        return this.state.getIrFunction().isInline();
    }

    @Override
    public boolean isExternal() {
        return this.state.getIrFunction().isExternal();
    }

    @Override
    public boolean isOperator() {
        return this.state.getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.state.getIrFunction()).isOperator();
    }

    @Override
    public boolean isInfix() {
        return this.state.getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.state.getIrFunction()).isInfix();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.state.getIrFunction().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        return string;
    }

    @Override
    @NotNull
    public List<Annotation> getAnnotations() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public List<KParameter> getParameters() {
        return this.state.getParameters(this.callInterceptor);
    }

    @Override
    @NotNull
    public KType getReturnType() {
        return this.state.getReturnType(this.callInterceptor);
    }

    @Override
    @NotNull
    public List<KTypeParameter> getTypeParameters() {
        return this.state.getTypeParameters(this.callInterceptor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public R call(Object ... args) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(args, "args");
        IrFunction invokeFunction = this.state.getInvokeSymbol().getOwner();
        Iterable iterable = IrUtilsKt.getNonDispatchParameters(invokeFunction);
        Collection collection = CollectionsKt.listOf(this.state);
        boolean $i$f$mapIndexed = false;
        void var6_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parameter;
            void argIndex;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            int n3 = n2;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.getEnvironment().convertToState$ir_interpreter(args[argIndex], parameter.getType()));
        }
        List valueArguments = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        return (R)CallInterceptor.interceptProxy$default(this.callInterceptor, invokeFunction, valueArguments, null, 4, null);
    }

    @Override
    public R callBy(@NotNull Map<KParameter, ? extends Object> args) {
        Intrinsics.checkNotNullParameter(args, "args");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public KVisibility getVisibility() {
        return this.toKVisibility(this.state.getIrFunction().getVisibility());
    }

    @Override
    public boolean isFinal() {
        return this.state.getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.state.getIrFunction()).getModality() == Modality.FINAL;
    }

    @Override
    public boolean isOpen() {
        return this.state.getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.state.getIrFunction()).getModality() == Modality.OPEN;
    }

    @Override
    public boolean isAbstract() {
        return this.state.getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.state.getIrFunction()).getModality() == Modality.ABSTRACT;
    }

    @Override
    public boolean isSuspend() {
        return AdditionalIrUtilsKt.isSuspend(this.state.getIrFunction());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KFunctionProxy)) {
            return false;
        }
        if (this.arity != ((KFunctionProxy)other).arity || this.isSuspend() != ((KFunctionProxy)other).isSuspend()) {
            return false;
        }
        Object object = this.state.getFunInterface();
        if (Intrinsics.areEqual(object != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null && (object = (IrClass)object.getOwner()) != null ? object.getOrigin() : null, IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB())) {
            return this.state == ((KFunctionProxy)other).state;
        }
        if (!StateKt.hasTheSameFieldsWith(this.state, ((KFunctionProxy)other).state)) {
            return false;
        }
        return this.isAdapter(this.state.getIrFunction()) && this.isAdapter(((KFunctionProxy)other).state.getIrFunction()) ? this.equalsByAdapteeCall(this.state.getIrFunction(), ((KFunctionProxy)other).state.getIrFunction()) : Intrinsics.areEqual(this.state.getIrFunction(), ((KFunctionProxy)other).state.getIrFunction());
    }

    @Override
    public int hashCode() {
        int n2;
        if (this.isAdapter(this.state.getIrFunction())) {
            IrFunctionSymbol irFunctionSymbol = this.getAdapteeCallSymbol(this.state.getIrFunction());
            Intrinsics.checkNotNull(irFunctionSymbol);
            n2 = irFunctionSymbol.hashCode();
        } else {
            n2 = this.state.getIrFunction().hashCode();
        }
        return n2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.state.toString();
    }

    private final boolean isAdapter(IrFunction $this$isAdapter) {
        return Intrinsics.areEqual($this$isAdapter.getOrigin(), IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE());
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunctionSymbol getAdapteeCallSymbol(IrFunction $this$getAdapteeCallSymbol) {
        void var3_2;
        if (!this.isAdapter($this$getAdapteeCallSymbol)) {
            return null;
        }
        IrBody irBody = $this$getAdapteeCallSymbol.getBody();
        Intrinsics.checkNotNull(irBody);
        IrStatement statement = CollectionsKt.single(IrUtilsKt.getStatements(irBody));
        IrStatement call2 = statement instanceof IrTypeOperatorCall ? (IrStatement)((IrTypeOperatorCall)statement).getArgument() : (statement instanceof IrReturn ? (IrStatement)((IrReturn)statement).getValue() : var3_2);
        IrFunctionAccessExpression irFunctionAccessExpression = call2 instanceof IrFunctionAccessExpression ? (IrFunctionAccessExpression)call2 : null;
        return irFunctionAccessExpression != null ? (IrFunctionSymbol)irFunctionAccessExpression.getSymbol() : null;
    }

    private final boolean equalsByAdapteeCall(IrFunction $this$equalsByAdapteeCall, IrFunction other) {
        Pair<IrExpression, IrExpression> pair;
        if (!this.isAdapter($this$equalsByAdapteeCall) || !this.isAdapter(other)) {
            return false;
        }
        IrBody irBody = $this$equalsByAdapteeCall.getBody();
        Intrinsics.checkNotNull(irBody);
        IrStatement statement = CollectionsKt.single(IrUtilsKt.getStatements(irBody));
        IrBody irBody2 = other.getBody();
        Intrinsics.checkNotNull(irBody2);
        IrStatement otherStatement = CollectionsKt.single(IrUtilsKt.getStatements(irBody2));
        IrStatement irStatement = statement;
        if (irStatement instanceof IrTypeOperatorCall) {
            if (!(otherStatement instanceof IrTypeOperatorCall)) {
                return false;
            }
            pair = new Pair<IrExpression, IrExpression>(((IrTypeOperatorCall)statement).getArgument(), ((IrTypeOperatorCall)otherStatement).getArgument());
        } else if (irStatement instanceof IrReturn) {
            if (!(otherStatement instanceof IrReturn)) {
                return false;
            }
            pair = new Pair<IrExpression, IrExpression>(((IrReturn)statement).getValue(), ((IrReturn)otherStatement).getValue());
        } else {
            pair = new Pair<IrStatement, IrStatement>(statement, otherStatement);
        }
        Pair<IrExpression, IrExpression> pair2 = pair;
        IrStatement thisArg = (IrStatement)pair2.component1();
        IrStatement otherArg = pair2.component2();
        if (!(thisArg instanceof IrFunctionAccessExpression) || !(otherArg instanceof IrFunctionAccessExpression)) {
            return false;
        }
        return Intrinsics.areEqual(((IrFunctionAccessExpression)thisArg).getSymbol(), ((IrFunctionAccessExpression)otherArg).getSymbol());
    }
}

