/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.Cache;
import androidx.compose.ui.text.ExpireAfterAccessCache;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.SkiaBackedTypeface;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.platform.SystemFont;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontMgrWithFallback;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.TypefaceFontProviderWithFallback;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J+\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/ui/text/platform/FontCache;", "", "<init>", "()V", "fonts", "Lorg/jetbrains/skia/paragraph/FontCollection;", "getFonts$ui_text", "()Lorg/jetbrains/skia/paragraph/FontCollection;", "fontProvider", "Lorg/jetbrains/skia/paragraph/TypefaceFontProviderWithFallback;", "registered", "", "", "typefacesCache", "Landroidx/compose/ui/text/Cache;", "Lorg/jetbrains/skia/Typeface;", "load", "Landroidx/compose/ui/text/platform/FontLoadResult;", "font", "Landroidx/compose/ui/text/platform/PlatformFont;", "load$ui_text", "loadPlatformTypes", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "loadPlatformTypes-RetOiIg$ui_text", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/platform/FontLoadResult;", "ensureRegistered", "", "typeface", "key", "", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformFont.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n37#2,2:439\n440#3,2:441\n35#3,3:443\n39#3:447\n442#3:448\n1#4:446\n*S KotlinDebug\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n*L\n323#1:439,2\n336#1:441,2\n336#1:443,3\n336#1:447\n336#1:448\n336#1:446\n*E\n"})
public final class FontCache {
    @NotNull
    private final FontCollection fonts = new FontCollection();
    @NotNull
    private final TypefaceFontProviderWithFallback fontProvider = new TypefaceFontProviderWithFallback();
    @NotNull
    private final Set<String> registered = new HashSet();
    @NotNull
    private final Cache<String, Typeface> typefacesCache = new ExpireAfterAccessCache(60000000000L, null, 2, null);
    public static final int $stable = 8;

    public FontCache() {
        this.fonts.setDefaultFontManager((FontMgr)new FontMgrWithFallback(this.fontProvider));
        this.fonts.setAssetFontManager((FontMgr)this.fontProvider);
    }

    @NotNull
    public final FontCollection getFonts$ui_text() {
        return this.fonts;
    }

    @NotNull
    public final FontLoadResult load$ui_text(@NotNull PlatformFont font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Typeface typeface2 = this.typefacesCache.get(font.getCacheKey$ui_text(), (Function1<String, Typeface>)((Function1)arg_0 -> FontCache.load$lambda$0(font, arg_0)));
        this.ensureRegistered(typeface2, font.getCacheKey$ui_text());
        return new FontLoadResult(typeface2, CollectionsKt.listOf((Object)font.getCacheKey$ui_text()));
    }

    @NotNull
    public final FontLoadResult loadPlatformTypes-RetOiIg$ui_text(@NotNull FontFamily fontFamily, @NotNull FontWeight fontWeight, int n) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        List<String> aliases = this.ensureRegistered(fontFamily);
        org.jetbrains.skia.FontStyle style = SkiaParagraph_skikoKt.toSkFontStyle-nzbMABs(n).withWeight(fontWeight.getWeight());
        Collection $this$toTypedArray$iv = aliases;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FontLoadResult((Typeface)ArraysKt.first((Object[])this.fonts.findTypefaces(thisCollection$iv.toArray(new String[0]), style)), aliases);
    }

    public static /* synthetic */ FontLoadResult loadPlatformTypes-RetOiIg$ui_text$default(FontCache fontCache, FontFamily fontFamily, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return fontCache.loadPlatformTypes-RetOiIg$ui_text(fontFamily, fontWeight, n);
    }

    private final void ensureRegistered(Typeface typeface2, String key) {
        if (!this.registered.contains(key)) {
            this.fontProvider.registerTypeface(typeface2, key);
            this.registered.add(key);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<String> ensureRegistered(FontFamily fontFamily) {
        List list;
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            List<Font> $this$fastMapNotNull$iv = ((FontListFontFamily)fontFamily).getFonts();
            boolean $i$f$fastMapNotNull = false;
            ArrayList target$iv = new ArrayList($this$fastMapNotNull$iv.size());
            List<Font> $this$fastForEach$iv$iv = $this$fastMapNotNull$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                String it$iv;
                Font item$iv$iv;
                Font e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Font it = e$iv;
                boolean bl2 = false;
                if ((it instanceof SystemFont ? ((SystemFont)it).getIdentity() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                ((Collection)target$iv).add(it$iv);
            }
            List fonts = target$iv;
            if (fonts.size() != ((FontListFontFamily)fontFamily).getFonts().size()) throw new IllegalArgumentException("Don't load FontListFontFamily through ensureRegistered: " + fontFamily);
            list = fonts;
            return list;
        }
        if (fontFamily2 instanceof LoadedFontFamily) {
            androidx.compose.ui.text.font.Typeface typeface2 = ((LoadedFontFamily)fontFamily).getTypeface();
            Intrinsics.checkNotNull((Object)typeface2, (String)"null cannot be cast to non-null type androidx.compose.ui.text.platform.SkiaBackedTypeface");
            SkiaBackedTypeface typeface3 = (SkiaBackedTypeface)typeface2;
            this.ensureRegistered(typeface3.getNativeTypeface(), typeface3.getAlias());
            list = CollectionsKt.listOf((Object)typeface3.getAlias());
            return list;
        } else if (fontFamily2 instanceof GenericFontFamily) {
            list = PlatformFont_skikoKt.getAliases((GenericFontFamily)fontFamily);
            return list;
        } else {
            if (!(fontFamily2 instanceof DefaultFontFamily)) throw new NoWhenBranchMatchedException();
            list = PlatformFont_skikoKt.getAliases(FontFamily.Companion.getSansSerif());
        }
        return list;
    }

    private static final Typeface load$lambda$0(PlatformFont $font, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DesktopFont_desktopKt.loadTypeface($font);
    }
}

