#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.50.3
visibility:           public
id:                   hledger-1.50.3-7Lfg4mrycTkJHPEAORjPFD
key:                  hledger-1.50.3-7Lfg4mrycTkJHPEAORjPFD
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  752dab7f539cf21b877e0b9fcee73d3e
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-1.50.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-1.50.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-1.50.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.50.3-7Lfg4mrycTkJHPEAORjPFD
depends:
    Decimal-0.5.2-EfeRJOh9ESJFpVyAivOumF
    Diff-0.5-HhQaTNERhJmIrCyukvTeRE
    aeson-2.1.2.1-6DouAcLayfd1cKsM4PdlxR
    ansi-terminal-1.0.2-5XGQCBITBQK54h4mZtEY0l base-4.18.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    containers-0.6.7 data-default-0.7.1.3-GjFcYIDEzFPmj8haZ8waF
    directory-1.3.8.5 extra-1.7.16-8dGAsSrJDrL2Qv7CcA7Z6y
    filepath-1.4.300.1 githash-0.1.6.3-70lrRFpX9RDHBIxTbbWuc0
    hashable-1.4.7.0-2TMrYujL0SWBJEdw6jCOMM haskeline-0.8.2.1
    hledger-lib-1.50.3-A69MenCB2oA2R6U9TbqqS3
    http-client-0.7.19-5kCWQrqBeyJH4fxMxrytAc
    http-types-0.12.4-5e6CiUpSQgfFBuPHItSqh0
    lucid-2.11.20250303-JrdCWT5fSI8CcNIQxGfyDE
    math-functions-0.3.4.4-9SsiBsTh55OKRq559iatyj
    megaparsec-9.7.0-EJ90AsoHAMdCjQYvJMoIz4
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    modern-uri-0.3.6.1-FnA4MkUIyqC37yOiWpoHu mtl-2.3.1 process-1.6.19.0
    regex-tdfa-1.3.2.5-DTLCNeui6jjF7PuXyFzkbb
    req-3.13.4-AvVMQxk5f078wwfTReaggy
    safe-0.3.21-Jx1j9PonLpAIXmir4WvZhd
    shakespeare-2.1.7-LBtmZ0fm3rP1DZX3OU8PFQ
    split-0.2.5-3RnrRTIeHLc8NBcVaUtFqR
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-5ThorlfIy4bAzjwer0MKIq
    temporary-1.3-BelDM7zTWCg7tBff187Pbn text-2.0.2
    text-ansi-0.3.0.1-8PPhEMhrcz6FOWuP457xFJ time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    unordered-containers-0.2.20.1-650icVWmHjf3WKXK0GKpae
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    utility-ht-0.0.17.2-64Klhw6OIc4KnbHbeUqiC6
    wizards-1.0.3-EMndOhiYuHdGTEqrX5mo0v

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

