/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.OpenCachingDeXmlHandler;
import tim.prune.function.search.SearchResult;

public class SearchOpenCachingDeFunction
extends GenericDownloaderFunction {
    private static final int MAX_DISTANCE = 50;

    public SearchOpenCachingDeFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.searchopencachingde";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            return;
        }
        double d = dataPoint.getLatitude().getDouble();
        double d2 = dataPoint.getLongitude().getDouble();
        this.submitSearch(d, d2);
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.geocaching.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
        this.finishedSearch();
    }

    private void submitSearch(double d, double d2) {
        Serializable serializable;
        String string = "https://opencaching.de/search.php?searchto=searchbydistance&showresult=1&output=XML&sort=bydistance&lat=" + d + "&lon=" + d2 + "&distance=" + 50 + "&unit=km";
        OpenCachingDeXmlHandler openCachingDeXmlHandler = new OpenCachingDeXmlHandler();
        try {
            serializable = new URL(string);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            Throwable throwable = null;
            Object var10_9 = null;
            try (InputStream inputStream = ((URL)serializable).openStream();){
                sAXParser.parse(inputStream, (DefaultHandler)openCachingDeXmlHandler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {}
        serializable = openCachingDeXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)serializable);
    }
}

