/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tim.prune.data.Field;
import tim.prune.data.FileType;

public class FieldList {
    private final ArrayList<Field> _fields = new ArrayList();

    public FieldList() {
    }

    public FieldList(Field ... fieldArray) {
        this();
        Collections.addAll(this._fields, fieldArray);
    }

    public int getFieldIndex(Field field) {
        if (field == null) {
            return -1;
        }
        int n = 0;
        for (Field field2 : this._fields) {
            if (field2 != null && field2.equals(field)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean contains(Field field) {
        return this.getFieldIndex(field) >= 0;
    }

    public int getNumFields() {
        return this._fields.size();
    }

    public Field getField(int n) {
        try {
            return this._fields.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public FieldList merge(FieldList fieldList) {
        FieldList fieldList2 = new FieldList();
        fieldList2._fields.addAll(this._fields);
        if (fieldList != null) {
            for (Field field : fieldList._fields) {
                if (this.contains(field)) continue;
                fieldList2._fields.add(field);
            }
        }
        return fieldList2;
    }

    public int addField(Field field) {
        int n = this.getFieldIndex(field);
        if (n >= 0) {
            return n;
        }
        this._fields.add(field);
        return this.getNumFields() - 1;
    }

    public void addFields(Field ... fieldArray) {
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            this.addField(field);
            ++n2;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Field field : this._fields) {
            stringBuilder.append(field.getName()).append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public List<Field> getFields(FileType fileType) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : this._fields) {
            if (!field.isSpecificToFileType(fileType)) continue;
            arrayList.add(field);
        }
        return arrayList;
    }
}

