/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.ApplicationThemeManager;
import generic.theme.FontValue;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconValue;
import generic.theme.LafType;
import generic.theme.laf.ComponentFontRegistry;
import generic.theme.laf.FontChangeListener;
import generic.theme.laf.UiDefaultsMapper;
import generic.util.action.BeginningOfLineAction;
import generic.util.action.DeleteToEndOfWordAction;
import generic.util.action.DeleteToStartOfWordAction;
import generic.util.action.EndOfLineAction;
import generic.util.action.SelectBeginningOfLineAction;
import generic.util.action.SelectEndOfLineAction;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import org.apache.commons.collections4.IteratorUtils;
import utilities.util.reflection.ReflectionUtilities;

public abstract class LookAndFeelManager {
    private static final int DEFAULT_CURSOR_BLINK_RATE = 500;
    private LafType laf;
    private Map<String, ComponentFontRegistry> fontRegistryMap = new HashMap<String, ComponentFontRegistry>();
    private Map<Component, String> componentToIdMap = new WeakHashMap<Component, String>();
    protected ApplicationThemeManager themeManager;
    protected Map<String, String> normalizedIdToLafIdMap;

    protected LookAndFeelManager(LafType laf, ApplicationThemeManager themeManager) {
        this.laf = laf;
        this.themeManager = themeManager;
    }

    public LafType getLookAndFeelType() {
        return this.laf;
    }

    public void installLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        this.doInstallLookAndFeel();
        this.processJavaDefaults();
        this.fixupLookAndFeelIssues();
        this.installCustomLookAndFeelActions();
        this.updateComponentUis();
    }

    public void resetAll(GThemeValueMap javaDefaults) {
        this.themeManager.refreshGThemeValues();
        this.resetIcons(javaDefaults);
        this.resetFonts(javaDefaults);
        this.updateAllRegisteredComponentFonts();
        this.updateComponentUis();
    }

    protected void updateAllRegisteredComponentFonts() {
        for (ComponentFontRegistry register : this.fontRegistryMap.values()) {
            register.updateComponentFonts();
        }
    }

    private void resetFonts(GThemeValueMap javaDefaults) {
        List<FontValue> fonts = javaDefaults.getFonts();
        UIDefaults defaults = UIManager.getDefaults();
        for (FontValue fontValue : fonts) {
            String id = fontValue.getId();
            String lafId = this.normalizedIdToLafIdMap.get(id);
            if (lafId == null) continue;
            Font correctFont = Gui.getFont(id);
            Font storedFont = defaults.getFont(id);
            if (correctFont == null || correctFont.equals(storedFont)) continue;
            defaults.put(lafId, this.toUiResource(correctFont));
        }
    }

    private void resetIcons(GThemeValueMap javaDefaults) {
        List<IconValue> icons = javaDefaults.getIcons();
        UIDefaults defaults = UIManager.getDefaults();
        for (IconValue iconValue : icons) {
            String id = iconValue.getId();
            String lafId = this.normalizedIdToLafIdMap.get(id);
            Icon correctIcon = Gui.getIcon(id);
            Icon storedIcon = defaults.getIcon(id);
            if (correctIcon == null || correctIcon.equals(storedIcon)) continue;
            defaults.put(lafId, correctIcon);
        }
    }

    public void colorsChanged() {
        this.themeManager.refreshGThemeValues();
        this.repaintAll();
    }

    public void iconsChanged(Set<String> changedIconIds, Icon newIcon) {
        UIDefaults defaults = UIManager.getDefaults();
        if (!(newIcon instanceof UIResource)) {
            newIcon = new IconUIResource(newIcon);
        }
        for (String changedIconId : changedIconIds) {
            String lafIconId = this.normalizedIdToLafIdMap.get(changedIconId);
            defaults.put(lafIconId, newIcon);
        }
        if (!changedIconIds.isEmpty()) {
            this.updateComponentUis();
        }
        this.themeManager.refreshGThemeValues();
        this.repaintAll();
    }

    public void fontsChanged(Set<String> changedFontIds) {
        UIDefaults defaults = UIManager.getDefaults();
        for (String changedFontId : changedFontIds) {
            Font font = Gui.getFont(changedFontId);
            String javaFontId = this.normalizedIdToLafIdMap.get(changedFontId);
            if (javaFontId == null) continue;
            defaults.put(javaFontId, new FontUIResource(font));
        }
        if (!changedFontIds.isEmpty()) {
            this.updateComponentUis();
        }
        this.updateAllRegisteredComponentFonts();
        this.repaintAll();
    }

    protected void updateComponentUis() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    protected void repaintAll() {
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
    }

    public void registerFont(Component component, String fontId) {
        this.checkForAlreadyRegistered(component, fontId);
        this.componentToIdMap.put(component, fontId);
        ComponentFontRegistry register = this.fontRegistryMap.computeIfAbsent(fontId, id -> new ComponentFontRegistry((String)id));
        register.addComponent(component);
    }

    public void registerFont(Component component, String fontId, int fontStyle) {
        this.checkForAlreadyRegistered(component, fontId);
        this.componentToIdMap.put(component, fontId);
        ComponentFontRegistry register = this.fontRegistryMap.computeIfAbsent(fontId, id -> new ComponentFontRegistry((String)id));
        register.addComponent(component, fontStyle);
    }

    public void unRegisterFont(JComponent component, String fontId) {
        this.componentToIdMap.remove(component);
        ComponentFontRegistry registry = this.fontRegistryMap.get(fontId);
        if (registry != null) {
            registry.removeComponent(component);
        }
    }

    private void checkForAlreadyRegistered(Component component, String newFontId) {
        String existingFontId = this.componentToIdMap.get(component);
        if (existingFontId == null) {
            return;
        }
        if (component instanceof FontChangeListener) {
            return;
        }
        Msg.warn((Object)this, (Object)"Component has a Font ID registered more than once. Previously registered ID: '%s'.  Newly registered ID: '%s'.\n".formatted(existingFontId, newFontId), (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
    }

    private Font toUiResource(Font font) {
        if (!(font instanceof UIResource)) {
            return new FontUIResource(font);
        }
        return font;
    }

    protected void doInstallLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String name = this.laf.getName();
        UIManager.setLookAndFeel(this.findLookAndFeelClassName(name));
    }

    protected void fixupLookAndFeelIssues() {
        this.installGlobalFontSizeOverride();
        this.installCursorBlinkingProperties();
    }

    protected void processJavaDefaults() {
        UIDefaults defaults = UIManager.getDefaults();
        UiDefaultsMapper uiDefaultsMapper = this.createUiDefaultsMapper(defaults);
        GThemeValueMap javaDefaults = uiDefaultsMapper.getNormalizedJavaDefaults();
        this.themeManager.setJavaDefaults(javaDefaults);
        uiDefaultsMapper.installValuesIntoUIDefaults(this.themeManager.getCurrentValues());
        this.normalizedIdToLafIdMap = uiDefaultsMapper.getNormalizedIdToLafIdMap();
    }

    protected abstract UiDefaultsMapper createUiDefaultsMapper(UIDefaults var1);

    protected String findLookAndFeelClassName(String lookAndFeelName) {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        for (UIManager.LookAndFeelInfo info : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            String className = info.getClassName();
            if (!lookAndFeelName.equals(className) && !lookAndFeelName.equals(info.getName())) continue;
            return className;
        }
        Msg.debug((Object)this, (Object)("Unable to find requested Look and Feel: " + lookAndFeelName));
        return UIManager.getSystemLookAndFeelClassName();
    }

    protected boolean isSupported(String lookAndFeelName) {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        for (UIManager.LookAndFeelInfo info : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelName.equals(info.getName())) continue;
            return true;
        }
        return false;
    }

    protected void setKeyBinding(String existingKsText, String newKsText, String[] prefixValues) {
        KeyStroke existingKs = KeyStroke.getKeyStroke(existingKsText);
        KeyStroke newKs = KeyStroke.getKeyStroke(newKsText);
        UIDefaults uiDefaults = UIManager.getDefaults();
        for (String properyPrefix : prefixValues) {
            Object object = uiDefaults.get(properyPrefix + ".focusInputMap");
            InputMap inputMap = (InputMap)object;
            Object action = inputMap.get(existingKs);
            inputMap.put(newKs, action);
        }
    }

    private void installGlobalFontSizeOverride() {
        Integer overrideFontInteger = SystemUtilities.getFontSizeOverrideValue();
        if (overrideFontInteger == null) {
            return;
        }
        this.setGlobalFontSizeOverride(overrideFontInteger);
    }

    public void installCursorBlinkingProperties() {
        UIDefaults defaults = UIManager.getDefaults();
        int blinkRate = this.themeManager.isBlinkingCursors() ? 500 : 0;
        defaults.put("TextPane.caretBlinkRate", (Object)blinkRate);
        defaults.put("TextField.caretBlinkRate", (Object)blinkRate);
        defaults.put("TextArea.caretBlinkRate", (Object)blinkRate);
    }

    private void installCustomLookAndFeelActions() {
        String[] UIPrefixValues = new String[]{"TextField", "FormattedTextField", "TextArea", "TextPane", "EditorPane"};
        DeleteToStartOfWordAction deleteToStartOfWordAction = new DeleteToStartOfWordAction();
        this.registerAction((Action)deleteToStartOfWordAction, DeleteToStartOfWordAction.KEY_STROKE, UIPrefixValues);
        DeleteToEndOfWordAction deleteToEndOfWordAction = new DeleteToEndOfWordAction();
        this.registerAction((Action)deleteToEndOfWordAction, DeleteToEndOfWordAction.KEY_STROKE, UIPrefixValues);
        BeginningOfLineAction beginningOfLineAction = new BeginningOfLineAction();
        this.registerAction((Action)beginningOfLineAction, BeginningOfLineAction.KEY_STROKE, UIPrefixValues);
        EndOfLineAction endOfLineAction = new EndOfLineAction();
        this.registerAction((Action)endOfLineAction, EndOfLineAction.KEY_STROKE, UIPrefixValues);
        SelectBeginningOfLineAction selectBeginningOfLineAction = new SelectBeginningOfLineAction();
        this.registerAction((Action)selectBeginningOfLineAction, SelectBeginningOfLineAction.KEY_STROKE, UIPrefixValues);
        SelectEndOfLineAction selectEndOfLineAction = new SelectEndOfLineAction();
        this.registerAction((Action)selectEndOfLineAction, SelectEndOfLineAction.KEY_STROKE, UIPrefixValues);
    }

    private void setGlobalFontSizeOverride(int fontSize) {
        UIDefaults defaults = UIManager.getDefaults();
        Set set = defaults.entrySet();
        for (Map.Entry entry : set) {
            Font currentFont;
            Object key = entry.getKey();
            if (key.toString().toLowerCase().indexOf("font") == -1 || (currentFont = defaults.getFont(key)) == null) continue;
            Font newFont = currentFont.deriveFont((float)fontSize);
            UIManager.put(key, newFont);
        }
    }

    private void registerAction(Action action, KeyStroke keyStroke, String[] prefixValues) {
        for (String properyPrefix : prefixValues) {
            UIDefaults defaults = UIManager.getDefaults();
            Object object = defaults.get(properyPrefix + ".focusInputMap");
            InputMap inputMap = (InputMap)object;
            inputMap.put(keyStroke, action);
        }
    }

    public static List<String> getLookAndFeelIdsForType(UIDefaults defaults, Class<?> clazz) {
        ArrayList<String> colorKeys = new ArrayList<String>();
        List keyList = IteratorUtils.toList(defaults.keys().asIterator());
        for (Object key : keyList) {
            Object value;
            if (!(key instanceof String) || !clazz.isInstance(value = defaults.get(key))) continue;
            colorKeys.add((String)key);
        }
        return colorKeys;
    }
}

