/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.util.viewer.field.AbstractOpenCloseField;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.listing.Data;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class OpenCloseField
extends AbstractOpenCloseField {
    private int indentLevel;
    private boolean isLast;
    private int insetSpace = 1;

    public OpenCloseField(FieldFactory factory, ProxyObj<?> proxy, int indentLevel, FontMetrics metrics, int x, int width, boolean isLast) {
        super(factory, proxy, metrics, x, width);
        this.isOpen = proxy.getListingLayoutModel().isOpen((Data)proxy.getObject());
        this.indentLevel = indentLevel;
        this.isLast = isLast;
    }

    public int getWidth() {
        return (this.indentLevel + 1) * this.fieldWidth;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        int toggleHandleStartY = -(this.heightAbove / 2 + this.toggleHandleSize / 2);
        int toggleHandleStartX = this.startX + this.indentLevel * this.fieldWidth + this.insetSpace;
        if (!context.isPrinting()) {
            if (this.isOpen) {
                g.drawImage(OPEN_ICON.getImageIcon().getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            } else {
                g.drawImage(CLOSED_ICON.getImageIcon().getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            }
        }
        g.setColor((Color)GThemeDefaults.Colors.Palette.LIGHT_GRAY);
        int fieldTopY = -this.heightAbove;
        int fieldBottomY = this.heightBelow;
        int toggleHandleHalfLength = this.toggleHandleSize / 2;
        for (int i = 1; i < this.indentLevel; ++i) {
            int fieldOffset = i * this.fieldWidth;
            int previousButtonStartX = this.startX + fieldOffset + this.insetSpace;
            int midpointX = previousButtonStartX + toggleHandleHalfLength;
            g.drawLine(midpointX, fieldTopY, midpointX, fieldBottomY);
        }
        if (this.indentLevel > 0) {
            boolean lastAndClosed;
            int indentOffset = this.getWidth();
            int toggleHandleEndX = toggleHandleStartX + this.toggleHandleSize;
            int midpointY = toggleHandleStartY + this.toggleHandleSize / 2;
            int endX = this.startX + indentOffset;
            g.drawLine(toggleHandleEndX, midpointY, endX, midpointY);
            int midpointX = toggleHandleStartX + toggleHandleHalfLength;
            int endY = toggleHandleStartY - this.insetSpace;
            g.drawLine(midpointX, fieldTopY, midpointX, endY);
            boolean bl = lastAndClosed = this.isLast && !this.isOpen;
            if (!lastAndClosed) {
                int buttonBottomY = toggleHandleStartY + this.toggleHandleSize;
                g.drawLine(midpointX, buttonBottomY, midpointX, fieldBottomY);
            }
        }
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    @Override
    public void toggleOpenCloseState() {
        this.proxy.getListingLayoutModel().toggleOpen((Data)this.proxy.getObject());
    }
}

