/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolsHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DebugCOFFSymbolTable {
    private int ptrToSymbolTable;
    private int symbolCount;
    private List<DebugCOFFSymbol> symbols = new ArrayList<DebugCOFFSymbol>();

    public DebugCOFFSymbolTable(BinaryReader reader, DebugCOFFSymbolsHeader coffHeader, int offset) throws IOException {
        this.ptrToSymbolTable = coffHeader.getFirstSymbolLVA() + offset;
        this.symbolCount = coffHeader.getNumberOfSymbols();
        if (this.symbolCount < 65536) {
            for (int i = 0; i < this.symbolCount; ++i) {
                this.symbols.add(new DebugCOFFSymbol(reader, this.ptrToSymbolTable + i * 18, this));
            }
        }
    }

    int getStringTableIndex() {
        return this.ptrToSymbolTable + this.symbolCount * 18;
    }

    public List<DebugCOFFSymbol> getSymbols() {
        return this.symbols;
    }
}

