/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledList;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftArray;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;
import java.util.stream.Collectors;

public class SwiftBoundGenericStructureNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled type = null;
        Demangled typeList = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Type: {
                    type = child.demangle(demangler);
                    continue block4;
                }
                case TypeList: {
                    typeList = child.demangle(demangler);
                    continue block4;
                }
            }
            this.skip(child);
        }
        if (type instanceof SwiftArray) {
            Demangled first;
            DemangledList list;
            SwiftArray arr = (SwiftArray)type;
            if (typeList instanceof DemangledList && !(list = (DemangledList)typeList).isEmpty() && (first = (Demangled)list.get(0)) instanceof DemangledDataType) {
                DemangledDataType ddt = (DemangledDataType)first;
                arr.setBoundType(ddt);
            }
            return arr;
        }
        if (typeList instanceof DemangledList) {
            DemangledList list = (DemangledList)typeList;
            String typeNames = list.stream().map(e -> e.getName()).collect(Collectors.joining(","));
            type.setName("%s<%s>".formatted(type.getName(), typeNames));
            return type;
        }
        return this.getUnknown();
    }
}

