/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AnnotationJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class RuntimeInvisibleAnnotationsAttribute
extends AbstractAttributeInfo {
    private short numberOfAnnotations;
    private AnnotationJava[] annotations;

    public RuntimeInvisibleAnnotationsAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.numberOfAnnotations = reader.readNextShort();
        this.annotations = new AnnotationJava[this.getNumberOfAnnotations()];
        for (int i = 0; i < this.getNumberOfAnnotations(); ++i) {
            this.annotations[i] = new AnnotationJava(reader);
        }
    }

    public int getNumberOfAnnotations() {
        return this.numberOfAnnotations & 0xFFFF;
    }

    public AnnotationJava[] getAnnotations() {
        return this.annotations;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "RuntimeInvisibleAnnotations_attribute|" + this.numberOfAnnotations + "|";
        StructureDataType structure = this.getBaseStructure(name);
        structure.add(WORD, "num_annotations", null);
        for (int i = 0; i < this.annotations.length; ++i) {
            structure.add(this.annotations[i].toDataType(), "annotation_" + i, null);
        }
        return structure;
    }
}

