/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedProperty;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedPropertyOwner;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;

public class SQLServerExtendedPropertyCache
extends JDBCObjectLookupCache<SQLServerExtendedPropertyOwner, SQLServerExtendedProperty> {
    @NotNull
    public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SQLServerExtendedPropertyOwner owner, @Nullable SQLServerExtendedProperty object, @Nullable String objectName) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ep.*, ");
        if (this.isSupportVariantProperty(session)) {
            sql.append("TYPE_ID(CAST(SQL_VARIANT_PROPERTY(value, 'BaseType') as nvarchar)) AS value_type ");
        } else {
            sql.append("NULL AS value_type ");
        }
        sql.append("FROM ");
        sql.append(SQLServerUtils.getExtendedPropsTableName(owner.getDatabase()));
        sql.append(" ep WHERE ep.major_id=? AND ep.minor_id=? AND ep.class=? ORDER BY ep.minor_id");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
        dbStat.setLong(1, owner.getMajorObjectId());
        dbStat.setLong(2, owner.getMinorObjectId());
        dbStat.setLong(3, (long)owner.getExtendedPropertyObjectClass().getClassId());
        return dbStat;
    }

    @Nullable
    protected SQLServerExtendedProperty fetchObject(@NotNull JDBCSession session, @NotNull SQLServerExtendedPropertyOwner owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        return new SQLServerExtendedProperty(session.getProgressMonitor(), owner, (ResultSet)resultSet);
    }

    private boolean isSupportVariantProperty(@NotNull JDBCSession session) {
        JDBCDataSource dataSource = session.getDataSource();
        if (dataSource instanceof SQLServerDataSource) {
            SQLServerDataSource sqlServerDataSource = (SQLServerDataSource)dataSource;
            return !sqlServerDataSource.isDataWarehouseServer(session.getProgressMonitor());
        }
        return !SQLServerUtils.isDriverBabelfish(dataSource.getContainer().getDriver());
    }
}

