/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

class FindLiterals
implements OWLObjectVisitorEx<Boolean> {
    private final OWLLiteral value;

    public FindLiterals(OWLLiteral value) {
        this.value = value;
    }

    @Override
    public Boolean visit(OWLAnnotation node) {
        if (node.getValue().equals(this.value)) {
            return Boolean.TRUE;
        }
        return this.visitStreamAndSpares(() -> node.getAnnotations().stream(), node.getValue());
    }

    @Override
    public Boolean visit(OWLLiteral node) {
        return node.equals(this.value);
    }

    @Override
    public Boolean visit(OWLDeclarationAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    protected Boolean visitAnnotations(HasAnnotations a) {
        return this.visitStream(a.getAnnotations().stream());
    }

    protected Boolean visitStream(Stream<? extends OWLObject> stream) {
        return stream.anyMatch(x -> x.accept(this));
    }

    protected Boolean visitStreamAndSpares(Supplier<Stream<? extends OWLObject>> stream, OWLObject ... objs) {
        for (OWLObject o : objs) {
            if (!o.accept(this).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return this.visitStream(stream.get());
    }

    @Override
    public Boolean visit(OWLDatatypeDefinitionAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLAnnotationAssertionAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), axiom.getValue());
    }

    @Override
    public Boolean visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLSubClassOfAxiom axiom) {
        Boolean b = this.visitStream(Stream.of(axiom.getSubClass(), axiom.getSuperClass()));
        if (b.booleanValue()) {
            return b;
        }
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDisjointClassesAxiom axiom) {
        Boolean b = this.visitStream(axiom.getClassExpressionsAsList().stream());
        if (b.booleanValue()) {
            return b;
        }
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDataPropertyDomainAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), axiom.getDomain());
    }

    @Override
    public Boolean visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), new OWLObject[]{axiom.getObject()});
    }

    @Override
    public Boolean visit(OWLDifferentIndividualsAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), axiom.getRange());
    }

    @Override
    public Boolean visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDisjointUnionAxiom axiom) {
        Boolean b = this.visitStream(axiom.getClassExpressions().stream());
        if (b.booleanValue()) {
            return Boolean.TRUE;
        }
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDataPropertyRangeAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), axiom.getRange());
    }

    @Override
    public Boolean visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLClassAssertionAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), axiom.getClassExpression());
    }

    @Override
    public Boolean visit(OWLEquivalentClassesAxiom axiom) {
        Boolean b = this.visitStream(axiom.getClassExpressionsAsList().stream());
        if (b.booleanValue()) {
            return b;
        }
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.visitStreamAndSpares(() -> axiom.getAnnotations().stream(), new OWLObject[]{axiom.getObject()});
    }

    @Override
    public Boolean visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLSameIndividualAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLSubPropertyChainOfAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(OWLHasKeyAxiom axiom) {
        return this.visitAnnotations(axiom);
    }

    @Override
    public Boolean visit(SWRLRule rule) {
        Boolean b = this.visitStream(rule.getHead().stream());
        if (b.booleanValue()) {
            return Boolean.TRUE;
        }
        b = this.visitStream(rule.getBody().stream());
        if (b.booleanValue()) {
            return Boolean.TRUE;
        }
        return this.visitAnnotations(rule);
    }

    @Override
    public Boolean visit(OWLClass ce) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLObjectIntersectionOf ce) {
        return this.visitStream(ce.getOperandsAsList().stream());
    }

    @Override
    public Boolean visit(OWLObjectUnionOf ce) {
        return this.visitStream(ce.getOperandsAsList().stream());
    }

    @Override
    public Boolean visit(OWLObjectComplementOf ce) {
        return ce.getOperand().accept(this);
    }

    @Override
    public Boolean visit(OWLObjectSomeValuesFrom ce) {
        return ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLObjectAllValuesFrom ce) {
        return ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLObjectHasValue ce) {
        return ((OWLIndividual)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLObjectMinCardinality ce) {
        return ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLObjectExactCardinality ce) {
        return ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLObjectMaxCardinality ce) {
        return ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLObjectHasSelf ce) {
        return this.visitStream(ce.getNestedClassExpressions().stream());
    }

    @Override
    public Boolean visit(OWLObjectOneOf ce) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLDataSomeValuesFrom ce) {
        return ((OWLDataRange)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLDataAllValuesFrom ce) {
        return ((OWLDataRange)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLDataHasValue ce) {
        return ((OWLLiteral)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLDataMinCardinality ce) {
        return ((OWLDataRange)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLDataExactCardinality ce) {
        return ((OWLDataRange)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLDataMaxCardinality ce) {
        return ((OWLDataRange)ce.getFiller()).accept(this);
    }

    @Override
    public Boolean visit(OWLDatatype node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLDataComplementOf node) {
        return node.getDataRange().accept(this);
    }

    @Override
    public Boolean visit(OWLDataOneOf node) {
        return this.visitStream(node.getValues().stream());
    }

    @Override
    public Boolean visit(OWLDataIntersectionOf node) {
        return this.visitStream(node.getOperands().stream());
    }

    @Override
    public Boolean visit(OWLDataUnionOf node) {
        return this.visitStream(node.getOperands().stream());
    }

    @Override
    public Boolean visit(OWLDatatypeRestriction node) {
        return this.visitStreamAndSpares(() -> node.getFacetRestrictions().stream(), node.getDatatype());
    }

    @Override
    public Boolean visit(OWLFacetRestriction node) {
        return node.getFacetValue().accept(this);
    }

    @Override
    public Boolean visit(OWLObjectProperty property) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLObjectInverseOf property) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLDataProperty property) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLAnnotationProperty property) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLNamedIndividual individual) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(IRI iri) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(OWLAnonymousIndividual individual) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(SWRLClassAtom node) {
        Boolean b = node.getPredicate().accept(this);
        if (b.booleanValue()) {
            return Boolean.TRUE;
        }
        return ((SWRLIArgument)node.getArgument()).accept(this);
    }

    @Override
    public Boolean visit(SWRLDataRangeAtom node) {
        return this.visitStreamAndSpares(() -> node.getAllArguments().stream(), node.getPredicate());
    }

    @Override
    public Boolean visit(SWRLObjectPropertyAtom node) {
        return this.visitStreamAndSpares(() -> node.getAllArguments().stream(), node.getPredicate());
    }

    @Override
    public Boolean visit(SWRLDataPropertyAtom node) {
        return this.visitStreamAndSpares(() -> node.getAllArguments().stream(), node.getPredicate());
    }

    @Override
    public Boolean visit(SWRLBuiltInAtom node) {
        return this.visitStreamAndSpares(() -> node.getAllArguments().stream(), node.getPredicate());
    }

    @Override
    public Boolean visit(SWRLVariable node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(SWRLIndividualArgument node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(SWRLLiteralArgument node) {
        return node.getLiteral().accept(this);
    }

    @Override
    public Boolean visit(SWRLSameIndividualAtom node) {
        if (node.getPredicate() instanceof OWLObject) {
            return this.visitStreamAndSpares(() -> node.getAllArguments().stream(), (OWLObject)((Object)node.getPredicate()));
        }
        return this.visitStream(node.getAllArguments().stream());
    }

    @Override
    public Boolean visit(SWRLDifferentIndividualsAtom node) {
        if (node.getPredicate() instanceof OWLObject) {
            return this.visitStreamAndSpares(() -> node.getAllArguments().stream(), (OWLObject)((Object)node.getPredicate()));
        }
        return this.visitStream(node.getAllArguments().stream());
    }

    @Override
    public Boolean visit(OWLOntology ontology) {
        return Boolean.FALSE;
    }
}

