/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.location;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.SaveConfirmationPanel;
import org.protege.editor.owl.ui.renderer.OWLIconProvider;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalLocationPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(PhysicalLocationPanel.class);
    private static final Color ROLL_OVER_COLOR = new Color(50, 50, 255);
    private final OWLEditorKit owlEditorKit;
    private final MList ontologiesPanel;
    private final Set<OWLOntology> ontologies = new HashSet<OWLOntology>();

    public PhysicalLocationPanel(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, owlEditorKit.getOWLModelManager().getOntologies());
    }

    public PhysicalLocationPanel(final OWLEditorKit owlEditorKit, Set<OWLOntology> ontologies) {
        this.owlEditorKit = owlEditorKit;
        this.ontologies.addAll(ontologies);
        this.setLayout(new BorderLayout(3, 3));
        this.ontologiesPanel = new MList(this){
            final /* synthetic */ PhysicalLocationPanel this$0;
            {
                this.this$0 = this$0;
            }

            protected List<MListButton> getButtons(Object value) {
                ArrayList<MListButton> buttons = new ArrayList<MListButton>(super.getButtons(value));
                buttons.add(new ReloadMListButton(e -> this.this$0.handleReload()));
                OWLOntology ont = ((OntologyListItem)value).ont;
                URI ontologyPhysicalURI = owlEditorKit.getModelManager().getOntologyPhysicalURI(ont);
                if (UIUtil.isLocalFile((URI)ontologyPhysicalURI)) {
                    buttons.add(new ShowFileMListButton(e -> this.this$0.handleShowFile()));
                }
                if (owlEditorKit.getModelManager().getDirtyOntologies().contains(ont)) {
                    buttons.add(new SaveMListButton(e -> this.this$0.handleSave()));
                }
                return buttons;
            }
        };
        this.ontologiesPanel.setCellRenderer((ListCellRenderer)new OntologyListCellRenderer());
        this.load();
        JPanel boxHolder = new JPanel(new BorderLayout());
        boxHolder.setOpaque(false);
        boxHolder.add((Component)this.ontologiesPanel, "North");
        this.add((Component)ComponentFactory.createScrollPane((JComponent)boxHolder), "Center");
    }

    public Set<OWLOntology> getSelectedOntologies() {
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        for (Object sel : this.ontologiesPanel.getSelectedValues()) {
            if (!(sel instanceof OntologyListItem)) continue;
            onts.add(((OntologyListItem)sel).ont);
        }
        return onts;
    }

    public void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies.clear();
        this.ontologies.addAll(ontologies);
        this.reload();
    }

    private void load() {
        OWLModelManager mngr = this.owlEditorKit.getModelManager();
        TreeSet<OWLObject> ts = new TreeSet<OWLObject>(mngr.getOWLObjectComparator());
        ts.addAll(this.ontologies);
        ArrayList<OntologyListItem> items = new ArrayList<OntologyListItem>();
        for (OWLOntology oWLOntology : ts) {
            items.add(new OntologyListItem(oWLOntology));
        }
        Object[] listData = items.toArray(new OntologyListItem[items.size()]);
        this.ontologiesPanel.setListData(listData);
    }

    private void reload() {
        this.load();
        this.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 500);
    }

    public static void showDialog(OWLEditorKit owlEditorKit) {
        PhysicalLocationPanel panel = new PhysicalLocationPanel(owlEditorKit);
        JOptionPane pane = new JOptionPane(panel, -1, -1);
        JDialog dlg = pane.createDialog((Component)((Object)owlEditorKit.getWorkspace()), "Ontology source locations");
        dlg.setResizable(true);
        dlg.setVisible(true);
    }

    private void handleSave() {
        if (this.ontologiesPanel.getSelectedValue() instanceof OntologyListItem) {
            OntologyListItem item = (OntologyListItem)this.ontologiesPanel.getSelectedValue();
            OWLOntology ont = item.ont;
            try {
                this.owlEditorKit.getOWLModelManager().save(ont);
                this.owlEditorKit.addRecent(this.owlEditorKit.getOWLModelManager().getOntologyPhysicalURI(ont));
                SaveConfirmationPanel.showDialog(this.owlEditorKit, Collections.singleton(ont));
                this.reload();
            }
            catch (OWLOntologyStorageException e) {
                ErrorLogPanel.showErrorDialog((Throwable)e);
            }
        }
    }

    private void handleReload() {
        try {
            if (this.ontologiesPanel.getSelectedValue() instanceof OntologyListItem) {
                OntologyListItem item = (OntologyListItem)this.ontologiesPanel.getSelectedValue();
                this.owlEditorKit.getModelManager().reload(item.ont);
            }
        }
        catch (OWLOntologyCreationException e) {
            JOptionPane.showMessageDialog((Component)((Object)this.owlEditorKit.getWorkspace()), "<html>Failed to reload ontology<p><p>.</html>");
        }
    }

    private void handleShowFile() {
        if (this.ontologiesPanel.getSelectedValue() instanceof OntologyListItem) {
            OntologyListItem item = (OntologyListItem)this.ontologiesPanel.getSelectedValue();
            OWLOntology ont = item.ont;
            URI physicalURI = this.owlEditorKit.getOWLModelManager().getOntologyPhysicalURI(ont);
            if (!UIUtil.isLocalFile((URI)physicalURI)) {
                throw new IllegalArgumentException("URI must be a file URI!");
            }
            try {
                FileUtils.showFile((File)new File(physicalURI));
            }
            catch (IOException ex) {
                this.logger.error("An error occurred whilst attempting to show a file in the Operating System.", (Throwable)ex);
            }
        }
    }

    private void handleClose(OWLOntology ont) {
        if (this.owlEditorKit.getModelManager().removeOntology(ont)) {
            this.ontologies.remove(ont);
            this.reload();
        } else {
            ProtegeManager.getInstance().disposeOfEditorKit((EditorKit)this.owlEditorKit);
        }
    }

    private class OntologyListCellRenderer
    implements ListCellRenderer {
        OntologySourcePanel panel;

        private OntologyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.panel == null) {
                this.panel = new OntologySourcePanel();
            }
            this.panel.setOntology(((OntologyListItem)value).ont);
            if (isSelected) {
                this.panel.setBackground(jList.getSelectionBackground());
            } else {
                this.panel.setBackground(jList.getBackground());
            }
            return this.panel;
        }
    }

    private class OntologyListItem
    implements MListItem {
        private OWLOntology ont;

        private OntologyListItem(OWLOntology ont) {
            this.ont = ont;
        }

        public boolean isEditable() {
            return false;
        }

        public void handleEdit() {
        }

        public boolean isDeleteable() {
            return !this.ont.equals((Object)PhysicalLocationPanel.this.owlEditorKit.getModelManager().getActiveOntology());
        }

        public boolean handleDelete() {
            PhysicalLocationPanel.this.handleClose(this.ont);
            return true;
        }

        public String getTooltip() {
            return this.ont.getAxiomCount() + " axioms";
        }
    }

    private static class SaveMListButton
    extends MListButton {
        protected SaveMListButton(ActionListener actionListener) {
            super("Save ontology", ROLL_OVER_COLOR, actionListener);
        }

        public void paintButtonContent(Graphics2D g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            g.drawRect(x + 4, y + 4, w - 8, h - 8);
            g.drawRect(x + 6, y + 4, w - 12, (h - 8) / 2);
            g.drawRect(x + 8, y + (h - 8) / 2 + 1, 2, (h - 8) / 2 - 2);
        }
    }

    private static class ShowFileMListButton
    extends MListButton {
        protected ShowFileMListButton(ActionListener actionListener) {
            super("Show source file", ROLL_OVER_COLOR, actionListener);
        }

        public void paintButtonContent(Graphics2D g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            g.drawOval(x + 3, y + 3, 6, 6);
            g.drawLine(x + 8, y + 8, x + w - 5, y + h - 5);
        }
    }

    private static class ReloadMListButton
    extends MListButton {
        protected ReloadMListButton(ActionListener actionListener) {
            super("Reload", ROLL_OVER_COLOR, actionListener);
        }

        public void paintButtonContent(Graphics2D g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            g.drawArc(x + 4, y + 4, w - 8, h - 8, 0, -270);
            Polygon arrowHead = new Polygon(new int[]{x + w / 2 + 3, x + w / 2, x + w / 2}, new int[]{y + 4, y + 2, y + 6}, 3);
            g.drawPolygon(arrowHead);
        }
    }

    private class OntologySourcePanel
    extends JPanel {
        private JLabel locURILabel;
        private JLabel ontURILabel;

        public OntologySourcePanel() {
            this.setOpaque(true);
            this.setLayout(new BorderLayout(3, 3));
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.ontURILabel = new JLabel();
            this.ontURILabel.setIcon(OWLIcons.getIcon("ontology.png"));
            this.add((Component)this.ontURILabel, "Center");
            this.locURILabel = new JLabel();
            this.locURILabel.setFont(this.locURILabel.getFont().deriveFont(12.0f));
            this.locURILabel.setForeground(Color.DARK_GRAY);
            this.locURILabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.add((Component)this.locURILabel, "South");
        }

        public void setOntology(OWLOntology ont) {
            OWLModelManager mngr = PhysicalLocationPanel.this.owlEditorKit.getModelManager();
            String label = OWLOntologyCellRenderer.getOntologyLabelText(ont, mngr);
            this.ontURILabel.setText(label);
            OWLIconProvider owlICP = PhysicalLocationPanel.this.owlEditorKit.getWorkspace().getOWLIconProvider();
            Icon ontIcon = owlICP.getIcon((OWLObject)ont);
            this.ontURILabel.setIcon(ontIcon);
            URI physicalURI = mngr.getOntologyPhysicalURI(ont);
            if (UIUtil.isLocalFile((URI)physicalURI)) {
                this.locURILabel.setText(new File(physicalURI).toString());
            } else {
                this.locURILabel.setText(physicalURI.toString());
            }
        }
    }
}

