/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Random;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.MockPseudoRandom;

public class ServerPlayerTest
extends FreeColTestCase {
    private static final GoodsType cottonType = ServerPlayerTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType foodType = ServerPlayerTest.spec().getPrimaryFoodType();
    private static final GoodsType musketsType = ServerPlayerTest.spec().getGoodsType("model.goods.muskets");
    private static final GoodsType silverType = ServerPlayerTest.spec().getGoodsType("model.goods.silver");
    private static final TileType plains = ServerPlayerTest.spec().getTileType("model.tile.plains");
    private static final UnitType colonistType = ServerPlayerTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType wagonTrainType = ServerPlayerTest.spec().getUnitType("model.unit.wagonTrain");
    private static final UnitType caravelType = ServerPlayerTest.spec().getUnitType("model.unit.caravel");
    private static final UnitType galleonType = ServerPlayerTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType privateerType = ServerPlayerTest.spec().getUnitType("model.unit.privateer");

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testMarketRecovery() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        ServerPlayer english = this.getServerPlayer(game, "model.nation.english");
        Market frenchMarket = french.getMarket();
        Market englishMarket = english.getMarket();
        int frenchGold = french.getGold();
        int silverPrice = ServerPlayerTest.spec().getInitialPrice(silverType);
        Random random = new Random();
        int m = english.sellInEurope(random, null, silverType, 1);
        ServerPlayerTest.assertTrue((boolean)englishMarket.hasBeenTraded(silverType));
        int englishAmount = englishMarket.getAmountInMarket(silverType);
        m = french.sellInEurope(random, null, silverType, 200);
        ServerPlayerTest.assertTrue((frenchGold < french.getGold() ? 1 : 0) != 0);
        ServerPlayerTest.assertTrue((boolean)frenchMarket.hasBeenTraded(silverType));
        ServerPlayerTest.assertTrue((frenchMarket.getSalePrice(silverType, 1) < silverPrice ? 1 : 0) != 0);
        ServerPlayerTest.assertTrue((String)"English silver increases due to French sales", (englishMarket.getAmountInMarket(silverType) > englishAmount ? 1 : 0) != 0);
        ServerPlayerTest.assertTrue((String)"English silver price might drop due to French sales", (englishMarket.getSalePrice(silverType, 1) <= silverPrice ? 1 : 0) != 0);
        ServerPlayerTest.assertTrue((String)"English silver price should drop less than French", (englishMarket.getSalePrice(silverType, 1) >= frenchMarket.getSalePrice(silverType, 1) ? 1 : 0) != 0);
        game.setTurn(new Turn(200));
        ArrayList<Integer> setValues = new ArrayList<Integer>();
        setValues.add(20);
        MockPseudoRandom mockRandom = new MockPseudoRandom(setValues, true);
        ServerTestHelper.setRandom(mockRandom);
        boolean frenchRecovered = false;
        boolean englishRecovered = false;
        for (int i = 0; i < 100; ++i) {
            ChangeSet cs = new ChangeSet();
            french.csYearlyGoodsAdjust(random, cs);
            game.sendTo(french, cs);
            if (frenchMarket.getSalePrice(silverType, 1) >= silverPrice) {
                frenchRecovered = true;
            }
            cs = new ChangeSet();
            english.csYearlyGoodsAdjust(random, cs);
            game.sendTo(english, cs);
            if (englishMarket.getSalePrice(silverType, 1) < silverPrice) continue;
            englishRecovered = true;
        }
        ServerPlayerTest.assertTrue((String)"French silver price should have recovered", (boolean)frenchRecovered);
        ServerPlayerTest.assertTrue((String)"English silver price should have recovered", (boolean)englishRecovered);
    }

    public void testHasExploredTile() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        Map map = game.getMap();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        InGameController igc = ServerTestHelper.getInGameController();
        Tile tile0 = map.getTile(0, 0);
        Tile tile1 = map.getTile(6, 8);
        Tile tile2 = map.getTile(8, 6);
        ServerPlayerTest.assertFalse((String)"Setup error, tile1 should not be explored by dutch player", (boolean)dutch.hasExplored(tile1));
        ServerPlayerTest.assertFalse((String)"Setup error, tile1 should not be explored by french player", (boolean)french.hasExplored(tile1));
        ServerPlayerTest.assertFalse((String)"Setup error, tile2 should not be explored by dutch player", (boolean)dutch.hasExplored(tile2));
        ServerPlayerTest.assertFalse((String)"Setup error, tile2 should not be explored by french player", (boolean)french.hasExplored(tile2));
        igc.move(dutch, new ServerUnit(game, tile0, dutch, colonistType), tile1);
        igc.move(french, new ServerUnit(game, tile0, french, colonistType), tile2);
        ServerPlayerTest.assertTrue((String)"Tile1 is explored", (boolean)tile1.isExplored());
        ServerPlayerTest.assertTrue((String)"Tile2 is explored", (boolean)tile2.isExplored());
        ServerPlayerTest.assertTrue((String)"Tile1 should be explored by dutch player", (boolean)dutch.hasExplored(tile1));
        ServerPlayerTest.assertFalse((String)"Tile1 should not be explored by french player", (boolean)french.hasExplored(tile1));
        ServerPlayerTest.assertFalse((String)"Tile2 should not be explored by dutch player", (boolean)dutch.hasExplored(tile2));
        ServerPlayerTest.assertTrue((String)"Tile2 should be explored by french player", (boolean)french.hasExplored(tile2));
    }

    public void testLoadInColony() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        Colony colony = this.getStandardColony();
        colony.addGoods(cottonType, 200);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerUnit wagonInColony = new ServerUnit(game, colony.getTile(), dutch, wagonTrainType);
        ServerUnit wagonNotInColony = new ServerUnit(game, map.getTile(10, 10), dutch, wagonTrainType);
        igc.loadGoods(dutch, colony, cottonType, 50, wagonNotInColony);
        ServerPlayerTest.assertEquals((int)0, (int)wagonNotInColony.getGoodsCount(cottonType));
        ServerPlayerTest.assertEquals((int)200, (int)colony.getGoodsCount(cottonType));
        igc.loadGoods(dutch, colony, cottonType, 10, wagonInColony);
        ServerPlayerTest.assertEquals((int)10, (int)wagonInColony.getGoodsCount(cottonType));
        ServerPlayerTest.assertEquals((int)190, (int)colony.getGoodsCount(cottonType));
        igc.unloadGoods(dutch, cottonType, 5, wagonInColony);
        ServerPlayerTest.assertEquals((int)5, (int)wagonInColony.getGoodsCount(cottonType));
        ServerPlayerTest.assertEquals((int)195, (int)colony.getGoodsCount(cottonType));
        igc.loadGoods(dutch, colony, cottonType, 200, wagonInColony);
        ServerPlayerTest.assertEquals((int)5, (int)wagonInColony.getGoodsCount(cottonType));
        ServerPlayerTest.assertEquals((int)195, (int)colony.getGoodsCount(cottonType));
        igc.loadGoods(dutch, colony, cottonType, 195, wagonInColony);
        ServerPlayerTest.assertEquals((int)200, (int)wagonInColony.getGoodsCount(cottonType));
        ServerPlayerTest.assertEquals((int)0, (int)colony.getGoodsCount(cottonType));
        ServerPlayerTest.assertFalse((boolean)wagonInColony.hasSpaceLeft());
        colony.addGoods(cottonType, 1);
        igc.loadGoods(dutch, colony, cottonType, 1, wagonInColony);
        ServerPlayerTest.assertEquals((int)200, (int)wagonInColony.getGoodsCount(cottonType));
        ServerPlayerTest.assertEquals((int)1, (int)colony.getGoodsCount(cottonType));
    }

    public void testLoadInEurope() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Europe europe = dutch.getEurope();
        ServerUnit privateer1 = new ServerUnit(game, europe, dutch, privateerType);
        ServerUnit privateer2 = new ServerUnit(game, map.getTile(1, 1), dutch, privateerType);
        igc.loadGoods(dutch, europe, cottonType, 10, privateer1);
        ServerPlayerTest.assertEquals((int)0, (int)privateer1.getGoodsCount(cottonType));
        dutch.setGold(10000);
        igc.loadGoods(dutch, europe, cottonType, 10, privateer1);
        ServerPlayerTest.assertEquals((int)10, (int)privateer1.getGoodsCount(cottonType));
        igc.unloadGoods(dutch, cottonType, 5, privateer1);
        ServerPlayerTest.assertEquals((int)5, (int)privateer1.getGoodsCount(cottonType));
        igc.loadGoods(dutch, europe, cottonType, 10, privateer2);
        ServerPlayerTest.assertEquals((int)0, (int)privateer2.getGoodsCount(cottonType));
        dutch.getMarket().setArrears(cottonType, 1);
        igc.loadGoods(dutch, europe, cottonType, 10, privateer1);
        ServerPlayerTest.assertEquals((int)5, (int)privateer1.getGoodsCount(cottonType));
    }

    public void testCheckGameOverNoUnits() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.setGold(0);
        ServerPlayerTest.assertEquals((String)"Should not have units", (int)0, (int)dutch.getUnitCount());
        ServerPlayerTest.assertEquals((String)"Should not be alive, no carrier", (Object)((Object)ServerPlayer.DeadCheck.IS_DEAD), (Object)((Object)dutch.checkForDeath()));
    }

    public void testCheckNoGameOverEnoughMoney() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.setGold(10000);
        ServerPlayerTest.assertEquals((String)"Should be alive, has enough money", (Object)((Object)ServerPlayer.DeadCheck.IS_ALIVE), (Object)((Object)dutch.checkForDeath()));
    }

    public void testCheckNoGameOverHasColonistInNewWorld() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        Map map = game.getMap();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.setGold(0);
        new ServerUnit(game, map.getTile(4, 7), dutch, colonistType);
        ServerPlayerTest.assertEquals((String)"Should be alive, has units", (Object)((Object)ServerPlayer.DeadCheck.IS_ALIVE), (Object)((Object)dutch.checkForDeath()));
    }

    public void testCheckGameOver1600Threshold() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.setGold(0);
        new ServerUnit(game, dutch.getEurope(), dutch, galleonType);
        ServerPlayerTest.assertEquals((String)"Should have 1 unit", (int)1, (int)dutch.getUnitCount());
        ServerPlayerTest.assertEquals((String)"Should not be game over, not 1600 yet, autorecruit", (Object)((Object)ServerPlayer.DeadCheck.IS_AUTORECRUIT), (Object)((Object)dutch.checkForDeath()));
        new ServerUnit(game, dutch.getEurope(), dutch, colonistType);
        ServerPlayerTest.assertEquals((String)"Should have 2 units", (int)2, (int)dutch.getUnitCount());
        ServerPlayerTest.assertEquals((String)"Should not be game over, not 1600 yet", (Object)((Object)ServerPlayer.DeadCheck.IS_ALIVE), (Object)((Object)dutch.checkForDeath()));
        game.setTurn(new Turn(1600));
        ServerPlayerTest.assertEquals((String)"Should be game over, no new world presence >= 1600", (Object)((Object)ServerPlayer.DeadCheck.IS_DEAD), (Object)((Object)dutch.checkForDeath()));
    }

    public void testCheckGameOverUnitsGoingToEurope() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap(ServerPlayerTest.spec().getTileType("model.tile.highSeas")));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.setGold(0);
        ServerUnit galleon = new ServerUnit(game, map.getTile(6, 8), dutch, galleonType);
        ServerUnit colonist = new ServerUnit(game, galleon, dutch, colonistType);
        ServerPlayerTest.assertTrue((String)"Colonist should be aboard the galleon", (colonist.getLocation() == galleon ? 1 : 0) != 0);
        ServerPlayerTest.assertEquals((String)"Galleon should have a colonist onboard", (int)1, (int)galleon.getUnitCount());
        igc.moveTo(dutch, galleon, dutch.getEurope());
        ServerPlayerTest.assertEquals((String)"Should be alive, units between new world and europe", (Object)((Object)ServerPlayer.DeadCheck.IS_ALIVE), (Object)((Object)dutch.checkForDeath()));
        game.setTurn(new Turn(1600));
        ServerPlayerTest.assertEquals((String)"Should not be alive, no new world presence >= 1600", (Object)((Object)ServerPlayer.DeadCheck.IS_DEAD), (Object)((Object)dutch.checkForDeath()));
    }

    public void testCheckGameOverUnitsGoingToNewWorld() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.setGold(0);
        ServerUnit galleon = new ServerUnit(game, dutch.getEurope(), dutch, galleonType);
        ServerUnit colonist = new ServerUnit(game, galleon, dutch, colonistType);
        ServerPlayerTest.assertEquals((String)"Colonist should be aboard the galleon", (Object)galleon, (Object)colonist.getLocation());
        ServerPlayerTest.assertEquals((String)"Galleon should have a colonist onboard", (int)1, (int)galleon.getUnitCount());
        igc.moveTo(dutch, galleon, map);
        ServerPlayerTest.assertEquals((String)"Should be alive, units between new world and europe", (Object)((Object)ServerPlayer.DeadCheck.IS_ALIVE), (Object)((Object)dutch.checkForDeath()));
        game.setTurn(new Turn(1600));
        ServerPlayerTest.assertEquals((String)"Should not be alive, no new world presence >= 1600", (Object)((Object)ServerPlayer.DeadCheck.IS_DEAD), (Object)((Object)dutch.checkForDeath()));
    }

    public void testSellingMakesPricesFall() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Market dm = dutch.getMarket();
        int previousGold = dutch.getGold();
        int price = ServerPlayerTest.spec().getInitialPrice(silverType);
        dutch.sellInEurope(null, null, silverType, 1000);
        ServerPlayerTest.assertTrue((previousGold < dutch.getGold() ? 1 : 0) != 0);
        ServerPlayerTest.assertTrue((dm.getSalePrice(silverType, 1) < price ? 1 : 0) != 0);
    }

    public void testBuyingMakesPricesRaise() {
        ServerGame game = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Market dm = dutch.getMarket();
        dutch.modifyGold(1000000);
        int previousGold = dutch.getGold();
        int price = dm.getCostToBuy(foodType);
        dutch.buyInEurope(null, new GoodsContainer((Game)game, dutch.getEurope()), foodType, 10000);
        ServerPlayerTest.assertTrue((previousGold > dutch.getGold() ? 1 : 0) != 0);
        ServerPlayerTest.assertTrue((dm.getBidPrice(foodType, 1) > price ? 1 : 0) != 0);
    }

    public int sellUntilPriceDrop(Game game, ServerPlayer player, GoodsType type) {
        int result = 0;
        Market market = player.getMarket();
        int price = market.getSalePrice(type, 1);
        if (price == 0) {
            throw new IllegalArgumentException("Price is already 0 for selling " + type);
        }
        while (price == market.getSalePrice(type, 1)) {
            player.sellInEurope(null, null, type, 10);
            ++result;
        }
        return result;
    }

    public int buyUntilPriceRise(Game game, ServerPlayer player, GoodsType type) {
        ServerGame g = ServerTestHelper.startServerGame(ServerPlayerTest.getTestMap());
        Random random = new Random();
        int result = 0;
        Market market = player.getMarket();
        int price = market.getBidPrice(type, 1);
        if (price == 20) {
            throw new IllegalArgumentException("Price is already 20 for buying " + type);
        }
        GoodsContainer container = new GoodsContainer(game, player.getEurope());
        while (price == market.getBidPrice(type, 1)) {
            player.buyInEurope(random, container, type, 10);
            ++result;
        }
        return result;
    }

    public void testDutchMarket() {
        Game game = ServerPlayerTest.getStandardGame();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        ServerPlayerTest.assertEquals((String)"model.nationType.trade", (String)dutch.getNationType().getId());
        ServerPlayerTest.assertTrue((boolean)dutch.getNationType().hasModifier("model.modifier.tradeBonus"));
        ServerPlayerTest.assertTrue((boolean)dutch.hasModifier("model.modifier.tradeBonus"));
        int dutchSellAmount = this.sellUntilPriceDrop(game, dutch, silverType);
        Game g2 = ServerPlayerTest.getStandardGame();
        ServerPlayer french2 = this.getServerPlayer(game, "model.nation.french");
        int frenchSellAmount = this.sellUntilPriceDrop(g2, french2, silverType);
        ServerPlayerTest.assertTrue((dutchSellAmount > frenchSellAmount ? 1 : 0) != 0);
        dutch.modifyGold(10000);
        french.modifyGold(10000);
        int dutchBuyAmount = this.buyUntilPriceRise(ServerPlayerTest.getStandardGame(), dutch, musketsType);
        int frenchBuyAmount = this.buyUntilPriceRise(ServerPlayerTest.getStandardGame(), french, musketsType);
        ServerPlayerTest.assertTrue((dutchBuyAmount > frenchBuyAmount ? 1 : 0) != 0);
    }
}

